/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.util;

import com.kingdee.eas.bs.ml.ResourceInfo;
import com.kingdee.eas.bs.ml.util.MDResourceParser;
import com.kingdee.eas.bs.ml.util.MLUtils;
import com.kingdee.eas.bs.ml.util.MetaDocConst;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class PermAndLogResourceParser
implements MDResourceParser {
    private PermAndLogResourceParser() {
    }

    public static PermAndLogResourceParser getInstance() {
        return new PermAndLogResourceParser();
    }

    @Override
    public List parser(Document doc, Map existWords, String metaType) throws Exception {
        if (doc == null || metaType == null) {
            return Collections.EMPTY_LIST;
        }
        if (existWords == null) {
            existWords = Collections.EMPTY_MAP;
        }
        ArrayList<ResourceInfo> list = new ArrayList<ResourceInfo>();
        Element root = doc.getRootElement();
        String pkg = root.elementText(MetaDocConst.NODE_PKG);
        String name = root.elementText(MetaDocConst.NODE_NAME);
        if (name == null || name.trim().length() <= 0) {
            return Collections.EMPTY_LIST;
        }
        if (pkg != null && pkg.trim().length() > 0) {
            pkg = pkg.replaceAll("\\.", "\\\\");
        }
        Element permissionItems = root.element("permissionItems");
        Element resource = root.element("resource");
        if (resource == null || permissionItems == null) {
            return Collections.EMPTY_LIST;
        }
        Iterator rsIt = permissionItems.elementIterator();
        while (rsIt.hasNext()) {
            ResourceInfo resInfo;
            String key;
            Element permissionItem = (Element)rsIt.next();
            String innerID = permissionItem.element("innerID").getTextTrim();
            if (innerID == null) continue;
            String itemName = permissionItem.elementTextTrim("name");
            String aliasKey = permissionItem.element("alias").getTextTrim();
            String alias_CN = MLUtils.myTrim(PermAndLogResourceParser.getCNResource(resource, aliasKey));
            String md52 = MLUtils.md5HashCode(alias_CN);
            if (alias_CN != null && alias_CN.length() > 0 && !alias_CN.equals("null")) {
                key = itemName + ".alias";
                if (!existWords.containsKey(key)) {
                    resInfo = new ResourceInfo();
                    resInfo.setInnerId(innerID);
                    resInfo.setZh_CN(alias_CN);
                    resInfo.setPkg(pkg);
                    resInfo.setFileName(name);
                    resInfo.setKey(key);
                    resInfo.setMetaType(metaType);
                    if (!MLUtils.containChinese(alias_CN)) {
                        resInfo.setEn_US(alias_CN);
                    }
                    list.add(resInfo);
                } else if (!md52.equals(existWords.get(key))) {
                    resInfo = new ResourceInfo();
                    resInfo.setInnerId(innerID);
                    resInfo.setZh_CN(alias_CN);
                    resInfo.setPkg(pkg);
                    resInfo.setFileName(name);
                    resInfo.setKey(key);
                    resInfo.setMetaType(metaType);
                    resInfo.setUpdate(true);
                    if (!MLUtils.containChinese(alias_CN)) {
                        resInfo.setEn_US(alias_CN);
                    }
                    list.add(resInfo);
                }
            }
            String desc_CN = null;
            if (permissionItem.element("description") != null) {
                desc_CN = MLUtils.myTrim(PermAndLogResourceParser.getCNResource(resource, permissionItem.element("description").getTextTrim()));
            }
            md52 = MLUtils.md5HashCode(desc_CN);
            if (desc_CN == null || desc_CN.length() <= 0 || desc_CN.equals("null")) continue;
            key = itemName + ".desc";
            if (!existWords.containsKey(key)) {
                resInfo = new ResourceInfo();
                resInfo.setInnerId(innerID);
                resInfo.setZh_CN(desc_CN);
                resInfo.setPkg(pkg);
                resInfo.setFileName(name);
                resInfo.setKey(key);
                resInfo.setMetaType(metaType);
                if (!MLUtils.containChinese(desc_CN)) {
                    resInfo.setEn_US(desc_CN);
                }
                list.add(resInfo);
                continue;
            }
            if (md52.equals(existWords.get(key))) continue;
            resInfo = new ResourceInfo();
            resInfo.setInnerId(innerID);
            resInfo.setZh_CN(desc_CN);
            resInfo.setPkg(pkg);
            resInfo.setFileName(name);
            resInfo.setKey(key);
            resInfo.setMetaType(metaType);
            resInfo.setUpdate(true);
            if (!MLUtils.containChinese(desc_CN)) {
                resInfo.setEn_US(desc_CN);
            }
            list.add(resInfo);
        }
        return list;
    }

    private static String getCNResource(Element resource, String resKey) {
        if (resKey == null) {
            return null;
        }
        String xpath = "//*[name() = 'rs' and @key = '" + resKey + "']/*[name() = 'lang' and @locale = 'zh_CN']";
        Element el = (Element)resource.selectSingleNode(xpath);
        if (el != null) {
            return el.attribute("value").getText();
        }
        return null;
    }

    public static void main(String[] args) {
        block4: {
            FileInputStream fileInputStream = null;
            try {
                File file = new File("H:/metas/hr_rec.permission");
                SAXReader reader = new SAXReader();
                fileInputStream = new FileInputStream(file);
                Document doc = reader.read((InputStream)fileInputStream);
                new PermAndLogResourceParser().parser(doc, Collections.EMPTY_MAP, "perm");
                fileInputStream.close();
            }
            catch (Exception ex) {
                if (fileInputStream == null) break block4;
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

