/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.util;

import com.kingdee.eas.bs.ml.ResourceInfo;
import com.kingdee.eas.bs.ml.util.MDResourceParser;
import com.kingdee.eas.bs.ml.util.MLToolsConstonts;
import com.kingdee.eas.bs.ml.util.MLUtils;
import com.kingdee.eas.bs.ml.util.MetaDocConst;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public final class UIResourceParser
implements MDResourceParser {
    private static Set ignoreProp = new HashSet();
    private static Pattern uiDescPtn = Pattern.compile("^uiObject\\[[^\\[|\\]]*?\\]\\.title$");
    private static Pattern uiResKeyPtn = Pattern.compile("^uiObject.*?components\\.component\\[(.*?)\\]\\.properties\\.property\\[(.*?)\\]\\.value$");
    private static Pattern uiActionResKeyPtn = Pattern.compile("^uiObject.*?actions\\.action\\[(.*?)\\]\\.(.*)$");

    private UIResourceParser() {
    }

    public static UIResourceParser getInstance() {
        UIResourceParser.initIgnoreProperties();
        return new UIResourceParser();
    }

    @Override
    public List parser(Document doc, Map existWords, String metaType) throws Exception {
        String project;
        if (doc == null || metaType == null) {
            return Collections.EMPTY_LIST;
        }
        if (!"ui".equalsIgnoreCase(metaType)) {
            return Collections.EMPTY_LIST;
        }
        if (existWords == null) {
            existWords = Collections.EMPTY_MAP;
        }
        ArrayList<ResourceInfo> uiResList = new ArrayList<ResourceInfo>();
        Element root = doc.getRootElement();
        String pkg = root.elementText(MetaDocConst.NODE_UI_ReleasePackage);
        if (pkg == null || "".equals(pkg)) {
            pkg = root.elementText(MetaDocConst.NODE_PKG);
        }
        if ((project = pkg.replaceAll("com.kingdee.eas.", "")).indexOf(".") > 0) {
            project = project.substring(0, project.indexOf("."));
        }
        pkg = pkg.replaceAll("\\.", "\\\\");
        String name = root.elementText(MetaDocConst.NODE_UI_ReleaseClass);
        if (name == null || "".equals(name)) {
            name = root.elementText(MetaDocConst.NODE_NAME);
        }
        Map actions = this.getActions(root);
        this.parseConstraintsNode(root, name, pkg, existWords, uiResList);
        Element resourceElement = root.element(MetaDocConst.NODE_RES);
        if (resourceElement == null) {
            return Collections.EMPTY_LIST;
        }
        Iterator rsIt = resourceElement.elementIterator();
        block0: while (rsIt.hasNext()) {
            String md52;
            String zh_CN;
            String locale;
            Element localeElement;
            Iterator langIt;
            int idx;
            String suffix;
            Element rsElement = (Element)rsIt.next();
            String key = this.getUIResKey(rsElement.attribute(MetaDocConst.ATT_KEY).getText(), actions);
            if (key == null || ignoreProp.contains(suffix = (idx = key.lastIndexOf(46)) > 0 ? key.substring(idx + 1) : key)) continue;
            if (key.endsWith(".border")) {
                key = key + ".title";
            }
            if (key.endsWith(".formatXml")) {
                langIt = rsElement.elementIterator();
                while (langIt.hasNext()) {
                    localeElement = (Element)langIt.next();
                    if (localeElement == null || localeElement.attribute("locale") == null || !(locale = localeElement.attribute("locale").getText()).equals("zh_CN")) continue;
                    zh_CN = localeElement.attribute("value").getText();
                    if (zh_CN == null || zh_CN.trim().length() <= 0) continue block0;
                    md52 = MLUtils.md5HashCode(zh_CN);
                    Map map = this.getFormatXmlRes(key.substring(0, key.lastIndexOf(46)), zh_CN);
                    Set fxSet = map.entrySet();
                    for (Map.Entry entry : fxSet) {
                        ResourceInfo resInfo;
                        String fxK = entry.getKey().toString();
                        String fxVl = MLUtils.myTrim(entry.getValue().toString());
                        String fxVlMD5 = MLUtils.md5HashCode(fxVl);
                        if (fxK == null || fxVl == null) continue;
                        if (!existWords.containsKey(fxK)) {
                            resInfo = new ResourceInfo();
                            resInfo.setZh_CN(fxVl);
                            resInfo.setPkg(pkg);
                            resInfo.setFileName(name);
                            resInfo.setKey(fxK);
                            resInfo.setMetaType("UI");
                            uiResList.add(resInfo);
                            continue;
                        }
                        if (fxVlMD5.equals(existWords.get(fxK))) continue;
                        resInfo = new ResourceInfo();
                        resInfo.setZh_CN(fxVl);
                        resInfo.setPkg(pkg);
                        resInfo.setFileName(name);
                        resInfo.setKey(fxK);
                        resInfo.setMetaType("UI");
                        resInfo.setUpdate(true);
                        uiResList.add(resInfo);
                    }
                }
                continue;
            }
            langIt = rsElement.elementIterator();
            while (langIt.hasNext()) {
                ResourceInfo resInfo;
                localeElement = (Element)langIt.next();
                locale = localeElement.attribute("locale").getText();
                if (!locale.equals("zh_CN")) continue;
                zh_CN = MLUtils.myTrim(localeElement.attribute("value").getText());
                if (zh_CN == null || zh_CN.length() <= 0 || !this.isValidRes(zh_CN) || key.endsWith(".items") && zh_CN.startsWith("[Enum]")) continue block0;
                if (key.endsWith("border.title")) {
                    zh_CN = MLUtils.myTrim(this.getBorderTitle(zh_CN));
                }
                md52 = MLUtils.md5HashCode(zh_CN);
                if (!existWords.containsKey(key)) {
                    resInfo = new ResourceInfo();
                    resInfo.setZh_CN(zh_CN);
                    resInfo.setPkg(pkg);
                    resInfo.setFileName(name);
                    resInfo.setKey(key);
                    resInfo.setMetaType("UI");
                    if (!MLUtils.containChinese(zh_CN)) {
                        resInfo.setEn_US(zh_CN);
                    }
                    uiResList.add(resInfo);
                    continue;
                }
                if (md52 == null || md52.equals(existWords.get(key))) continue;
                resInfo = new ResourceInfo();
                resInfo.setZh_CN(zh_CN);
                resInfo.setPkg(pkg);
                resInfo.setFileName(name);
                resInfo.setKey(key);
                resInfo.setMetaType("UI");
                resInfo.setUpdate(true);
                if (!MLUtils.containChinese(zh_CN)) {
                    resInfo.setEn_US(zh_CN);
                }
                uiResList.add(resInfo);
            }
        }
        return uiResList;
    }

    private Map getFormatXmlRes(String tblName, String formatXml) throws Exception {
        if (tblName == null || formatXml == null) {
            return Collections.EMPTY_MAP;
        }
        SAXReader reader = new SAXReader();
        StringReader in = new StringReader(formatXml);
        Document doc = null;
        try {
            doc = reader.read((Reader)in);
        }
        catch (Exception ex) {
            System.out.println(tblName);
            return Collections.EMPTY_MAP;
        }
        String colPath = "//*[name() = 'Table']/*[name() = 't:Sheet']/*[name() = 't:Table']/*[name() = 't:ColumnGroup']/*[name() = 't:Column']";
        List colList = doc.selectNodes(colPath);
        ArrayList<String> keyList = new ArrayList<String>();
        int j = colList.size();
        for (int i = 0; i < j; ++i) {
            Element el = (Element)colList.get(i);
            keyList.add(el.attribute("key").getValue());
        }
        String headRowPath = "//*[name() = 't:Head']/*[name() = 't:Row']";
        List rowList = doc.selectNodes(headRowPath);
        String prefix = tblName + ".";
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < rowList.size(); ++i) {
            Element rowEl = (Element)rowList.get(i);
            List cells = rowEl.elements();
            if (cells.size() > keyList.size()) continue;
            int n = cells.size();
            for (int m = 0; m < n; ++m) {
                Element cellEl = (Element)cells.get(m);
                String resKey = prefix + keyList.get(m);
                if (i > 0) {
                    resKey = resKey + MLToolsConstonts.TABLE_MULTI_HEADER + (i + 1);
                }
                map.put(resKey, cellEl.getTextTrim());
            }
        }
        return map;
    }

    private void parseConstraintsNode(Element root, String name, String pkg, Map existWords, List uiResList) throws Exception {
        Element components = root.element("components");
        if (components == null) {
            return;
        }
        List list = components.elements();
        for (int i = 0; i < list.size(); ++i) {
            ResourceInfo resInfo;
            Element component = (Element)list.get(i);
            String str = MLUtils.myTrim(component.elementText("constraints"));
            String componentName = component.elementText("name");
            if (!MLUtils.containChinese(str) || componentName == null) continue;
            String key = componentName + ".constraints";
            if (!existWords.containsKey(key)) {
                resInfo = new ResourceInfo();
                resInfo.setZh_CN(str);
                resInfo.setPkg(pkg);
                resInfo.setFileName(name);
                resInfo.setKey(key);
                resInfo.setMetaType("UI");
                uiResList.add(resInfo);
                continue;
            }
            if (str.equals(existWords.get(key))) continue;
            resInfo = new ResourceInfo();
            resInfo.setZh_CN(str);
            resInfo.setPkg(pkg);
            resInfo.setFileName(name);
            resInfo.setKey(key);
            resInfo.setMetaType("UI");
            resInfo.setUpdate(true);
            uiResList.add(resInfo);
        }
    }

    private String getUIResKey(String srcKey, Map actions) {
        if (srcKey == null || srcKey.trim().length() <= 0) {
            return null;
        }
        Matcher m = uiResKeyPtn.matcher(srcKey);
        if (m.find()) {
            return m.group(1) + "." + m.group(2);
        }
        if (actions != null && actions.size() > 0 && (m = uiActionResKeyPtn.matcher(srcKey)).find()) {
            String insName = m.group(1);
            if (!actions.containsKey(insName)) {
                return null;
            }
            String actionClassName = actions.get(m.group(1)).toString();
            String prop = m.group(2);
            if (actionClassName == null || prop == null) {
                return null;
            }
            if ("name".equalsIgnoreCase(prop)) {
                return actionClassName + ".NAME";
            }
            if ("longdescription".equalsIgnoreCase(prop)) {
                return actionClassName + ".LONG_DESCRIPTION";
            }
            if ("shortdescription".equalsIgnoreCase(prop)) {
                return actionClassName + ".SHORT_DESCRIPTION";
            }
        }
        if ((m = uiDescPtn.matcher(srcKey)).find() && srcKey.endsWith(".title")) {
            return "this.title";
        }
        return null;
    }

    private Map getActions(Element root) {
        Element actionElement = root.element(MetaDocConst.NODE_UI_ACTIONS);
        if (actionElement == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator acIt = actionElement.elementIterator();
        while (acIt.hasNext()) {
            Element actionEL = (Element)acIt.next();
            String insName = null;
            if (actionEL.element(MetaDocConst.NODE_UI_ACTION_InstanceName) != null) {
                insName = actionEL.element(MetaDocConst.NODE_UI_ACTION_InstanceName).getText();
            }
            String clName = null;
            if (actionEL.element(MetaDocConst.NODE_UI_ACTION_CLASS) != null) {
                clName = actionEL.element(MetaDocConst.NODE_UI_ACTION_CLASS).getText();
            }
            if (insName == null || clName == null) continue;
            map.put(insName, clName);
        }
        return map;
    }

    private boolean isValidRes(String str) {
        if (str == null || str.trim().length() <= 0) {
            return false;
        }
        if ("true".equalsIgnoreCase(str) || "false".equalsIgnoreCase(str) || "null".equalsIgnoreCase(str)) {
            return false;
        }
        String regex = "^-?([1-9]\\d*|0)(\\.\\d+)?$";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(str);
        return !m.find();
    }

    private String getBorderTitle(String borderXML) throws Exception {
        if (borderXML == null) {
            return null;
        }
        SAXReader reader = new SAXReader();
        Document doc = reader.read((Reader)new StringReader(borderXML));
        Element root = doc.getRootElement();
        Element t = root.element("Title");
        if (t != null) {
            return t.getText();
        }
        return null;
    }

    private static void initIgnoreProperties() {
        ignoreProp.add("buttonGroup");
        ignoreProp.add("background");
        ignoreProp.add("caretColor");
        ignoreProp.add("disabledTextColor");
        ignoreProp.add("foreground");
        ignoreProp.add("selectionColor");
        ignoreProp.add("preferredSize");
        ignoreProp.add("maximumSize");
        ignoreProp.add("minimumSize");
        ignoreProp.add("maximumValue");
        ignoreProp.add("minimumValue");
        ignoreProp.add("enabled");
        ignoreProp.add("visible");
        ignoreProp.add("mnemonic");
        ignoreProp.add("action");
        ignoreProp.add("dataType");
        ignoreProp.add("precision");
        ignoreProp.add("maxLength");
        ignoreProp.add("minLength");
        ignoreProp.add("required");
        ignoreProp.add("queryInfo");
        ignoreProp.add("editable");
        ignoreProp.add("editFormat");
        ignoreProp.add("displayFormat");
        ignoreProp.add("commitFormat");
        ignoreProp.add("boundLabelLength");
        ignoreProp.add("boundLabelUnderline");
        ignoreProp.add("icon");
        ignoreProp.add("readOnly");
        ignoreProp.add("selectedIndex");
        ignoreProp.add("orientation");
        ignoreProp.add("focusable");
        ignoreProp.add("focusCycleRoot");
        ignoreProp.add("verifyInputWhenFocusTarget");
        ignoreProp.add("doubleBuffered");
        ignoreProp.add("dragEnabled");
        ignoreProp.add("autoscrolls");
        ignoreProp.add("opaque");
        ignoreProp.add("autoToolTipText");
        ignoreProp.add("caretPosition");
        ignoreProp.add("columns");
        ignoreProp.add("debugGraphicsOptions");
        ignoreProp.add("navigationFilter");
        ignoreProp.add("scrollOffset");
        ignoreProp.add("selectionEnd");
        ignoreProp.add("selectionStart");
        ignoreProp.add("labelVisible");
        ignoreProp.add("display");
        ignoreProp.add("margin");
        ignoreProp.add("verticalAlignment");
        ignoreProp.add("verticalTextPosition");
        ignoreProp.add("borderPainted");
        ignoreProp.add("contentAreaFilled");
        ignoreProp.add("disabledIcon");
        ignoreProp.add("disabledSelectedIcon");
        ignoreProp.add("font");
        ignoreProp.add("focusPainted");
        ignoreProp.add("displayedMnemonicIndex");
        ignoreProp.add("validCharacters");
        ignoreProp.add("dateEnabled");
        ignoreProp.add("milliSecondEnable");
        ignoreProp.add("timeEnabled");
        ignoreProp.add("maximumRowCount");
        ignoreProp.add("popupVisible");
        ignoreProp.add("lightWeightPopupEnabled");
        ignoreProp.add("popupVisible");
        ignoreProp.add("selectedIndex");
        ignoreProp.add("actionCommand");
    }

    public static void main(String[] args) {
        UIResourceParser obj = new UIResourceParser();
    }
}

