/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.util;

import com.kingdee.eas.bs.ml.ResourceInfo;
import com.kingdee.eas.bs.ml.util.MDResourceParser;
import com.kingdee.eas.bs.ml.util.MLToolsConstonts;
import com.kingdee.eas.bs.ml.util.MLUtils;
import com.kingdee.eas.bs.ml.util.MetaDocConst;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public final class WebPageResourceParser
implements MDResourceParser {
    private static Set includeProp = new HashSet();

    private WebPageResourceParser() {
    }

    public static WebPageResourceParser getInstance() {
        WebPageResourceParser.initIncludeProperties();
        return new WebPageResourceParser();
    }

    @Override
    public List parser(Document doc, Map existWords, String metaType) throws Exception {
        String project;
        if (doc == null || metaType == null) {
            return Collections.EMPTY_LIST;
        }
        if (!"wbpage".equalsIgnoreCase(metaType)) {
            return Collections.EMPTY_LIST;
        }
        if (existWords == null) {
            existWords = Collections.EMPTY_MAP;
        }
        ArrayList uiResList = new ArrayList();
        Element root = doc.getRootElement();
        String pkg = root.elementText(MetaDocConst.NODE_UI_ReleasePackage);
        if (pkg == null || "".equals(pkg)) {
            pkg = root.elementText(MetaDocConst.NODE_PKG);
        }
        if ((project = pkg.replaceAll("com.kingdee.eas.", "")).indexOf(".") > 0) {
            project = project.substring(0, project.indexOf("."));
        }
        pkg = pkg.replaceAll("\\.", "\\\\");
        String name = root.elementText(MetaDocConst.NODE_UI_ReleaseClass);
        if (name == null || "".equals(name)) {
            name = root.elementText(MetaDocConst.NODE_NAME);
        }
        uiResList.addAll(this.processResNode(root, existWords, pkg, name));
        uiResList.addAll(this.processFrontResNode(root, existWords, pkg, name));
        return uiResList;
    }

    private Set<String> getXmlMulFieldKeySet(Element root) {
        Element componentsElement;
        HashSet<String> mulRsSet = new HashSet<String>();
        Element aliasElement = root.element(MetaDocConst.NODE_ALIAS);
        if (aliasElement != null && aliasElement.getText() != null && aliasElement.getText() != "") {
            mulRsSet.add(aliasElement.getText());
        }
        if ((componentsElement = root.element(MetaDocConst.NODE_COMPONENTS)) == null) {
            return null;
        }
        Iterator compIt = componentsElement.elementIterator();
        while (compIt.hasNext()) {
            Element compElement = (Element)compIt.next();
            Element proptsElement = compElement.element(MetaDocConst.NODE_PROPERTIES);
            if (proptsElement == null) continue;
            Iterator proptsIt = proptsElement.elementIterator();
            while (proptsIt.hasNext()) {
                Element proptyElement = (Element)proptsIt.next();
                Element isMulElement = proptyElement.element(MetaDocConst.NODE_ISMULTILAN);
                if (isMulElement == null || !"true".equalsIgnoreCase(isMulElement.getText())) continue;
                mulRsSet.add(proptyElement.elementText(MetaDocConst.ATT_VALUE));
            }
        }
        return mulRsSet;
    }

    private List processResNode(Element root, Map existWords, String pkg, String className) {
        ArrayList uiResList = new ArrayList();
        HashMap mulRsMap = new HashMap();
        Set<String> mulRsSet = this.getXmlMulFieldKeySet(root);
        if (mulRsSet == null) {
            return uiResList;
        }
        Element resourceElement = root.element(MetaDocConst.NODE_RES);
        if (resourceElement == null) {
            return Collections.EMPTY_LIST;
        }
        Iterator rsIt = resourceElement.elementIterator();
        while (rsIt.hasNext()) {
            Element rsElement = (Element)rsIt.next();
            String key = rsElement.attribute(MetaDocConst.ATT_KEY).getText();
            String realKey = null;
            if (!mulRsSet.contains(key)) continue;
            String suffix = null;
            if (key.indexOf("components") > 0) {
                suffix = key.substring(key.indexOf(".properties.property[") + ".properties.property[".length());
                suffix = suffix.substring(0, suffix.indexOf("]"));
                realKey = key.substring(key.indexOf(".components.component[") + ".components.component[".length());
                realKey = realKey.substring(0, realKey.indexOf("]"));
                realKey = realKey + "." + suffix;
            } else {
                realKey = key.substring(key.lastIndexOf("."));
                realKey = "this" + realKey;
            }
            this.dealWithKey(uiResList, rsElement, existWords, pkg, className, key, realKey);
        }
        return uiResList;
    }

    private void dealWithKey(List uiResList, Element rsElement, Map existWords, String pkg, String className, String key, String realKey) {
        Iterator langIt = rsElement.elementIterator();
        while (langIt.hasNext()) {
            ResourceInfo resInfo;
            Element localeElement = (Element)langIt.next();
            String locale = localeElement.attribute("locale").getText();
            if (!locale.equals("zh_CN")) continue;
            String zh_CN = localeElement.attribute("value").getText();
            String md52 = MLUtils.md5HashCode(zh_CN);
            if (!existWords.containsKey(realKey)) {
                resInfo = new ResourceInfo();
                resInfo.setZh_CN(zh_CN);
                resInfo.setPkg(pkg);
                resInfo.setFileName(className);
                resInfo.setKey(realKey);
                resInfo.setMetaType("wbpage");
                if (!MLUtils.containChinese(zh_CN)) {
                    resInfo.setEn_US(zh_CN);
                }
                uiResList.add(resInfo);
                continue;
            }
            if (md52 == null || md52.equals(existWords.get(realKey))) continue;
            resInfo = new ResourceInfo();
            resInfo.setZh_CN(zh_CN);
            resInfo.setPkg(pkg);
            resInfo.setFileName(className);
            resInfo.setKey(realKey);
            resInfo.setMetaType("wbpage");
            resInfo.setUpdate(true);
            if (!MLUtils.containChinese(zh_CN)) {
                resInfo.setEn_US(zh_CN);
            }
            uiResList.add(resInfo);
        }
    }

    private List processFrontResNode(Element root, Map existWords, String pkg, String className) {
        ArrayList<ResourceInfo> uiResList = new ArrayList<ResourceInfo>();
        Element resourceElement = root.element(MetaDocConst.NODE_FRONT_RES);
        if (resourceElement == null) {
            return Collections.EMPTY_LIST;
        }
        Iterator rsIt = resourceElement.elementIterator();
        while (rsIt.hasNext()) {
            ResourceInfo resInfo;
            Element rsElement = (Element)rsIt.next();
            String key = null;
            String value = null;
            Iterator keyIt = rsElement.elementIterator();
            while (keyIt.hasNext()) {
                Element keyElement = (Element)keyIt.next();
                if (keyElement.getName().equalsIgnoreCase("name")) {
                    key = keyElement.getText();
                    continue;
                }
                if (!keyElement.getName().equalsIgnoreCase("zh_CN")) continue;
                value = keyElement.getText();
            }
            String md52 = MLUtils.md5HashCode(value);
            if (!existWords.containsKey(key)) {
                resInfo = new ResourceInfo();
                resInfo.setZh_CN(value);
                resInfo.setPkg(pkg);
                resInfo.setFileName(className);
                resInfo.setKey(key);
                resInfo.setMetaType("wbpage");
                if (!MLUtils.containChinese(value)) {
                    resInfo.setEn_US(value);
                }
                uiResList.add(resInfo);
                continue;
            }
            if (md52 == null || md52.equals(existWords.get(key))) continue;
            resInfo = new ResourceInfo();
            resInfo.setZh_CN(value);
            resInfo.setPkg(pkg);
            resInfo.setFileName(className);
            resInfo.setKey(key);
            resInfo.setMetaType("wbpage");
            resInfo.setUpdate(true);
            if (!MLUtils.containChinese(value)) {
                resInfo.setEn_US(value);
            }
            uiResList.add(resInfo);
        }
        return uiResList;
    }

    private Map getFormatXmlRes(String tblName, String formatXml) throws Exception {
        if (tblName == null || formatXml == null) {
            return Collections.EMPTY_MAP;
        }
        SAXReader reader = new SAXReader();
        StringReader in = new StringReader(formatXml);
        Document doc = null;
        try {
            doc = reader.read((Reader)in);
        }
        catch (Exception ex) {
            System.out.println(tblName);
            return Collections.EMPTY_MAP;
        }
        String colPath = "//*[name() = 'Table']/*[name() = 't:Sheet']/*[name() = 't:Table']/*[name() = 't:ColumnGroup']/*[name() = 't:Column']";
        List colList = doc.selectNodes(colPath);
        ArrayList<String> keyList = new ArrayList<String>();
        int j = colList.size();
        for (int i = 0; i < j; ++i) {
            Element el = (Element)colList.get(i);
            keyList.add(el.attribute("key").getValue());
        }
        String headRowPath = "//*[name() = 't:Head']/*[name() = 't:Row']";
        List rowList = doc.selectNodes(headRowPath);
        String prefix = tblName + ".";
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < rowList.size(); ++i) {
            Element rowEl = (Element)rowList.get(i);
            List cells = rowEl.elements();
            if (cells.size() > keyList.size()) continue;
            int n = cells.size();
            for (int m = 0; m < n; ++m) {
                Element cellEl = (Element)cells.get(m);
                String resKey = prefix + keyList.get(m);
                if (i > 0) {
                    resKey = resKey + MLToolsConstonts.TABLE_MULTI_HEADER + (i + 1);
                }
                map.put(resKey, cellEl.getTextTrim());
            }
        }
        return map;
    }

    private void parseConstraintsNode(Element root, String name, String pkg, Map existWords, List uiResList) throws Exception {
        Element components = root.element("components");
        if (components == null) {
            return;
        }
        List list = components.elements();
        for (int i = 0; i < list.size(); ++i) {
            ResourceInfo resInfo;
            Element component = (Element)list.get(i);
            String str = MLUtils.myTrim(component.elementText("constraints"));
            String componentName = component.elementText("name");
            if (!MLUtils.containChinese(str) || componentName == null) continue;
            String key = componentName + ".constraints";
            if (!existWords.containsKey(key)) {
                resInfo = new ResourceInfo();
                resInfo.setZh_CN(str);
                resInfo.setPkg(pkg);
                resInfo.setFileName(name);
                resInfo.setKey(key);
                resInfo.setMetaType("wbpage");
                uiResList.add(resInfo);
                continue;
            }
            if (str.equals(existWords.get(key))) continue;
            resInfo = new ResourceInfo();
            resInfo.setZh_CN(str);
            resInfo.setPkg(pkg);
            resInfo.setFileName(name);
            resInfo.setKey(key);
            resInfo.setMetaType("wbpage");
            resInfo.setUpdate(true);
            uiResList.add(resInfo);
        }
    }

    private Map getActions(Element root) {
        Element actionElement = root.element(MetaDocConst.NODE_UI_ACTIONS);
        if (actionElement == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator acIt = actionElement.elementIterator();
        while (acIt.hasNext()) {
            Element actionEL = (Element)acIt.next();
            String insName = null;
            if (actionEL.element(MetaDocConst.NODE_UI_ACTION_InstanceName) != null) {
                insName = actionEL.element(MetaDocConst.NODE_UI_ACTION_InstanceName).getText();
            }
            String clName = null;
            if (actionEL.element(MetaDocConst.NODE_UI_ACTION_CLASS) != null) {
                clName = actionEL.element(MetaDocConst.NODE_UI_ACTION_CLASS).getText();
            }
            if (insName == null || clName == null) continue;
            map.put(insName, clName);
        }
        return map;
    }

    private boolean isValidRes(String str) {
        if (str == null || str.trim().length() <= 0) {
            return false;
        }
        if ("true".equalsIgnoreCase(str) || "false".equalsIgnoreCase(str) || "null".equalsIgnoreCase(str)) {
            return false;
        }
        String regex = "^-?([1-9]\\d*|0)(\\.\\d+)?$";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(str);
        return !m.find();
    }

    private String getBorderTitle(String borderXML) throws Exception {
        if (borderXML == null) {
            return null;
        }
        SAXReader reader = new SAXReader();
        Document doc = reader.read((Reader)new StringReader(borderXML));
        Element root = doc.getRootElement();
        Element t = root.element("Title");
        if (t != null) {
            return t.getText();
        }
        return null;
    }

    private static void initIncludeProperties() {
        includeProp.add("text");
        includeProp.add("caption");
        includeProp.add("alias");
        includeProp.add("validator.errMsg");
        includeProp.add("title");
        includeProp.add("label");
        includeProp.add("tips");
        includeProp.add("groupText");
        includeProp.add("titleText");
        includeProp.add("rootName");
        includeProp.add("dateFormat");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        WebPageResourceParser obj = WebPageResourceParser.getInstance();
        FileInputStream is = null;
        try {
            is = new FileInputStream("W:/metas/com/kingdee/eas/custom/web/TestDepEditPage.wbpage");
            SAXReader saxReader = new SAXReader();
            Document rootDocument = saxReader.read((InputStream)is);
            obj.parser(rootDocument, null, "wbpage");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

