/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.ba;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentException;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.base.attachment.common.SimpleAttachmentInfo;
import com.kingdee.eas.base.attachment.util.FileGetter;
import com.kingdee.eas.base.attachment.util.Resrcs;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.util.MutilLangeToolForParam;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.ba.IRptRelease;
import com.kingdee.eas.cp.ba.IRptReportType;
import com.kingdee.eas.cp.ba.RptReleaseCollection;
import com.kingdee.eas.cp.ba.RptReleaseException;
import com.kingdee.eas.cp.ba.RptReleaseFactory;
import com.kingdee.eas.cp.ba.RptReleaseInfo;
import com.kingdee.eas.cp.ba.RptReportException;
import com.kingdee.eas.cp.ba.RptReportTypeFactory;
import com.kingdee.eas.cp.ba.RptReportTypeInfo;
import com.kingdee.eas.cp.ba.RptTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.LocaleUtils;
import java.io.File;
import java.io.FileInputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class RptAutoReleaseManager {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.ba.RptAutoReleaseManager");
    private File file;
    private RptReleaseInfo releaseInfo;
    private BOSUuid boID = null;
    private Context ctx;
    private String rptID;

    public String getRptID() {
        return this.rptID;
    }

    public void setRptID(String rptID) {
        this.rptID = rptID;
    }

    public BOSUuid getBoID() {
        return this.boID;
    }

    public void setBoID(BOSUuid boID) {
        this.boID = boID;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public RptReleaseInfo getReleaseInfo() {
        return this.releaseInfo;
    }

    public void setReleaseInfo(RptReleaseInfo releaseInfo) {
        this.releaseInfo = releaseInfo;
    }

    public RptAutoReleaseManager() {
    }

    public RptAutoReleaseManager(File file, RptReleaseInfo rptInfo) {
        this.file = file;
        this.releaseInfo = rptInfo;
    }

    public RptAutoReleaseManager(RptReleaseInfo rptInfo) {
        this.file = null;
        this.releaseInfo = rptInfo;
    }

    public void releaseReport() throws Exception {
        if (this.releaseInfo == null) {
            throw new RptReleaseException(RptReleaseException.RELEASEINFO_NOT_NULL);
        }
        this.releaseReport(this.releaseInfo.getReleaseType());
    }

    public void releaseReport(RptTypeEnum typeEnum) throws Exception {
        if (this.releaseInfo == null) {
            throw new RptReleaseException(RptReleaseException.RELEASEINFO_NOT_NULL);
        }
        if (typeEnum == null) {
            throw new RptReportException(RptReportException.RELEASE_TYPE_NOT_NULL);
        }
        if (typeEnum.equals((Object)RptTypeEnum.SNAP_EXCEL_MODE) || typeEnum.equals((Object)RptTypeEnum.SNAP_HTML_MODE)) {
            this.releaseStaticReport();
        } else if (typeEnum.equals((Object)RptTypeEnum.SNAP_LINK_MODE)) {
            this.releaseLinkedReport();
        }
    }

    public void releaseStaticReport() throws Exception {
        this.setBoID();
        if (this.boID != null) {
            this.addNewAttachment(this.file, this.boID.toString());
        } else {
            this.addNewAttachment(this.file, "");
        }
        this.releaseInfo.setId(this.boID);
        this.rptReportTypeTreeHandle(this.releaseInfo);
        RptReleaseFactory.getLocalInstance(this.ctx).addnew((CoreBaseInfo)this.releaseInfo);
    }

    public void releaseLinkedReport() throws Exception {
        this.setBoID();
        this.rptReportTypeTreeHandle(this.releaseInfo);
        String tempID = this.releaseInfo.getBizID();
        if (tempID == null || "".equals(tempID.trim())) {
            RptReleaseFactory.getLocalInstance(this.ctx).addnew((CoreBaseInfo)this.releaseInfo);
        } else {
            RptReleaseInfo rrInfo = this.getExistReleaseInfo(this.ctx, tempID);
            if (rrInfo == null || rrInfo.getId() == null) {
                RptReleaseFactory.getLocalInstance(this.ctx).addnew((CoreBaseInfo)this.releaseInfo);
            } else {
                this.releaseInfo.setId(rrInfo.getId());
                RptReleaseFactory.getLocalInstance(this.ctx).update((IObjectPK)new ObjectUuidPK(rrInfo.getId()), (CoreBaseInfo)this.releaseInfo);
            }
        }
    }

    public RptReleaseInfo getExistReleaseInfo(Context ctx, String rptID) throws BOSException, EASBizException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = ev.getSelector();
        sic.add(new SelectorItemInfo("*"));
        filter.getFilterItems().add(new FilterItemInfo("bizID", (Object)rptID));
        filter.setMaskString(" #0 ");
        ev.setFilter(filter);
        IRptRelease iRpt = null;
        RptReleaseCollection cols = null;
        RptReleaseInfo rrInfo = null;
        iRpt = RptReleaseFactory.getLocalInstance(ctx);
        cols = iRpt.getRptReleaseCollection(ev);
        if (cols != null && cols.size() > 0) {
            rrInfo = cols.get(0);
        }
        return rrInfo;
    }

    public void rptReportTypeTreeHandle(RptReleaseInfo info) throws Exception {
        if (info == null) {
            return;
        }
        IRptReportType iRpt = null;
        RptReportTypeInfo newInfo2 = null;
        RptReportTypeInfo tempInfo = null;
        TreeBaseCollection cols = null;
        iRpt = RptReportTypeFactory.getLocalInstance(this.ctx);
        RptReportTypeInfo rptInfo = info.getRptSort();
        cols = iRpt.getChildren(rptInfo);
        for (RptReportTypeInfo newInfo2 : cols) {
            if (newInfo2.getName() != null && newInfo2.getName().equals(info.getType()) && newInfo2.isIsBusiness()) {
                info.setRptSort(newInfo2);
                break;
            }
            newInfo2 = null;
        }
        if (newInfo2 != null) {
            return;
        }
        tempInfo = new RptReportTypeInfo();
        tempInfo.setParent(info.getRptSort());
        String number = String.valueOf(new Date().getTime());
        tempInfo.setName(info.getType(LocaleUtils.getLocale((String)"l1")), LocaleUtils.getLocale((String)"l1"));
        tempInfo.setName(info.getType(LocaleUtils.getLocale((String)"l2")), LocaleUtils.getLocale((String)"l2"));
        tempInfo.setName(info.getType(LocaleUtils.getLocale((String)"l3")), LocaleUtils.getLocale((String)"l3"));
        tempInfo.setNumber(number);
        tempInfo.setIsLeaf(true);
        tempInfo.setIsStart(1);
        tempInfo.setIsBusiness(true);
        if (info.getRptSort().getLevel() == 2) {
            tempInfo.setIsPortlet(true);
        } else {
            tempInfo.setIsPortlet(false);
        }
        IObjectPK tempPK = iRpt.addnew((CoreBaseInfo)tempInfo);
        info.setRptSort((RptReportTypeInfo)iRpt.getTreeBaseInfo(tempPK));
    }

    private String addNewAttachment(String boID, SimpleAttachmentInfo sai) throws BOSException, EASBizException {
        String attchID = "";
        AttachmentInfo attachmentInfo = this.makeAttachmentInfo(this.getIA(), boID, sai);
        attchID = this.getIA().addnew(attachmentInfo).toString();
        return attchID;
    }

    private String addNewAttachment(File file, AttachmentUIContextInfo info) throws Exception {
        if (file == null) {
            throw new RptReleaseException(RptReleaseException.TEMPFILL_ERROR);
        }
        String fullname = file.getName();
        String mainname = StringUtil4File.getMainFileName((String)fullname);
        String extname = StringUtil4File.getExtendedFileName((String)fullname);
        byte[] content = FileGetter.getBytesFromFile((File)file);
        SimpleAttachmentInfo sai = new SimpleAttachmentInfo();
        sai.setMainName(mainname);
        sai.setExtName(extname);
        sai.setContent(content);
        sai.setCode(info.getCode());
        sai.setIsShared(false);
        sai.setShareRange(info.getShareRange());
        return this.addNewAttachment(info.getBoID(), sai);
    }

    private String addNewAttachment(File file, String id) throws Exception {
        if (file == null) {
            throw new RptReleaseException(RptReleaseException.TEMPFILL_ERROR);
        }
        String fullname = file.getName();
        String mainname = StringUtil4File.getMainFileName((String)fullname);
        String extname = StringUtil4File.getExtendedFileName((String)fullname);
        byte[] content = null;
        try {
            byte[] b = null;
            FileInputStream fis = new FileInputStream(file);
            FileChannel fc = fis.getChannel();
            long size = fc.size();
            b = new byte[new Long(size).intValue()];
            MappedByteBuffer mbb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, size);
            mbb.get(b);
            mbb.clear();
            fc.close();
            fis.close();
            content = b;
        }
        catch (Exception e) {
            e.toString();
        }
        SimpleAttachmentInfo sai = new SimpleAttachmentInfo();
        sai.setMainName(mainname);
        sai.setExtName(extname);
        sai.setContent(content);
        sai.setIsShared(false);
        return this.addNewAttachment(id, sai);
    }

    protected IAttachment getIA() throws BOSException {
        return AttachmentFactory.getLocalInstance((Context)this.ctx);
    }

    public void setBoID() {
        if (this.releaseInfo != null) {
            this.boID = BOSUuid.create((BOSObjectType)this.releaseInfo.getBOSType());
        }
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public AttachmentInfo makeAttachmentInfo(IAttachment ia, String boID, SimpleAttachmentInfo sai) throws BOSException, EASBizException {
        AttachmentInfo ai = new AttachmentInfo();
        String mainname = sai.getMainName();
        String extname = sai.getExtName();
        String description = sai.getDescription();
        String code = sai.getCode();
        byte[] content = sai.getContent();
        boolean isShared = sai.getIsShared();
        MutilLangeToolForParam.muti2Obj((String)mainname, (IObjectValue)ai, (String)"name");
        MutilLangeToolForParam.muti2Obj((String)description, (IObjectValue)ai, (String)"description");
        String tempValue = ai.isIsShared() ? EASResource.getString((String)"yes") : EASResource.getString((String)"no");
        MutilLangeToolForParam.muti2Obj((String)tempValue, (IObjectValue)ai, (String)"sharedDesc");
        ai.setNumber(code);
        ai.setFile(content);
        ai.setIsShared(isShared && !extname.equals("url"));
        ai.setSimpleName(extname);
        ai.setType(extname.equals("url") ? "URL" : StringUtil4File.getFileTypeDescription((String)extname));
        ai.setSize(StringUtil4File.getFileSizeRepresentation((long)content.length));
        ai.setSizeInByte(content.length);
        ai.setShareRange(sai.getShareRange());
        ai.setAttachID(new SimpleDateFormat("yyyyMMddHHmmssSSS").format(SysUtil.getAppServerTime((Context)this.ctx)));
        ai.getBoAttchAsso().add(this.makeBoAttchAssoInfo(boID));
        return ai;
    }

    public BoAttchAssoInfo makeBoAttchAssoInfo(String boID) {
        BoAttchAssoInfo baai = new BoAttchAssoInfo();
        baai.setBoID(boID);
        baai.setAssoType(Resrcs.getString((String)"NewAttachment"));
        baai.setAssoBusObjType(BOSUuid.read((String)boID).getType().toString());
        return baai;
    }

    public void checkFile(IAttachment ia, String boID, String mainname, byte[] content) throws BOSException, AttachmentException, EASBizException {
        if (mainname == null || mainname.equals("")) {
            throw new AttachmentException(AttachmentException.FILENAMEISEMPTY);
        }
        if (content.length == 0) {
            throw new AttachmentException(AttachmentException.FILECONTENTNOTGIVEN);
        }
        IParamControl iParam = ParamControlFactory.getRemoteInstance();
        String value = iParam.getParamValue(null, "InclosureNameDuplicate");
        if (value == null) {
            value = "false";
        }
        if (value.equals("false") && ia.isFileNameExisted(boID, mainname)) {
            throw new AttachmentException(AttachmentException.FILENAMEEXISTED, (Object[])new String[]{mainname});
        }
    }
}

