/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.ba;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.base.attachment.common.SimpleAttachmentInfo;
import com.kingdee.eas.base.attachment.util.FileGetter;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.base.attachment.util.VariousAttachmentInfoMaker;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.cp.ba.IRptReportType;
import com.kingdee.eas.cp.ba.RptReleaseFactory;
import com.kingdee.eas.cp.ba.RptReleaseInfo;
import com.kingdee.eas.cp.ba.RptReportException;
import com.kingdee.eas.cp.ba.RptReportTypeFactory;
import com.kingdee.eas.cp.ba.RptReportTypeInfo;
import com.kingdee.eas.cp.ba.RptTypeEnum;
import com.kingdee.eas.cp.ba.SourceTypeEnum;
import com.kingdee.eas.cp.ba.client.RptReleaseEditUI;
import com.kingdee.eas.cp.ba.util.RptUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.util.LocaleUtils;
import java.awt.Component;
import java.io.File;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

public class RptReleaseManager {
    String title;
    File file;
    SystemEnum fromSys;
    Object ev;
    RptTypeEnum typeEnum;
    RptReleaseInfo releaseInfo;
    BOSUuid boID;
    String uiClassName;
    SourceTypeEnum sourceReportType;
    File[] files;
    String bizID;

    public String getBizID() {
        return this.bizID;
    }

    public void setBizID(String bizID) {
        this.bizID = bizID;
    }

    public File[] getFiles() {
        return this.files;
    }

    public void setFiles(File[] files) {
        this.files = files;
    }

    public RptReleaseManager(File file, SystemEnum fromSys) {
        this("", file, fromSys);
        this.file = file;
        if (file != null) {
            this.title = file.getName();
        }
    }

    public RptReleaseManager() {
    }

    public RptReleaseManager(String title, File file, SystemEnum fromSys) {
        this(title, file, fromSys, null, RptTypeEnum.SNAP_HTML_MODE, SourceTypeEnum.DEFAULT_TYPE, null);
    }

    public RptReleaseManager(String title, File file, SystemEnum fromSys, Object ev, RptTypeEnum rptEnum, SourceTypeEnum sourceReportType, String uiClassName) {
        this.title = title;
        this.file = file;
        this.fromSys = fromSys;
        this.typeEnum = rptEnum;
        this.ev = ev;
        this.uiClassName = uiClassName;
        this.sourceReportType = sourceReportType;
    }

    public RptReleaseManager(String title, SystemEnum fromSys, Object ev, RptTypeEnum rptEnum, SourceTypeEnum sourceReportType, String uiClassName) {
        this(title, fromSys, ev, rptEnum, sourceReportType, uiClassName, null);
    }

    public RptReleaseManager(String title, SystemEnum fromSys, Object ev, RptTypeEnum rptEnum, SourceTypeEnum sourceReportType, String uiClassName, String bizID) {
        this.title = title;
        this.file = null;
        this.fromSys = fromSys;
        this.typeEnum = rptEnum;
        this.ev = ev;
        this.uiClassName = uiClassName;
        this.sourceReportType = sourceReportType;
        this.bizID = bizID;
    }

    public RptReleaseManager(String title, File file, SystemEnum fromSys, RptTypeEnum rptTypeEnum) {
        this(title, file, fromSys, null, rptTypeEnum, null, "");
    }

    public RptReleaseManager(String title, File[] files, SystemEnum fromSys, RptTypeEnum rptTypeEnum) {
        this(title, files, fromSys, rptTypeEnum, null);
    }

    public RptReleaseManager(String title, File[] files, SystemEnum fromSys, RptTypeEnum rptTypeEnum, String bizID) {
        this.title = title;
        this.file = null;
        this.files = files;
        this.fromSys = fromSys;
        this.typeEnum = rptTypeEnum;
        this.ev = null;
        this.uiClassName = null;
        this.sourceReportType = null;
        this.bizID = bizID;
    }

    public void createReleaseInfo() {
        if (this.releaseInfo != null) {
            this.setBoID(BOSUuid.create((BOSObjectType)this.releaseInfo.getBOSType()));
        } else {
            this.releaseInfo = new RptReleaseInfo();
        }
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    private void initData() {
        this.createReleaseInfo();
    }

    public RptReleaseInfo getReleaseInfo() {
        return this.releaseInfo;
    }

    public void setReleaseInfo(RptReleaseInfo releaseInfo) {
        this.releaseInfo = releaseInfo;
    }

    public void showReleaseUI(Component comp) throws UIException {
        this.initData();
        UIContext uiContext = new UIContext((Object)comp);
        uiContext.put((Object)RptUtil.RECEIVER_INFO, (Object)this.releaseInfo);
        uiContext.put((Object)RptUtil.RPT_MGR, (Object)this);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(RptReleaseEditUI.class.getName(), (Map)uiContext, null, null);
        window.show();
    }

    public void releaseReport() throws Exception {
        this.initData();
        AttachmentUIContextInfo info = new AttachmentUIContextInfo();
        if (this.boID != null) {
            info.setBoID(this.boID.toString());
        }
        this.addNewAttachment(this.files[0], info);
        this.releaseInfo.setId(this.boID);
        this.rptReportTypeTreeHandle(this.releaseInfo);
        RptReleaseFactory.getRemoteInstance().addnew((CoreBaseInfo)this.releaseInfo);
    }

    public void releaseReport_mul() throws Exception {
        this.initData();
        File[] files = this.files;
        AttachmentUIContextInfo info = null;
        int j = files.length;
        for (int i = 0; i < j; ++i) {
            info = new AttachmentUIContextInfo();
            if (this.boID != null) {
                info.setBoID(this.boID.toString());
            }
            this.addNewAttachment(files[i], info);
            this.releaseInfo.setId(this.boID);
        }
        this.rptReportTypeTreeHandle(this.releaseInfo);
        RptReleaseFactory.getRemoteInstance().addnew((CoreBaseInfo)this.releaseInfo);
    }

    public void releaseLinkedReport() throws Exception {
        this.initData();
        this.rptReportTypeTreeHandle(this.releaseInfo);
        RptReleaseFactory.getRemoteInstance().addnew((CoreBaseInfo)this.releaseInfo);
    }

    public void rptReportTypeTreeHandle(RptReleaseInfo info) throws Exception {
        if (info == null) {
            return;
        }
        IRptReportType iRpt = null;
        RptReportTypeInfo newInfo2 = null;
        RptReportTypeInfo tempInfo = null;
        TreeBaseCollection cols = null;
        iRpt = RptReportTypeFactory.getRemoteInstance();
        RptReportTypeInfo rptInfo = info.getRptSort();
        cols = iRpt.getChildren(rptInfo);
        for (RptReportTypeInfo newInfo2 : cols) {
            if (newInfo2.getName() != null && newInfo2.getName().equals(info.getType()) && newInfo2.isIsBusiness()) {
                info.setRptSort(newInfo2);
                break;
            }
            newInfo2 = null;
        }
        if (newInfo2 != null) {
            return;
        }
        tempInfo = new RptReportTypeInfo();
        tempInfo.setParent(info.getRptSort());
        String number = String.valueOf(new Date().getTime());
        tempInfo.setName(info.getType(LocaleUtils.getLocale((String)"l1")), LocaleUtils.getLocale((String)"l1"));
        tempInfo.setName(info.getType(LocaleUtils.getLocale((String)"l2")), LocaleUtils.getLocale((String)"l2"));
        tempInfo.setName(info.getType(LocaleUtils.getLocale((String)"l3")), LocaleUtils.getLocale((String)"l3"));
        tempInfo.setNumber(number);
        tempInfo.setIsLeaf(true);
        tempInfo.setIsStart(1);
        tempInfo.setIsBusiness(true);
        if (info.getRptSort().getLevel() == 2) {
            tempInfo.setIsPortlet(true);
        } else {
            tempInfo.setIsPortlet(false);
        }
        IObjectPK tempPK = iRpt.addnew((CoreBaseInfo)tempInfo);
        info.setRptSort((RptReportTypeInfo)iRpt.getTreeBaseInfo(tempPK));
    }

    public void releaseReport(RptTypeEnum typeEnum) throws Exception {
        if (typeEnum == null) {
            throw new RptReportException(RptReportException.RELEASE_TYPE_NOT_NULL);
        }
        if (typeEnum.equals((Object)RptTypeEnum.SNAP_EXCEL_MODE) || typeEnum.equals((Object)RptTypeEnum.SNAP_HTML_MODE)) {
            if (this.files != null && this.files.length > 0) {
                if (this.files.length == 1) {
                    this.releaseReport();
                } else {
                    this.releaseReport_mul();
                }
            }
        } else if (typeEnum.equals((Object)RptTypeEnum.SNAP_LINK_MODE)) {
            this.releaseLinkedReport();
        }
    }

    private String addNewAttachment(File file, AttachmentUIContextInfo info) throws Exception {
        String fullname = file.getName();
        String mainname = StringUtil4File.getMainFileName((String)fullname);
        String extname = StringUtil4File.getExtendedFileName((String)fullname);
        byte[] content = FileGetter.getBytesFromFile((File)file);
        SimpleAttachmentInfo sai = new SimpleAttachmentInfo();
        sai.setMainName(mainname);
        sai.setExtName(extname);
        sai.setContent(content);
        sai.setCode(info.getCode());
        sai.setIsShared(false);
        sai.setShareRange(info.getShareRange());
        return this.addNewAttachment(info.getBoID(), sai);
    }

    private String addNewAttachment(String boID, SimpleAttachmentInfo sai) throws BOSException, EASBizException {
        String attchID = "";
        AttachmentInfo attachmentInfo = VariousAttachmentInfoMaker.makeAttachmentInfo((IAttachment)this.getIA(), (String)boID, (SimpleAttachmentInfo)sai);
        attchID = this.getIA().addnew(attachmentInfo).toString();
        return attchID;
    }

    protected IAttachment getIA() throws BOSException {
        return AttachmentFactory.getRemoteInstance();
    }

    public BOSUuid getBoID() {
        return this.boID;
    }

    public void setBoID(BOSUuid boID) {
        this.boID = boID;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public SystemEnum getFromSys() {
        return this.fromSys;
    }

    public void setFromSys(SystemEnum fromSys) {
        this.fromSys = fromSys;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Object getEv() {
        return this.ev;
    }

    public void setEv(Object ev) {
        this.ev = ev;
    }

    public RptTypeEnum getTypeEnum() {
        return this.typeEnum;
    }

    public void setTypeEnum(RptTypeEnum typeEnum) {
        this.typeEnum = typeEnum;
    }

    public SourceTypeEnum getSourceReportType() {
        return this.sourceReportType;
    }

    public void setSourceReportType(SourceTypeEnum sourceReportType) {
        this.sourceReportType = sourceReportType;
    }

    public String getUiClassName() {
        return this.uiClassName;
    }

    public void setUiClassName(String uiClassName) {
        this.uiClassName = uiClassName;
    }
}

