/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.ba.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.ba.IRptAccepter;
import com.kingdee.eas.cp.ba.IRptMgrFacade;
import com.kingdee.eas.cp.ba.IRptRelease;
import com.kingdee.eas.cp.ba.IRptReportType;
import com.kingdee.eas.cp.ba.RptAccepterCollection;
import com.kingdee.eas.cp.ba.RptAccepterFactory;
import com.kingdee.eas.cp.ba.RptAccepterInfo;
import com.kingdee.eas.cp.ba.RptMgrFacadeFactory;
import com.kingdee.eas.cp.ba.RptMgrMenuInfo;
import com.kingdee.eas.cp.ba.RptReleaseCollection;
import com.kingdee.eas.cp.ba.RptReleaseFactory;
import com.kingdee.eas.cp.ba.RptReleaseInfo;
import com.kingdee.eas.cp.ba.RptReportTypeFactory;
import com.kingdee.eas.cp.ba.RptReportTypeInfo;
import com.kingdee.eas.cp.ba.util.RptUtil;
import com.kingdee.eas.fi.rpt.ReportTypeCollection;
import com.kingdee.eas.fi.rpt.ReportTypeFactory;
import com.kingdee.eas.fi.rpt.ReportTypeInfo;
import com.kingdee.eas.fi.rpt.RptTypeStdCollection;
import com.kingdee.eas.fi.rpt.RptTypeStdFactory;
import com.kingdee.eas.fi.rpt.RptTypeStdInfo;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class RptMgrTreeUtil {
    protected static Logger logger = Logger.getLogger(RptMgrTreeUtil.class);
    private static Set functionSet;
    private static String FI_ID;
    public static RptMgrMenuInfo virtualInfo;
    public static final Color disableColor;
    private static DefaultKingdeeTreeNode customNode;
    private static DefaultKingdeeTreeNode defineNode;
    private static DefaultKingdeeTreeNode rootNode;

    public static TreeModel buildRptInitModel() {
        KingdeeTreeModel model = null;
        DefaultKingdeeTreeNode root = RptMgrTreeUtil.getRootNode();
        root.removeAllChildren();
        try {
            List list = RptMgrTreeUtil.buildSubSysMenuModels();
            DefaultKingdeeTreeNode level1 = null;
            RptMgrMenuInfo rptInfo = null;
            for (int i = 0; i < list.size(); ++i) {
                rptInfo = (RptMgrMenuInfo)list.get(i);
                level1 = RptMgrTreeUtil.buildTreeNode(rptInfo);
                if (FI_ID.equals(rptInfo.getId())) {
                    DefaultKingdeeTreeNode defNode = RptMgrTreeUtil.getDefineNode();
                    defNode.removeAllChildren();
                    defNode.insert((MutableTreeNode)RptMgrTreeUtil.buildVirtualNode(), 0);
                    level1.insert((MutableTreeNode)defNode, 0);
                    ((RptMgrMenuInfo)defNode.getUserObject()).setCanDoPorlet(true);
                    ((RptMgrMenuInfo)defNode.getUserObject()).setId(FI_ID);
                    DefaultKingdeeTreeNode cusNode = RptMgrTreeUtil.getCustomNode();
                    cusNode.removeAllChildren();
                    cusNode.insert((MutableTreeNode)RptMgrTreeUtil.buildVirtualNode(), 0);
                    level1.insert((MutableTreeNode)cusNode, 1);
                } else {
                    level1.insert((MutableTreeNode)RptMgrTreeUtil.buildVirtualNode(), 0);
                    ((RptMgrMenuInfo)level1.getUserObject()).setCanDoPorlet(true);
                }
                root.insert((MutableTreeNode)level1, i);
            }
            model = new KingdeeTreeModel((TreeNode)root);
            model.setRoot((TreeNode)root);
            return model;
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return model;
    }

    public static void destory() {
        if (defineNode != null) {
            defineNode.removeAllChildren();
        }
        if (customNode != null) {
            customNode.removeAllChildren();
        }
        if (rootNode != null) {
            rootNode.removeAllChildren();
        }
    }

    public static boolean hasPermission(String function) {
        if (StringUtils.isEmpty((String)function)) {
            return true;
        }
        if (functionSet == null) {
            try {
                functionSet = PermissionFactory.getRemoteInstance().getFunctionPermissions();
            }
            catch (EASBizException e) {
                functionSet = null;
                e.printStackTrace();
            }
            catch (BOSException e) {
                functionSet = null;
                e.printStackTrace();
            }
        }
        if (functionSet == null) {
            return true;
        }
        return functionSet.contains(function);
    }

    private static void buidMenuRptNode(DefaultKingdeeTreeNode node) {
        RptMgrMenuInfo menuModel = null;
        RptMgrMenuInfo rptInfo = node == defineNode ? (RptMgrMenuInfo)((DefaultKingdeeTreeNode)node.getParent()).getUserObject() : (RptMgrMenuInfo)node.getUserObject();
        try {
            String longNumber = null;
            String name = null;
            node.removeAllChildren();
            IRptMgrFacade iMainFunctionMenu = RptMgrFacadeFactory.getRemoteInstance();
            IRowSet rowset = iMainFunctionMenu.getMenuByParent(rptInfo.getLongNumber());
            int i = 0;
            String uiClassName = null;
            while (rowset.next()) {
                if (rowset.getInt("FIsLeaf") == 0 || !RptMgrTreeUtil.hasPermission(rowset.getString("FFunction"))) continue;
                longNumber = rowset.getString("FLongNumber");
                name = rowset.getString("FName_" + SysContext.getSysContext().getLocale());
                menuModel = new RptMgrMenuInfo();
                menuModel.setId(rowset.getString("FID"));
                uiClassName = rowset.getString("FUiClassName");
                if (uiClassName == null || "".equals(uiClassName)) {
                    menuModel.setEnable(false);
                } else {
                    menuModel.setEnable(true);
                }
                menuModel.setUiClassName(uiClassName);
                menuModel.setName(name);
                menuModel.setLongNumber(longNumber);
                menuModel.setIsLeaf(true);
                menuModel.setLevel(2);
                node.insert((MutableTreeNode)RptMgrTreeUtil.buildTreeNode(menuModel), i);
                ++i;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void buildChildRptNode(DefaultKingdeeTreeNode node) {
        if (customNode == node) {
            RptMgrTreeUtil.buildCustomRptNode(node);
        } else {
            RptMgrTreeUtil.buidMenuRptNode(node);
        }
    }

    private static DefaultKingdeeTreeNode[] getIsLeafOfTree(DefaultKingdeeTreeNode treeNodeRoot) {
        DefaultKingdeeTreeNode leafNode;
        int leafNodeCount = treeNodeRoot.getLeafCount();
        int leafNodeChild = treeNodeRoot.getChildCount();
        if (leafNodeCount == 1 && leafNodeChild == 0) {
            return null;
        }
        DefaultKingdeeTreeNode[] leafNodeArray = new DefaultKingdeeTreeNode[leafNodeCount];
        leafNodeArray[0] = leafNode = (DefaultKingdeeTreeNode)treeNodeRoot.getFirstLeaf();
        for (int i = 1; i < leafNodeCount; ++i) {
            leafNodeArray[i] = leafNode = (DefaultKingdeeTreeNode)leafNode.getNextLeaf();
        }
        return leafNodeArray;
    }

    private static void buildCustomRptNode(DefaultKingdeeTreeNode node) {
        block6: {
            node.removeAllChildren();
            String currCompanyID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            ArrayList<BOSUuid> allArrayId = new ArrayList<BOSUuid>();
            ReportTypeCollection reportTypeCollection = new ReportTypeCollection();
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("isLeaf"));
            sic.add(new SelectorItemInfo("level"));
            sic.add(new SelectorItemInfo("parent.id"));
            sic.add(new SelectorItemInfo("rptTypeStd.id"));
            sic.add(new SelectorItemInfo("rptTypeStd.stdType"));
            FilterInfo filter = new FilterInfo();
            FilterItemInfo filterItem = new FilterItemInfo("rptTypeStd.stdType", (Object)new Integer(2));
            FilterItemInfo filterItem2 = new FilterItemInfo("company", (Object)currCompanyID);
            filter.getFilterItems().add(filterItem);
            filter.getFilterItems().add(filterItem2);
            view.setFilter(filter);
            SorterItemCollection sortic = view.getSorter();
            sortic.add(new SorterItemInfo("level"));
            try {
                reportTypeCollection = ReportTypeFactory.getRemoteInstance().getReportTypeCollection(view);
                EntityViewInfo viewTypeStd = new EntityViewInfo();
                SelectorItemCollection sicTypeStd = viewTypeStd.getSelector();
                sicTypeStd.add(new SelectorItemInfo("id"));
                sicTypeStd.add(new SelectorItemInfo("name"));
                sicTypeStd.add(new SelectorItemInfo("seq"));
                FilterInfo filterTypeStd = new FilterInfo();
                FilterItemInfo filterItemTypeStd1 = new FilterItemInfo("isUsed", (Object)new Integer(1));
                FilterItemInfo filterItemTypeStd2 = new FilterItemInfo("stdType", (Object)new Integer(2));
                FilterItemInfo filterItemTypeStd3 = new FilterItemInfo("company", (Object)currCompanyID);
                filterTypeStd.getFilterItems().add(filterItemTypeStd1);
                filterTypeStd.getFilterItems().add(filterItemTypeStd2);
                filterTypeStd.getFilterItems().add(filterItemTypeStd3);
                viewTypeStd.setFilter(filterTypeStd);
                SorterItemCollection sorticTypeStd = viewTypeStd.getSorter();
                sorticTypeStd.add(new SorterItemInfo("seq"));
                RptTypeStdCollection rptTypeStdCollection = RptTypeStdFactory.getRemoteInstance().getRptTypeStdCollection(viewTypeStd);
                if (rptTypeStdCollection == null || rptTypeStdCollection.size() <= 0) break block6;
                int rptTypeStdCollectionSize = rptTypeStdCollection.size();
                for (int j = 0; j < rptTypeStdCollectionSize; ++j) {
                    RptTypeStdInfo tempTypeStd = rptTypeStdCollection.get(j);
                    allArrayId.add(tempTypeStd.getId());
                    ReportTypeCollection featReportTypeColl = RptMgrTreeUtil.getFeatReportType(reportTypeCollection, tempTypeStd);
                    DefaultKingdeeTreeNode[] leafNodeArray = RptMgrTreeUtil.getIsLeafOfTree(node);
                    if (leafNodeArray != null && leafNodeArray.length > 0) {
                        for (DefaultKingdeeTreeNode currencyLeafNode : leafNodeArray) {
                            RptMgrTreeUtil.addNote(currencyLeafNode, featReportTypeColl, reportTypeCollection);
                        }
                        continue;
                    }
                    RptMgrTreeUtil.addNote(node, featReportTypeColl, reportTypeCollection);
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static ReportTypeCollection getFeatReportType(ReportTypeCollection reportTypeCollection, RptTypeStdInfo tempTypeStd) {
        ReportTypeCollection featReportType = new ReportTypeCollection();
        int reportTypeCollectionSize = reportTypeCollection.size();
        for (int i = 0; i < reportTypeCollectionSize; ++i) {
            if (!reportTypeCollection.get(i).getRptTypeStd().getId().equals((Object)tempTypeStd.getId()) || reportTypeCollection.get(i).getParent() != null) continue;
            featReportType.add(reportTypeCollection.get(i));
        }
        return featReportType;
    }

    private static synchronized void addNote(DefaultKingdeeTreeNode parentNode, ReportTypeCollection featReportTypeColl, ReportTypeCollection reportTypeCollection) throws Exception {
        if (featReportTypeColl == null || featReportTypeColl.size() == 0) {
            return;
        }
        int featReportTypeCollSize = featReportTypeColl.size();
        RptMgrMenuInfo customModel = null;
        ReportTypeInfo type = null;
        for (int j = 0; j < featReportTypeCollSize; ++j) {
            type = featReportTypeColl.get(j);
            customModel = new RptMgrMenuInfo();
            customModel.setId(type.getId().toString());
            customModel.setEnable(true);
            customModel.setCustom(true);
            customModel.setUiClassName("com.kingdee.eas.cp.ba.client.RptCustomListUI");
            customModel.setName(type.getName());
            customModel.setLongNumber(type.getLongNumber());
            ReportTypeCollection childNode = RptMgrTreeUtil.getChild(featReportTypeColl.get(j), reportTypeCollection);
            if (childNode.size() > 0) {
                customModel.setIsLeaf(false);
            } else {
                customModel.setIsLeaf(true);
            }
            customModel.setLevel(type.getLevel() + 2);
            DefaultKingdeeTreeNode newLeafNode = RptMgrTreeUtil.buildTreeNode(customModel);
            parentNode.insert((MutableTreeNode)newLeafNode, j);
            RptMgrTreeUtil.addNote(newLeafNode, childNode, reportTypeCollection);
        }
    }

    private static ReportTypeCollection getChild(ReportTypeInfo parentNode, ReportTypeCollection reportTypeCollection) {
        ReportTypeCollection childNodeColl = new ReportTypeCollection();
        if (reportTypeCollection == null && reportTypeCollection.size() == 0) {
            return null;
        }
        int reportTypeCollectionSize = reportTypeCollection.size();
        for (int i = 0; i < reportTypeCollectionSize; ++i) {
            if (reportTypeCollection.get(i).getParent() == null || !reportTypeCollection.get(i).getParent().getId().equals((Object)parentNode.getId())) continue;
            childNodeColl.add(reportTypeCollection.get(i));
        }
        return childNodeColl;
    }

    private static DefaultKingdeeTreeNode buildTreeNode(RptMgrMenuInfo info) {
        DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode();
        node.setUserObject((Object)info);
        if (info.getIsLeaf() && !info.isEnable()) {
            node.setTextColor(disableColor);
        }
        return node;
    }

    private static DefaultKingdeeTreeNode buildVirtualNode() {
        DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode();
        node.setUserObject((Object)virtualInfo);
        node.setTextColor(disableColor);
        return node;
    }

    private static RptMgrMenuInfo bulidVirtualInfo() {
        RptMgrMenuInfo info = new RptMgrMenuInfo();
        info.setName("\u8282\u70b9\u8f7d\u5165\u4e2d...");
        info.setIsLeaf(true);
        info.setEnable(false);
        info.setLevel(2);
        return info;
    }

    public static DefaultKingdeeTreeNode getRootNode() {
        if (rootNode != null) {
            return rootNode;
        }
        rootNode = new DefaultKingdeeTreeNode();
        rootNode.setUserObject((Object)RptMgrTreeUtil.getRootInfo());
        return rootNode;
    }

    public static DefaultKingdeeTreeNode getCustomNode() {
        if (customNode != null) {
            return customNode;
        }
        customNode = new DefaultKingdeeTreeNode();
        customNode.setUserObject((Object)RptMgrTreeUtil.getCustomInfo());
        return customNode;
    }

    public static DefaultKingdeeTreeNode getDefineNode() {
        if (defineNode != null) {
            return defineNode;
        }
        defineNode = new DefaultKingdeeTreeNode();
        defineNode.setUserObject((Object)RptMgrTreeUtil.getDefineInfo());
        return defineNode;
    }

    public static void deleteLinkedReport(RptReportTypeInfo info) throws Exception {
        if (info == null) {
            return;
        }
        RptReleaseInfo rptInfo = null;
        IRptRelease iRpt = null;
        iRpt = RptReleaseFactory.getRemoteInstance();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("rptSort", (Object)info.getId().toString(), CompareType.EQUALS));
        filter.setMaskString(" #0 ");
        ev.setFilter(filter);
        RptReleaseCollection cols = iRpt.getRptReleaseCollection(ev);
        Iterator ite = cols.iterator();
        while (ite.hasNext()) {
            rptInfo = (RptReleaseInfo)ite.next();
            iRpt.delete((IObjectPK)new ObjectUuidPK(rptInfo.getId()));
        }
    }

    public static void deleteAccepter(RptReportTypeInfo info) throws Exception {
        if (info == null) {
            return;
        }
        RptAccepterInfo accInfo = null;
        IRptAccepter iAcc = null;
        iAcc = RptAccepterFactory.getRemoteInstance();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("report", (Object)info.getId().toString(), CompareType.EQUALS));
        filter.setMaskString(" #0 ");
        ev.setFilter(filter);
        RptAccepterCollection cols = iAcc.getRptAccepterCollection(ev);
        Iterator ite = cols.iterator();
        while (ite.hasNext()) {
            accInfo = (RptAccepterInfo)ite.next();
            iAcc.delete((IObjectPK)new ObjectUuidPK(accInfo.getId()));
        }
    }

    private static RptMgrMenuInfo getCustomInfo() {
        RptMgrMenuInfo info = new RptMgrMenuInfo();
        info.setName("\u81ea\u5b9a\u4e49\u62a5\u8868");
        info.setIsLeaf(false);
        info.setCustom(true);
        info.setLevel(1);
        return info;
    }

    private static RptMgrMenuInfo getDefineInfo() {
        RptMgrMenuInfo info = new RptMgrMenuInfo();
        info.setName("\u56fa\u5b9a\u62a5\u8868");
        info.setIsLeaf(false);
        info.setCustom(true);
        info.setLevel(1);
        return info;
    }

    private static RptMgrMenuInfo getRootInfo() {
        RptMgrMenuInfo info = new RptMgrMenuInfo();
        info.setName("\u7ba1\u7406\u62a5\u8868");
        info.setIsLeaf(false);
        info.setLevel(0);
        return info;
    }

    private static List buildSubSysMenuModels() throws EASBizException, BOSException, SQLException {
        ArrayList<RptMgrMenuInfo> result = new ArrayList<RptMgrMenuInfo>();
        Timestamp startTime = new Timestamp(System.currentTimeMillis());
        String longNumber = null;
        String name = null;
        RptMgrMenuInfo menuModel = null;
        IRptMgrFacade iMainFunctionMenu = RptMgrFacadeFactory.getRemoteInstance();
        IRowSet rowset = iMainFunctionMenu.getMainSys();
        while (rowset.next()) {
            longNumber = rowset.getString("FLongNumber");
            name = rowset.getString("FName_" + SysContext.getSysContext().getLocale());
            menuModel = new RptMgrMenuInfo();
            menuModel.setId(rowset.getString("FID"));
            menuModel.setName(name);
            menuModel.setLongNumber(longNumber);
            menuModel.setIsLeaf(false);
            menuModel.setLevel(1);
            result.add(menuModel);
        }
        logger.info((Object)("\u53d6\u4e00\u7ea7\u83dc\u5355\u8017\u65f6\uff1a" + (double)(System.currentTimeMillis() - startTime.getTime()) / 1000.0));
        return result;
    }

    public static boolean checkPersonPermission(String rptTypeID, UserInfo uInfo) {
        return RptMgrTreeUtil.checkPersonPermission(rptTypeID, uInfo.getId().toString(), uInfo.getDefOrgUnit().getId().toString());
    }

    public static boolean checkPersonPermission(String rptTypeID, String userID, String orgID) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("value", (Object)userID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("value", (Object)orgID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("report.id", (Object)rptTypeID, CompareType.EQUALS));
        filter.setMaskString("( #0 or #1 ) and #2 ");
        IRptAccepter iAcc = null;
        try {
            iAcc = RptAccepterFactory.getRemoteInstance();
            return iAcc.exists(filter);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static Object[] getPersonRelease(TreeBaseInfo treeInfo, UserInfo user) throws BOSException {
        EntityViewInfo ev = RptMgrTreeUtil.getPermissionFilter(treeInfo, user);
        IRptRelease iRpt = null;
        RptReleaseCollection cols = null;
        iRpt = RptReleaseFactory.getRemoteInstance();
        cols = iRpt.getRptReleaseCollection(ev);
        if (cols != null && cols.size() > 0) {
            return cols.toArray();
        }
        return null;
    }

    public static List getAllReport(TreeBaseInfo treeInfo, boolean mark) {
        ArrayList<String> dataList = new ArrayList<String>();
        if (treeInfo.isIsLeaf()) {
            dataList.add(treeInfo.getId().toString());
        } else {
            IRptReportType iRpt = null;
            TreeBaseCollection cols = null;
            RptReportTypeInfo rptInfo2 = null;
            try {
                iRpt = RptReportTypeFactory.getRemoteInstance();
                cols = iRpt.getAllChildren(treeInfo);
            }
            catch (Exception e) {
                logger.info((Object)e);
                return dataList;
            }
            for (RptReportTypeInfo rptInfo2 : cols) {
                if (!rptInfo2.isIsLeaf()) continue;
                dataList.add(rptInfo2.getId().toString());
            }
        }
        return dataList;
    }

    public static EntityViewInfo getPermissionFilter(TreeBaseInfo treeInfo, UserInfo user) {
        String mark = null;
        StringBuffer markString = new StringBuffer();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("receiver.value", (Object)user.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("receiver.value", (Object)user.getDefOrgUnit().getId().toString()));
        markString.append(" ( #0 or #1 ) ");
        List dataList = RptMgrTreeUtil.getAllReport(treeInfo, true);
        Iterator ite = dataList.iterator();
        int i = 2;
        while (ite.hasNext()) {
            filter.getFilterItems().add(new FilterItemInfo("rptSort.id", (Object)ite.next().toString()));
            if (i == 2) {
                markString.append(" and ( #" + i);
            } else {
                markString.append(" or #" + i);
            }
            ++i;
        }
        if (i > 2) {
            markString.append(" ) ");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("rptSort.id", (Object)"@@@@@@@@@@@@@@@@@@@@"));
            markString.append(" and #2 ");
        }
        mark = markString.toString();
        filter.setMaskString(mark);
        ev.setFilter(filter);
        return ev;
    }

    public static void removeNodeWithChild(KDTreeNode treeNode, boolean hasBizReport) throws Exception {
        RptReportTypeInfo info = null;
        info = (RptReportTypeInfo)treeNode.getUserObject();
        if (info.getLevel() == RptUtil.PORTLETLEVEL) {
            RptMgrTreeUtil.deleteAccepter(info);
        }
        if (hasBizReport) {
            RptMgrTreeUtil.deleteAllReport(treeNode);
        }
        IRptReportType rptTree = null;
        rptTree = RptReportTypeFactory.getRemoteInstance();
        rptTree.deleteWithChildren(info);
    }

    public static void deleteAllReport(KDTreeNode treeNode) throws Exception {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE, CompareType.EQUALS));
        filter.setMaskString("#0");
        ev.setFilter(filter);
        RptReportTypeInfo tempInfo2 = null;
        RptReportTypeInfo info = (RptReportTypeInfo)treeNode.getUserObject();
        IRptReportType rptTree = RptReportTypeFactory.getRemoteInstance();
        TreeBaseCollection cols = rptTree.getAllChildren(info, ev);
        for (RptReportTypeInfo tempInfo2 : cols) {
            RptMgrTreeUtil.deleteLinkedReport(tempInfo2);
        }
    }

    public static void removeLeafNode(KDTreeNode treeNode, boolean hasBizReport) throws Exception {
        RptReportTypeInfo info = (RptReportTypeInfo)treeNode.getUserObject();
        if (info.getLevel() == RptUtil.PORTLETLEVEL) {
            RptMgrTreeUtil.deleteAccepter(info);
        }
        if (hasBizReport) {
            RptMgrTreeUtil.deleteAllReport(treeNode);
        }
        IRptReportType rptTree = null;
        rptTree = RptReportTypeFactory.getRemoteInstance();
        rptTree.deleteWithChildren(info);
    }

    static {
        FI_ID = "18850e62-f0c8-403a-9e9c-d4a5ed16ccf4FD37DC9F";
        virtualInfo = RptMgrTreeUtil.bulidVirtualInfo();
        disableColor = new Color(102, 102, 102);
    }
}

