/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IMainMenuItem;
import com.kingdee.eas.base.permission.MainMenuItemFactory;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.cp.base.CPMenuTreeFactory;
import com.kingdee.eas.cp.base.CPMenuTreeInfo;
import com.kingdee.eas.cp.base.ICPMenuTree;
import com.kingdee.eas.cp.base.IMenuDef;
import com.kingdee.eas.cp.base.IMenuSolution;
import com.kingdee.eas.cp.base.IShortcutMenu;
import com.kingdee.eas.cp.base.MenuDefCollection;
import com.kingdee.eas.cp.base.MenuDefFactory;
import com.kingdee.eas.cp.base.MenuDefInfo;
import com.kingdee.eas.cp.base.MenuIconInfo;
import com.kingdee.eas.cp.base.MenuSolutionCollection;
import com.kingdee.eas.cp.base.MenuSolutionFactory;
import com.kingdee.eas.cp.base.MenuSolutionInfo;
import com.kingdee.eas.cp.base.MenuTypeEnum;
import com.kingdee.eas.cp.base.OwnerEnum;
import com.kingdee.eas.cp.base.ShortcutMenuCollection;
import com.kingdee.eas.cp.base.ShortcutMenuFactory;
import com.kingdee.eas.cp.base.ShortcutMenuInfo;
import com.kingdee.eas.cp.base.StateEnum;
import com.kingdee.eas.cp.base.app.AbstractMenuDefControllerBean;
import com.kingdee.eas.cp.base.web.MenuCommonHandle;
import com.kingdee.eas.cp.base.web.MenuParamInfo;
import com.kingdee.eas.cp.base.web.WebMenuUtil;
import com.kingdee.eas.portal.IPortalServiceFacade;
import com.kingdee.eas.portal.PortalServiceFacadeFactory;
import com.kingdee.eas.portal.PortletExtFactory;
import com.kingdee.eas.portal.PortletExtInfo;
import com.kingdee.eas.portal.PortletFactory;
import com.kingdee.eas.portal.PortletInfo;
import com.kingdee.eas.portal.PortletStateEnum;
import com.kingdee.eas.portal.web.configuration.PortletDefinitionsFactoryWrapper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class MenuDefControllerBean
extends AbstractMenuDefControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.base.app.MenuDefControllerBean");
    private String operMsg = "";
    private String tableName = "T_CP_MenuDef";

    @Override
    protected String _dragDropTree(Context ctx, Map paramMap) throws BOSException {
        ObjectUuidPK parentNodePK = new ObjectUuidPK((String)paramMap.get("parentNode"));
        ObjectUuidPK currentNodePK = new ObjectUuidPK((String)paramMap.get("currentNode"));
        String solutionId = (String)paramMap.get("solutionId");
        String dragDropType = (String)paramMap.get("type");
        IMenuDef menuDef = null;
        MenuParamInfo paramInfo = new MenuParamInfo();
        paramInfo.setSolutionId(solutionId);
        MenuDefInfo currentMenuDefInfo = null;
        MenuDefInfo parentMenuDefInfo = null;
        try {
            menuDef = MenuDefFactory.getLocalInstance(ctx);
            currentMenuDefInfo = (MenuDefInfo)menuDef.getValue((IObjectPK)currentNodePK);
            parentMenuDefInfo = (MenuDefInfo)menuDef.getValue((IObjectPK)parentNodePK);
            if (this.addSolution(ctx, paramInfo)) {
                String beforeCurrentNumber = currentMenuDefInfo.getLongNumber();
                String newCurrentNumber = StringUtils.replace((String)beforeCurrentNumber, (String)"M", (String)"U");
                currentMenuDefInfo = menuDef.getMenuDefCollection("where longnumber='" + newCurrentNumber + "'").get(0);
                String beforeParentNumber = parentMenuDefInfo.getLongNumber();
                String newParentNumber = StringUtils.replace((String)beforeParentNumber, (String)"M", (String)"U");
                parentMenuDefInfo = menuDef.getMenuDefCollection("where longnumber='" + newParentNumber + "'").get(0);
            }
            BOSUuid parentId = currentMenuDefInfo.getParent().getId();
            if (!dragDropType.equals("append") && currentMenuDefInfo.getParent().getId().toString().equals(parentMenuDefInfo.getParent().getId().toString())) {
                this.sortSameLevelMenu(ctx, menuDef, currentMenuDefInfo, parentMenuDefInfo, dragDropType);
                this.updateNumber(menuDef, currentMenuDefInfo.getId().toString());
            } else {
                if (dragDropType.equals("append")) {
                    this.updateCurrentLevelDisplayOrder(ctx, currentMenuDefInfo);
                    currentMenuDefInfo.setParent(parentMenuDefInfo);
                    this.setdisplayOrder(ctx, menuDef, currentMenuDefInfo, parentMenuDefInfo, true);
                    currentMenuDefInfo.setLevel(parentMenuDefInfo.getLevel() + 1);
                    menuDef.update((IObjectPK)new ObjectUuidPK(currentMenuDefInfo.getId()), currentMenuDefInfo);
                } else {
                    this.updateCurrentLevelDisplayOrder(ctx, currentMenuDefInfo);
                    currentMenuDefInfo.setParent(parentMenuDefInfo.getParent());
                    this.setdisplayOrder(ctx, menuDef, currentMenuDefInfo, parentMenuDefInfo, false);
                    currentMenuDefInfo.setLevel(parentMenuDefInfo.getLevel());
                    menuDef.update((IObjectPK)new ObjectUuidPK(currentMenuDefInfo.getId()), currentMenuDefInfo);
                    this.sortSameLevelMenu(ctx, menuDef, currentMenuDefInfo, parentMenuDefInfo, dragDropType);
                }
                this.updateNumber(menuDef, parentId.toString());
                this.updateNumber(menuDef, currentMenuDefInfo.getParent().getId().toString());
                if (menuDef.exists("where parent='" + currentMenuDefInfo.getId().toString() + "'")) {
                    MenuDefInfo current = (MenuDefInfo)menuDef.getValue((IObjectPK)new ObjectUuidPK(currentMenuDefInfo.getId()));
                    this.updateChildNumber(menuDef, currentMenuDefInfo.getId().toString(), current.getNumber());
                }
            }
            if (!menuDef.exists("where parent='" + parentId.toString() + "'")) {
                DbUtil.execute((Context)ctx, (String)("update " + this.tableName + " set fisleaf=1 where fid='" + parentId.toString() + "'"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.operMsg = e.getMessage();
            return WebMenuUtil.getErrorMsg(new String[]{"\u4fdd\u5b58\u64cd\u4f5c\u5931\u8d25"});
        }
        return WebMenuUtil.getSuccessMsg(null);
    }

    @Override
    protected String _delMenuDef(Context ctx, MenuParamInfo paramInfo) throws BOSException {
        IMenuDef menuDef = null;
        try {
            menuDef = MenuDefFactory.getLocalInstance(ctx);
            if (menuDef.exists("where parent='" + paramInfo.getId() + "' and state = 0")) {
                this.operMsg = "1";
                return WebMenuUtil.getErrorMsg(new String[]{this.operMsg});
            }
            if (menuDef.exists("where id='" + paramInfo.getId() + "' and parent is null")) {
                this.operMsg = "2";
                return WebMenuUtil.getErrorMsg(new String[]{this.operMsg});
            }
            this.addSolution(ctx, paramInfo);
            MenuDefInfo menuDefInfo = (MenuDefInfo)menuDef.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)paramInfo.getId())));
            paramInfo.setParentId(menuDefInfo.getParent().getId().toString());
            menuDef.delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)paramInfo.getId())));
            ShortcutMenuFactory.getLocalInstance(ctx).delete("where menu = '" + paramInfo.getId() + "'");
        }
        catch (Exception e) {
            return WebMenuUtil.getErrorMsg(new String[]{this.operMsg});
        }
        return WebMenuUtil.getSuccessMsg(new String[]{"", this.getNodePath(ctx, paramInfo.getParentId())});
    }

    @Override
    protected String _saveMenuDef(Context ctx, MenuParamInfo paramInfo) throws BOSException {
        MenuSolutionInfo menuSoInfo = null;
        try {
            menuSoInfo = this.saveSolution(ctx, paramInfo);
            this.addSolution(ctx, paramInfo);
            if (null != paramInfo.getId() && !"".equals(paramInfo.getId())) {
                this.updateModel(ctx, paramInfo);
            } else {
                this.addNewModel(ctx, paramInfo, menuSoInfo);
            }
        }
        catch (Exception e) {
            this.operMsg = "1";
            if (e.getMessage().indexOf("80") > -1) {
                this.operMsg = "2";
            }
            return WebMenuUtil.getErrorMsg(new String[]{this.operMsg});
        }
        return WebMenuUtil.getSuccessMsg(new String[]{menuSoInfo.getId().toString(), this.getNodePath(ctx, paramInfo.getId())});
    }

    private String getNodePath(Context ctx, String menuId) {
        StringBuffer path = new StringBuffer("/" + WebMenuUtil.ROOT_NODE + "/");
        try {
            MenuDefInfo menuInfo = MenuDefFactory.getLocalInstance(ctx).getMenuDefCollection("select longnumber where id='" + menuId + "'").get(0);
            path.append(StringUtils.replace((String)menuInfo.getLongNumber(), (String)"!", (String)"/"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return path.toString();
    }

    private void updateNumber(IMenuDef menuDef, String parentId) throws Exception {
        MenuDefCollection menuDefCols = menuDef.getMenuDefCollection("where parent ='" + parentId + "' order by displayOrder asc");
        if (null != menuDefCols && menuDefCols.size() > 0) {
            int i;
            MenuDefInfo thisInfo = null;
            String parentNumber = ((MenuDefInfo)menuDef.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)parentId)))).getNumber();
            String tempNum = "T" + parentNumber.substring(1);
            for (i = 0; i < menuDefCols.size(); ++i) {
                thisInfo = menuDefCols.get(i);
                if (i < 9) {
                    thisInfo.setNumber(tempNum + "0" + (i + 1));
                } else {
                    thisInfo.setNumber(tempNum + (i + 1));
                }
                thisInfo.setDisplayOrder(i + 1);
                menuDef.update((IObjectPK)new ObjectUuidPK(thisInfo.getId()), thisInfo);
            }
            for (i = 0; i < menuDefCols.size(); ++i) {
                thisInfo = menuDefCols.get(i);
                if (i < 9) {
                    thisInfo.setNumber(parentNumber + "0" + (i + 1));
                } else {
                    thisInfo.setNumber(parentNumber + (i + 1));
                }
                menuDef.update((IObjectPK)new ObjectUuidPK(thisInfo.getId()), thisInfo);
            }
        }
    }

    private void updateChildNumber(IMenuDef menuDef, String parentId, String parentNumber) throws Exception {
        MenuDefCollection menuDefCols = menuDef.getMenuDefCollection("where parent ='" + parentId + "' order by longnumber asc");
        if (null != menuDefCols && menuDefCols.size() > 0) {
            MenuDefInfo thisInfo = null;
            for (int i = 0; i < menuDefCols.size(); ++i) {
                thisInfo = menuDefCols.get(i);
                if (i < 9) {
                    thisInfo.setNumber(parentNumber + "0" + (i + 1));
                } else {
                    thisInfo.setNumber(parentNumber + (i + 1));
                }
                menuDef.update((IObjectPK)new ObjectUuidPK(thisInfo.getId()), thisInfo);
                this.updateChildNumber(menuDef, thisInfo.getId().toString(), thisInfo.getNumber());
            }
        }
    }

    private void updateModel(Context ctx, MenuParamInfo paramInfo) throws Exception {
        ObjectUuidPK pk;
        IMenuDef menuDef = null;
        MenuDefInfo menuDefInfo = null;
        menuDef = MenuDefFactory.getLocalInstance(ctx);
        if (menuDef.exists((IObjectPK)(pk = new ObjectUuidPK(BOSUuid.read((String)paramInfo.getId()))))) {
            menuDefInfo = (MenuDefInfo)menuDef.getValue((IObjectPK)pk);
            this.setMenuDefInfo(ctx, menuDefInfo, paramInfo);
            menuDef.update((IObjectPK)pk, menuDefInfo);
        }
        DbUtil.execute((Context)ctx, (String)("update t_cp_shortcutmenu set fname_l2='" + menuDefInfo.getName() + "' where fmenuid='" + pk.toString() + "'"));
    }

    private void addNewModel(Context ctx, MenuParamInfo paramInfo, MenuSolutionInfo menuSoInfo) throws Exception {
        IMenuDef menuDef = null;
        MenuDefInfo menuDefInfo = null;
        menuDef = MenuDefFactory.getLocalInstance(ctx);
        PersonInfo personInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        menuDefInfo = new MenuDefInfo();
        menuDefInfo.setSolution(menuSoInfo);
        this.setMenuDefInfo(ctx, menuDefInfo, paramInfo);
        MenuDefInfo parentInfo = null;
        if (null != paramInfo.getParentId() && !"".equals(paramInfo.getParentId()) && !"root".equals(paramInfo.getParentId())) {
            parentInfo = (MenuDefInfo)menuDef.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)paramInfo.getParentId())));
            parentInfo.setIsLeaf(false);
            menuDefInfo.setParent(parentInfo);
            menuDef.update((IObjectPK)new ObjectUuidPK(parentInfo.getId()), parentInfo);
            menuDefInfo.setLevel(parentInfo.getLevel() + 1);
            this.setWebMenuNumber(ctx, menuDef, parentInfo, menuDefInfo);
        } else {
            String number = menuSoInfo.getNumber();
            menuDefInfo.setNumber(number);
            menuDefInfo.setLongNumber(number);
            menuDefInfo.setLevel(1);
            menuDefInfo.setDisplayOrder(1);
        }
        menuDefInfo.setId(BOSUuid.create((BOSObjectType)menuDefInfo.getBOSType()));
        menuDefInfo.setOwnerType(OwnerEnum.getEnum(paramInfo.isAdmin() ? 0 : 1));
        menuDefInfo.setPerson(paramInfo.isAdmin() ? null : personInfo);
        menuDefInfo.setState(StateEnum.ENABLE_STATE);
        menuDef.addnew(menuDefInfo);
        paramInfo.setId(menuDefInfo.getId().toString());
    }

    private void setMenuDefInfo(Context ctx, MenuDefInfo menuDefInfo, MenuParamInfo paramInfo) throws Exception {
        menuDefInfo.setName(paramInfo.getMenuName());
        menuDefInfo.setMenuType(MenuTypeEnum.getEnum(Integer.parseInt(paramInfo.getMenuType())));
        try {
            MenuIconInfo menuIcon = new MenuIconInfo();
            menuIcon.setId(BOSUuid.read((String)paramInfo.getMenuIcon()));
            menuDefInfo.setIcon(menuIcon);
        }
        catch (Exception e) {
            menuDefInfo.setMenuIcon(paramInfo.getMenuIcon());
        }
        menuDefInfo.setNodeType(paramInfo.isParentNode());
        if (!paramInfo.isParentNode()) {
            menuDefInfo.setWebUrl(null);
            menuDefInfo.setGuiMenu(null);
            menuDefInfo.setWebMenu(null);
        } else {
            ICPMenuTree webMenu = CPMenuTreeFactory.getLocalInstance(ctx);
            IMainMenuItem guiMenu = MainMenuItemFactory.getLocalInstance((Context)ctx);
            if (menuDefInfo.getMenuType().equals((Object)MenuTypeEnum.URL_MENU)) {
                menuDefInfo.setWebUrl(paramInfo.getMenuUrl());
            } else if (null != paramInfo.getMenuUrl() && !"".equals(paramInfo.getMenuUrl())) {
                if (menuDefInfo.getMenuType().equals((Object)MenuTypeEnum.GUI_MENU)) {
                    MainMenuItemInfo menuInfo = (MainMenuItemInfo)guiMenu.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)paramInfo.getMenuUrl())));
                    menuDefInfo.setGuiMenu(menuInfo);
                } else if (menuDefInfo.getMenuType().equals((Object)MenuTypeEnum.WEB_MENU)) {
                    CPMenuTreeInfo menuInfo = (CPMenuTreeInfo)webMenu.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)paramInfo.getMenuUrl())));
                    menuDefInfo.setWebMenu(menuInfo);
                } else if (menuDefInfo.getMenuType().equals((Object)MenuTypeEnum.DOC_MENU)) {
                    // empty if block
                }
            }
        }
    }

    private void sortSameLevelMenu(Context ctx, IMenuDef menuDef, MenuDefInfo currentMenuDefInfo, MenuDefInfo parentMenuDefInfo, String type) throws Exception {
        String updateSql = null;
        if (currentMenuDefInfo.getParent().equals(currentMenuDefInfo.getParent())) {
            if (currentMenuDefInfo.getDisplayOrder() > parentMenuDefInfo.getDisplayOrder()) {
                if (type.equals("above")) {
                    updateSql = "update " + this.tableName + " set fdisplayOrder=fdisplayOrder+1 where fdisplayOrder>=" + parentMenuDefInfo.getDisplayOrder() + " and fdisplayOrder<" + currentMenuDefInfo.getDisplayOrder() + " and flevel=" + currentMenuDefInfo.getLevel() + " and  fparentid='" + currentMenuDefInfo.getParent().getId().toString() + "'";
                    DbUtil.execute((Context)ctx, (String)updateSql);
                    currentMenuDefInfo.setDisplayOrder(parentMenuDefInfo.getDisplayOrder());
                    menuDef.update((IObjectPK)new ObjectUuidPK(currentMenuDefInfo.getId()), currentMenuDefInfo);
                } else if (type.equals("below")) {
                    updateSql = "update " + this.tableName + " set fdisplayOrder=fdisplayOrder+1 where fdisplayOrder>=" + (parentMenuDefInfo.getDisplayOrder() + 1) + " and fdisplayOrder<" + currentMenuDefInfo.getDisplayOrder() + " and flevel=" + currentMenuDefInfo.getLevel() + " and  fparentid='" + currentMenuDefInfo.getParent().getId().toString() + "'";
                    DbUtil.execute((Context)ctx, (String)updateSql);
                    currentMenuDefInfo.setDisplayOrder(parentMenuDefInfo.getDisplayOrder() + 1);
                    menuDef.update((IObjectPK)new ObjectUuidPK(currentMenuDefInfo.getId()), currentMenuDefInfo);
                }
            } else if (type.equals("above")) {
                updateSql = "update " + this.tableName + " set fdisplayOrder=fdisplayOrder-1 where fdisplayOrder>" + currentMenuDefInfo.getDisplayOrder() + " and fdisplayOrder<" + parentMenuDefInfo.getDisplayOrder() + " and flevel=" + currentMenuDefInfo.getLevel() + " and  fparentid='" + currentMenuDefInfo.getParent().getId().toString() + "'";
                DbUtil.execute((Context)ctx, (String)updateSql);
                currentMenuDefInfo.setDisplayOrder(parentMenuDefInfo.getDisplayOrder() - 1);
                menuDef.update((IObjectPK)new ObjectUuidPK(currentMenuDefInfo.getId()), currentMenuDefInfo);
            } else if (type.equals("below")) {
                updateSql = "update " + this.tableName + " set fdisplayOrder=fdisplayOrder-1 where fdisplayOrder>" + currentMenuDefInfo.getDisplayOrder() + " and fdisplayOrder<=" + parentMenuDefInfo.getDisplayOrder() + " and flevel=" + currentMenuDefInfo.getLevel() + " and  fparentid='" + currentMenuDefInfo.getParent().getId().toString() + "'";
                DbUtil.execute((Context)ctx, (String)updateSql);
                currentMenuDefInfo.setDisplayOrder(parentMenuDefInfo.getDisplayOrder());
                menuDef.update((IObjectPK)new ObjectUuidPK(currentMenuDefInfo.getId()), currentMenuDefInfo);
            }
        }
    }

    private void setdisplayOrder(Context ctx, IMenuDef menuDef, MenuDefInfo currentMenuDefInfo, MenuDefInfo parentMenuDefInfo, boolean isAppend) {
        try {
            String oql = null;
            oql = isAppend ? "where longNumber like '%" + parentMenuDefInfo.getLongNumber() + "%' and level=" + (parentMenuDefInfo.getLevel() + 1) + " order by displayOrder desc" : "where parent.id='" + parentMenuDefInfo.getParent().getId().toString() + "' order by displayOrder desc";
            MenuDefCollection menuDefCols = menuDef.getMenuDefCollection(oql);
            if (null != menuDefCols && menuDefCols.size() > 0) {
                MenuDefInfo menuDefInfo = menuDefCols.get(0);
                currentMenuDefInfo.setDisplayOrder(menuDefInfo.getDisplayOrder() + 1);
            } else {
                currentMenuDefInfo.setDisplayOrder(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateCurrentLevelDisplayOrder(Context ctx, MenuDefInfo currentMenuDefInfo) {
        try {
            String updateSql = "update " + this.tableName + " set fdisplayOrder=fdisplayOrder-1 where fdisplayOrder>" + currentMenuDefInfo.getDisplayOrder() + " and fparentid='" + currentMenuDefInfo.getParent().getId().toString() + "'";
            DbUtil.execute((Context)ctx, (String)updateSql);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setWebMenuNumber(Context ctx, IMenuDef menuDef, MenuDefInfo parentMenuInfo, MenuDefInfo menuDefInfo) {
        String longNumber = parentMenuInfo.getLongNumber();
        MenuDefInfo tempInfo = null;
        try {
            MenuDefCollection menuDefCols = menuDef.getMenuDefCollection("where longNumber like '%" + longNumber + "!%' and level=" + (parentMenuInfo.getLevel() + 1) + " order by longnumber desc");
            int size = menuDefCols.size();
            if (size > 0) {
                tempInfo = menuDefCols.get(0);
                String tempLongNumber = tempInfo.getLongNumber();
                String lastStr = tempLongNumber.substring(tempLongNumber.lastIndexOf("!") + 1, tempLongNumber.length());
                int num = Integer.parseInt(lastStr.substring(lastStr.length() - 2, lastStr.length()));
                if (num < 9) {
                    menuDefInfo.setNumber(tempInfo.getNumber().substring(0, tempInfo.getNumber().length() - 2) + "0" + (num + 1));
                    menuDefInfo.setLongNumber(parentMenuInfo.getLongNumber() + "!" + menuDefInfo.getNumber());
                } else {
                    menuDefInfo.setNumber(tempInfo.getNumber().substring(0, tempInfo.getNumber().length() - 2) + (num + 1));
                    menuDefInfo.setLongNumber(parentMenuInfo.getLongNumber() + "!" + menuDefInfo.getNumber());
                }
                menuDefInfo.setDisplayOrder(num + 1);
            } else {
                menuDefInfo.setNumber(parentMenuInfo.getNumber() + "01");
                menuDefInfo.setLongNumber(parentMenuInfo.getLongNumber() + "!" + menuDefInfo.getNumber());
                menuDefInfo.setDisplayOrder(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private synchronized MenuSolutionInfo saveSolution(Context ctx, MenuParamInfo paramInfo) {
        IMenuSolution menuSolution = null;
        MenuSolutionInfo menuSoInfo = null;
        try {
            menuSolution = MenuSolutionFactory.getLocalInstance(ctx);
            IPortalServiceFacade portletService = PortalServiceFacadeFactory.getLocalInstance((Context)ctx);
            if (null == paramInfo.getSolutionId() || "null".equals(paramInfo.getSolutionId()) || "".equals(paramInfo.getSolutionId())) {
                menuSoInfo = new MenuSolutionInfo();
                menuSoInfo.setSpecNum(MenuDefControllerBean.getUniqueMenuSolutionSpecNum(ctx));
                menuSoInfo.setNumber("M" + menuSoInfo.getSpecNum());
                menuSoInfo.setName(paramInfo.getSolutionName());
                menuSoInfo.setState(StateEnum.ENABLE_STATE);
                menuSoInfo.setId(BOSUuid.create((BOSObjectType)menuSoInfo.getBOSType()));
                PortletInfo pInfo = new PortletInfo();
                pInfo.setId(BOSUuid.create((BOSObjectType)pInfo.getBOSType()));
                pInfo.setPortletDefineId("205");
                Locale locale = new Locale("L1");
                pInfo.setPortletName(paramInfo.getSolutionName(), locale);
                pInfo.setDescription(paramInfo.getSolutionName(), locale);
                locale = new Locale("L2");
                pInfo.setDescription(paramInfo.getSolutionName(), locale);
                pInfo.setPortletName(paramInfo.getSolutionName(), locale);
                locale = new Locale("L3");
                pInfo.setDescription(paramInfo.getSolutionName(), locale);
                pInfo.setPortletName(paramInfo.getSolutionName(), locale);
                pInfo.setEnable(PortletStateEnum.PORTLET_RUN);
                Date date = new Date();
                pInfo.setPortletNumber("CPM-" + Long.toString(date.getTime()).substring(4));
                PortletExtInfo extInfo = new PortletExtInfo();
                extInfo.setId(BOSUuid.create((BOSObjectType)extInfo.getBOSType()));
                extInfo.setShowTitleArea(1);
                extInfo.setTitle(paramInfo.getSolutionName());
                extInfo.setShowContentAreaBorder(1);
                extInfo.setShowTitleAreaBorder(1);
                extInfo.setHeight(0);
                extInfo.setBizDefUrl(WebMenuUtil.MENU_DEF_URL);
                extInfo.setBizInsUrl(WebMenuUtil.MENU_INS_URL);
                extInfo.setAttrConfigurable(1);
                extInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                extInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                extInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                extInfo.setCreateTime(this.getTime());
                extInfo.setLastUpdateTime(this.getTime());
                pInfo.setPortletExt(extInfo);
                portletService.addPortlet(pInfo);
                this.refreshPortletCache(ctx);
                menuSoInfo.setPortletId(pInfo.getId().toString());
                menuSolution.addnew(menuSoInfo);
            } else {
                menuSoInfo = (MenuSolutionInfo)menuSolution.getValue((IObjectPK)new ObjectUuidPK(paramInfo.getSolutionId()));
                if (!paramInfo.getSolutionName().equals(menuSoInfo.getName())) {
                    ObjectUuidPK pk = new ObjectUuidPK(menuSoInfo.getPortletId().toString());
                    PortletInfo pInfo = (PortletInfo)PortletFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)pk);
                    PortletExtInfo pExtInfo = (PortletExtInfo)PortletExtFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(pInfo.getPortletExt().getId()));
                    pExtInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                    pExtInfo.setLastUpdateTime(this.getTime());
                    pExtInfo.setTitle(paramInfo.getSolutionName());
                    if (pInfo != null) {
                        pInfo.setPortletExt(pExtInfo);
                        Locale locale = new Locale("L1");
                        pInfo.setPortletName(paramInfo.getSolutionName(), locale);
                        locale = new Locale("L2");
                        pInfo.setPortletName(paramInfo.getSolutionName(), locale);
                        locale = new Locale("L3");
                        pInfo.setPortletName(paramInfo.getSolutionName(), locale);
                        portletService.update(pInfo.getId(), pInfo);
                        this.refreshPortletCache(ctx);
                    }
                    menuSoInfo.setName(paramInfo.getSolutionName());
                    menuSolution.update((IObjectPK)new ObjectUuidPK(menuSoInfo.getId()), menuSoInfo);
                }
            }
            return menuSoInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void refreshPortletCache(Context ctx) {
        try {
            PortletDefinitionsFactoryWrapper.refreshPortletDefinitions((Context)ctx);
            PortalServiceFacadeFactory.getLocalInstance((Context)ctx).refreshPortletCache();
            logger.debug((Object)"\u95e8\u6237\u83dc\u5355\u66f4\u65b0portlet\u540e\u5237\u65b0\u7f13\u5b58\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected boolean _isUserHasSolution(Context ctx, Map paramMap) throws BOSException {
        String solutionId = (String)paramMap.get("solutionId");
        String personId = (String)paramMap.get("personId");
        try {
            return MenuDefFactory.getLocalInstance(ctx).exists("where solution='" + solutionId + "' and person='" + personId + "' and ownerType = 1");
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean addSolution(Context ctx, MenuParamInfo paramInfo) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        boolean isExe = false;
        if (!paramInfo.isAdmin()) {
            PersonInfo personInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
            paramMap.put("solutionId", paramInfo.getSolutionId());
            paramMap.put("personId", personInfo.getId().toString());
            try {
                if (!this.isUserHasSolution(ctx, paramMap)) {
                    this.batchAddUserSolution(ctx, paramInfo, paramMap);
                    this.updateShortcutMenuID(ctx, paramMap);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return isExe;
    }

    @Override
    protected void _batchAddUserSolution(Context ctx, MenuParamInfo paramInfo, Map cacheMap) {
        try {
            IMenuDef menuDef = MenuDefFactory.getLocalInstance(ctx);
            PersonInfo personInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
            MenuDefInfo menuDefInfo = null;
            MenuDefCollection menuCols = menuDef.getMenuDefCollection("where ownerType = 0 and solution='" + paramInfo.getSolutionId() + "' order by longnumber asc");
            Map wfKeyMap = MenuCommonHandle.getAllWorkFlowKeyMap(ctx);
            if (null != menuCols && menuCols.size() > 0) {
                String userSolutionNumber = this.getUserSolutionNumber(ctx, menuDef, menuDefInfo, paramInfo.getSolutionId());
                IMenuSolution menuSol = MenuSolutionFactory.getLocalInstance(ctx);
                MenuSolutionInfo solInfo = (MenuSolutionInfo)menuSol.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)paramInfo.getSolutionId())));
                for (int i = 0; i < menuCols.size(); ++i) {
                    menuDefInfo = (MenuDefInfo)menuCols.get(i).clone();
                    if (null != menuDefInfo.getWebMenu() && null != wfKeyMap.get(menuDefInfo.getWebMenu().getId().toString())) continue;
                    String id = menuDefInfo.getId().toString();
                    menuDefInfo.setId(BOSUuid.create((BOSObjectType)menuDefInfo.getBOSType()));
                    cacheMap.put(id, menuDefInfo);
                    menuDefInfo.setSourceId(id);
                    menuDefInfo.setPerson(personInfo);
                    menuDefInfo.setOwnerType(OwnerEnum.IS_USER);
                    if (id.equals(paramInfo.getId())) {
                        paramInfo.setId(menuDefInfo.getId().toString());
                    }
                    menuDefInfo.setNumber(StringUtils.replace((String)menuDefInfo.getNumber(), (String)solInfo.getNumber(), (String)userSolutionNumber));
                    String curLongNumber = StringUtils.replace((String)menuDefInfo.getLongNumber(), (String)solInfo.getNumber(), (String)userSolutionNumber);
                    menuDefInfo.setLongNumber(curLongNumber);
                    this.resetUserMenuParent(ctx, menuDef, curLongNumber, paramInfo, cacheMap, menuDefInfo);
                    if (id.equals(paramInfo.getParentId())) {
                        paramInfo.setParentId(menuDefInfo.getId().toString());
                    }
                    menuDef.addnew(menuDefInfo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _updateShortcutMenuID(Context ctx, Map idMap) {
        try {
            PersonInfo personInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
            IShortcutMenu ism = ShortcutMenuFactory.getLocalInstance(ctx);
            ShortcutMenuCollection scmcols = ism.getShortcutMenuCollection("where state = 0 and person='" + personInfo.getId().toString() + "'");
            if (null != scmcols && scmcols.size() > 0) {
                ShortcutMenuInfo scmInfo = null;
                String menuId = null;
                for (int j = 0; j < scmcols.size(); ++j) {
                    scmInfo = scmcols.get(j);
                    if (null == scmInfo.getMenu() || null == idMap.get(menuId = scmInfo.getMenu().getId().toString())) continue;
                    scmInfo.setMenu((MenuDefInfo)idMap.get(menuId));
                    ism.update((IObjectPK)new ObjectUuidPK(scmInfo.getId()), scmInfo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getUserSolutionNumber(Context ctx, IMenuDef menuDef, MenuDefInfo menuDefInfo, String solutionId) throws Exception {
        MenuDefCollection menuCols = menuDef.getMenuDefCollection("where ownerType = 1 and parent is null");
        String solNumber = "U" + this.getUniqueUserMenuNumber(ctx, menuCols);
        return solNumber;
    }

    private static synchronized int getUniqueMenuSolutionSpecNum(Context ctx) throws Exception {
        IMenuSolution menuSol = MenuSolutionFactory.getLocalInstance(ctx);
        MenuSolutionCollection cols = menuSol.getMenuSolutionCollection("select specNum order by specNum desc");
        return cols.get(0).getSpecNum() + 1;
    }

    private synchronized int getUniqueUserMenuNumber(Context ctx, MenuDefCollection menuCols) {
        int number = 1;
        if (null == menuCols || menuCols.size() == 0) {
            return number;
        }
        int[] num = new int[menuCols.size()];
        for (int i = 0; i < menuCols.size(); ++i) {
            num[i] = Integer.parseInt(menuCols.get(i).getNumber().substring(1));
        }
        for (int j = 0; j < num.length; ++j) {
            if (num[j] <= number) continue;
            number = num[j];
        }
        return number + 1;
    }

    private void resetUserMenuParent(Context ctx, IMenuDef menuDef, String curLongNumber, MenuParamInfo paramInfo, Map cacheMap, MenuDefInfo menuDefInfo) throws Exception {
        if (curLongNumber.indexOf("!") > -1) {
            String parentNumber = curLongNumber.substring(0, curLongNumber.lastIndexOf("!"));
            MenuDefInfo parentMenuDefInfo = null;
            if (null != cacheMap.get(parentNumber)) {
                menuDefInfo.setParent((MenuDefInfo)cacheMap.get(parentNumber));
            } else {
                parentMenuDefInfo = menuDef.getMenuDefCollection("where longnumber ='" + parentNumber + "'").get(0);
                menuDefInfo.setParent(parentMenuDefInfo);
                cacheMap.put(parentNumber, parentMenuDefInfo);
            }
        } else {
            cacheMap.put(curLongNumber, menuDefInfo);
        }
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }
}

