/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.base.IMenuSolution;
import com.kingdee.eas.cp.base.MenuDefFactory;
import com.kingdee.eas.cp.base.MenuSolutionFactory;
import com.kingdee.eas.cp.base.MenuSolutionInfo;
import com.kingdee.eas.cp.base.ShortcutMenuFactory;
import com.kingdee.eas.cp.base.StateEnum;
import com.kingdee.eas.cp.base.app.AbstractMenuSolutionControllerBean;
import com.kingdee.eas.cp.base.web.WebMenuUtil;
import com.kingdee.eas.portal.IPortalServiceFacade;
import com.kingdee.eas.portal.PortalServiceFacadeFactory;
import com.kingdee.eas.portal.PortletFactory;
import com.kingdee.eas.portal.PortletInfo;
import com.kingdee.eas.portal.web.configuration.PortletDefinitionsFactoryWrapper;
import com.kingdee.util.UuidException;
import org.apache.log4j.Logger;

public class MenuSolutionControllerBean
extends AbstractMenuSolutionControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.base.app.MenuSolutionControllerBean");
    private String operMsg = "";

    @Override
    protected String _delMenuSolution(Context ctx, String solutionId) throws BOSException {
        try {
            MenuDefFactory.getLocalInstance(ctx).delete("where ownerType=0 and solution='" + solutionId + "'");
            IMenuSolution msol = MenuSolutionFactory.getLocalInstance(ctx);
            MenuSolutionInfo menusolution = (MenuSolutionInfo)msol.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)solutionId)));
            PortletInfo portletInfo = (PortletInfo)PortletFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)menusolution.getPortletId())));
            ShortcutMenuFactory.getLocalInstance(ctx).delete("where solution='" + solutionId + "'");
            PortalServiceFacadeFactory.getLocalInstance((Context)ctx).deletePortlet(portletInfo.getId().toString());
            msol.delete("where id='" + solutionId + "'");
            this.refreshPortletCache(ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.operMsg = "\u5220\u9664\u5931\u8d25";
            return WebMenuUtil.getErrorMsg(new String[]{this.operMsg});
        }
        return WebMenuUtil.getSuccessMsg(null);
    }

    @Override
    protected String _disableMenuSolution(Context ctx, String solutionId) throws BOSException {
        try {
            IMenuSolution msol = MenuSolutionFactory.getLocalInstance(ctx);
            MenuSolutionInfo menusolution = (MenuSolutionInfo)msol.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)solutionId)));
            menusolution.setState(StateEnum.DISABLE_STATE);
            msol.update((IObjectPK)new ObjectUuidPK(menusolution.getId()), menusolution);
            IPortalServiceFacade iPortal = PortalServiceFacadeFactory.getLocalInstance((Context)ctx);
            iPortal.disablePortlet(menusolution.getPortletId());
            this.refreshPortletCache(ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.operMsg = "\u7981\u7528\u5931\u8d25";
            return WebMenuUtil.getErrorMsg(new String[]{this.operMsg});
        }
        return WebMenuUtil.getSuccessMsg(null);
    }

    @Override
    protected String _enableMenuSolution(Context ctx, String solutionId) throws BOSException {
        try {
            IMenuSolution msol = MenuSolutionFactory.getLocalInstance(ctx);
            MenuSolutionInfo menusolution = (MenuSolutionInfo)msol.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)solutionId)));
            menusolution.setState(StateEnum.ENABLE_STATE);
            msol.update((IObjectPK)new ObjectUuidPK(menusolution.getId()), menusolution);
            IPortalServiceFacade iPortal = PortalServiceFacadeFactory.getLocalInstance((Context)ctx);
            iPortal.enablePortlet(menusolution.getPortletId());
            this.refreshPortletCache(ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.operMsg = "\u542f\u7528\u5931\u8d25";
            return WebMenuUtil.getErrorMsg(new String[]{this.operMsg});
        }
        return WebMenuUtil.getSuccessMsg(null);
    }

    private void refreshPortletCache(Context ctx) {
        try {
            PortletDefinitionsFactoryWrapper.refreshPortletDefinitions((Context)ctx);
            PortalServiceFacadeFactory.getLocalInstance((Context)ctx).refreshPortletCache();
            logger.debug((Object)"\u95e8\u6237\u83dc\u5355\u65b9\u6848\u5237\u65b0portlet\u7f13\u5b58\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected String _expandNodes(Context ctx, String solutionId, boolean expandStatus) throws BOSException {
        IMenuSolution msol = MenuSolutionFactory.getLocalInstance(ctx);
        try {
            MenuSolutionInfo menuSolution = (MenuSolutionInfo)msol.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)solutionId)));
            menuSolution.setExpand(expandStatus);
            msol.update((IObjectPK)new ObjectUuidPK(menuSolution.getId()), menuSolution);
            IPortalServiceFacade iPortal = PortalServiceFacadeFactory.getLocalInstance((Context)ctx);
            iPortal.enablePortlet(menuSolution.getPortletId());
            this.refreshPortletCache(ctx);
            return WebMenuUtil.getSuccessMsg(null);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return WebMenuUtil.getErrorMsg(new String[]{"\u64cd\u4f5c\u5931\u8d25"});
        }
        catch (UuidException e) {
            e.printStackTrace();
            return WebMenuUtil.getErrorMsg(new String[]{"\u64cd\u4f5c\u5931\u8d25"});
        }
    }
}

