/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IMainMenuItem;
import com.kingdee.eas.base.permission.MainMenuItemFactory;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.cp.base.CPMenuTreeFactory;
import com.kingdee.eas.cp.base.CPMenuTreeInfo;
import com.kingdee.eas.cp.base.ICPMenuTree;
import com.kingdee.eas.cp.base.IMenuDef;
import com.kingdee.eas.cp.base.IShortcutMenu;
import com.kingdee.eas.cp.base.MenuDefFactory;
import com.kingdee.eas.cp.base.MenuDefInfo;
import com.kingdee.eas.cp.base.MenuIconInfo;
import com.kingdee.eas.cp.base.MenuTypeEnum;
import com.kingdee.eas.cp.base.OwnerEnum;
import com.kingdee.eas.cp.base.ShortcutDefFactory;
import com.kingdee.eas.cp.base.ShortcutDefInfo;
import com.kingdee.eas.cp.base.ShortcutMenuFactory;
import com.kingdee.eas.cp.base.ShortcutMenuInfo;
import com.kingdee.eas.cp.base.SourceFromEnum;
import com.kingdee.eas.cp.base.StateEnum;
import com.kingdee.eas.cp.base.app.AbstractShortcutDefControllerBean;
import com.kingdee.eas.cp.base.web.MenuCommonHandle;
import com.kingdee.eas.cp.base.web.MenuParamInfo;
import com.kingdee.eas.cp.base.web.WebMenuUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ShortcutDefControllerBean
extends AbstractShortcutDefControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.base.app.ShortcutDefControllerBean");
    private String operMsg = "";

    @Override
    protected String _saveShtMenuDef(Context ctx, MenuParamInfo paramInfo) throws BOSException {
        IShortcutMenu iShortcutMenu = null;
        try {
            iShortcutMenu = ShortcutMenuFactory.getLocalInstance(ctx);
            if (!paramInfo.isAdmin()) {
                MenuCommonHandle.batchAddShorcutMenu(ctx, paramInfo);
                MenuCommonHandle.batchSynUserMenuSolution(ctx, new HashMap());
            }
            if (null != paramInfo.getId() && !"".equals(paramInfo.getId())) {
                this.updateModel(ctx, iShortcutMenu, paramInfo);
            } else {
                this.addNewModel(ctx, iShortcutMenu, paramInfo);
            }
        }
        catch (Exception e) {
            this.operMsg = "1";
            if (e.getMessage().indexOf("80") > -1) {
                this.operMsg = "2";
            }
            return WebMenuUtil.getErrorMsg(new String[]{this.operMsg});
        }
        return WebMenuUtil.getSuccessMsg(new String[]{this.getNodePath(iShortcutMenu, paramInfo.getId())});
    }

    private String getNodePath(IShortcutMenu iShortcutMenu, String shortcutMenuId) {
        StringBuffer path = new StringBuffer("/" + WebMenuUtil.ROOT_NODE + "/");
        try {
            ShortcutMenuInfo menuInfo = (ShortcutMenuInfo)iShortcutMenu.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)shortcutMenuId)));
            path.append(menuInfo.getNumber());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return path.toString();
    }

    private void updateModel(Context ctx, IShortcutMenu iShortcutMenu, MenuParamInfo paramInfo) throws Exception {
        ShortcutMenuInfo shtMenuInfo = null;
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)paramInfo.getId()));
        shtMenuInfo = (ShortcutMenuInfo)iShortcutMenu.getValue((IObjectPK)pk);
        if (StringUtils.equals((String)paramInfo.getBusinessType(), (String)"myworkflow_list")) {
            shtMenuInfo.setBusinessType("myworkflow_list");
            ICPMenuTree menuTree = CPMenuTreeFactory.getLocalInstance(ctx);
            CPMenuTreeInfo treeInfo = (CPMenuTreeInfo)menuTree.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)paramInfo.getMenuUrl())));
            Object[] args = new Object[]{ctx, treeInfo.getSimpleName(), ContextUtil.getCurrentUserInfo((Context)ctx).getCU().getId().toString()};
            String newPerType = (String)WebMenuUtil.invokeStaticMethod("com.kingdee.eas.cp.wfm.plugins.DataTools", "getNewPerType", args);
            if (StringUtils.equals((String)newPerType, (String)"1")) {
                shtMenuInfo.setEffectScope(true);
            } else {
                shtMenuInfo.setEffectScope(false);
            }
        } else if (StringUtils.equals((String)paramInfo.getBusinessType(), (String)"undefined")) {
            shtMenuInfo.setBusinessType(null);
            shtMenuInfo.setEffectScope(false);
        }
        shtMenuInfo.setSourceFrom(SourceFromEnum.FROM_SHORTCUTDEF);
        shtMenuInfo.setName(paramInfo.getMenuName());
        if (shtMenuInfo.getShortcutDef() == null) {
            PersonInfo personInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
            ShortcutDefInfo shtMenuDefInfo = new ShortcutDefInfo();
            shtMenuDefInfo.setId(BOSUuid.create((BOSObjectType)shtMenuDefInfo.getBOSType()));
            shtMenuDefInfo.setOwnerType(OwnerEnum.getEnum(paramInfo.isAdmin() ? 0 : 1));
            shtMenuDefInfo.setPerson(paramInfo.isAdmin() ? null : personInfo);
            shtMenuDefInfo.setState(StateEnum.ENABLE_STATE);
            this.setShortcutDefInfo(ctx, shtMenuDefInfo, paramInfo);
            ShortcutDefFactory.getLocalInstance(ctx).addnew(shtMenuDefInfo);
            shtMenuInfo.setShortcutDef(shtMenuDefInfo);
            IMenuDef imdef = MenuDefFactory.getLocalInstance(ctx);
            MenuDefInfo menuDef = (MenuDefInfo)imdef.getValue((IObjectPK)new ObjectUuidPK(shtMenuInfo.getMenu().getId()));
            if (menuDef.getOwnerType().equals((Object)OwnerEnum.IS_ADMIN) && !paramInfo.isAdmin()) {
                menuDef = imdef.getMenuDefCollection("where sourceId='" + shtMenuInfo.getMenu().getId() + "' and person='" + personInfo.getId().toString() + "'").get(0);
                shtMenuInfo.setMenu(menuDef);
            }
            this.setMenuDefInfo(ctx, menuDef, paramInfo);
            imdef.update((IObjectPK)new ObjectUuidPK(menuDef.getId()), menuDef);
            shtMenuInfo.setMenu(null);
            shtMenuInfo.setSolution(null);
        } else {
            ShortcutDefInfo shtMenuDefInfo = (ShortcutDefInfo)ShortcutDefFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(shtMenuInfo.getShortcutDef().getId()));
            this.setShortcutDefInfo(ctx, shtMenuDefInfo, paramInfo);
            ShortcutDefFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(shtMenuDefInfo.getId()), shtMenuDefInfo);
        }
        String menuId = shtMenuInfo.getShortcutDef().getId().toString();
        if (StringUtils.isNotBlank((String)menuId)) {
            ShortcutDefInfo shtDefInfo = (ShortcutDefInfo)ShortcutDefFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(menuId));
            if (null != shtDefInfo.getWebMenu()) {
                Map keyMap = MenuCommonHandle.getAllWorkFlowKeyMap(ctx);
                shtMenuInfo.setAllWorkFlow(keyMap.containsKey(shtDefInfo.getWebMenu().getId().toString()));
            } else {
                shtMenuInfo.setAllWorkFlow(false);
            }
        }
        iShortcutMenu.update((IObjectPK)new ObjectUuidPK(shtMenuInfo.getId()), shtMenuInfo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setMenuDefInfo(Context ctx, MenuDefInfo menuDefInfo, MenuParamInfo paramInfo) {
        menuDefInfo.setName(paramInfo.getMenuName());
        menuDefInfo.setMenuType(MenuTypeEnum.getEnum(Integer.parseInt(paramInfo.getMenuType())));
        try {
            MenuIconInfo menuIcon = new MenuIconInfo();
            menuIcon.setId(BOSUuid.read((String)paramInfo.getMenuIcon()));
            menuDefInfo.setIcon(menuIcon);
        }
        catch (Exception e) {
            menuDefInfo.setMenuIcon(paramInfo.getMenuIcon());
        }
        try {
            ICPMenuTree webMenu = CPMenuTreeFactory.getLocalInstance(ctx);
            IMainMenuItem guiMenu = MainMenuItemFactory.getLocalInstance((Context)ctx);
            if (menuDefInfo.getMenuType().equals((Object)MenuTypeEnum.URL_MENU)) {
                menuDefInfo.setWebUrl(paramInfo.getMenuUrl());
                return;
            }
            if (null == paramInfo.getMenuUrl() || "".equals(paramInfo.getMenuUrl())) return;
            if (menuDefInfo.getMenuType().equals((Object)MenuTypeEnum.GUI_MENU)) {
                MainMenuItemInfo menuInfo = (MainMenuItemInfo)guiMenu.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)paramInfo.getMenuUrl())));
                menuDefInfo.setGuiMenu(menuInfo);
                return;
            }
            if (menuDefInfo.getMenuType().equals((Object)MenuTypeEnum.WEB_MENU)) {
                CPMenuTreeInfo menuInfo = (CPMenuTreeInfo)webMenu.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)paramInfo.getMenuUrl())));
                menuDefInfo.setWebMenu(menuInfo);
                return;
            }
            if (!menuDefInfo.getMenuType().equals((Object)MenuTypeEnum.DOC_MENU)) return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setShortcutDefInfo(Context ctx, ShortcutDefInfo shtMenuDefInfo, MenuParamInfo paramInfo) {
        shtMenuDefInfo.setName(paramInfo.getMenuName());
        shtMenuDefInfo.setMenuType(MenuTypeEnum.getEnum(Integer.parseInt(paramInfo.getMenuType())));
        shtMenuDefInfo.setNodeType(false);
        try {
            MenuIconInfo menuIcon = new MenuIconInfo();
            menuIcon.setId(BOSUuid.read((String)paramInfo.getMenuIcon()));
            shtMenuDefInfo.setIcon(menuIcon);
        }
        catch (Exception menuIcon) {
            // empty catch block
        }
        try {
            ICPMenuTree webMenu = CPMenuTreeFactory.getLocalInstance(ctx);
            IMainMenuItem guiMenu = MainMenuItemFactory.getLocalInstance((Context)ctx);
            if (shtMenuDefInfo.getMenuType().equals((Object)MenuTypeEnum.URL_MENU)) {
                shtMenuDefInfo.setWebUrl(paramInfo.getMenuUrl());
            } else if (null != paramInfo.getMenuUrl() && !"".equals(paramInfo.getMenuUrl())) {
                if (shtMenuDefInfo.getMenuType().equals((Object)MenuTypeEnum.GUI_MENU)) {
                    MainMenuItemInfo menuInfo = (MainMenuItemInfo)guiMenu.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)paramInfo.getMenuUrl())));
                    shtMenuDefInfo.setGuiMenu(menuInfo);
                } else if (shtMenuDefInfo.getMenuType().equals((Object)MenuTypeEnum.WEB_MENU)) {
                    CPMenuTreeInfo menuInfo = (CPMenuTreeInfo)webMenu.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)paramInfo.getMenuUrl())));
                    shtMenuDefInfo.setWebMenu(menuInfo);
                } else if (shtMenuDefInfo.getMenuType().equals((Object)MenuTypeEnum.LOCALAPP_MENU)) {
                    shtMenuDefInfo.setLocalAppPath(paramInfo.getMenuUrl());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addNewModel(Context ctx, IShortcutMenu imu, MenuParamInfo paramInfo) throws Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (StringUtils.equals((String)paramInfo.getBusinessType(), (String)"myworkflow_list")) {
            ICPMenuTree menuTree = CPMenuTreeFactory.getLocalInstance(ctx);
            CPMenuTreeInfo treeInfo = (CPMenuTreeInfo)menuTree.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)paramInfo.getMenuUrl())));
            Object[] args = new Object[]{ctx, treeInfo.getSimpleName(), ContextUtil.getCurrentUserInfo((Context)ctx).getCU().getId().toString()};
            String newPerType = (String)WebMenuUtil.invokeStaticMethod("com.kingdee.eas.cp.wfm.plugins.DataTools", "getNewPerType", args);
            if (StringUtils.equals((String)newPerType, (String)"1")) {
                paramMap.put("effectScope", Boolean.TRUE);
            } else {
                paramMap.put("effectScope", Boolean.FALSE);
            }
            paramMap.put("businessType", "myworkflow_list");
        } else {
            paramMap.put("effectScope", Boolean.FALSE);
        }
        PersonInfo personInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        ShortcutDefInfo shtMenuDefInfo = new ShortcutDefInfo();
        shtMenuDefInfo.setId(BOSUuid.create((BOSObjectType)shtMenuDefInfo.getBOSType()));
        shtMenuDefInfo.setOwnerType(OwnerEnum.getEnum(paramInfo.isAdmin() ? 0 : 1));
        shtMenuDefInfo.setPerson(paramInfo.isAdmin() ? null : personInfo);
        shtMenuDefInfo.setState(StateEnum.ENABLE_STATE);
        this.setShortcutDefInfo(ctx, shtMenuDefInfo, paramInfo);
        ShortcutDefFactory.getLocalInstance(ctx).addnew(shtMenuDefInfo);
        paramMap.put("menuId", shtMenuDefInfo.getId().toString());
        paramMap.put("sourceFrom", (Object)SourceFromEnum.FROM_SHORTCUTDEF);
        imu.addtoShortMenu(paramMap);
        if (null != paramMap.get("id")) {
            paramInfo.setId((String)paramMap.get("id"));
        }
    }
}

