/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.cp.base.CPMenuTreeFactory;
import com.kingdee.eas.cp.base.CPMenuTreeInfo;
import com.kingdee.eas.cp.base.ICPMenuTree;
import com.kingdee.eas.cp.base.IShortcutMenu;
import com.kingdee.eas.cp.base.MenuDefFactory;
import com.kingdee.eas.cp.base.MenuDefInfo;
import com.kingdee.eas.cp.base.OwnerEnum;
import com.kingdee.eas.cp.base.ShortcutDefFactory;
import com.kingdee.eas.cp.base.ShortcutDefInfo;
import com.kingdee.eas.cp.base.ShortcutMenuFactory;
import com.kingdee.eas.cp.base.ShortcutMenuInfo;
import com.kingdee.eas.cp.base.SourceFromEnum;
import com.kingdee.eas.cp.base.StateEnum;
import com.kingdee.eas.cp.base.app.AbstractShortcutMenuControllerBean;
import com.kingdee.eas.cp.base.web.MenuCommonHandle;
import com.kingdee.eas.cp.base.web.MenuParamInfo;
import com.kingdee.eas.cp.base.web.WebMenuUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ShortcutMenuControllerBean
extends AbstractShortcutMenuControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.base.app.ShortcutMenuControllerBean");
    private String tableName = "T_CP_ShortcutMenu";

    @Override
    protected String _addtoShortMenu(Context ctx, Map paramMap) throws BOSException {
        String menuId = (String)paramMap.get("menuId");
        SourceFromEnum from = (SourceFromEnum)((Object)paramMap.get("sourceFrom"));
        boolean effectScope = false;
        if (paramMap.get("effectScope") != null) {
            effectScope = (Boolean)paramMap.get("effectScope");
        }
        String businessType = (String)paramMap.get("businessType");
        ShortcutMenuInfo shortcut = new ShortcutMenuInfo();
        MenuParamInfo paramInfo = new MenuParamInfo();
        try {
            IShortcutMenu imu = ShortcutMenuFactory.getLocalInstance(ctx);
            this.synShorcutMenu(ctx, imu, paramInfo);
            boolean isAdmin = MenuCommonHandle.isCMAdmin(ctx);
            if (isAdmin) {
                shortcut.setEffectScope(effectScope);
            } else {
                shortcut.setEffectScope(false);
            }
            shortcut.setBusinessType(businessType);
            PersonInfo personInfo = isAdmin ? null : ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
            shortcut.setId(BOSUuid.create((BOSObjectType)shortcut.getBOSType()));
            shortcut.setOwnerType(isAdmin ? OwnerEnum.IS_ADMIN : OwnerEnum.IS_USER);
            Map keyMap = MenuCommonHandle.getAllWorkFlowKeyMap(ctx);
            if (from.equals((Object)SourceFromEnum.FROM_MENUDEF)) {
                MenuDefInfo menuInfo = (MenuDefInfo)MenuDefFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)menuId)));
                if (null != menuInfo.getWebMenu()) {
                    shortcut.setAllWorkFlow(keyMap.containsKey(menuInfo.getWebMenu().getId().toString()));
                    ICPMenuTree iMenuTree = CPMenuTreeFactory.getLocalInstance(ctx);
                    CPMenuTreeInfo menuTreeInfo = (CPMenuTreeInfo)iMenuTree.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)menuInfo.getWebMenu().getId().toString())));
                    if (StringUtils.equals((String)menuTreeInfo.getBusinessType(), (String)"myworkflow_list")) {
                        Object[] args = new Object[]{ctx, menuTreeInfo.getSimpleName(), ContextUtil.getCurrentUserInfo((Context)ctx).getCU().getId().toString()};
                        String newPerType = (String)WebMenuUtil.invokeStaticMethod("com.kingdee.eas.cp.wfm.plugins.DataTools", "getNewPerType", args);
                        if (StringUtils.equals((String)newPerType, (String)"1")) {
                            shortcut.setEffectScope(true);
                        } else {
                            shortcut.setEffectScope(false);
                        }
                        shortcut.setBusinessType("myworkflow_list");
                    }
                } else {
                    shortcut.setAllWorkFlow(false);
                }
                shortcut.setMenu(menuInfo);
                shortcut.setName(menuInfo.getName());
                shortcut.setSolution(menuInfo.getSolution());
            } else {
                ShortcutDefInfo shtMenuInfo = (ShortcutDefInfo)ShortcutDefFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(menuId));
                if (null != shtMenuInfo.getWebMenu()) {
                    shortcut.setAllWorkFlow(keyMap.containsKey(shtMenuInfo.getWebMenu().getId().toString()));
                } else {
                    shortcut.setAllWorkFlow(false);
                }
                shortcut.setShortcutDef(shtMenuInfo);
                shortcut.setName(shtMenuInfo.getName());
            }
            shortcut.setSourceFrom(from);
            shortcut.setPerson(personInfo);
            shortcut.setState(StateEnum.ENABLE_STATE);
            shortcut.setNumber(String.valueOf(System.currentTimeMillis()));
            shortcut.setDisplayOrder(MenuCommonHandle.getUniqueDisplayOrder(imu, personInfo));
            imu.addnew(shortcut);
            paramMap.put("id", shortcut.getId().toString());
            return WebMenuUtil.getSuccessMsg(new String[]{"1"});
        }
        catch (Exception e) {
            return WebMenuUtil.getErrorMsg(new String[]{"2"});
        }
    }

    private void synShorcutMenu(Context ctx, IShortcutMenu imu, MenuParamInfo paramInfo) {
        boolean isAdmin = MenuCommonHandle.isCMAdmin(ctx);
        if (!isAdmin) {
            MenuCommonHandle.batchAddShorcutMenu(ctx, paramInfo);
        }
    }

    @Override
    protected String _ddShortcutMenu(Context ctx, Map paramMap) throws BOSException {
        String parentNode = (String)paramMap.get("parentNode");
        String currentNode = (String)paramMap.get("currentNode");
        String dragDropType = (String)paramMap.get("type");
        ShortcutMenuInfo currentMenuInfo = null;
        ShortcutMenuInfo parentMenuInfo = null;
        try {
            MenuParamInfo paramInfo = new MenuParamInfo();
            paramInfo.setId(currentNode);
            paramInfo.setParentId(parentNode);
            IShortcutMenu imu = ShortcutMenuFactory.getLocalInstance(ctx);
            this.synShorcutMenu(ctx, imu, paramInfo);
            currentMenuInfo = (ShortcutMenuInfo)imu.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)paramInfo.getId())));
            parentMenuInfo = (ShortcutMenuInfo)imu.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)paramInfo.getParentId())));
            this.sortMenuDisplayOrder(ctx, imu, currentMenuInfo, parentMenuInfo, dragDropType);
            return WebMenuUtil.getSuccessMsg(new String[]{"1"});
        }
        catch (Exception e) {
            return WebMenuUtil.getSuccessMsg(new String[]{"2"});
        }
    }

    private void sortMenuDisplayOrder(Context ctx, IShortcutMenu menu, ShortcutMenuInfo currentMenuDefInfo, ShortcutMenuInfo parentMenuDefInfo, String type) throws Exception {
        String updateSql = null;
        PersonInfo personInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        String sqlExt = null;
        sqlExt = null != personInfo && !MenuCommonHandle.isCMAdmin(ctx) ? " and fpersonid='" + personInfo.getId().toString() + "' and fownerType = 1" : "  and fownerType = 0";
        if (currentMenuDefInfo.getDisplayOrder() > parentMenuDefInfo.getDisplayOrder()) {
            if (type.equals("above")) {
                updateSql = "update " + this.tableName + " set fdisplayOrder=fdisplayOrder+1 where fdisplayOrder>=" + parentMenuDefInfo.getDisplayOrder() + " and fdisplayOrder<" + currentMenuDefInfo.getDisplayOrder() + sqlExt;
                DbUtil.execute((Context)ctx, (String)updateSql);
                currentMenuDefInfo.setDisplayOrder(parentMenuDefInfo.getDisplayOrder());
                menu.update((IObjectPK)new ObjectUuidPK(currentMenuDefInfo.getId()), currentMenuDefInfo);
            } else if (type.equals("below")) {
                updateSql = "update " + this.tableName + " set fdisplayOrder=fdisplayOrder+1 where fdisplayOrder>=" + (parentMenuDefInfo.getDisplayOrder() + 1) + " and fdisplayOrder<" + currentMenuDefInfo.getDisplayOrder() + sqlExt;
                DbUtil.execute((Context)ctx, (String)updateSql);
                currentMenuDefInfo.setDisplayOrder(parentMenuDefInfo.getDisplayOrder() + 1);
                menu.update((IObjectPK)new ObjectUuidPK(currentMenuDefInfo.getId()), currentMenuDefInfo);
            }
        } else if (type.equals("above")) {
            updateSql = "update " + this.tableName + " set fdisplayOrder=fdisplayOrder-1 where fdisplayOrder>" + currentMenuDefInfo.getDisplayOrder() + " and fdisplayOrder<" + parentMenuDefInfo.getDisplayOrder() + sqlExt;
            DbUtil.execute((Context)ctx, (String)updateSql);
            currentMenuDefInfo.setDisplayOrder(parentMenuDefInfo.getDisplayOrder() - 1);
            menu.update((IObjectPK)new ObjectUuidPK(currentMenuDefInfo.getId()), currentMenuDefInfo);
        } else if (type.equals("below")) {
            updateSql = "update " + this.tableName + " set fdisplayOrder=fdisplayOrder-1 where fdisplayOrder>" + currentMenuDefInfo.getDisplayOrder() + " and fdisplayOrder<=" + parentMenuDefInfo.getDisplayOrder() + sqlExt;
            DbUtil.execute((Context)ctx, (String)updateSql);
            currentMenuDefInfo.setDisplayOrder(parentMenuDefInfo.getDisplayOrder());
            menu.update((IObjectPK)new ObjectUuidPK(currentMenuDefInfo.getId()), currentMenuDefInfo);
        }
    }

    @Override
    protected String _delShortcutMenu(Context ctx, Map paramMap) throws BOSException {
        String id = (String)paramMap.get("recordId");
        MenuParamInfo paramInfo = new MenuParamInfo();
        paramInfo.setId(id);
        try {
            IShortcutMenu imu = ShortcutMenuFactory.getLocalInstance(ctx);
            this.synShorcutMenu(ctx, imu, paramInfo);
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)paramInfo.getId()));
            ShortcutMenuInfo scmInfo = (ShortcutMenuInfo)imu.getValue((IObjectPK)pk);
            if (scmInfo.getSourceFrom().equals((Object)SourceFromEnum.FROM_MENUDEF)) {
                imu.delete((IObjectPK)pk);
            } else {
                ShortcutDefFactory.getLocalInstance(ctx).delete("where id='" + scmInfo.getShortcutDef().getId().toString() + "'");
                imu.delete((IObjectPK)pk);
            }
            return WebMenuUtil.getSuccessMsg(new String[]{"1"});
        }
        catch (Exception e) {
            return WebMenuUtil.getErrorMsg(new String[]{"2"});
        }
    }
}

