/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.base.cache.hsqldb;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.server.RTQuerySqlAccess;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.base.cache.CacheManager;
import com.kingdee.eas.cp.base.cache.F7TipsParam;
import com.kingdee.eas.cp.base.cache.hsqldb.HsqldbOperator;
import com.kingdee.eas.cp.base.cache.hsqldb.IHsqldbOperator;
import com.kingdee.eas.cp.base.cache.hsqldb.MemDBManager;
import com.kingdee.eas.cp.base.job.F7JobServiceWrapper;
import com.kingdee.eas.cp.base.util.MetadataUtil;
import com.kingdee.eas.cp.common.web.util.DataCenterManager;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class HsqldbCacheManger
extends CacheManager {
    Logger logger = Logger.getLogger(HsqldbCacheManger.class);
    IHsqldbOperator operator = HsqldbOperator.getInstance();

    private HsqldbCacheManger() {
    }

    public static HsqldbCacheManger newInstance() {
        return new HsqldbCacheManger();
    }

    private synchronized IRowSet synGetJsonFromDB(Context ctx, F7TipsParam param, String memTableName, String[] dbFieldNames) throws BOSException, SQLException, JSONException {
        IRowSet rowSet = null;
        QueryInfo query = param.getQuery();
        String queryName = query.getFullName();
        if (memTableName != null) {
            Map fieldsMap = this.getFieldsMap(ctx, queryName);
            String[] diffFields = this.getDiffFields(fieldsMap, dbFieldNames);
            rowSet = diffFields.length > 0 ? this.getRowSetFromDB(ctx, param, memTableName, dbFieldNames) : this.getRowSetFromCache(ctx, param, memTableName, dbFieldNames);
        } else {
            memTableName = this.genMemTableName(ctx, query);
            this.createCountTable(ctx);
            rowSet = this.getRowSetFromDB(ctx, param, memTableName, dbFieldNames);
            F7JobServiceWrapper.createF7CacheJob(ctx);
        }
        return rowSet;
    }

    @Override
    protected IRowSet getJsonRowSetFromDB(Context ctx, F7TipsParam param, String memTableName, String[] dbFieldNames) throws SQLException, JSONException, BOSException {
        QueryInfo query = param.getQuery();
        EntityViewInfo entityView = param.getEntityView();
        QueryInfo queryForDb = this.getQueryFromCache(query, entityView);
        String sql = new RTQuerySqlAccess(ctx, queryForDb).getSql();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        this.putFields(ctx, query, rowSet, dbFieldNames);
        return rowSet;
    }

    @Override
    protected IRowSet getJsonRowSetFromCacheAfterFillDB(Context ctx, IRowSet rowSet, F7TipsParam param, String memTableName, String[] dbFieldNames) throws SQLException, JSONException, BOSException {
        String compareFieldName;
        QueryInfo query = param.getQuery();
        String string = compareFieldName = param == null ? "name" : param.getMatchPinYinField();
        if (memTableName.equals(this.getMemTableName(ctx, query.getFullName()))) {
            this.operator.execSql(ctx, "DROP TABLE " + memTableName);
        }
        Map fieldsMap = this.getFieldsMap(ctx, query.getFullName());
        this.operator.fillCache(memTableName, dbFieldNames, fieldsMap, rowSet, compareFieldName);
        this.setMemTableName(ctx, query.getFullName(), memTableName);
        return this.getRowSetFromCache(ctx, param, memTableName, dbFieldNames);
    }

    @Override
    protected IRowSet getJsonRowSet(Context ctx, F7TipsParam param) throws SQLException, JSONException, BOSException {
        QueryInfo query = param.getQuery();
        EntityViewInfo entityView = param.getEntityView();
        String queryName = param.getQuery().getFullName();
        IRowSet rowSet = null;
        String[] dbFieldNames = MetadataUtil.getQueryFields(this.getQueryFromCache(query, entityView), true);
        String memTableName = this.getMemTableName(ctx, queryName);
        if (memTableName != null) {
            Map fieldsMap = this.getFieldsMap(ctx, queryName);
            String[] diffFields = this.getDiffFields(fieldsMap, dbFieldNames);
            try {
                if (diffFields.length > 0) {
                    rowSet = this.synGetJsonFromDB(ctx, param, memTableName, dbFieldNames);
                }
                rowSet = this.getRowSetFromCache(ctx, param, memTableName, dbFieldNames);
            }
            catch (SQLException e) {
                if (e.getMessage().indexOf("Table not found: " + memTableName.toUpperCase()) > -1 || e.getMessage().indexOf("Table not found: " + "T_CP_F7UseCount".toUpperCase()) > -1 || e.getMessage().indexOf("object not found") > -1) {
                    this.logger.error((Object)("----&&&*****----\u8868" + memTableName + "\u4e0d\u5b58\u5728\uff0c\u91cd\u65b0\u586b\u5145\u7f13\u5b58\uff01"));
                    this.clearCache(ctx, query);
                    return this.getJsonRowSet(ctx, param);
                }
                throw e;
            }
        } else {
            rowSet = this.synGetJsonFromDB(ctx, param, memTableName, dbFieldNames);
        }
        return rowSet;
    }

    @Override
    protected IRowSet getJsonRowSetFromCache(Context ctx, F7TipsParam param, String memTableName, String[] dbFieldNames) throws SQLException, JSONException {
        StringBuffer sqlEntity = new StringBuffer().append("SELECT ").append(StringUtils.join((Object[])dbFieldNames, (char)',')).append(',').append("F_PinYin_FirstLetter").append(',').append("F_QuanPin_Field").append(" ,0 as firstSort FROM ").append(memTableName);
        EntityViewInfo entityView = param.getEntityView();
        if (entityView.getFilter() != null && entityView.getFilter().getFilterItems().size() > 0) {
            sqlEntity.append(" WHERE ").append(MetadataUtil.changeEntityViewPropertyName(entityView, ".", "_").getFilter().toString());
        }
        if (param.isSearch()) {
            String like = " LIKE '%";
            if (memTableName.startsWith("T_BD_Person")) {
                like = " LIKE '";
            }
            if (sqlEntity.indexOf("WHERE") > -1) {
                sqlEntity.append(" AND ");
            } else {
                sqlEntity.append(" WHERE ");
            }
            String valueEscape = "'%" + StringUtils.replace((String)param.getInputValue().toUpperCase(), (String)"_", (String)"&_") + "%' escape '&' ";
            String tempSql = sqlEntity.toString();
            sqlEntity.append(" (UPPER(NAME) LIKE ").append(valueEscape).append(") union all ").append(StringUtils.replace((String)tempSql, (String)"0 as firstSort", (String)"1 as firstSort"));
            sqlEntity.append(" UPPER(NAME) NOT LIKE ").append(valueEscape).append(" and (").append("F_PinYin_FirstLetter").append(like).append(param.getInputValue().toUpperCase()).append("%' OR ").append("F_QuanPin_Field").append(like).append(param.getInputValue().toUpperCase()).append("%' OR UPPER(NUMBER) LIKE ").append(valueEscape).append(") ");
        }
        StringBuffer sqlCount = new StringBuffer().append("SELECT FCount,FBizId FROM ").append(this.getCountTableName(ctx)).append(" WHERE FUserId='" + ctx.getCaller()).append('\'');
        StringBuffer sql = new StringBuffer().append("select * from (SELECT t.*,c.FCount sort FROM (").append(sqlEntity).append(") t LEFT OUTER JOIN (").append(sqlCount).append(") c ON t.id=c.FBizId) s ");
        if (param.isCommonUse()) {
            sql.append(" where s.sort is not null and s.sort<>0 ");
        }
        sql.append(" ORDER BY s.firstSort ASC,s.sort DESC;");
        Connection conn = MemDBManager.getF7MemDBConnection();
        ResultSet rs = conn.createStatement().executeQuery(sql.toString());
        JdbcRowSet jdbcRowSet = new JdbcRowSet();
        jdbcRowSet.populate(rs);
        this.replaceComumnName((IRowSet)jdbcRowSet, '_', '.');
        return jdbcRowSet;
    }

    @Override
    protected JSONArray rowSetToJSONArray(IRowSet rowSet, F7TipsParam param) throws SQLException, JSONException {
        JSONArray jsonArray = new JSONArray();
        String[] fieldNames = MetadataUtil.getQueryFields(this.getQueryFromCache(param.getQuery(), param.getEntityView()), false);
        for (int maxTips = 0; rowSet.next() && maxTips < param.getMaxCount(); ++maxTips) {
            JSONObject json = new JSONObject();
            for (int i = 0; i < fieldNames.length; ++i) {
                String value = StringUtils.replace((String)rowSet.getString(fieldNames[i]), (String)"'", (String)"&acute");
                value = StringUtils.replace((String)value, (String)"\"", (String)"&quot");
                json.put(fieldNames[i], (Object)value);
            }
            jsonArray.put((Object)json);
        }
        return jsonArray;
    }

    @Override
    public void clearCache(Context ctx, QueryInfo query) {
        String queryName = query.getFullName();
        String memTableName = this.getMemTableName(ctx, queryName);
        DataCenterManager dcManager = new DataCenterManager(ctx);
        String dataCenterName = dcManager.getDatacenterName(ctx);
        if (memTableName != null) {
            try {
                this.clearTable(memTableName);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            ((Map)tableNameCache.get(dataCenterName)).remove(queryName);
            queryCache.remove(queryName);
            this.logger.info((Object)("*&*&*\u534f\u540cF7   \u6e05\u9664\u7f13\u5b58\u6210\u529f\uff0c\u6570\u636e\u4e2d\u5fc3\uff1a" + dataCenterName + "\uff0c\u5185\u5b58\u8868\u540d\uff1a" + memTableName + "\uff0cquery\u540d\uff1a" + queryName));
        }
        String countTableName = ((Map)tableNameCache.get(dataCenterName)).get("T_CP_F7UseCount").toString();
        try {
            this.clearTable(countTableName);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        ((Map)tableNameCache.get(dataCenterName)).remove("T_CP_F7UseCount");
    }

    @Override
    public void clearCache(Context ctx) {
        DataCenterManager dcManager = new DataCenterManager(ctx);
        String dataCenterName = dcManager.getDatacenterName(ctx);
        Set tableSet = ((Map)tableNameCache.get(dataCenterName)).keySet();
        Iterator it = tableSet.iterator();
        while (it.hasNext()) {
            String queryName = it.next().toString();
            String memTableName = this.getMemTableName(ctx, queryName);
            try {
                this.clearTable(memTableName);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            this.logger.info((Object)("*&*&*\u534f\u540cF7   \u6e05\u9664\u7f13\u5b58\u6210\u529f\uff0c\u6570\u636e\u4e2d\u5fc3\uff1a" + dataCenterName + "\uff0c\u5185\u5b58\u8868\u540d\uff1a" + memTableName + "\uff0cquery\u540d\uff1a" + queryName));
        }
        ((Map)tableNameCache.get(dataCenterName)).clear();
        queryCache.clear();
    }

    private void clearTable(String memTableName) throws SQLException {
        Connection conn = MemDBManager.getF7MemDBConnection();
        StringBuffer sb = new StringBuffer();
        sb.append("DROP TABLE ").append(memTableName);
        conn.createStatement().execute(sb.toString());
    }

    @Override
    protected JSONObject getJsonIncludeHeaders(JSONArray jsonArray, F7TipsParam param) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("data", (Object)jsonArray);
        json.put("inputValue", (Object)param.getInputValue());
        return json;
    }

    @Override
    public String getCurDataCenterTableName(Context ctx, String tableName) {
        DataCenterManager dcManager = new DataCenterManager(ctx);
        String dataCenterName = dcManager.getDatacenterName(ctx);
        Map<String, String> tableMap = null;
        if (tableNameCache.get(dataCenterName) == null) {
            tableMap = new HashMap();
            tableNameCache.put(dataCenterName, tableMap);
        } else {
            tableMap = (Map)tableNameCache.get(dataCenterName);
        }
        String dataCenterTableName = (String)tableMap.get(tableName);
        if (dataCenterTableName == null) {
            dataCenterTableName = this.genMemTableName(ctx, tableName);
            tableMap.put(tableName, dataCenterTableName);
        }
        return dataCenterTableName;
    }

    private String getMemTableName(Context ctx, String queryName) {
        DataCenterManager dcManager = new DataCenterManager(ctx);
        String dataCenterName = dcManager.getDatacenterName(ctx);
        if (tableNameCache.get(dataCenterName) == null) {
            tableNameCache.put(dataCenterName, new HashMap());
            return null;
        }
        Map tableMap = (Map)tableNameCache.get(dataCenterName);
        return (String)tableMap.get(queryName);
    }

    private void setMemTableName(Context ctx, String queryName, String memTableName) {
        DataCenterManager dcManager = new DataCenterManager(ctx);
        String dataCenterName = dcManager.getDatacenterName(ctx);
        Map tableMap = (Map)tableNameCache.get(dataCenterName);
        tableMap.put(queryName, memTableName);
    }

    private String genMemTableName(Context ctx, QueryInfo query) {
        String dbTableName = MetadataUtil.getEntityByQueryName(ctx, query.getFullName()).getTable().getName();
        return this.genMemTableName(ctx, dbTableName);
    }

    private String genMemTableName(Context ctx, String queryName) {
        StringBuffer memTableName = new StringBuffer();
        memTableName.append(queryName).append("__").append(BOSUuid.create((String)"ABCDEFGH").toString().substring(0, 8).replace('+', 'F').replace('=', 'T').replace('/', '9'));
        return memTableName.toString();
    }

    private void putFields(Context ctx, QueryInfo query, IRowSet rowSet, String[] dbFieldNames) throws SQLException {
        Map queryFieldsMap;
        DataCenterManager dcManager = new DataCenterManager(ctx);
        String dataCenterName = dcManager.getDatacenterName(ctx);
        if (queryFields.get(dataCenterName) == null) {
            queryFields.put(dataCenterName, new HashMap());
        }
        if ((queryFieldsMap = (Map)queryFields.get(dataCenterName)).get(query.getFullName()) == null) {
            queryFieldsMap.put(query.getFullName(), new HashMap());
        }
        Map fieldsMap = (Map)queryFieldsMap.get(query.getFullName());
        IRowSetMetaData rowMeta = rowSet.getRowSetMetaData();
        StringBuffer colTypeName = new StringBuffer();
        for (int i = 0; i < dbFieldNames.length; ++i) {
            int colIndex = rowMeta.getColumnIndex(dbFieldNames[i].toUpperCase().replace('_', '.'));
            String columnTypeName = this.convertColumnType(rowMeta.getColumnTypeName(colIndex));
            colTypeName.append(columnTypeName);
            if (rowMeta.getColumnType(colIndex) == 12) {
                colTypeName.append("(").append(rowMeta.getColumnDisplaySize(colIndex)).append(")");
            }
            fieldsMap.put(dbFieldNames[i].replace('.', '_'), colTypeName.toString());
            colTypeName.delete(0, colTypeName.length());
        }
    }

    private Map getFieldsMap(Context ctx, String queryName) {
        DataCenterManager dcManager = new DataCenterManager(ctx);
        String dataCenterName = dcManager.getDatacenterName(ctx);
        Map queryFieldsMap = (Map)queryFields.get(dataCenterName);
        if (queryFieldsMap == null) {
            return null;
        }
        Map fieldsMap = (Map)queryFieldsMap.get(queryName);
        return fieldsMap;
    }

    private String convertColumnType(String columnType) {
        if (columnType.toUpperCase().indexOf("VARCHAR") > -1 || columnType.toUpperCase().indexOf("GRAPHIC") > -1 || columnType.toUpperCase().indexOf("CLOB") > -1 || columnType.toUpperCase().indexOf("TEXT") > -1) {
            return "VARCHAR";
        }
        if (columnType.toUpperCase().indexOf("CHAR") > -1) {
            return "CHAR";
        }
        if (columnType.toUpperCase().indexOf("NUMBER") > -1) {
            return "NUMERIC";
        }
        return columnType;
    }

    private String[] getDiffFields(Map fields, String[] fieldsNames) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < fieldsNames.length; ++i) {
            if (fields.keySet().contains(fieldsNames[i])) continue;
            list.add(fieldsNames[i]);
        }
        String[] diffFields = new String[list.size()];
        for (int i = 0; i < diffFields.length; ++i) {
            diffFields[i] = (String)list.get(i);
        }
        return diffFields;
    }

    private QueryInfo getQueryFromCache(QueryInfo query, EntityViewInfo entityView) {
        QueryInfo queryInfo = (QueryInfo)queryCache.get(query.getFullName());
        if (queryInfo == null) {
            queryInfo = (QueryInfo)query.clone();
            MetadataUtil.getQueryIncludeFilterFields(query, entityView);
            queryCache.put(query.getFullName(), queryInfo);
        }
        return queryInfo;
    }

    protected String getCountTableName(Context ctx) {
        DataCenterManager dcManager = new DataCenterManager(ctx);
        String dataCenterName = dcManager.getDatacenterName(ctx);
        Map tableNameMap = (Map)tableNameCache.get(dataCenterName);
        String countTableName = (String)tableNameMap.get("T_CP_F7UseCount");
        if (countTableName == null) {
            countTableName = "T_CP_F7UseCount__" + BOSUuid.create((String)"ABCDEFGH").toString().substring(0, 8).replace('+', 'F').replace('=', 'T').replace('/', '9');
            tableNameMap.put("T_CP_F7UseCount", countTableName);
        }
        return countTableName;
    }

    protected void createCountTable(Context ctx) throws BOSException, SQLException {
        DataCenterManager dcManager = new DataCenterManager(ctx);
        String dataCenterName = dcManager.getDatacenterName(ctx);
        Map tableNameMap = (Map)tableNameCache.get(dataCenterName);
        String countTableName = (String)tableNameMap.get("T_CP_F7UseCount");
        if (countTableName == null) {
            countTableName = this.getCountTableName(ctx);
            this.operator.createCountTable(ctx, countTableName);
        }
    }

    @Override
    public void updateCountTable(Context ctx, String bizId) throws EASBizException, BOSException, SQLException {
        String countTableName = this.getCountTableName(ctx);
        this.operator.updateCountTable(ctx, countTableName, bizId);
    }

    @Override
    public synchronized void updateCache(Context ctx) throws SQLException, BOSException {
        Set keySet = queryCache.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            String queryName = it.next().toString();
            QueryInfo query = (QueryInfo)queryCache.get(queryName);
            DataCenterManager dcManager = new DataCenterManager(ctx);
            ArrayList dcList = dcManager.getDCList();
            for (int i = 0; i < dcList.size(); ++i) {
                String dataCenterName = ((DCInfo)dcList.get(i)).getName("L2");
                Map tableMap = (Map)tableNameCache.get(dataCenterName);
                String memTableName = (String)tableMap.get(queryName);
                IRowSet rowSet = null;
                String sql = new RTQuerySqlAccess(ctx, query).getSql();
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                this.operator.execSql(ctx, "DROP TABLE " + memTableName);
                String[] dbFieldNames = MetadataUtil.getQueryFields(query, true);
                Map fieldsMap = this.getFieldsMap(ctx, queryName);
                this.operator.fillCache(memTableName, dbFieldNames, fieldsMap, rowSet, new F7TipsParam("").getMatchPinYinField());
                String countTableName = (String)tableMap.get("T_CP_F7UseCount");
                if (countTableName != null) {
                    tableMap.put("T_CP_F7UseCount", null);
                    this.operator.execSql(ctx, "DROP TABLE " + countTableName);
                }
                this.logger.info((Object)("*&*&*\u534f\u540cF7   \u66f4\u65b0\u7f13\u5b58\u6210\u529f\uff0c\u6570\u636e\u4e2d\u5fc3\uff1a" + dataCenterName + "\uff0c\u5185\u5b58\u8868\u540d\uff1a" + memTableName + "\uff0cquery\u540d\uff1a" + queryName));
            }
        }
    }

    @Override
    public void printMemDBMsg(Context ctx) {
        DataCenterManager dcManager = new DataCenterManager(ctx);
        String dataCenterName = dcManager.getDatacenterName(ctx);
        for (String queryName : ((Map)tableNameCache.get(dataCenterName)).keySet()) {
            String memTableName = this.getMemTableName(ctx, queryName);
            Map fieldsMap = this.getFieldsMap(ctx, queryName);
            this.logger.info((Object)("*&*&*\u534f\u540cF7  query\u540d\uff1a" + queryName + "  \u5185\u5b58\u8868\u540d\uff1a" + memTableName + "\uff0c\u6570\u636e\u4e2d\u5fc3\uff1a" + dataCenterName + "\n"));
            this.logger.info((Object)("*&*&*\u534f\u540cF7   \u5b57\u6bb5\uff08" + fieldsMap.size() + "\uff09\uff1a" + fieldsMap));
            Connection conn = MemDBManager.getF7MemDBConnection();
            try {
                ResultSet rs = conn.createStatement().executeQuery("select count(*) result from " + memTableName);
                if (!rs.next()) continue;
                this.logger.info((Object)("*&*&*\u534f\u540cF7   \u8868" + memTableName + "\u8bb0\u5f55\u6570\uff1a" + rs.getInt("result")));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void createTableAndFillCache(String tableName, String[] fieldNames, IRowSet rowSet, String compareField, Map fieldsMap) throws SQLException {
        this.operator.fillCache(tableName, fieldNames, fieldsMap, rowSet, compareField);
    }
}

