/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.base.cache.hsqldb;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.form.util.WordsUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.base.F7UseCountCollection;
import com.kingdee.eas.cp.base.F7UseCountFactory;
import com.kingdee.eas.cp.base.F7UseCountInfo;
import com.kingdee.eas.cp.base.IF7UseCount;
import com.kingdee.eas.cp.base.cache.hsqldb.IHsqldbOperator;
import com.kingdee.eas.cp.base.cache.hsqldb.MemDBManager;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class HsqldbOperator
implements IHsqldbOperator {
    private static IHsqldbOperator hsqldbOperator = null;

    private HsqldbOperator() {
    }

    public static IHsqldbOperator getInstance() {
        if (hsqldbOperator == null) {
            hsqldbOperator = new HsqldbOperator();
        }
        return hsqldbOperator;
    }

    @Override
    public void execSql(Context ctx, String sql) throws SQLException {
        Connection conn = MemDBManager.getF7MemDBConnection();
        conn.createStatement().execute(sql);
    }

    @Override
    public void fillCache(String memTableName, String[] fieldNames, Map fieldsMap, IRowSet rowSet, String compareField) throws SQLException {
        Connection conn = MemDBManager.getF7MemDBConnection();
        this.createTable(conn, memTableName, fieldsMap);
        this.insertData(conn, memTableName, fieldNames, rowSet, compareField, fieldsMap);
    }

    @Override
    public void createTable(Connection conn, String memTableName, Map fieldsMap) throws SQLException {
        Iterator it = fieldsMap.keySet().iterator();
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE TABLE ").append(memTableName).append(" (");
        while (it.hasNext()) {
            String colTypeName = (String)it.next();
            sb.append(colTypeName).append(" ").append(fieldsMap.get(colTypeName)).append(',');
        }
        sb.append("F_PinYin_FirstLetter").append(" VARCHAR(500)").append(',').append("F_QuanPin_Field").append(" VARCHAR(2000)").append(");");
        conn.createStatement().execute(sb.toString());
    }

    @Override
    public void createCountTable(Context ctx, String countTableName) throws SQLException, BOSException {
        Connection conn = MemDBManager.getF7MemDBConnection();
        String sql = "CREATE TABLE " + countTableName + " (FBizId VARCHAR(80),FEntityName VARCHAR(128),FUserId VARCHAR(80),FCount INT);";
        conn.createStatement().execute(sql);
        this.synCountTabale(ctx, countTableName);
    }

    @Override
    public void synCountTabale(Context ctx, String countTableName) throws SQLException, BOSException {
        String sql = "SELECT  FBizId,FEntityName,FUserId,FCount FROM T_CP_F7UseCount";
        Connection conn = MemDBManager.getF7MemDBConnection();
        StringBuffer sb = new StringBuffer();
        Statement st = conn.createStatement();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (rowSet.next()) {
            sb.append("INSERT INTO ").append(countTableName).append("(FBizId,FEntityName,FUserId,FCount)VALUES(").append("'").append(rowSet.getString("FBizId")).append("','").append(rowSet.getString("FEntityName")).append("','").append(rowSet.getString("FUserId")).append("',").append(rowSet.getString("FCount")).append(")");
            st.execute(sb.toString());
            sb.delete(0, sb.length());
        }
    }

    @Override
    public void updateCountTable(Context ctx, String countTableName, String bizId) throws SQLException, BOSException, EASBizException {
        String userId = ctx.getCaller().toString();
        String entityName = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getBusinessObject(BOSUuid.read((String)bizId).getType()).getFullName();
        String sqlUpdate = "UPDATE " + countTableName + " SET FCount=FCount+1 WHERE FBizId='" + bizId + "' AND FUserId='" + userId + "'";
        String sqlInsert = "INSERT INTO " + countTableName + " (FBizId,FEntityName,FUserId,FCount) VALUES ('" + bizId + "','" + entityName + "','" + userId + "',1)";
        Connection conn = MemDBManager.getF7MemDBConnection();
        Statement st = conn.createStatement();
        int result = st.executeUpdate(sqlUpdate);
        if (result < 1) {
            st.executeUpdate(sqlInsert);
        }
        String oql = "select count where bizId='" + bizId + "' AND userId='" + userId + "'";
        F7UseCountInfo countInfo = null;
        IF7UseCount f7Service = F7UseCountFactory.getLocalInstance(ctx);
        F7UseCountCollection countColl = f7Service.getF7UseCountCollection(oql);
        if (countColl != null && countColl.size() > 0) {
            countInfo = countColl.get(0);
            countInfo.setCount(countInfo.getCount() + 1);
        } else {
            countInfo = new F7UseCountInfo();
            countInfo.setBizId(bizId);
            countInfo.setEntityName(entityName);
            countInfo.setUserId(userId);
            countInfo.setCount(1);
        }
        f7Service.save((CoreBaseInfo)countInfo);
    }

    @Override
    public void insertData(Connection conn, String tableName, String[] fieldNames, IRowSet rowSet, String compareField, Map fieldsMap) throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ").append(tableName).append(" (");
        sb.append(StringUtils.join((Object[])fieldNames, (char)',')).append(",").append("F_QuanPin_Field").append(",").append("F_PinYin_FirstLetter").append(") VALUES(  ");
        StringBuffer sbSql = new StringBuffer();
        WordsUtil wordsUtil = new WordsUtil();
        rowSet.beforeFirst();
        while (rowSet.next()) {
            int j;
            sbSql.delete(0, sbSql.length());
            sbSql.append(sb);
            for (j = 0; j < fieldNames.length - 1; ++j) {
                String value = rowSet.getString(fieldNames[j].replace('_', '.'));
                if (value == null || "null".equalsIgnoreCase(value)) {
                    String nullValue = this.convertNullValue(value, fieldsMap.get(fieldNames[j]));
                    sbSql.append(nullValue).append(",");
                    continue;
                }
                sbSql.append("'").append(StringUtils.replace((String)value, (String)"'", (String)"''")).append("',");
            }
            String name = rowSet.getString(compareField) == null ? "" : rowSet.getString(compareField);
            String value = rowSet.getString(fieldNames[j].replace('_', '.'));
            if (value == null || "null".equalsIgnoreCase(value)) {
                value = this.convertNullValue(rowSet.getString(fieldNames[j].replace('_', '.')), fieldsMap.get(fieldNames[j]));
            }
            sbSql.append("'").append(StringUtils.replace((String)value, (String)"'", (String)"''")).append("','").append(wordsUtil.getQuanPin(name)).append("','").append(wordsUtil.getFistPinYinLetter(name)).append("')");
            conn.createStatement().execute(sbSql.toString());
        }
    }

    private String convertNullValue(String value, Object fieldType) {
        if (fieldType != null && (fieldType.toString().toUpperCase().indexOf("INT") > -1 || fieldType.toString().toUpperCase().indexOf("NUMERIC") > -1)) {
            return "0";
        }
        return "null";
    }
}

