/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.base.job;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.service.job.core.JobDef;
import com.kingdee.bos.service.job.core.PulseSource;
import com.kingdee.bos.service.job.core.Trigger;
import com.kingdee.bos.service.job.core.Wrapper;
import com.kingdee.bos.service.job.pulse.TimerPulseSource;
import com.kingdee.bos.service.job.wrapper.MethodWrapper;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.ScheduleType;
import com.kingdee.eas.cp.base.cache.CacheManager;
import com.kingdee.eas.cp.base.cache.ICacheManager;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class F7JobServiceWrapper {
    private static final String JOB_TITLE = "CP_BASE_UPDATE_F7_CACHE__";
    private static boolean JOB_CREATEED = false;

    public void updateF7Cache(Context ctx) {
        ICacheManager cacheManager = CacheManager.getCacheManager(ctx);
        try {
            cacheManager.updateCache(ctx);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void createF7CacheJob(Context ctx) {
        if (JOB_CREATEED) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("select ftitle from t_job_def d left outer join t_job_trigger t on d.fjobdefid=t.fjobdefid ").append("where fisvalid='Y' and ftitle like '").append(JOB_TITLE).append("%'");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (!rowSet.next()) {
                F7JobServiceWrapper.createUpdateF7CacheJobDef(ctx);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private static void createUpdateF7CacheJobDef(Context ctx) {
        String packageName = null;
        String description = null;
        String proxyUserID = null;
        String proxyOrgID = null;
        boolean isPersistent = true;
        try {
            MethodWrapper wrapper = new MethodWrapper(F7JobServiceWrapper.class, "updateF7Cache", null);
            String title = JOB_TITLE + new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(new Date());
            JobDef jobDef = new JobDef(ctx, packageName, title, description, proxyUserID, proxyOrgID, isPersistent, (Wrapper)wrapper);
            Date validateTime = new Date();
            Calendar expiredTime = Calendar.getInstance();
            expiredTime.set(2088, 12, 30);
            String schedulePlan = F7JobServiceWrapper.getSchedule();
            Trigger trigger = new Trigger(validateTime, expiredTime.getTime(), jobDef, (PulseSource)new TimerPulseSource(), schedulePlan, false);
            trigger.enable();
            JobServiceFactory.getLocalInstance((Context)ctx).createJobDef(jobDef, trigger, true);
            JOB_CREATEED = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getSchedule() {
        ScheduleDef define = new ScheduleDef(null);
        int hour = 1;
        int minute = 15;
        int second = 30;
        String value = second + " " + minute + " " + hour + " * * ?";
        define.setType(ScheduleType.EVERYDAY);
        define.setUseCalendar(false);
        define.setDefine(value);
        String scheduleXML = define.getType() + ":" + define.getDefine();
        return scheduleXML;
    }
}

