/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.base.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.form.extend.flow.DocumentInfoCollection;
import com.kingdee.eas.base.form.extend.flow.DocumentInfoFactory;
import com.kingdee.eas.base.form.extend.flow.IDocumentInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class BotpUtil {
    public static final int BOTP_TRACE_UP = 0;
    public static final int BOTP_TRACE_DOWN = 1;
    public static final int DYNAMIC_FORM_BILL = 0;
    public static final int WAF_BILL = 1;
    public static final int GUI_BILL = 2;

    public static Vector getBotpRelationIds(int botpTraceType, String billInfoID) throws BOSException, BTPException {
        Vector<String> traceBillIDs;
        block3: {
            IBTPManager btpManager;
            block2: {
                traceBillIDs = new Vector<String>();
                btpManager = BTPManagerFactory.getRemoteInstance();
                if (0 != botpTraceType) break block2;
                BOTRelationCollection relaColl = btpManager.getRelationCollection(billInfoID);
                for (int i = 0; i < relaColl.size(); ++i) {
                    traceBillIDs.add(relaColl.get(i).getSrcObjectID());
                }
                break block3;
            }
            if (1 != botpTraceType) break block3;
            BOTRelationCollection relaColl = btpManager.getDestRelation(billInfoID);
            for (int i = 0; i < relaColl.size(); ++i) {
                traceBillIDs.add(relaColl.get(i).getDestObjectID());
            }
        }
        return traceBillIDs;
    }

    public static Vector getBotpDestRelationIds(String srcBillId) throws BOSException, BTPException {
        return BotpUtil.getBotpRelationIds(1, srcBillId);
    }

    public static Vector getBotpSrcRelationIds(String destBillId) throws BOSException, BTPException {
        return BotpUtil.getBotpRelationIds(0, destBillId);
    }

    public static int getBillType(String billId) throws BOSException {
        String oql;
        IDocumentInfo iDocument = DocumentInfoFactory.getRemoteInstance();
        DocumentInfoCollection docColl = iDocument.getDocumentInfoCollection(oql = "select id where sourcePK='" + billId + "'");
        return docColl.size() > 0 ? 0 : 1;
    }

    public static boolean isDynamicFormBill(String billId) throws BOSException {
        String oql;
        IDocumentInfo iDocument = DocumentInfoFactory.getRemoteInstance();
        DocumentInfoCollection docColl = iDocument.getDocumentInfoCollection(oql = "select id where sourcePK='" + billId + "'");
        return docColl.size() > 0;
    }

    public static boolean containsDynamicFormBill(Vector billIds) throws BOSException {
        return BotpUtil.getDocumentInfoCollection(billIds).size() > 0;
    }

    public static boolean isOnlyDynamicFormBill(Vector billIds) throws BOSException {
        return BotpUtil.getDocumentInfoCollection(billIds).size() == 1;
    }

    private static DocumentInfoCollection getDocumentInfoCollection(String oql) throws BOSException {
        IDocumentInfo iDocument = DocumentInfoFactory.getRemoteInstance();
        DocumentInfoCollection docColl = iDocument.getDocumentInfoCollection(oql);
        return docColl;
    }

    private static DocumentInfoCollection getDocumentInfoCollection(Vector billIds) throws BOSException {
        String billIdsStr = BotpUtil.parseSqlInStr(billIds);
        String oql = "select id,formID where sourcePK in(" + billIdsStr + ")";
        DocumentInfoCollection docColl = BotpUtil.getDocumentInfoCollection(oql);
        return docColl;
    }

    public static String parseSqlInStr(Collection coll) {
        Iterator i = coll.iterator();
        if (!i.hasNext()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("'");
        while (true) {
            Object o = i.next();
            sb.append(o);
            if (!i.hasNext()) {
                return sb.append("'").toString();
            }
            sb.append("','");
        }
    }

    private static HashMap getRelatedBillType(Vector srcBillIDs) {
        HashMap hashMap = new HashMap();
        if (srcBillIDs != null) {
            for (int i = 0; i < srcBillIDs.size(); ++i) {
                String BOSTypeString = BOSUuid.read((String)((String)srcBillIDs.get(i))).getType().toString();
                if (!hashMap.containsKey(BOSTypeString)) {
                    Vector vector = new Vector();
                    vector.add(srcBillIDs.get(i));
                    hashMap.put(BOSTypeString, vector);
                    continue;
                }
                if (((Vector)hashMap.get(BOSTypeString)).contains(srcBillIDs.get(i))) continue;
                ((Vector)hashMap.get(BOSTypeString)).add(srcBillIDs.get(i));
            }
        }
        return hashMap;
    }

    public static String getDynformBillViewURL(String billId) {
        String formId = BotpUtil.getFormIdFromBillId(billId);
        return BotpUtil.getDynformBillViewURL(formId, billId);
    }

    public static String getDynformBillViewURL(String formId, String billId) {
        StringBuffer url = new StringBuffer();
        url.append("/easweb/servlet/BillServlet?status=VIEW&formID=").append(URLEncoder.encode(formId)).append("&pk=").append(URLEncoder.encode(billId));
        return url.toString();
    }

    public static String getDynformListViewURL(String formId) {
        if (formId == null || "".equals(formId)) {
            return "";
        }
        StringBuffer url = new StringBuffer();
        url.append("/easweb/servlet/ListServlet?formID=").append(URLEncoder.encode(formId));
        return url.toString();
    }

    public static String getDynformListViewURLByBillId(String billId) {
        String formId = BotpUtil.getFormIdFromBillId(billId);
        return BotpUtil.getDynformListViewURL(formId);
    }

    private static String getFormIdFromBillId(String billId) {
        String oql = "select id,formID where sourcePK='" + billId + "'";
        String formId = "";
        try {
            IDocumentInfo iDocument = DocumentInfoFactory.getRemoteInstance();
            DocumentInfoCollection docColl = iDocument.getDocumentInfoCollection(oql);
            if (docColl.size() > 0) {
                formId = docColl.get(0).getFormID();
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return formId;
    }

    public static HashMap getEntityObjectInfo4Trace(Context ctx, Vector billIds) throws BOSException, BTPException {
        HashMap<String, String> infoMap = new HashMap<String, String>();
        String billIdStr = BotpUtil.parseSqlInStr(billIds);
        String displayString = "";
        String oql = "select t.FName_l2,d.FFormID from T_Bas_DocumentInfo d join T_Bas_Template t on d.FTemplateID=t.FID where d.FSourcePK in(" + billIdStr + ")";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)oql);
        try {
            if (rowSet.next()) {
                displayString = rowSet.getString("FName_l2");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        String botpFilter = " in (" + billIdStr + ")";
        infoMap.put("listUIName", BotpUtil.getDynformListViewURLByBillId(billIds.get(0).toString()));
        infoMap.put("displayString", displayString);
        infoMap.put("botpFilter", botpFilter);
        return infoMap;
    }
}

