/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.base.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.LicenseUserInfo;
import com.kingdee.eas.base.license.agent.LicenseSrvFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Date;
import org.apache.log4j.Logger;

public class LicenseUtil {
    private static final Logger logger = Logger.getLogger(LicenseUtil.class);

    public static int checkLicence(Context ctx, String objectKey) throws Exception {
        LicenseUserInfo licenseUserInfo = LicenseUtil.createLicenseUserInfo(ctx);
        logger.info((Object)("JSP check Licence, before call, LicenseSrvFactory.getInstance().requestLicense(), ui=" + objectKey));
        int result = LicenseSrvFactory.getInstance().requestLicense(licenseUserInfo, objectKey);
        logger.info((Object)("JSP check Licence, ui=" + objectKey + ", resule=" + result));
        return result;
    }

    public static void releaseLicense(Context ctx, String pkg) throws LicenseException {
        logger.info((Object)("JSP release License, ui=" + pkg));
        LicenseSrvFactory.getInstance().releaseLicense(ctx.getContextID(), pkg);
    }

    public static LicenseUserInfo createLicenseUserInfo(Context ctx) {
        LicenseUserInfo user = null;
        try {
            Date loginTime = new Date(System.currentTimeMillis());
            user = new LicenseUserInfo();
            if (ctx != null) {
                UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
                if (userInfo != null && userInfo.getId() != null) {
                    user.setUserID(userInfo.getId().toString());
                }
                user.setUserName(ctx.getUserName());
                user.setSessionID(ctx.getContextID());
                if (ContextUtil.getCurrentCtrlUnit((Context)ctx) != null) {
                    user.setUserCompany(ContextUtil.getCurrentCtrlUnit((Context)ctx).getName());
                }
                user.setUserLoginAis(ctx.getAIS());
            }
            user.setUserIP(ctx.getClientHostIP());
            user.setUserLoginTime(loginTime);
        }
        catch (Exception e) {
            e.printStackTrace();
            user = null;
        }
        return user;
    }
}

