/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.base.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.SubQueryInfo;

public class MetadataUtil {
    public static EntityObjectInfo getEntityByQueryName(Context ctx, String queryName) {
        QueryInfo query = null;
        query = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery((IMetaDataPK)MetaDataPK.create((String)queryName)) : MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getQuery((IMetaDataPK)MetaDataPK.create((String)queryName));
        EntityObjectInfo entity = null;
        try {
            if (query != null) {
                SubObjectInfo mainEntity = query.getMainObject();
                if (mainEntity != null && mainEntity instanceof SubEntityInfo) {
                    entity = ((SubEntityInfo)mainEntity).getEntityRef();
                } else if (mainEntity != null && mainEntity instanceof SubQueryInfo) {
                    QueryInfo queryInfo = ((SubQueryInfo)mainEntity).getQueryRef();
                    entity = MetadataUtil.getEntityByQueryName(ctx, queryInfo.getFullName());
                } else {
                    entity = (EntityObjectInfo)mainEntity.getStateManager().getStateValue("entityRef");
                }
            }
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        return entity;
    }

    public static QueryInfo getQueryIncludeFilterFields(QueryInfo query, EntityViewInfo entityView) {
        if (entityView.getFilter() == null || entityView.getFilter().getFilterItems().size() == 0) {
            return query;
        }
        FilterItemCollection filterColl = entityView.getFilter().getFilterItems();
        for (int i = 0; i < filterColl.size(); ++i) {
            entityView.getSelector().add(new SelectorItemInfo(filterColl.get(i).getPropertyName()));
        }
        try {
            query.updateQuery(entityView);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return query;
    }

    public static String[] getQueryFields(QueryInfo query, boolean needReplace) {
        SelectorInfo selector = query.getSelector();
        Object[] fields = selector.getFields().toArray();
        String[] fieldNames = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fieldNames[i] = needReplace ? fields[i].toString().replace('.', '_') : fields[i].toString();
        }
        return fieldNames;
    }

    public static JSONObject getQueryHeadersJson(QueryInfo query) throws JSONException {
        SelectorInfo selector = query.getSelector();
        Object[] fields = selector.getFields().toArray();
        JSONObject json = new JSONObject();
        for (int i = 0; i < fields.length; ++i) {
            json.put(fields[i].toString(), (Object)query.getUnits().get(fields[i].toString()).getDisplayName());
        }
        return json;
    }

    public static EntityViewInfo changeEntityViewPropertyName(EntityViewInfo entityViewInfo, String src, String dest) {
        FilterItemCollection filterColl = entityViewInfo.getFilter().getFilterItems();
        for (int i = 0; i < filterColl.size(); ++i) {
            FilterItemInfo item = filterColl.get(i);
            String propertyName = StringUtils.replace((String)item.getPropertyName(), (String)src, (String)dest);
            item.setPropertyName(propertyName);
        }
        return entityViewInfo;
    }
}

