/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.base.web;

import com.kingdee.eas.base.log.common.Resource;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.cp.base.MenuDefInfo;
import com.kingdee.eas.cp.base.MenuIconInfo;
import com.kingdee.eas.cp.base.MenuSolutionInfo;
import com.kingdee.eas.cp.base.MenuTypeEnum;
import com.kingdee.eas.cp.base.ShortcutMenuInfo;
import com.kingdee.eas.cp.base.SourceFromEnum;
import com.kingdee.eas.cp.base.SubSystemInfo;
import com.kingdee.eas.cp.common.json.org.JSONArray;
import com.kingdee.eas.cp.common.json.org.JSONObject;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.util.LinkedList;

public class JsonObjectUtil {
    public static JSONObject convertSolutionForList(MenuSolutionInfo menuSolutionInfo) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("id", (Object)menuSolutionInfo.getId().toString());
        jsonObj.put("number", (Object)menuSolutionInfo.getNumber());
        jsonObj.put("name", (Object)menuSolutionInfo.getName());
        jsonObj.put("state", (Object)menuSolutionInfo.getState().getAlias());
        String BASE_RES = "com.kingdee.eas.cp.base.BaseResource";
        String expand = Resource.getString((String)"com.kingdee.eas.cp.base.BaseResource", (String)"expand");
        String collapse = Resource.getString((String)"com.kingdee.eas.cp.base.BaseResource", (String)"collapse");
        jsonObj.put("expand", (Object)(menuSolutionInfo.isExpand() ? expand : collapse));
        return jsonObj;
    }

    public static JSONObject defaultJsonObj() {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("id", (Object)"root");
        jsonObj.put("text", (Object)"");
        jsonObj.put("leaf", (Object)new Boolean(true));
        jsonObj.put("children", (Object)new JSONArray());
        return jsonObj;
    }

    public static JSONObject convertLeftTree(MenuDefInfo menuDefInfo) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("id", (Object)menuDefInfo.getNumber());
        jsonObj.put("text", (Object)menuDefInfo.getName());
        jsonObj.put("level", (Object)new Integer(menuDefInfo.getLevel()));
        jsonObj.put("leaf", (Object)new Boolean(menuDefInfo.isNodeType()));
        jsonObj.put("menuType", menuDefInfo.getMenuType().getValue());
        jsonObj.put("allowDrag", true);
        if (menuDefInfo.getMenuType().equals((Object)MenuTypeEnum.URL_MENU) && !StringUtils.isEmpty((String)menuDefInfo.getWebUrl())) {
            jsonObj.put("href", (Object)menuDefInfo.getWebUrl());
        } else if (menuDefInfo.getMenuType().equals((Object)MenuTypeEnum.GUI_MENU) && null != menuDefInfo.getGuiMenu()) {
            if (null != menuDefInfo.getGuiMenu().getUiClassName()) {
                jsonObj.put("href", (Object)menuDefInfo.getGuiMenu().getUiClassName().trim());
            }
            jsonObj.put("uiClassParam", (Object)menuDefInfo.getGuiMenu().getUiClassParam());
            jsonObj.put("uiOprt", (Object)menuDefInfo.getGuiMenu().getUiOprt());
        } else if (menuDefInfo.getMenuType().equals((Object)MenuTypeEnum.WEB_MENU) && null != menuDefInfo.getWebMenu()) {
            jsonObj.put("href", (Object)menuDefInfo.getWebMenu().getUi());
        }
        jsonObj.put("expanded", (Object)new Boolean(true));
        jsonObj.put("children", (Object)new JSONArray());
        jsonObj.put("pid", (Object)(null != menuDefInfo.getParent() ? menuDefInfo.getParent().getNumber() : ""));
        return jsonObj;
    }

    public static JSONObject convertTreeNodeInfo(MenuDefInfo menuDefInfo) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("id", (Object)menuDefInfo.getNumber());
        jsonObj.put("solutionId", (Object)menuDefInfo.getSolution().getId().toString());
        jsonObj.put("solutionName", (Object)menuDefInfo.getSolution().getName());
        jsonObj.put("parentId", (Object)(null != menuDefInfo.getParent() ? menuDefInfo.getParent().getNumber() : ""));
        jsonObj.put("parentName", (Object)(null != menuDefInfo.getParent() ? menuDefInfo.getParent().getName() : ""));
        jsonObj.put("menuName", (Object)menuDefInfo.getName());
        jsonObj.put("menuType", menuDefInfo.getMenuType().getValue());
        String menuUrl = "";
        if (menuDefInfo.getMenuType().equals((Object)MenuTypeEnum.URL_MENU)) {
            menuUrl = null != menuDefInfo.getWebUrl() ? "[{value:'" + menuDefInfo.getWebUrl() + "',text:{'id':'" + menuDefInfo.getWebUrl() + "','name':'" + menuDefInfo.getWebUrl() + "','number':'" + menuDefInfo.getWebUrl() + "'}}]" : "[{value:'',text:{'id':'','name':'','number':''}}]";
        } else if (menuDefInfo.getMenuType().equals((Object)MenuTypeEnum.GUI_MENU)) {
            menuUrl = null != menuDefInfo.getGuiMenu() ? "[{value:'" + menuDefInfo.getGuiMenu().getId().toString() + "',text:{'id':'" + menuDefInfo.getGuiMenu().getId().toString() + "','name':'" + menuDefInfo.getGuiMenu().getName() + "','number':'" + menuDefInfo.getGuiMenu().getNumber() + "'}}]" : "[{value:'',text:{'id':'','name':'','number':''}}]";
        } else if (menuDefInfo.getMenuType().equals((Object)MenuTypeEnum.WEB_MENU)) {
            menuUrl = null != menuDefInfo.getWebMenu() ? "[{value:'" + menuDefInfo.getWebMenu().getId().toString() + "',text:{'id':'" + menuDefInfo.getWebMenu().getId().toString() + "','name':'" + menuDefInfo.getWebMenu().getName() + "','number':'" + menuDefInfo.getWebMenu().getNumber() + "'}}]" : "[{value:'',text:{'id':'','name':'','number':''}}]";
        }
        jsonObj.put("menuUrl", (Object)menuUrl);
        if (null == menuDefInfo.getIcon()) {
            jsonObj.put("menuIcon", (Object)"/html/portlet/cp/navigation/images/icon/default.jpg");
        } else {
            jsonObj.put("menuIcon", (Object)("/cp/menuIconManage?method=loadIcon&iconId=" + menuDefInfo.getIcon().getId().toString()));
        }
        jsonObj.put("nodeType", menuDefInfo.isNodeType());
        jsonObj.put("hasChild", ((Boolean)menuDefInfo.get("hasChild")).booleanValue());
        return jsonObj;
    }

    public static JSONObject convertShtTreeNodeInfo(ShortcutMenuInfo shortcutMenuInfo) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("id", (Object)shortcutMenuInfo.getNumber());
        if (shortcutMenuInfo.getSourceFrom().equals((Object)SourceFromEnum.FROM_MENUDEF)) {
            jsonObj.put("menuName", (Object)shortcutMenuInfo.getMenu().getName());
            jsonObj.put("menuType", shortcutMenuInfo.getMenu().getMenuType().getValue());
            String menuUrl = "";
            if (shortcutMenuInfo.getMenu().getMenuType().equals((Object)MenuTypeEnum.URL_MENU)) {
                menuUrl = null != shortcutMenuInfo.getMenu().getWebUrl() ? "[{value:'" + shortcutMenuInfo.getMenu().getWebUrl() + "',text:{'id':'" + shortcutMenuInfo.getMenu().getWebUrl() + "','name':'" + shortcutMenuInfo.getMenu().getWebUrl() + "','number':'" + shortcutMenuInfo.getMenu().getWebUrl() + "'}}]" : "[{value:'',text:{'id':'','name':'','number':''}}]";
            } else if (shortcutMenuInfo.getMenu().getMenuType().equals((Object)MenuTypeEnum.GUI_MENU)) {
                menuUrl = null != shortcutMenuInfo.getMenu().getGuiMenu() ? "[{value:'" + shortcutMenuInfo.getMenu().getGuiMenu().getId().toString() + "',text:{'id':'" + shortcutMenuInfo.getMenu().getGuiMenu().getId().toString() + "','name':'" + shortcutMenuInfo.getMenu().getGuiMenu().getName() + "','number':'" + shortcutMenuInfo.getMenu().getGuiMenu().getNumber() + "'}}]" : "[{value:'',text:{'id':'','name':'','number':''}}]";
            } else if (shortcutMenuInfo.getMenu().getMenuType().equals((Object)MenuTypeEnum.WEB_MENU)) {
                menuUrl = null != shortcutMenuInfo.getMenu().getWebMenu() ? "[{value:'" + shortcutMenuInfo.getMenu().getWebMenu().getId().toString() + "',text:{'id':'" + shortcutMenuInfo.getMenu().getWebMenu().getId().toString() + "','name':'" + shortcutMenuInfo.getMenu().getWebMenu().getName() + "','number':'" + shortcutMenuInfo.getMenu().getWebMenu().getNumber() + "'}}]" : "[{value:'',text:{'id':'','name':'','number':''}}]";
            }
            jsonObj.put("menuUrl", (Object)menuUrl);
            if (null == shortcutMenuInfo.getMenu().getIcon()) {
                jsonObj.put("menuIcon", (Object)"/html/portlet/cp/navigation/images/icon/default.jpg");
            } else {
                jsonObj.put("menuIcon", (Object)("/cp/menuIconManage?method=loadIcon&iconId=" + shortcutMenuInfo.getMenu().getIcon().getId().toString()));
            }
        } else {
            jsonObj.put("menuName", (Object)shortcutMenuInfo.getShortcutDef().getName());
            jsonObj.put("menuType", shortcutMenuInfo.getShortcutDef().getMenuType().getValue());
            String menuUrl = "";
            if (shortcutMenuInfo.getShortcutDef().getMenuType().equals((Object)MenuTypeEnum.URL_MENU)) {
                menuUrl = null != shortcutMenuInfo.getShortcutDef().getWebUrl() ? "[{value:'" + shortcutMenuInfo.getShortcutDef().getWebUrl() + "',text:{'id':'" + shortcutMenuInfo.getShortcutDef().getWebUrl() + "','name':'" + shortcutMenuInfo.getShortcutDef().getWebUrl() + "','number':'" + shortcutMenuInfo.getShortcutDef().getWebUrl() + "'}}]" : "[{value:'',text:{'id':'','name':'','number':''}}]";
            }
            if (shortcutMenuInfo.getShortcutDef().getMenuType().equals((Object)MenuTypeEnum.LOCALAPP_MENU)) {
                String pathString = JsonObjectUtil.changeToLocalPath(shortcutMenuInfo.getShortcutDef().getLocalAppPath());
                menuUrl = null != pathString ? "[{value:'" + pathString + "',text:{'id':'" + pathString + "','name':'" + pathString + "','number':'" + pathString + "'}}]" : "[{value:'',text:{'id':'','name':'','number':''}}]";
            } else if (shortcutMenuInfo.getShortcutDef().getMenuType().equals((Object)MenuTypeEnum.GUI_MENU)) {
                menuUrl = null != shortcutMenuInfo.getShortcutDef().getGuiMenu() ? "[{value:'" + shortcutMenuInfo.getShortcutDef().getGuiMenu().getId().toString() + "',text:{'id':'" + shortcutMenuInfo.getShortcutDef().getGuiMenu().getId().toString() + "','name':'" + shortcutMenuInfo.getShortcutDef().getGuiMenu().getName() + "','number':'" + shortcutMenuInfo.getShortcutDef().getGuiMenu().getNumber() + "'}}]" : "[{value:'',text:{'id':'','name':'','number':''}}]";
            } else if (shortcutMenuInfo.getShortcutDef().getMenuType().equals((Object)MenuTypeEnum.WEB_MENU)) {
                menuUrl = null != shortcutMenuInfo.getShortcutDef().getWebMenu() ? "[{value:'" + shortcutMenuInfo.getShortcutDef().getWebMenu().getId().toString() + "',text:{'id':'" + shortcutMenuInfo.getShortcutDef().getWebMenu().getId().toString() + "','name':'" + shortcutMenuInfo.getShortcutDef().getWebMenu().getName() + "','number':'" + shortcutMenuInfo.getShortcutDef().getWebMenu().getNumber() + "'}}]" : "[{value:'',text:{'id':'','name':'','number':''}}]";
            }
            jsonObj.put("menuUrl", (Object)menuUrl);
            if (null == shortcutMenuInfo.getShortcutDef().getIcon()) {
                jsonObj.put("menuIcon", (Object)"/html/portlet/cp/navigation/images/icon/default.jpg");
            } else {
                jsonObj.put("menuIcon", (Object)("/cp/menuIconManage?method=loadIcon&iconId=" + shortcutMenuInfo.getShortcutDef().getIcon().getId().toString()));
            }
        }
        return jsonObj;
    }

    public static JSONObject convertExtTree(IRowSet rowset) {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("id", (Object)rowset.getString("FID"));
            jsonObj.put("text", (Object)rowset.getString("FName_L2"));
            jsonObj.put("number", (Object)rowset.getString("FNumber"));
            jsonObj.put("level", rowset.getInt("FLevel"));
            jsonObj.put("leaf", (Object)new Boolean(rowset.getInt("FIsLeaf") == 1));
            jsonObj.put("businessType", (Object)(rowset.getString("FBusinessType") == null ? "undefined" : rowset.getString("FBusinessType")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObj;
    }

    public static JSONObject convertMenuItem2Json(MainMenuItemInfo menuItemInfo) {
        JSONObject jsonObj = new JSONObject();
        try {
            if (null != menuItemInfo.get("disabled")) {
                jsonObj.put("dis", true);
                jsonObj.put("text", (Object)("<font color=\"gray\">" + menuItemInfo.getName() + "</font>"));
            } else {
                jsonObj.put("text", (Object)menuItemInfo.getName());
                jsonObj.put("dis", false);
            }
            jsonObj.put("id", (Object)menuItemInfo.getId().toString());
            jsonObj.put("number", (Object)menuItemInfo.getNumber());
            jsonObj.put("level", menuItemInfo.getLevel());
            jsonObj.put("leaf", menuItemInfo.isIsLeaf());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObj;
    }

    public static JSONArray convertMenuComposite2Json(LinkedList list) {
        JSONArray jsonArray = new JSONArray();
        try {
            for (int i = 0; i < list.size(); ++i) {
                jsonArray.put((Object)JsonObjectUtil.convertMenuItem2Json((MainMenuItemInfo)list.get(i)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonArray;
    }

    public static JSONObject convertMenuIcon2Json(File file) {
        JSONObject jsonObj = new JSONObject();
        try {
            String sp = System.getProperty("file.separator");
            String path = "/html/portlet/cp/navigation/images/icon/";
            jsonObj.put("name", (Object)file.getName());
            jsonObj.put("url", (Object)(path + file.getName()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObj;
    }

    public static JSONObject convertMenuIcon2Json(MenuIconInfo menuInco) {
        JSONObject jsonObj = new JSONObject();
        try {
            String path = "/cp/menuIconManage?method=loadIcon&iconId=";
            jsonObj.put("name", (Object)menuInco.getName());
            jsonObj.put("url", (Object)(path + menuInco.getId().toString()));
            jsonObj.put("id", (Object)menuInco.getId().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObj;
    }

    public static JSONObject convertShortcutMenu2Json(ShortcutMenuInfo scmenu) {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("id", (Object)scmenu.getId().toString());
            if (scmenu.getSourceFrom().equals((Object)SourceFromEnum.FROM_MENUDEF)) {
                if (scmenu.getMenu().getMenuType().equals((Object)MenuTypeEnum.WEB_MENU)) {
                    if (null == scmenu.getMenu().getWebMenu()) {
                        jsonObj.put("menuUrl", (Object)"javascript:checkUrl();");
                    } else {
                        jsonObj.put("menuUrl", (Object)("javascript:invokeUrl('" + MenuTypeEnum.WEB_MENU.getValue() + "','" + scmenu.getMenu().getWebMenu().getUi() + "')"));
                    }
                } else if (scmenu.getMenu().getMenuType().equals((Object)MenuTypeEnum.URL_MENU)) {
                    if (null == scmenu.getMenu().getWebUrl()) {
                        jsonObj.put("menuUrl", (Object)"javascript:checkUrl();");
                    } else {
                        jsonObj.put("menuUrl", (Object)("javascript:invokeUrl('" + MenuTypeEnum.URL_MENU.getValue() + "','" + scmenu.getMenu().getWebUrl() + "')"));
                    }
                } else if (scmenu.getMenu().getMenuType().equals((Object)MenuTypeEnum.GUI_MENU)) {
                    if (null == scmenu.getMenu().getGuiMenu()) {
                        jsonObj.put("menuUrl", (Object)"javascript:checkUrl();");
                    } else {
                        StringBuffer sb = new StringBuffer();
                        sb.append("javascript:invokeFunction('");
                        sb.append(scmenu.getMenu().getGuiMenu().getUiClassName() + "',");
                        if (null != scmenu.getMenu().getGuiMenu().getUiClassParam()) {
                            sb.append("'").append(scmenu.getMenu().getGuiMenu().getUiClassParam()).append("',");
                        } else {
                            sb.append("'',");
                        }
                        if (null != scmenu.getMenu().getGuiMenu().getUiOprt()) {
                            sb.append("'").append(scmenu.getMenu().getGuiMenu().getUiOprt()).append("',");
                        } else {
                            sb.append("'',");
                        }
                        sb.append("'0')");
                        jsonObj.put("menuUrl", (Object)sb.toString());
                    }
                }
                if (null == scmenu.getMenu().getIcon()) {
                    jsonObj.put("menuIcon", (Object)"/html/portlet/cp/navigation/images/icon/default.jpg");
                } else {
                    jsonObj.put("menuIcon", (Object)("/cp/menuIconManage?method=loadIcon&iconId=" + scmenu.getMenu().getIcon().getId().toString()));
                }
                String subStr = scmenu.getMenu().getName().length() > 4 ? scmenu.getMenu().getName().substring(0, 4) + "." : scmenu.getMenu().getName();
                jsonObj.put("name", (Object)subStr);
                jsonObj.put("fullName", (Object)scmenu.getMenu().getName());
                jsonObj.put("number", (Object)scmenu.getMenu().getNumber());
            } else {
                if (scmenu.getShortcutDef().getMenuType().equals((Object)MenuTypeEnum.WEB_MENU)) {
                    if (null == scmenu.getShortcutDef().getWebMenu()) {
                        jsonObj.put("menuUrl", (Object)"javascript:checkUrl();");
                    } else {
                        jsonObj.put("menuUrl", (Object)("javascript:invokeUrl('" + MenuTypeEnum.WEB_MENU.getValue() + "','" + scmenu.getShortcutDef().getWebMenu().getUi() + "')"));
                    }
                } else if (scmenu.getShortcutDef().getMenuType().equals((Object)MenuTypeEnum.URL_MENU)) {
                    if (null == scmenu.getShortcutDef().getWebUrl()) {
                        jsonObj.put("menuUrl", (Object)"javascript:checkUrl();");
                    } else {
                        jsonObj.put("menuUrl", (Object)("javascript:invokeUrl('" + MenuTypeEnum.URL_MENU.getValue() + "','" + scmenu.getShortcutDef().getWebUrl() + "')"));
                    }
                } else if (scmenu.getShortcutDef().getMenuType().equals((Object)MenuTypeEnum.LOCALAPP_MENU)) {
                    if (null == scmenu.getShortcutDef().getLocalAppPath()) {
                        jsonObj.put("menuUrl", (Object)"javascript:checkUrl();");
                    } else {
                        String localAppPath = JsonObjectUtil.changeToLocalPath(scmenu.getShortcutDef().getLocalAppPath());
                        jsonObj.put("menuUrl", (Object)("javascript:invokeUrl('" + MenuTypeEnum.LOCALAPP_MENU.getValue() + "','" + localAppPath + "')"));
                    }
                } else if (scmenu.getShortcutDef().getMenuType().equals((Object)MenuTypeEnum.GUI_MENU)) {
                    if (null == scmenu.getShortcutDef().getGuiMenu()) {
                        jsonObj.put("menuUrl", (Object)"javascript:checkUrl();");
                    } else {
                        StringBuffer sb = new StringBuffer();
                        sb.append("javascript:invokeFunction('");
                        sb.append(scmenu.getShortcutDef().getGuiMenu().getUiClassName() + "',");
                        if (null != scmenu.getShortcutDef().getGuiMenu().getUiClassParam()) {
                            sb.append("'").append(scmenu.getShortcutDef().getGuiMenu().getUiClassParam()).append("',");
                        } else {
                            sb.append("'',");
                        }
                        if (null != scmenu.getShortcutDef().getGuiMenu().getUiOprt()) {
                            sb.append("'").append(scmenu.getShortcutDef().getGuiMenu().getUiOprt()).append("',");
                        } else {
                            sb.append("'',");
                        }
                        sb.append("'0')");
                        jsonObj.put("menuUrl", (Object)sb.toString());
                    }
                }
                if (null == scmenu.getShortcutDef().getIcon()) {
                    jsonObj.put("menuIcon", (Object)"/html/portlet/cp/navigation/images/icon/default.jpg");
                } else {
                    jsonObj.put("menuIcon", (Object)("/cp/menuIconManage?method=loadIcon&iconId=" + scmenu.getShortcutDef().getIcon().getId().toString()));
                }
                String subStr = "";
                if (null != scmenu.getShortcutDef().getName()) {
                    subStr = scmenu.getShortcutDef().getName().length() > 4 ? scmenu.getShortcutDef().getName().substring(0, 4) + "." : scmenu.getShortcutDef().getName();
                }
                jsonObj.put("name", (Object)subStr);
                jsonObj.put("fullName", (Object)scmenu.getShortcutDef().getName());
                jsonObj.put("number", (Object)scmenu.getShortcutDef().getNumber());
            }
            jsonObj.put("displayOrder", scmenu.getDisplayOrder());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObj;
    }

    private static String changeToLocalPath(String path) {
        if (path == null) {
            return "";
        }
        return path.replaceAll("\\\\", "\\\\\\\\");
    }

    public static JSONObject convertShtLeftTree(ShortcutMenuInfo shtMenuInfo) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("id", (Object)shtMenuInfo.getNumber());
        jsonObj.put("text", (Object)shtMenuInfo.getName());
        jsonObj.put("leaf", (Object)new Boolean(true));
        jsonObj.put("children", (Object)new JSONArray());
        return jsonObj;
    }

    public static JSONObject contvertSubSystem2Nav(SubSystemInfo subSystemInfo) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("id", (Object)subSystemInfo.getNumber());
        jsonObj.put("name", (Object)subSystemInfo.getName());
        jsonObj.put("number", (Object)subSystemInfo.getNumber());
        jsonObj.put("index", subSystemInfo.getIndex());
        jsonObj.put("imageUrl", (Object)subSystemInfo.getImageUrl());
        jsonObj.put("detailUrl", (Object)subSystemInfo.getDetailUrl());
        return jsonObj;
    }

    public static JSONObject contvertSubSystem2LeftTree(SubSystemInfo subSystemInfo) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("id", (Object)subSystemInfo.getNumber());
        jsonObj.put("text", (Object)subSystemInfo.getName());
        jsonObj.put("level", (Object)new Integer(1));
        jsonObj.put("leaf", (Object)new Boolean(true));
        jsonObj.put("children", (Object)new JSONArray());
        return jsonObj;
    }
}

