/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.base.web;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.cp.base.IMenuIcon;
import com.kingdee.eas.cp.base.MenuDefFactory;
import com.kingdee.eas.cp.base.MenuIconCollection;
import com.kingdee.eas.cp.base.MenuIconFactory;
import com.kingdee.eas.cp.base.MenuIconInfo;
import com.kingdee.eas.cp.base.OwnerEnum;
import com.kingdee.eas.cp.base.ShortcutDefFactory;
import com.kingdee.eas.cp.base.web.JsonObjectUtil;
import com.kingdee.eas.cp.base.web.MenuCommonHandle;
import com.kingdee.eas.cp.common.json.org.JSONArray;
import com.kingdee.eas.cp.common.json.org.JSONObject;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MenuIconManageServlet
extends HttpServlet {
    String resultMsg = "";

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String method = request.getParameter("method");
        boolean isRes = true;
        if (method.equals("uploadIcon")) {
            this.uploadIcon(request, response);
        }
        if (method.equals("loadIcon")) {
            isRes = false;
            this.loadIcon(request, response);
        }
        if (method.equals("loadIconView")) {
            this.loadIconView(request, response);
        }
        if (method.equals("checkIconRef")) {
            this.checkIconRef(request, response);
        }
        if (method.equals("deleteMenuIcon")) {
            this.deleteMenuIcon(request, response);
        }
        if (isRes) {
            response.setContentType("text/html;charset=utf-8");
            response.getWriter().print(this.resultMsg);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    private void uploadIcon(HttpServletRequest request, HttpServletResponse response) {
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            String contentType = request.getContentType();
            DataInputStream in = new DataInputStream((InputStream)request.getInputStream());
            int formDataLength = request.getContentLength();
            if (formDataLength / 0x100000 > 1) {
                String state = EASResource.getString((String)"com.kingdee.eas.cp.base.BaseResource", (String)"icon_upload_size_failure");
                this.resultMsg = "{'success':false,'message':'" + state + "'}";
                return;
            }
            byte[] dataBytes = new byte[formDataLength];
            int byteRead = 0;
            for (int totalBytesRead = 0; totalBytesRead < formDataLength; totalBytesRead += byteRead) {
                byteRead = in.read(dataBytes, totalBytesRead, formDataLength);
            }
            String file = new String(dataBytes);
            String saveFile = file.substring(file.indexOf("filename=\"") + 10);
            saveFile = saveFile.substring(0, saveFile.indexOf("\n"));
            saveFile = saveFile.substring(saveFile.lastIndexOf("\\") + 1, saveFile.indexOf("\""));
            int lastIndex = contentType.lastIndexOf("=");
            String boundary = contentType.substring(lastIndex + 1, contentType.length());
            int pos = file.indexOf("filename=\"");
            pos = file.indexOf("\n", pos) + 1;
            pos = file.indexOf("\n", pos) + 1;
            pos = file.indexOf("\n", pos) + 1;
            int boundaryLocation = file.indexOf(boundary, pos) - 4;
            int startPos = file.substring(0, pos).getBytes().length;
            int rest = file.substring(boundaryLocation + 1).getBytes().length;
            byte[] dataFinal = new byte[formDataLength - (startPos + rest)];
            for (int i = startPos; i < formDataLength - rest; ++i) {
                dataFinal[i - startPos] = dataBytes[i];
            }
            ByteArrayInputStream is = new ByteArrayInputStream(dataFinal);
            String[] name = saveFile.split("\\.");
            MenuIconInfo menuIcon = new MenuIconInfo();
            menuIcon.setName(name[0]);
            menuIcon.setSimpleName(saveFile);
            if (MenuCommonHandle.isCMAdmin(ctx)) {
                menuIcon.setOwnerType(OwnerEnum.IS_ADMIN);
            } else {
                menuIcon.setOwnerType(OwnerEnum.IS_USER);
            }
            this.resultMsg = MenuIconFactory.getLocalInstance(ctx).uploadIcon(menuIcon, is);
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String state = EASResource.getString((String)"com.kingdee.eas.cp.base.BaseResource", (String)"icon_upload_failure");
            this.resultMsg = "{'success':false,'message':'" + state + "'}";
        }
    }

    private void loadIcon(HttpServletRequest request, HttpServletResponse response) {
        String iconId = request.getParameter("iconId");
        iconId = iconId.replaceAll(" ", "+");
        String sql = "select FContent from T_CP_MenuIcon where FID='" + iconId + "'";
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            ServletOutputStream out = response.getOutputStream();
            ByteArrayInputStream in = null;
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql);
            Blob blob = null;
            if (rows.next()) {
                int len;
                blob = rows.getBlob(1);
                byte[] b = blob.getBytes(1L, Integer.valueOf(String.valueOf(blob.length())));
                in = new ByteArrayInputStream(b);
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf, 0, 1024)) != -1) {
                    out.write(buf, 0, len);
                }
            }
            out.close();
            response.flushBuffer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadIconView(HttpServletRequest request, HttpServletResponse response) {
        JSONObject reply = new JSONObject();
        JSONArray records = new JSONArray();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        EntityViewInfo viewInfo = this.buildViewInfo(ctx);
        try {
            MenuIconCollection iconCols = MenuIconFactory.getLocalInstance(ctx).getMenuIconCollection(viewInfo);
            if (null != iconCols && iconCols.size() > 0) {
                for (int i = 0; i < iconCols.size(); ++i) {
                    records.put((Object)JsonObjectUtil.convertMenuIcon2Json(iconCols.get(i)));
                }
            }
            reply.put("images", (Object)records);
            this.resultMsg = reply.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkIconRef(HttpServletRequest request, HttpServletResponse response) {
        String id = request.getParameter("nodeId");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        try {
            boolean existMenuDef = MenuDefFactory.getLocalInstance(ctx).exists("where icon='" + id + "'");
            boolean existShortcutDef = ShortcutDefFactory.getLocalInstance(ctx).exists("where icon='" + id + "'");
            this.resultMsg = existMenuDef || existShortcutDef ? "{'success':true,'message':'true'}" : "{'success':true,'message':'false'}";
        }
        catch (Exception e) {
            this.resultMsg = "{'success':false}";
            e.printStackTrace();
        }
    }

    private void deleteMenuIcon(HttpServletRequest request, HttpServletResponse response) {
        String id = request.getParameter("nodeId");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        try {
            boolean isAdmin = MenuCommonHandle.isCMAdmin(ctx);
            boolean existMenuDef = MenuDefFactory.getLocalInstance(ctx).exists("where icon='" + id + "'");
            boolean existShortcutDef = ShortcutDefFactory.getLocalInstance(ctx).exists("where icon='" + id + "'");
            String sql1 = null;
            String sql2 = null;
            if (!isAdmin) {
                PersonInfo personInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
                sql1 = "update t_cp_menudef set ficonid= null where ficonid='" + id + "' and fpersonid='" + personInfo.getId().toString() + "' and fownerType=1";
                sql2 = "update t_cp_shortcutdef set ficonid= null where ficonid='" + id + "' and fpersonid='" + personInfo.getId().toString() + "' and fownerType=1";
            } else {
                sql1 = "update t_cp_menudef set ficonid= null where ficonid='" + id + "'  and fownerType=0";
                sql2 = "update t_cp_shortcutdef set ficonid= null where ficonid='" + id + "'  and fownerType=0";
            }
            if (existMenuDef) {
                DbUtil.execute((Context)ctx, (String)sql1);
            }
            if (existShortcutDef) {
                DbUtil.execute((Context)ctx, (String)sql2);
            }
            IMenuIcon icon = MenuIconFactory.getLocalInstance(ctx);
            MenuIconInfo iconInfo = (MenuIconInfo)icon.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            if (!isAdmin && iconInfo.getOwnerType().equals((Object)OwnerEnum.IS_ADMIN)) {
                this.resultMsg = "{'success':true,'message':false}";
            } else {
                MenuIconFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                this.resultMsg = "{'success':true,'message':true}";
            }
        }
        catch (Exception e) {
            this.resultMsg = "{'success':false}";
            e.printStackTrace();
        }
    }

    private EntityViewInfo buildViewInfo(Context ctx) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("ownerType"));
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("ownerType", (Object)new Integer(0)));
        if (!MenuCommonHandle.isCMAdmin(ctx)) {
            PersonInfo person = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
            filter.getFilterItems().add(new FilterItemInfo("person", (Object)person.getId().toString()));
            filter.setMaskString(" #0 or #1 ");
        }
        SorterItemInfo ownerTypeSortInfo = new SorterItemInfo("ownerType");
        ownerTypeSortInfo.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(ownerTypeSortInfo);
        SorterItemInfo nameSortInfo = new SorterItemInfo("name");
        nameSortInfo.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(nameSortInfo);
        return viewInfo;
    }
}

