/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.base.web;

import com.kingdee.eas.cp.base.IMenuSolution;
import com.kingdee.eas.cp.base.MenuSolutionCollection;
import com.kingdee.eas.cp.base.MenuSolutionFactory;
import com.kingdee.eas.cp.base.MenuSolutionInfo;
import com.kingdee.eas.cp.base.web.JsonObjectUtil;
import com.kingdee.eas.cp.base.web.MenuBaseAction;
import com.kingdee.eas.cp.common.json.org.JSONArray;
import com.kingdee.eas.cp.common.json.org.JSONObject;
import com.kingdee.util.StringUtils;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class SolutionListAction
extends MenuBaseAction {
    @Override
    protected ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        if (METHOD_NAME.equals("solutionList")) {
            this.getSolutionList(mapping, form, request, response);
        }
        if (METHOD_NAME.equals("addSolution")) {
            return this.addSolution(mapping, form, request, response);
        }
        if (METHOD_NAME.equals("editSolution")) {
            return this.editSolution(mapping, form, request, response);
        }
        if (METHOD_NAME.equals("enableSolution")) {
            this.enableSolution(mapping, form, request, response);
        }
        if (METHOD_NAME.equals("disableSolution")) {
            this.disableSolution(mapping, form, request, response);
        }
        if (METHOD_NAME.equals("delSolution")) {
            this.delSolution(mapping, form, request, response);
        }
        if (METHOD_NAME.equals("expandNodes")) {
            this.expandNodes(mapping, form, request, response, true);
        }
        if (METHOD_NAME.equals("retractNodes")) {
            this.expandNodes(mapping, form, request, response, false);
        }
        try {
            response.setContentType("text/json;charset=utf-8");
            response.getWriter().write(this.resultMsg);
            response.getWriter().flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected ActionForward getSolutionList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            IMenuSolution menuSol = MenuSolutionFactory.getLocalInstance(CTX);
            MenuSolutionCollection menuCols = null;
            menuCols = IS_ADMIN ? menuSol.getMenuSolutionCollection("where state <> 1  order by number") : menuSol.getMenuSolutionCollection("where state = 0  order by number");
            JSONObject jsonResult = new JSONObject();
            jsonResult.put("count", (Object)new Integer(menuCols.size()));
            JSONArray soluJsonArray = new JSONArray();
            Iterator it = menuCols.iterator();
            MenuSolutionInfo menuSolutionInfo = null;
            int i = 1;
            while (it.hasNext()) {
                menuSolutionInfo = (MenuSolutionInfo)it.next();
                JSONObject solutionJsonObj = JsonObjectUtil.convertSolutionForList(menuSolutionInfo);
                soluJsonArray.put((Object)solutionJsonObj);
                ++i;
            }
            jsonResult.put("solution", (Object)soluJsonArray);
            this.resultMsg = jsonResult.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected ActionForward addSolution(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("method", (Object)"addSolution");
        request.setAttribute("disableEditSolution", (Object)(IS_ADMIN ? new Boolean(false) : new Boolean(true)));
        request.setAttribute("hiddenSynMenu", (Object)(IS_ADMIN ? new Boolean(true) : new Boolean(false)));
        return mapping.findForward("todoSolution");
    }

    protected ActionForward editSolution(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("method", (Object)"editSolution");
        request.setAttribute("disableEditSolution", (Object)(IS_ADMIN ? new Boolean(false) : new Boolean(true)));
        request.setAttribute("hiddenSynMenu", (Object)(IS_ADMIN ? new Boolean(true) : new Boolean(false)));
        return mapping.findForward("todoSolution");
    }

    protected ActionForward delSolution(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String solutionId = request.getParameter("recordId");
        solutionId = StringUtils.replace((String)solutionId, (String)" ", (String)"+");
        try {
            this.resultMsg = MenuSolutionFactory.getLocalInstance(CTX).delMenuSolution(solutionId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected ActionForward expandNodes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, boolean status) {
        String solutionId = request.getParameter("recordId");
        solutionId = StringUtils.replace((String)solutionId, (String)" ", (String)"+");
        try {
            this.resultMsg = MenuSolutionFactory.getLocalInstance(CTX).expandNodes(solutionId, status);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected ActionForward enableSolution(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String solutionId = request.getParameter("recordId");
        solutionId = StringUtils.replace((String)solutionId, (String)" ", (String)"+");
        try {
            this.resultMsg = MenuSolutionFactory.getLocalInstance(CTX).enableMenuSolution(solutionId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected ActionForward disableSolution(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String solutionId = request.getParameter("recordId");
        solutionId = StringUtils.replace((String)solutionId, (String)" ", (String)"+");
        try {
            this.resultMsg = MenuSolutionFactory.getLocalInstance(CTX).disableMenuSolution(solutionId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

