/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.base.wfutil.dao;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.cp.base.wfutil.Message;
import com.kingdee.eas.cp.base.wfutil.MessageExtraFilter;
import com.kingdee.eas.cp.base.wfutil.dao.CPMessageDAO;
import com.kingdee.eas.cp.base.wfutil.dao.CPMsgBizTypeSingleton;
import com.kingdee.eas.cp.common.web.util.DAOException;
import com.kingdee.eas.cp.common.web.util.ValueListDAO;
import com.kingdee.eas.cp.eip.mc.web.MsgType;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CPMessageDAOImpl
implements CPMessageDAO,
ValueListDAO {
    Logger logger = Logger.getLogger((String)CPMessageDAOImpl.class.getName());
    private Context context;
    private ResultSet rs;
    private String local = "L2";
    private boolean history = false;
    private String ctCountSql = "select count(*) from T_BAS_Message";
    private String hisCountSql = "select count(*) from T_BAS_MessageHst";
    private String countSql = "";
    private String recsCtSql = "";
    private String recsHisSql = "";
    private String recsSql = "";
    private String filterSql = "";
    private MessageExtraFilter extraFilter;

    public CPMessageDAOImpl(Context context) throws DAOException {
        this.setContext(context);
    }

    public CPMessageDAOImpl(Context context, MsgType type) throws DAOException {
        this.setContext(context);
        this.extraFilter = new MessageExtraFilter(CPMessageDAOImpl.class.getName(), this.local, type);
        this.setMessageSql(context.getCaller().toString(), type);
    }

    private void setMessageSql(String userId, MsgType type) throws DAOException {
        StringBuffer tempBuf = new StringBuffer();
        if (type.getType() >= 0) {
            tempBuf.append(" where FType = ");
            tempBuf.append(type.getType());
            if (type.getSourceStatus() >= -2) {
                if (type.getSourceStatus() == -1) {
                    tempBuf.append(" and (FSourceStatus = ");
                    tempBuf.append(1);
                    tempBuf.append(" or FSourceStatus = ");
                    tempBuf.append(2);
                    tempBuf.append(")");
                } else if (type.getSourceStatus() == -2) {
                    tempBuf.append(" and (FSourceStatus = ");
                    tempBuf.append(4);
                    tempBuf.append(" or FSourceStatus = ");
                    tempBuf.append(8);
                    tempBuf.append(" or FSourceStatus = ");
                    tempBuf.append(16);
                    tempBuf.append(")");
                } else {
                    tempBuf.append(" and FSourceStatus = ");
                    tempBuf.append(type.getSourceStatus());
                }
            } else if (type.getBizType() >= 0) {
                tempBuf.append(" and FBizType = ");
                tempBuf.append(type.getBizType());
            } else if (type.getBizType() == -2) {
                tempBuf.append(" and FBizType not in (");
                tempBuf.append(0);
                tempBuf.append(",");
                tempBuf.append(10);
                tempBuf.append(",");
                tempBuf.append(40);
                tempBuf.append(")");
            }
            tempBuf.append(" and FReceiver = '");
            tempBuf.append(userId);
            tempBuf.append("'");
        } else {
            tempBuf.append(" where FReceiver = '");
            tempBuf.append(userId);
            tempBuf.append("'");
        }
        if (type.getMsgDate() != null && !"".equals(type.getMsgDate())) {
            String beginStr = type.getMsgDate() + " 00:00:00";
            String endStr = type.getMsgDate() + " 23:59:59";
            Timestamp begin = Timestamp.valueOf(beginStr);
            Timestamp end = Timestamp.valueOf(endStr);
            tempBuf.append(" and FReceiveTime >={");
            tempBuf.append(begin);
            tempBuf.append("} and FReceiveTime <={");
            tempBuf.append(end);
            tempBuf.append("}");
        }
        if ("true".equals(type.getIfCurrentOrg())) {
            String filterSql = this.getOrgFilter(this.context);
            this.logger.debug((Object)("message filter sql is " + filterSql));
            tempBuf.append(filterSql);
        }
        if (type.getMsgBizType() != null && !"".equals(type.getMsgBizType())) {
            CPMsgBizTypeSingleton msgBizInstance = CPMsgBizTypeSingleton.getInstance(this.context);
            tempBuf.append(CPMsgBizTypeSingleton.getBizPackageFilter(type.getMsgBizType()));
        }
        if (type.getStatus() == 0 || type.getStatus() == 10) {
            tempBuf.append(" AND FStatus = ").append(type.getStatus());
        }
        this.extraFilter.setFilterSql(tempBuf);
        if ("true".equals(type.getIfHistory())) {
            this.countSql = this.hisCountSql + tempBuf.toString();
            this.recsSql = this.recsHisSql + tempBuf.toString();
            this.history = true;
        } else {
            this.countSql = this.ctCountSql + tempBuf.toString();
            this.recsSql = this.recsCtSql + tempBuf.toString();
            this.history = false;
        }
    }

    public int getRecordsCount() throws DAOException {
        try {
            int count = 0;
            this.logger.debug((Object)("\u6267\u884c\u6d88\u606f\u67e5\u8be2\u8bed\u53e5\uff1a" + this.countSql));
            this.rs = DbUtil.executeQuery((Context)this.context, (String)this.countSql);
            while (this.rs.next()) {
                count += this.rs.getInt(1);
            }
            this.logger.info((Object)("\u672c\u6b21\u67e5\u8be2\u6761\u4ef6\u53d6\u5f97\u7684\u8bb0\u5f55\u6570\u4e3a:" + count));
            return count;
        }
        catch (Exception e) {
            this.logger.error((Object)("\u5f97\u5230\u6d88\u606f\u6570\u91cf\u65f6\u53d1\u751f\u9519\u8bef" + e.getMessage()));
            throw new DAOException((Throwable)e);
        }
    }

    public List getRecords(int pageSize, int pageNo, String orderByField, String orderType) throws DAOException {
        ArrayList<Message> list = new ArrayList<Message>();
        if (pageNo <= 0) {
            return list;
        }
        try {
            Message message;
            this.recsSql = "select top " + pageSize * pageNo + this.recsSql;
            this.recsSql = orderByField != null && orderByField.trim().length() > 0 ? this.recsSql + " order by " + orderByField + " " + orderType : this.recsSql + " order by FReceiveTime DESC";
            this.logger.debug((Object)("\u6267\u884c\u67e5\u8be2\u6d88\u606f\u8bb0\u5f55\u7684\u8bed\u53e5\uff1a" + this.recsSql));
            this.rs = DbUtil.executeQuery((Context)this.context, (String)this.recsSql);
            int i = 0;
            String sourceids = null;
            while (this.rs.next()) {
                if (i == (pageNo - 1) * pageSize) {
                    message = new Message();
                    message.setLocale(new Locale(this.local));
                    message.setID(this.rs.getString(1));
                    message.setType(this.rs.getInt(2));
                    message.setBizType(this.rs.getInt(3));
                    message.setSender(this.rs.getString(4));
                    message.setPriority(this.rs.getInt(5));
                    message.setStatus(this.rs.getInt(6));
                    message.setSourceStatus(this.rs.getInt(7));
                    message.setTitle(this.rs.getString(8));
                    message.setSendTime(this.rs.getTimestamp(9));
                    message.setReceiveTime(this.rs.getTimestamp(10));
                    message.setSourceID(this.rs.getString(11));
                    sourceids = this.rs.getString(12);
                    if (!StringUtils.isEmpty((String)sourceids)) {
                        sourceids = sourceids.replaceAll("[|]", "^!^");
                    }
                    message.setSourceIDs(sourceids);
                    message.setReceiver(this.rs.getString(13));
                    message.setBody(this.rs.getString(14));
                    list.add(message);
                    break;
                }
                ++i;
            }
            while (this.rs.next()) {
                message = new Message();
                message.setLocale(new Locale(this.local));
                message.setID(this.rs.getString(1));
                message.setType(this.rs.getInt(2));
                message.setBizType(this.rs.getInt(3));
                message.setSender(this.rs.getString(4));
                message.setPriority(this.rs.getInt(5));
                message.setStatus(this.rs.getInt(6));
                message.setSourceStatus(this.rs.getInt(7));
                message.setTitle(this.rs.getString(8));
                message.setSendTime(this.rs.getTimestamp(9));
                message.setReceiveTime(this.rs.getTimestamp(10));
                message.setSourceID(this.rs.getString(11));
                sourceids = this.rs.getString(12);
                if (!StringUtils.isEmpty((String)sourceids)) {
                    sourceids = sourceids.replaceAll("[|]", "^!^");
                }
                message.setSourceIDs(sourceids);
                message.setReceiver(this.rs.getString(13));
                message.setBody(this.rs.getString(14));
                list.add(message);
            }
        }
        catch (SQLException sqle) {
            this.logger.error((Object)("\u53d6\u6d88\u606f\u8bb0\u5f55\u65f6\u53d1\u751f\u9519\u8bef\uff1a" + sqle.getMessage()));
            throw new DAOException((Throwable)sqle);
        }
        catch (Exception e) {
            this.logger.error((Object)("\u53d6\u6d88\u606f\u8bb0\u5f55\u65f6\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage()));
            throw new DAOException((Throwable)e);
        }
        return list;
    }

    public void setContext(Context context) {
        this.local = context.getLocale().toString();
        this.recsCtSql = " FID, FType, FBizType, FSender_" + this.local + ",FPriority,FStatus, FSourceStatus, FTitle_" + this.local + ",FSendTime ,FReceiveTime, FSourceID, FSourceIDs, FReceiver ,FBody_" + this.local + " from T_BAS_Message";
        this.recsHisSql = " FID, FType, FBizType, FSender_" + this.local + ",FPriority,FStatus, FSourceStatus, FTitle_" + this.local + ",FSendTime ,FReceiveTime, FSourceID, FSourceIDs, FReceiver ,FBody_" + this.local + " from T_BAS_MessageHst";
        this.context = context;
    }

    public String getRecsCountSql() {
        return this.countSql;
    }

    public String getRecsSql() {
        return this.recsSql;
    }

    private String getOrgFilter(Context ctx) {
        StringBuffer buffer = new StringBuffer();
        CtrlUnitInfo ctrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        AdminOrgUnitInfo adminOrgUnitInfo = ContextUtil.getCurrentAdminUnit((Context)ctx);
        CompanyOrgUnitInfo companyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        SaleOrgUnitInfo saleOrgUnitInfo = ContextUtil.getCurrentSaleUnit((Context)ctx);
        PurchaseOrgUnitInfo purchaseOrgUnitInfo = ContextUtil.getCurrentPurchaseUnit((Context)ctx);
        StorageOrgUnitInfo storageOrgUnitInfo = ContextUtil.getCurrentStorageUnit((Context)ctx);
        CostCenterOrgUnitInfo costCenterOrgUnitInfo = ContextUtil.getCurrentCostUnit((Context)ctx);
        ProfitCenterOrgUnitInfo profitCenterOrgUnitInfo = ContextUtil.getCurrentProfitUnit((Context)ctx);
        buffer.append(" AND ( ( FOrgType = ").append(-1).append(" AND FOrgID = '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("' ) ");
        if (ctrlUnitInfo != null && ctrlUnitInfo.getId() != null) {
            buffer.append(" OR ( FOrgType = ").append(10).append(" AND FOrgID = '").append(ctrlUnitInfo.getId().toString()).append("' ) ");
        }
        if (adminOrgUnitInfo != null && adminOrgUnitInfo.getId() != null) {
            buffer.append(" OR ( FOrgType = ").append(0).append(" AND FOrgID = '").append(adminOrgUnitInfo.getId().toString()).append("' ) ");
        }
        if (companyOrgUnitInfo != null && companyOrgUnitInfo.getId() != null) {
            buffer.append(" OR ( FOrgType = ").append(1).append(" AND FOrgID = '").append(companyOrgUnitInfo.getId().toString()).append("' ) ");
        }
        if (saleOrgUnitInfo != null && saleOrgUnitInfo.getId() != null) {
            buffer.append(" OR ( FOrgType = ").append(2).append(" AND FOrgID = '").append(saleOrgUnitInfo.getId().toString()).append("' ) ");
        }
        if (purchaseOrgUnitInfo != null && purchaseOrgUnitInfo.getId() != null) {
            buffer.append(" OR ( FOrgType = ").append(3).append(" AND FOrgID = '").append(purchaseOrgUnitInfo.getId().toString()).append("' ) ");
        }
        if (storageOrgUnitInfo != null && storageOrgUnitInfo.getId() != null) {
            buffer.append(" OR ( FOrgType = ").append(4).append(" AND FOrgID = '").append(storageOrgUnitInfo.getId().toString()).append("' ) ");
        }
        if (costCenterOrgUnitInfo != null && costCenterOrgUnitInfo.getId() != null) {
            buffer.append(" OR ( FOrgType = ").append(5).append(" AND FOrgID = '").append(costCenterOrgUnitInfo.getId().toString()).append("' ) ");
        }
        if (profitCenterOrgUnitInfo != null && profitCenterOrgUnitInfo.getId() != null) {
            buffer.append(" OR ( FOrgType = ").append(6).append(" AND FOrgID = '").append(profitCenterOrgUnitInfo.getId().toString()).append("' ) ");
        }
        buffer.append(" ) ");
        return buffer.toString();
    }
}

