/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.base.xt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.cp.base.xt.AttchmentDTO;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.util.FileUtil;
import com.kingdee.lightapp.util.StringUtil;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class XTUtil {
    public static final String NEWS_PUBACCTNAME = "XTNews";
    public static final String ODM_PUBACCTNAME = "XTOdm";
    public static final String DM_PUBACCTNAME = "XTKnowledge";
    public static final String ODM = "odm";
    public static final String NEWS = "news";
    public static final String PATHS_KEY = "xt.pubacct.local.server.dir";
    public static final String HREF_LINK_ClEAR_KEY = "data.hreflink.clear";
    public static final String IMAGE_LINK_EXTERNAL_KEY = "data.imagelink.external.converttodata";
    public static final String IMAGE_LINK_INTERNAL_KEY = "data.imagelink.internal.converttodata";
    public static final String HTTP_URL_PORT_KEY = "http.url.port";
    public static final String APPID = "appId";
    public static final String MORESERVER = "moreServer";
    public static final String ISENABLELIGHTAPP = "isEnableLightApp";
    public static final int DEFAULT_WIDTH = 150;
    public static final int DEFAULT_HEIGHT = 150;
    public static final String TITLE = "title";
    public static final String VIEWCONTENT = "viewContent";

    public static String isEnableLightApp(Context ctx, String pubacctname) {
        XTServiceConfig xTServiceConfig = XTServiceConfig.getInstance();
        String isEnableLightApp = "false";
        try {
            String eid = xTServiceConfig.getEidByDbCode(ctx.getAIS());
            isEnableLightApp = xTServiceConfig.getPubAcctProperty(eid, pubacctname, ISENABLELIGHTAPP, "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isEnableLightApp;
    }

    public static boolean isEnableApp(Context ctx, String pubacctname) {
        XTServiceConfig xTServiceConfig = XTServiceConfig.getInstance();
        boolean isEnableApp = false;
        try {
            String eid = xTServiceConfig.getEidByDbCode(ctx.getAIS());
            isEnableApp = xTServiceConfig.getPubEnabled(eid, pubacctname);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isEnableApp;
    }

    public static boolean isEnableXTNews(Context ctx) {
        return XTUtil.isEnableApp(ctx, NEWS_PUBACCTNAME);
    }

    public static boolean isEnableXTOdm(Context ctx) {
        return XTUtil.isEnableApp(ctx, ODM_PUBACCTNAME);
    }

    public static String getStyleFileSrcPath() {
        String cssSrcPath = System.getProperty("EAS_HOME") + File.separator + "server" + File.separator + "deploy" + File.separator + "eas.ear" + File.separator + "cp_web.war" + File.separator + "cm" + File.separator + "css";
        cssSrcPath = cssSrcPath.replace("/", File.separator);
        return cssSrcPath;
    }

    public static String getCssFileSrcPath() {
        String cssSrcPath = System.getProperty("EAS_HOME") + File.separator + "server" + File.separator + "deploy" + File.separator + "eas.ear" + File.separator + "light_cp.war" + File.separator + "cp" + File.separator + "xt" + File.separator + "css";
        cssSrcPath = cssSrcPath.replace("/", File.separator);
        return cssSrcPath;
    }

    public static String getSwipeJsFileSrcPath() {
        String jsSrcPath = System.getProperty("EAS_HOME") + File.separator + "server" + File.separator + "deploy" + File.separator + "eas.ear" + File.separator + "light_cp.war" + File.separator + "cp" + File.separator + "xt" + File.separator + "js";
        return jsSrcPath;
    }

    public static String getJsFileSrcPath() {
        String cssSrcPath = System.getProperty("EAS_HOME") + File.separator + "server" + File.separator + "deploy" + File.separator + "portal.ear" + File.separator + "portal.war" + File.separator + "res" + File.separator + "js" + File.separator + "lib";
        cssSrcPath = cssSrcPath.replace("/", File.separator);
        return cssSrcPath;
    }

    public static String getAttListJsFileSrcPath() {
        String cssSrcPath = System.getProperty("EAS_HOME") + File.separator + "server" + File.separator + "deploy" + File.separator + "eas.ear" + File.separator + "light_cp.war" + File.separator + "cp" + File.separator + "xt" + File.separator + "js";
        cssSrcPath = cssSrcPath.replace("/", File.separator);
        return cssSrcPath;
    }

    public static String getImgFileSrcPath() {
        String cssSrcPath = System.getProperty("EAS_HOME") + File.separator + "server" + File.separator + "deploy" + File.separator + "eas.ear" + File.separator + "light_cp.war" + File.separator + "cp" + File.separator + "xt" + File.separator + "img";
        cssSrcPath = cssSrcPath.replace("/", File.separator);
        return cssSrcPath;
    }

    public static File getUIDFolder(Context ctx, String pubacctName, String id, String folder) {
        XTServiceConfig xTServiceConfig = XTServiceConfig.getInstance();
        String path = xTServiceConfig.getPubAcctProperty(xTServiceConfig.getEidByDbCode(ctx.getAIS()), pubacctName, PATHS_KEY, "");
        String eas_home = System.getProperty("EAS_HOME");
        path = eas_home + path.substring(11, path.length());
        String newsPath = path + File.separator + folder;
        newsPath = newsPath.replace("/", File.separator);
        String uid = StringUtil.encoder((String)id);
        if (uid.indexOf("%") > -1) {
            uid = uid.replaceAll("%", "9");
        }
        File uidFolder = FileUtil.createFolder((String)(newsPath + File.separator + uid));
        return uidFolder;
    }

    public static String formatFileName(String source) {
        if (StringUtil.isEmpty((String)source)) {
            return source;
        }
        String result = StringUtil.encoder((String)source);
        if (result.indexOf("%") > -1) {
            result = result.replaceAll("%", "9");
        }
        return result;
    }

    public static void delMobileDownLoadFile(Context ctx, String modelType, String contentID) {
        if (StringUtils.isEmpty((String)contentID)) {
            return;
        }
        XTUtil.delDocDocument(ctx, modelType, contentID);
        XTUtil.delAttchment(ctx, contentID);
    }

    private static void delDocDocument(Context ctx, String modelType, String contentID) {
        String docId = contentID;
        String path = System.getProperty("EAS_HOME");
        path = path + "/server/deploy/eas.ear/light_app_bas.war/download/cp/doc/";
        String idForFileName = docId.replaceAll("/", "2F");
        String doc = ODM.equals(modelType) ? ".doc" : ".docx";
        try {
            File file = new File(path + idForFileName + doc);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void delAttchment(Context ctx, String contentID) {
        String path = System.getProperty("EAS_HOME");
        path = path + "/server/deploy/eas.ear/light_app_bas.war/download/cp/";
        try {
            List<AttchmentDTO> list = XTUtil.getAttchmentIds(ctx, contentID);
            for (AttchmentDTO dto : list) {
                String idForFileName = dto.getId().replaceAll("/", "2F");
                File file = new File(path + idForFileName + "." + dto.getSimplename());
                if (!file.exists()) continue;
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static List<AttchmentDTO> getAttchmentIds(Context ctx, String billId) {
        IRowSet rowSet = null;
        ArrayList<AttchmentDTO> list = new ArrayList<AttchmentDTO>();
        StringBuffer sql = new StringBuffer();
        sql.append("select att.fid,att.fsimplename ");
        sql.append(" from t_Bas_Attachment att, t_bas_boattchasso bo ");
        sql.append(" where att.fid = bo.fAttachmentid and bo.fboid = '");
        sql.append(billId);
        sql.append("' and att.Fname_l2 not like 'docBody_%' order by att.fname_l2 ");
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet == null) {
                return null;
            }
            while (rowSet.next()) {
                AttchmentDTO dto = new AttchmentDTO();
                dto.setId(rowSet.getString("fid"));
                dto.setSimplename(rowSet.getString("fsimplename"));
                list.add(dto);
            }
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        catch (UuidException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }
}

