/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.base.xt;

import com.kingdee.bos.Context;
import com.kingdee.eas.cp.base.xt.HTMLUtil;
import com.kingdee.lightapp.pa.ThumbnailSizeEnum;
import com.kingdee.lightapp.util.FileUtil;
import com.kingdee.lightapp.util.StringUtil;
import com.kingdee.lightapp.util.image.FileImageByteConverter;
import com.kingdee.lightapp.util.image.IImageByteConverter;
import com.kingdee.lightapp.util.image.ImageUtil;
import com.kingdee.lightapp.util.image.URLImageByteConverter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.MimetypesFileTypeMap;

public class XtImageUtil {
    public static final String JPEG_EXT_NAME = "jpg";
    public static final String ATTACH_PREFIX = "/easportal";
    public static final String FILE_PREFIX = "file:";
    public static final String HTTP_PREFIX = "http:";
    public static final String IMAGE_FOLDER_NAME = "images";

    private XtImageUtil() {
    }

    public static String reduceImageURL(String content, File contentFolder, Context ctx) {
        List<Map<String, Object>> imageList = XtImageUtil.getImageList(content, contentFolder, ctx);
        if (imageList == null || imageList.size() < 1) {
            return content;
        }
        boolean isInternalConvert = false;
        boolean isExternalConvert = false;
        try {
            for (Map<String, Object> img : imageList) {
                IImageByteConverter converter = (IImageByteConverter)img.get("converter");
                if (converter == null) continue;
                String url = img.get("url").toString();
                if (img.get("type").equals("attach")) {
                    if (isInternalConvert) {
                        content = content.replace(url, XtImageUtil.getImageURIString(converter));
                        continue;
                    }
                    XtImageUtil.createImageFile(contentFolder, IMAGE_FOLDER_NAME + File.separator + converter.getName(), converter.getByte(converter.getFormat()));
                    content = content.replace(url, IMAGE_FOLDER_NAME + File.separator + converter.getName());
                    continue;
                }
                if (img.get("type").equals("file")) {
                    if (isInternalConvert) {
                        content = content.replace(url, XtImageUtil.getImageURIString(converter));
                        continue;
                    }
                    String relativePath = url.replace("file://" + contentFolder.getAbsolutePath() + File.separator, "");
                    content = content.replace(url, relativePath);
                    continue;
                }
                if (!img.get("type").equals("http") || !isExternalConvert) continue;
                content = content.replace(url, XtImageUtil.getImageURIString(converter));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return content;
    }

    public static void createImageFile(File contentFolder, String name, byte[] data) {
        try {
            FileUtil.createFile((String)(contentFolder.getPath() + File.separator + name));
            FileUtil.writeFile((String)(contentFolder.getPath() + File.separator + name), (byte[])data);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static List<Map<String, Object>> getImageList(String content, File contentFolder, Context ctx) {
        ArrayList imageList = null;
        List<String> list = HTMLUtil.getImgSrcList(content);
        if (list == null) {
            return imageList;
        }
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            FileImageByteConverter converter;
            if (imageList == null) {
                imageList = new ArrayList();
            }
            HashMap<String, String> img = new HashMap<String, String>();
            String url = iterator.next();
            img.put("url", url);
            if (url.substring(0, 5).equalsIgnoreCase(FILE_PREFIX)) {
                converter = new FileImageByteConverter();
                img.put("type", "file");
            } else if (url.substring(0, 5).equalsIgnoreCase(HTTP_PREFIX)) {
                converter = new URLImageByteConverter();
                img.put("type", "http");
            } else {
                img.put("type", "unknow");
                continue;
            }
            converter.setPath(url);
            img.put("converter", (String)converter);
            imageList.add(img);
        }
        return imageList;
    }

    private static String getImageURIString(IImageByteConverter converter) {
        byte[] data = XtImageUtil.getScaleImage(converter.getByte(converter.getFormat()));
        String base64 = StringUtil.getBase64FromByte((byte[])data);
        String mimeType = XtImageUtil.getMimeType(converter.getFormat());
        String uri = "data:" + mimeType + ";base64," + base64;
        return uri;
    }

    private static String getMimeType(String format) {
        String mimeType = new MimetypesFileTypeMap().getContentType("." + format);
        if (mimeType.equals("application/octet-stream")) {
            format = JPEG_EXT_NAME;
            mimeType = new MimetypesFileTypeMap().getContentType("." + format);
        }
        return mimeType;
    }

    private static byte[] getScaleImage(byte[] data) {
        byte[] out = null;
        out = ImageUtil.scaleByWidth((byte[])data, (int)ThumbnailSizeEnum.BIG_WIDTH.value(), (String)JPEG_EXT_NAME);
        return out;
    }
}

