/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.ByteArray;
import com.kingdee.eas.cp.hsqldb.DatabaseRowInput;
import com.kingdee.eas.cp.hsqldb.DatabaseRowInputInterface;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

class BinaryDatabaseRowInput
extends DatabaseRowInput
implements DatabaseRowInputInterface {
    public BinaryDatabaseRowInput(byte[] bin, int pos) throws IOException {
        super(bin, pos);
    }

    @Override
    public int readType() throws IOException {
        return this.readInt();
    }

    @Override
    public int readIntData() throws IOException {
        return this.readInt();
    }

    @Override
    public String readString() throws IOException {
        return this.readUTF();
    }

    private String readNumericString() throws IOException {
        return this.readString();
    }

    byte[] readByteArray() throws IOException {
        byte[] b = new byte[this.readInt()];
        this.readFully(b);
        return b;
    }

    @Override
    protected boolean checkNull() throws IOException {
        return this.readInt() == 0;
    }

    @Override
    protected String readChar(int type) throws IOException {
        return this.readUTF();
    }

    @Override
    protected Integer readSmallint() throws IOException, SQLException {
        return Integer.valueOf(this.readNumericString());
    }

    @Override
    protected Integer readInteger() throws IOException, SQLException {
        return new Integer(this.readIntData());
    }

    @Override
    protected Long readBigint() throws IOException, SQLException {
        return Long.valueOf(this.readNumericString());
    }

    @Override
    protected Double readReal(int type) throws IOException, SQLException {
        if (type == 7) {
            return Double.valueOf(this.readNumericString());
        }
        return new Double(Double.longBitsToDouble(this.readLong()));
    }

    @Override
    protected BigDecimal readDecimal() throws IOException, SQLException {
        return new BigDecimal(this.readNumericString());
    }

    @Override
    protected Boolean readBit() throws IOException, SQLException {
        return Boolean.valueOf(this.readString());
    }

    @Override
    protected Time readTime() throws IOException, SQLException {
        return Time.valueOf(this.readString());
    }

    @Override
    protected Date readDate() throws IOException, SQLException {
        return Date.valueOf(this.readString());
    }

    @Override
    protected Timestamp readTimestamp() throws IOException, SQLException {
        return Timestamp.valueOf(this.readString());
    }

    @Override
    protected Object readOther() throws IOException, SQLException {
        String binarystring = this.readString();
        byte[] o = binarystring.equals("**") ? this.readByteArray() : ByteArray.hexToByteArray(binarystring);
        return ByteArray.deserialize(o);
    }

    @Override
    protected byte[] readBinary(int type) throws IOException, SQLException {
        String hexstring = this.readString();
        if (hexstring.equals("**")) {
            return this.readByteArray();
        }
        return ByteArray.hexToByteArray(hexstring);
    }
}

