/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.ByteArray;
import com.kingdee.eas.cp.hsqldb.CachedRow;
import com.kingdee.eas.cp.hsqldb.DatabaseRowOutput;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

class BinaryDatabaseRowOutput
extends DatabaseRowOutput {
    int storageSize;
    private ByteArrayOutputStream byteOut;

    public BinaryDatabaseRowOutput() throws IOException {
        super(new ByteArrayOutputStream());
        this.byteOut = (ByteArrayOutputStream)this.out;
    }

    public BinaryDatabaseRowOutput(int size) throws IOException {
        super(new ByteArrayOutputStream(size));
        this.byteOut = (ByteArrayOutputStream)this.out;
    }

    @Override
    public void writeIntData(int i) throws IOException {
        this.writeInt(i);
    }

    @Override
    public void writePos(int pos) throws IOException {
        this.writeInt(pos);
        while (this.byteOut.size() < this.storageSize) {
            this.write(0);
        }
    }

    @Override
    public void writeSize(int size) throws IOException {
        this.storageSize = size;
        this.writeInt(size);
    }

    @Override
    public void writeType(int type) throws IOException {
        this.writeInt(type);
    }

    @Override
    public void writeString(String s) throws IOException {
        this.writeUTF(s);
    }

    @Override
    public byte[] toByteArray() throws IOException {
        byte[] ret = this.byteOut.toByteArray();
        this.byteOut.reset();
        return ret;
    }

    @Override
    protected void writeFieldType(int type) throws IOException {
        this.writeInt(type);
    }

    @Override
    protected void writeNull(int type) throws IOException {
        this.writeType(0);
    }

    @Override
    protected void writeChar(String s, int t) throws IOException {
        this.writeUTF(s);
    }

    @Override
    protected void writeSmallint(Number o) throws IOException, SQLException {
        this.writeString(o.toString());
    }

    @Override
    protected void writeInteger(Number o) throws IOException, SQLException {
        this.writeInt(o.intValue());
    }

    @Override
    protected void writeBigint(Number o) throws IOException, SQLException {
        this.writeString(o.toString());
    }

    @Override
    protected void writeReal(Double o, int type) throws IOException, SQLException {
        if (type == 7) {
            this.writeString(o.toString());
        } else {
            this.writeLong(Double.doubleToLongBits(o));
        }
    }

    @Override
    protected void writeDecimal(BigDecimal o) throws IOException, SQLException {
        this.writeString(o.toString());
    }

    @Override
    protected void writeBit(Boolean o) throws IOException, SQLException {
        this.writeString(o.toString());
    }

    @Override
    protected void writeDate(Date o) throws IOException, SQLException {
        this.writeString(o.toString());
    }

    @Override
    protected void writeTime(Time o) throws IOException, SQLException {
        this.writeString(o.toString());
    }

    @Override
    protected void writeTimestamp(Timestamp o) throws IOException, SQLException {
        this.writeString(o.toString());
    }

    @Override
    protected void writeOther(Object o) throws IOException, SQLException {
        byte[] ba = ByteArray.serialize(o);
        this.writeByteArray(ba);
    }

    @Override
    protected void writeBinary(byte[] o, int t) throws IOException, SQLException {
        this.writeByteArray(o);
    }

    protected void writeByteArray(byte[] b) throws IOException {
        this.writeString("**");
        this.writeInt(b.length);
        this.write(b, 0, b.length);
    }

    public static int getSize(CachedRow row) throws SQLException {
        Object[] data = row.getData();
        int[] type = row.getTable().getColumnTypes();
        return BinaryDatabaseRowOutput.getSize(data, data.length, type);
    }

    private static int getSize(Object[] data, int l, int[] type) throws SQLException {
        int s = 0;
        block6: for (int i = 0; i < l; ++i) {
            Object o = data[i];
            s += 4;
            if (o == null) continue;
            switch (type[i]) {
                case 4: {
                    s += 4;
                    continue block6;
                }
                case 6: 
                case 8: {
                    s += 8;
                    continue block6;
                }
                case -4: 
                case -3: 
                case -2: {
                    s += BinaryDatabaseRowOutput.getUTFsize("**");
                    s += 4;
                    s += ((byte[])o).length;
                    continue block6;
                }
                case 1111: {
                    s += BinaryDatabaseRowOutput.getUTFsize("**");
                    s += 4;
                    s += ByteArray.serialize(o).length;
                }
                default: {
                    s += BinaryDatabaseRowOutput.getUTFsize(o.toString());
                }
            }
        }
        return s;
    }

    private static int getUTFsize(String s) {
        int len = s == null ? 0 : s.length();
        int l = 2;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++l;
                continue;
            }
            if (c > '\u07ff') {
                l += 3;
                continue;
            }
            l += 2;
        }
        return l;
    }
}

