/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.ConstraintCore;
import com.kingdee.eas.cp.hsqldb.HsqlName;
import com.kingdee.eas.cp.hsqldb.Index;
import com.kingdee.eas.cp.hsqldb.Node;
import com.kingdee.eas.cp.hsqldb.Record;
import com.kingdee.eas.cp.hsqldb.Result;
import com.kingdee.eas.cp.hsqldb.Table;
import com.kingdee.eas.cp.hsqldb.Trace;
import com.kingdee.eas.cp.hsqldb.lib.ArrayUtil;
import java.sql.SQLException;

class Constraint {
    static final int FOREIGN_KEY = 0;
    static final int MAIN = 1;
    static final int UNIQUE = 2;
    private ConstraintCore core;
    private HsqlName constName;
    private int iType;

    Constraint(HsqlName name, Table t, Index index) {
        this.core = new ConstraintCore();
        this.constName = name;
        this.iType = 2;
        this.core.tMain = t;
        this.core.iMain = index;
        this.core.iColMain = index.getColumns();
        this.core.iLen = this.core.iColMain.length;
    }

    Constraint(HsqlName name, Constraint fkconstraint) {
        this.constName = name;
        this.iType = 1;
        this.core = fkconstraint.core;
    }

    Constraint(HsqlName pkname, HsqlName fkname, Table main, Table ref, int[] colmain, int[] colref, Index imain, Index iref, boolean cascade) throws SQLException {
        this.core = new ConstraintCore();
        this.core.pkName = pkname;
        this.core.fkName = fkname;
        this.constName = fkname;
        this.iType = 0;
        this.core.tMain = main;
        this.core.tRef = ref;
        this.core.iColMain = colmain;
        this.core.iLen = this.core.iColMain.length;
        this.core.iColRef = colref;
        this.core.oColRef = new Object[this.core.iColRef.length];
        this.core.iMain = imain;
        this.core.iRef = iref;
        this.core.bCascade = cascade;
        this.setTableRows();
    }

    private Constraint() {
    }

    private void setTableRows() throws SQLException {
        this.core.oMain = this.core.tMain.getNewRow();
        if (this.core.tRef != null) {
            this.core.oRef = this.core.tRef.getNewRow();
        }
    }

    HsqlName getName() {
        return this.constName;
    }

    private void setName(String name, boolean isquoted) {
        this.constName.rename(name, isquoted);
    }

    String getPkName() {
        return this.core.pkName == null ? null : this.core.pkName.name;
    }

    String getFkName() {
        return this.core.fkName == null ? null : this.core.fkName.name;
    }

    int getType() {
        return this.iType;
    }

    Table getMain() {
        return this.core.tMain;
    }

    Index getMainIndex() {
        return this.core.iMain;
    }

    Table getRef() {
        return this.core.tRef;
    }

    Index getRefIndex() {
        return this.core.iRef;
    }

    boolean isCascade() {
        return this.core.bCascade;
    }

    int[] getMainColumns() {
        return this.core.iColMain;
    }

    int[] getRefColumns() {
        return this.core.iColRef;
    }

    boolean isIndexFK(Index index) {
        return !(this.iType != 0 && this.iType != 1 || this.core.iMain != index && this.core.iRef != index);
    }

    boolean isIndexUnique(Index index) {
        return this.iType == 2 && this.core.iMain == index;
    }

    boolean isEquivalent(int[] col, int type) {
        return type == this.iType && this.iType == 2 && this.core.iLen == col.length && ArrayUtil.haveEqualSets(this.core.iColMain, col, this.core.iLen);
    }

    void replaceTable(Table oldt, Table newt, int colindex, int adjust) throws SQLException {
        if (oldt == this.core.tMain) {
            this.core.tMain = newt;
            this.setTableRows();
            this.core.iMain = this.core.tMain.getIndex(this.core.iMain.getName().name);
            this.core.iColMain = ArrayUtil.getAdjustedColumnArray(this.core.iColMain, this.core.iLen, colindex, adjust);
        }
        if (oldt == this.core.tRef) {
            this.core.tRef = newt;
            this.setTableRows();
            if (this.core.iRef != null) {
                this.core.iRef = this.core.tRef.getIndex(this.core.iRef.getName().name);
                if (this.core.iRef != this.core.iMain) {
                    this.core.iColRef = ArrayUtil.getAdjustedColumnArray(this.core.iColRef, this.core.iLen, colindex, adjust);
                }
            }
        }
    }

    void checkInsert(Object[] row) throws SQLException {
        if (this.iType == 1 || this.iType == 2) {
            return;
        }
        for (int i = 0; i < this.core.iLen; ++i) {
            Object o = row[this.core.iColRef[i]];
            if (o == null) {
                return;
            }
            this.core.oMain[this.core.iColMain[i]] = o;
        }
        Trace.check(this.core.iMain.find(this.core.oMain) != null, 8, this.core.fkName.name + " table: " + this.core.tMain.getName().name);
    }

    private void checkDelete(Object[] row) throws SQLException {
        for (int i = 0; i < this.core.iLen; ++i) {
            Object o = row[this.core.iColMain[i]];
            if (o == null) {
                return;
            }
            this.core.oRef[this.core.iColRef[i]] = o;
        }
        Node node = this.core.iRef.find(this.core.oRef);
        Trace.check(node == null, 8, this.core.fkName.name + " table: " + this.core.tRef.getName().name);
    }

    Node findFkRef(Object[] row) throws SQLException {
        for (int i = 0; i < this.core.iLen; ++i) {
            Object o = row[this.core.iColMain[i]];
            if (o == null) {
                return null;
            }
            this.core.oColRef[i] = o;
        }
        Node node = this.core.iRef.findSimple(this.core.oColRef, this.core.bCascade);
        Trace.check(node == null || this.core.bCascade, 8, this.core.fkName.name + " table: " + this.core.tRef.getName().name);
        return node;
    }

    void checkUpdate(int[] col, Result deleted, Result inserted) throws SQLException {
        block7: {
            block6: {
                if (this.iType == 2) {
                    return;
                }
                if (this.iType != 1) break block6;
                if (!ArrayUtil.haveCommonElement(col, this.core.iColMain, this.core.iLen)) {
                    return;
                }
                Record r = deleted.rRoot;
                while (r != null) {
                    if (this.core.iMain.find(r.data) == null) {
                        this.checkDelete(r.data);
                    }
                    r = r.next;
                }
                break block7;
            }
            if (this.iType != 0) break block7;
            if (!ArrayUtil.haveCommonElement(col, this.core.iColMain, this.core.iLen)) {
                return;
            }
            Record r = inserted.rRoot;
            while (r != null) {
                this.checkInsert(r.data);
                r = r.next;
            }
        }
    }
}

