/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.Cache;
import com.kingdee.eas.cp.hsqldb.Column;
import com.kingdee.eas.cp.hsqldb.Constraint;
import com.kingdee.eas.cp.hsqldb.DatabaseInformation;
import com.kingdee.eas.cp.hsqldb.DatabaseScript;
import com.kingdee.eas.cp.hsqldb.HsqlDatabaseProperties;
import com.kingdee.eas.cp.hsqldb.HsqlName;
import com.kingdee.eas.cp.hsqldb.Index;
import com.kingdee.eas.cp.hsqldb.Library;
import com.kingdee.eas.cp.hsqldb.Log;
import com.kingdee.eas.cp.hsqldb.Parser;
import com.kingdee.eas.cp.hsqldb.Record;
import com.kingdee.eas.cp.hsqldb.Result;
import com.kingdee.eas.cp.hsqldb.Select;
import com.kingdee.eas.cp.hsqldb.Session;
import com.kingdee.eas.cp.hsqldb.Table;
import com.kingdee.eas.cp.hsqldb.TableWorks;
import com.kingdee.eas.cp.hsqldb.TextTable;
import com.kingdee.eas.cp.hsqldb.Tokenizer;
import com.kingdee.eas.cp.hsqldb.Trace;
import com.kingdee.eas.cp.hsqldb.Trigger;
import com.kingdee.eas.cp.hsqldb.TriggerDef;
import com.kingdee.eas.cp.hsqldb.User;
import com.kingdee.eas.cp.hsqldb.UserManager;
import com.kingdee.eas.cp.hsqldb.View;
import com.kingdee.eas.cp.hsqldb.jdbcConnection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class Database {
    private String sName;
    private UserManager aAccess;
    private Vector tTable;
    private DatabaseInformation dInfo;
    Logger logger;
    boolean bReadOnly;
    private boolean bShutdown;
    private Hashtable hAlias;
    private boolean bIgnoreCase;
    private boolean bReferentialIntegrity;
    private Vector cSession;
    private HsqlDatabaseProperties databaseProperties;
    private Session sysSession;
    private static final int CALL = 1;
    private static final int CHECKPOINT = 2;
    private static final int COMMIT = 3;
    private static final int CONNECT = 4;
    private static final int CREATE = 5;
    private static final int DELETE = 6;
    private static final int DISCONNECT = 7;
    private static final int DROP = 8;
    private static final int GRANT = 9;
    private static final int INSERT = 10;
    private static final int REVOKE = 11;
    private static final int ROLLBACK = 12;
    private static final int SAVEPOINT = 13;
    private static final int SCRIPT = 14;
    private static final int SELECT = 15;
    private static final int SET = 16;
    private static final int SHUTDOWN = 17;
    private static final int UPDATE = 18;
    private static final int SEMICOLON = 19;
    private static final int ALTER = 20;
    private static final Hashtable hCommands = new Hashtable(37);

    Database(String name) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.sName = name;
        this.open();
    }

    private void open() throws SQLException {
        this.tTable = new Vector();
        this.aAccess = new UserManager();
        this.cSession = new Vector();
        this.hAlias = new Hashtable();
        this.logger = new Logger();
        this.bReferentialIntegrity = true;
        Library.register(this.hAlias);
        this.dInfo = new DatabaseInformation(this, this.tTable, this.aAccess);
        boolean newdatabase = false;
        this.sysSession = new Session(this, new User(null, null, true, null), true, false, 0);
        this.registerSession(this.sysSession);
        this.databaseProperties = new HsqlDatabaseProperties(this.sName);
        if (this.sName.equals(".")) {
            newdatabase = true;
            this.databaseProperties.setProperty("sql.strict_fk", true);
        } else {
            newdatabase = this.logger.openLog(this, this.sysSession, this.sName);
        }
        HsqlName.sysNumber = 0;
        Library.setSqlMonth(this.databaseProperties.isPropertyTrue("sql.month"));
        Parser.setEnforceSize(this.databaseProperties.isPropertyTrue("sql.enforce_size"));
        Column.setCompareInLocal(this.databaseProperties.isPropertyTrue("sql.compare_in_locale"));
        Record.gcFrequency = this.databaseProperties.getIntegerProperty("hsqldb.gc_interval", 0);
        if (newdatabase) {
            this.execute("CREATE USER SA PASSWORD \"\" ADMIN", this.sysSession);
        }
        this.aAccess.grant("PUBLIC", "CLASS \"java.lang.Math\"", 15);
        this.aAccess.grant("PUBLIC", "CLASS \"org.hsqldb.Library\"", 15);
    }

    String getName() {
        return this.sName;
    }

    HsqlDatabaseProperties getProperties() {
        return this.databaseProperties;
    }

    boolean isShutdown() {
        return this.bShutdown;
    }

    synchronized Session connect(String username, String password) throws SQLException {
        int size;
        User user = this.aAccess.getUser(username.toUpperCase(), password.toUpperCase());
        int id = size = this.cSession.size();
        for (int i = 0; i < size; ++i) {
            if (this.cSession.elementAt(i) != null) continue;
            id = i;
            break;
        }
        Session session = new Session(this, user, true, this.bReadOnly, id);
        this.logger.writeToLog(session, "CONNECT USER " + username + " PASSWORD \"" + password + "\"");
        this.registerSession(session);
        return session;
    }

    void registerSession(Session session) {
        int size = this.cSession.size();
        int id = session.getId();
        if (id >= size) {
            this.cSession.setSize(id + 1);
        }
        this.cSession.setElementAt(session, id);
    }

    byte[] execute(String user, String password, String statement) {
        Result r = null;
        try {
            Session session = this.connect(user, password);
            r = this.execute(statement, session);
            this.execute("DISCONNECT", session);
        }
        catch (SQLException e) {
            r = new Result(e.getMessage(), e.getErrorCode());
        }
        catch (Exception e) {
            r = new Result(e.getMessage(), 40);
        }
        try {
            return r.getBytes();
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    synchronized Result execute(String statement, Session session) {
        if (Record.gcFrequency != 0 && Record.memoryRecords > Record.gcFrequency) {
            System.gc();
            Trace.printSystemOut("gc at " + Record.memoryRecords);
            Record.memoryRecords = 0;
        }
        if (Trace.TRACE) {
            Trace.trace(statement);
        }
        Result rResult = null;
        try {
            Tokenizer c = new Tokenizer(statement);
            Parser p = new Parser(this, c, session);
            this.logger.cleanUp();
            Trace.check(session != null, 33);
            Trace.check(!this.bShutdown, 4);
            while (true) {
                c.setPartMarker();
                session.setScripting(false);
                String sToken = c.getString();
                if (sToken.length() != 0) {
                    Integer command = (Integer)hCommands.get(sToken);
                    if (command == null) {
                        throw Trace.error(11, sToken);
                    }
                    int cmd = command;
                    switch (cmd) {
                        case 15: {
                            rResult = p.processSelect();
                            break;
                        }
                        case 10: {
                            rResult = p.processInsert();
                            break;
                        }
                        case 18: {
                            rResult = p.processUpdate();
                            break;
                        }
                        case 6: {
                            rResult = p.processDelete();
                            break;
                        }
                        case 1: {
                            rResult = p.processCall();
                            break;
                        }
                        case 16: {
                            rResult = this.processSet(c, session);
                            break;
                        }
                        case 3: {
                            rResult = this.processCommit(c, session);
                            session.setScripting(true);
                            break;
                        }
                        case 12: {
                            rResult = this.processRollback(c, session);
                            session.setScripting(true);
                            break;
                        }
                        case 13: {
                            rResult = this.processSavepoint(c, session);
                            session.setScripting(true);
                            break;
                        }
                        case 5: {
                            rResult = this.processCreate(c, session);
                            break;
                        }
                        case 20: {
                            rResult = this.processAlter(c, session);
                            break;
                        }
                        case 8: {
                            rResult = this.processDrop(c, session);
                            break;
                        }
                        case 9: {
                            rResult = this.processGrantOrRevoke(c, session, true);
                            break;
                        }
                        case 11: {
                            rResult = this.processGrantOrRevoke(c, session, false);
                            break;
                        }
                        case 4: {
                            rResult = this.processConnect(c, session);
                            break;
                        }
                        case 7: {
                            rResult = this.processDisconnect(session);
                            break;
                        }
                        case 14: {
                            rResult = this.processScript(c, session);
                            break;
                        }
                        case 17: {
                            rResult = this.processShutdown(c, session);
                            break;
                        }
                        case 2: {
                            rResult = this.processCheckpoint(session);
                            break;
                        }
                    }
                    if (!session.getScripting()) continue;
                    this.logger.writeToLog(session, c.getLastPart());
                    continue;
                }
                break;
            }
        }
        catch (SQLException e) {
            rResult = new Result(e.getMessage() + " in statement [" + statement + "]", e.getErrorCode());
        }
        catch (Exception e) {
            e.printStackTrace();
            String s = Trace.getMessage(40) + " " + e;
            rResult = new Result(s + " in statement [" + statement + "]", 40);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            rResult = new Result("out of memory", 40);
        }
        return rResult == null ? new Result() : rResult;
    }

    void setReadOnly() {
        this.bReadOnly = true;
    }

    Vector getTables() {
        return this.tTable;
    }

    UserManager getUserManager() {
        return this.aAccess;
    }

    void setReferentialIntegrity(boolean ref) {
        this.bReferentialIntegrity = ref;
    }

    boolean isReferentialIntegrity() {
        return this.bReferentialIntegrity;
    }

    Hashtable getAlias() {
        return this.hAlias;
    }

    String getAlias(String s) {
        String alias = (String)this.hAlias.get(s);
        return alias == null ? s : alias;
    }

    Table getTable(String name, Session session) throws SQLException {
        Table t = this.findUserTable(name, session);
        if (t == null) {
            t = this.dInfo.getSystemTable(name, session);
        }
        if (t == null) {
            throw Trace.error(22, name);
        }
        return t;
    }

    Table getUserTable(String name, Session session) throws SQLException {
        Table t = this.findUserTable(name, session);
        if (t == null) {
            throw Trace.error(22, name);
        }
        return t;
    }

    Table getUserTable(String name) throws SQLException {
        Table t = this.findUserTable(name);
        if (t == null) {
            throw Trace.error(22, name);
        }
        return t;
    }

    Table findUserTable(String name) {
        int tsize = this.tTable.size();
        for (int i = 0; i < tsize; ++i) {
            Table t = (Table)this.tTable.elementAt(i);
            if (!t.equals(name)) continue;
            return t;
        }
        return null;
    }

    Table findUserTable(String name, Session session) {
        int tsize = this.tTable.size();
        for (int i = 0; i < tsize; ++i) {
            Table t = (Table)this.tTable.elementAt(i);
            if (!t.equals(name, session)) continue;
            return t;
        }
        return null;
    }

    Result getScript(boolean drop, boolean insert, boolean cached, Session session) throws SQLException {
        return DatabaseScript.getScript(this, drop, insert, cached, session);
    }

    void linkTable(Table t) throws SQLException {
        this.tTable.addElement(t);
    }

    boolean isIgnoreCase() {
        return this.bIgnoreCase;
    }

    private Result processScript(Tokenizer c, Session session) throws SQLException {
        String sToken = c.getString();
        if (c.wasValue()) {
            sToken = (String)c.getAsValue();
            Log.scriptToFile(this, sToken, true, session);
            return new Result();
        }
        c.back();
        return this.getScript(false, true, false, session);
    }

    private Result processCreate(Tokenizer c, Session session) throws SQLException {
        session.checkReadWrite();
        session.checkAdmin();
        String sToken = c.getString();
        boolean isTemp = false;
        if (sToken.equals("TEMP")) {
            isTemp = true;
            sToken = c.getString();
            Trace.check(sToken.equals("TABLE") || sToken.equals("MEMORY") || sToken.equals("TEXT"), 11, sToken);
            session.setScripting(false);
        } else {
            session.checkReadWrite();
            session.checkAdmin();
            session.setScripting(true);
        }
        if (sToken.equals("TABLE")) {
            int tableType = isTemp ? 1 : 2;
            this.processCreateTable(c, session, tableType);
        } else if (sToken.equals("MEMORY")) {
            c.getThis("TABLE");
            int tableType = isTemp ? 1 : 2;
            this.processCreateTable(c, session, tableType);
        } else if (sToken.equals("CACHED")) {
            c.getThis("TABLE");
            this.processCreateTable(c, session, 3);
        } else if (sToken.equals("TEXT")) {
            c.getThis("TABLE");
            int tableType = isTemp ? 4 : 5;
            this.processCreateTable(c, session, tableType);
        } else if (sToken.equals("VIEW")) {
            this.processCreateView(c, session);
        } else if (sToken.equals("TRIGGER")) {
            this.processCreateTrigger(c, session);
        } else if (sToken.equals("USER")) {
            String u = c.getStringToken();
            c.getThis("PASSWORD");
            String p = c.getStringToken();
            boolean admin = c.getString().equals("ADMIN");
            this.aAccess.createUser(u, p, admin);
        } else if (sToken.equals("ALIAS")) {
            String name = c.getString();
            sToken = c.getString();
            Trace.check(sToken.equals("FOR"), 11, sToken);
            sToken = c.getString();
            if (sToken.startsWith("org.hsql.Library.")) {
                sToken = "org.hsqldb.Library." + sToken.substring("org.hsql.Library.".length());
            } else if (sToken.equals("java.lang.Math.abs")) {
                sToken = "org.hsqldb.Library.abs";
            }
            this.hAlias.put(name, sToken);
        } else {
            boolean unique = false;
            if (sToken.equals("UNIQUE")) {
                unique = true;
                sToken = c.getString();
            }
            if (!sToken.equals("INDEX")) {
                throw Trace.error(11, sToken);
            }
            String name = c.getName();
            boolean isnamequoted = c.wasQuotedIdentifier();
            c.getThis("ON");
            Table t = this.getTable(c.getName(), session);
            this.addIndexOn(c, session, name, isnamequoted, t, unique);
        }
        return new Result();
    }

    private int[] processColumnList(Tokenizer c, Table t) throws SQLException {
        Hashtable<String, String> h;
        Vector<String> v;
        block3: {
            String sToken;
            v = new Vector<String>();
            h = new Hashtable<String, String>();
            c.getThis("(");
            do {
                String colname = c.getName();
                v.addElement(colname);
                h.put(colname, colname);
                sToken = c.getString();
                if (sToken.equals(")")) break block3;
            } while (sToken.equals(","));
            throw Trace.error(11, sToken);
        }
        int s = v.size();
        if (s != h.size()) {
            throw Trace.error(27, "duplicate column in list");
        }
        int[] col = new int[s];
        for (int i = 0; i < s; ++i) {
            col[i] = t.getColumnNr((String)v.elementAt(i));
        }
        return col;
    }

    private void addIndexOn(Tokenizer c, Session session, String name, boolean namequoted, Table t, boolean unique) throws SQLException {
        int[] col = this.processColumnList(c, t);
        HsqlName indexname = HsqlName.isReservedName(name) ? HsqlName.makeAutoName("USER", name) : new HsqlName(name, namequoted);
        if (this.findIndex(name) != null) {
            throw Trace.error(23);
        }
        session.commit();
        session.setScripting(!t.isTemp());
        TableWorks tw = new TableWorks(t);
        tw.createIndex(col, indexname, unique);
    }

    private Index findIndex(String name) {
        Table t = this.findTableForIndex(name);
        if (t == null) {
            return null;
        }
        return t.getIndex(name);
    }

    private Table findTableForIndex(String name) {
        int tsize = this.tTable.size();
        for (int i = 0; i < tsize; ++i) {
            Table t = (Table)this.tTable.elementAt(i);
            if (t.getIndex(name) == null) continue;
            return t;
        }
        return null;
    }

    int getTableIndex(Table table) {
        int tsize = this.tTable.size();
        for (int i = 0; i < tsize; ++i) {
            Table t = (Table)this.tTable.elementAt(i);
            if (t != table) continue;
            return i;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processCreateTrigger(Tokenizer c, Session session) throws SQLException {
        boolean bForEach = false;
        boolean bNowait = false;
        int nQueueSize = TriggerDef.getDefaultQueueSize();
        String sTrigName = c.getName();
        String sWhen = c.getString();
        String sOper = c.getString();
        c.getThis("ON");
        String sTableName = c.getString();
        Table t = this.getTable(sTableName, session);
        if (t.isView()) {
            throw Trace.error(55);
        }
        session.setScripting(!t.isTemp());
        String tok = c.getString();
        if (tok.equals("FOR")) {
            tok = c.getString();
            if (!tok.equals("EACH")) throw Trace.error(12, tok);
            tok = c.getString();
            if (!tok.equals("ROW")) throw Trace.error(12, tok);
            bForEach = true;
            tok = c.getString();
        }
        if (tok.equals("NOWAIT")) {
            bNowait = true;
            tok = c.getString();
        }
        if (tok.equals("QUEUE")) {
            nQueueSize = Integer.parseInt(c.getString());
            tok = c.getString();
        }
        if (!tok.equals("CALL")) {
            throw Trace.error(12, tok);
        }
        String sClassName = c.getString();
        try {
            Class<?> cl = Class.forName(sClassName);
            Trigger o = (Trigger)cl.newInstance();
            TriggerDef td = new TriggerDef(sTrigName, sWhen, sOper, bForEach, t, o, "\"" + sClassName + "\"", bNowait, nQueueSize);
            if (!td.isValid()) {
                String msg = "Error in parsing trigger command ";
                throw Trace.error(11, msg);
            }
            t.addTrigger(td);
            td.start();
            return;
        }
        catch (Exception e) {
            String msg = "Exception in loading trigger class " + e.getMessage();
            throw Trace.error(13, msg);
        }
    }

    private Column processCreateColumn(Tokenizer c, Table t) throws SQLException {
        String sToken;
        boolean identity = false;
        boolean primarykey = false;
        String sColumn = sToken = c.getString();
        boolean isnamequoted = c.wasQuotedIdentifier();
        String typestring = c.getString();
        int iType = Column.getTypeNr(typestring);
        Trace.check(!sColumn.equals(""), 27, sColumn);
        if (typestring.equals("IDENTITY")) {
            identity = true;
            primarykey = true;
        }
        if (iType == 12 && this.bIgnoreCase) {
            iType = 100;
        }
        sToken = c.getString();
        if (iType == 8 && sToken.equals("PRECISION")) {
            sToken = c.getString();
        }
        String sLen = "";
        if (sToken.equals("(")) {
            do {
                if ((sToken = c.getString()).equals(")")) continue;
                sLen = sLen + sToken;
            } while (!sToken.equals(")"));
            sToken = c.getString();
        }
        int iLen = 0;
        int iScale = 0;
        int index = sLen.indexOf(",");
        if (index != -1) {
            String sScale = sLen.substring(index + 1, sLen.length());
            sLen = sLen.substring(0, index);
            try {
                iScale = Integer.parseInt(sScale.trim());
            }
            catch (NumberFormatException ne) {
                throw Trace.error(11, sLen);
            }
        }
        if (sLen.trim().length() > 0) {
            try {
                iLen = Integer.parseInt(sLen.trim());
            }
            catch (NumberFormatException ne) {
                throw Trace.error(11, sLen);
            }
        }
        String defaultvalue = null;
        if (sToken.equals("DEFAULT")) {
            String s = c.getString();
            if (c.wasValue() && iType != -2 && iType != 1111) {
                Object sv = c.getAsValue();
                if (sv != null) {
                    defaultvalue = String.valueOf(sv);
                    try {
                        Column.convertObject(defaultvalue, iType);
                    }
                    catch (Exception e) {
                        throw Trace.error(46, defaultvalue);
                    }
                    String testdefault = (String)Parser.enforceSize(defaultvalue, iType, iLen, false);
                    if (!defaultvalue.equals(testdefault)) {
                        throw Trace.error(46, defaultvalue);
                    }
                }
            } else {
                throw Trace.error(46, s);
            }
            sToken = c.getString();
        }
        boolean nullable = true;
        if (sToken.equals("NULL")) {
            sToken = c.getString();
        } else if (sToken.equals("NOT")) {
            c.getThis("NULL");
            nullable = false;
            sToken = c.getString();
        }
        if (sToken.equals("IDENTITY")) {
            identity = true;
            sToken = c.getString();
            primarykey = true;
        }
        if (sToken.equals("PRIMARY")) {
            c.getThis("KEY");
            primarykey = true;
        } else {
            c.back();
        }
        return new Column(new HsqlName(sColumn, isnamequoted), nullable, iType, iLen, iScale, identity, primarykey, defaultvalue);
    }

    private void processCreateTable(Tokenizer c, Session session, int type) throws SQLException {
        String sToken = c.getName();
        boolean isnamequoted = c.wasQuotedIdentifier();
        if (DatabaseInformation.isSystemTable(sToken) || this.findUserTable(sToken, session) != null) {
            throw Trace.error(21, sToken);
        }
        Table t = type == 4 || type == 5 ? new TextTable(this, new HsqlName(sToken, isnamequoted), type, session) : new Table(this, new HsqlName(sToken, isnamequoted), type, session);
        c.getThis("(");
        int[] primarykeycolumn = null;
        int column = 0;
        boolean constraint = false;
        while (true) {
            sToken = c.getString();
            isnamequoted = c.wasQuotedIdentifier();
            if (sToken.equals("CONSTRAINT") || sToken.equals("PRIMARY") || sToken.equals("FOREIGN") || sToken.equals("UNIQUE")) {
                c.back();
                constraint = true;
                break;
            }
            c.back();
            Column newcolumn = this.processCreateColumn(c, t);
            t.addColumn(newcolumn);
            if (newcolumn.isPrimaryKey()) {
                Trace.check(primarykeycolumn == null, 24, "column " + column);
                primarykeycolumn = new int[]{column};
            }
            if ((sToken = c.getString()).equals(")")) break;
            if (!sToken.equals(",")) {
                throw Trace.error(11, sToken);
            }
            ++column;
        }
        try {
            HsqlName pkName;
            TempConstraint tempConst;
            Vector<TempConstraint> tempConstraints;
            block20: {
                tempConstraints = new Vector<TempConstraint>();
                tempConst = new TempConstraint(null, primarykeycolumn, null, null, 1, false);
                pkName = null;
                tempConstraints.addElement(tempConst);
                if (constraint) {
                    int i = 0;
                    do {
                        int[] col;
                        sToken = c.getString();
                        HsqlName cname = null;
                        ++i;
                        if (sToken.equals("CONSTRAINT")) {
                            cname = new HsqlName(c.getName(), c.wasQuotedIdentifier());
                            sToken = c.getString();
                        }
                        if (sToken.equals("PRIMARY")) {
                            c.getThis("KEY");
                            pkName = cname;
                            col = this.processColumnList(c, t);
                            TempConstraint mainConst = (TempConstraint)tempConstraints.elementAt(0);
                            Trace.check(mainConst.localCol == null, 24);
                            mainConst.localCol = col;
                        } else if (sToken.equals("UNIQUE")) {
                            col = this.processColumnList(c, t);
                            if (cname == null) {
                                cname = HsqlName.makeAutoName("CT");
                            }
                            tempConst = new TempConstraint(cname, col, null, null, 2, false);
                            tempConstraints.addElement(tempConst);
                        } else if (sToken.equals("FOREIGN")) {
                            c.getThis("KEY");
                            tempConst = this.processCreateFK(c, session, t, cname);
                            if (tempConst.expCol == null) {
                                TempConstraint mainConst = (TempConstraint)tempConstraints.elementAt(0);
                                tempConst.expCol = mainConst.localCol;
                                if (tempConst.expCol == null) {
                                    throw Trace.error(26, "table has no primary key");
                                }
                            }
                            t.checkColumnsMatch(tempConst.localCol, tempConst.expTable, tempConst.expCol);
                            tempConstraints.addElement(tempConst);
                        }
                        sToken = c.getString();
                        if (sToken.equals(")")) break block20;
                    } while (sToken.equals(","));
                    throw Trace.error(11, sToken);
                }
            }
            session.commit();
            tempConst = (TempConstraint)tempConstraints.elementAt(0);
            t.createPrimaryKey(pkName, tempConst.localCol);
            boolean logDDL = false;
            for (int i = 1; i < tempConstraints.size(); ++i) {
                TableWorks tw;
                tempConst = (TempConstraint)tempConstraints.elementAt(i);
                if (tempConst.type == 2) {
                    tw = new TableWorks(t);
                    tw.createUniqueConstraint(tempConst.localCol, tempConst.name);
                    t = tw.getTable();
                }
                if (tempConst.type != 0) continue;
                tw = new TableWorks(t);
                tw.createForeignKey(tempConst.localCol, tempConst.expCol, tempConst.name, tempConst.expTable, tempConst.cascade);
                t = tw.getTable();
            }
            this.linkTable(t);
        }
        catch (SQLException e) {
            this.removeExportedKeys(t);
            throw e;
        }
    }

    TempConstraint processCreateFK(Tokenizer c, Session session, Table t, HsqlName cname) throws SQLException {
        int[] localcol = this.processColumnList(c, t);
        c.getThis("REFERENCES");
        String expTableName = c.getString();
        Table expTable = t.equals(expTableName) ? t : this.getTable(expTableName, session);
        int[] expcol = null;
        String sToken = c.getString();
        c.back();
        if (sToken.equals("(")) {
            expcol = this.processColumnList(c, expTable);
        } else {
            Index expIndex = expTable.getPrimaryIndex();
            if (expIndex != null && (expcol = expIndex.getColumns())[0] == expTable.getColumnCount()) {
                throw Trace.error(26, expTableName + " has no primary key");
            }
        }
        sToken = c.getString();
        boolean cascade = false;
        if (sToken.equals("ON")) {
            c.getThis("DELETE");
            c.getThis("CASCADE");
            cascade = true;
        } else {
            c.back();
        }
        if (cname == null) {
            cname = HsqlName.makeAutoName("FK");
        }
        return new TempConstraint(cname, localcol, expTable, expcol, 0, cascade);
    }

    private void processCreateView(Tokenizer c, Session session) throws SQLException {
        String sToken = c.getName();
        int logposition = c.getPartMarker();
        if (this.findUserTable(sToken, session) != null) {
            throw Trace.error(52, sToken);
        }
        View v = new View(this, new HsqlName(sToken, c.wasQuotedIdentifier()));
        c.getThis("AS");
        c.setPartMarker();
        c.getThis("SELECT");
        Parser p = new Parser(this, c, session);
        int maxRows = session.getMaxRows();
        Select select = p.parseSelect();
        if (select.sIntoTable != null) {
            throw Trace.error(22);
        }
        select.setPreProcess();
        Result rResult = select.getResult(1);
        v.setStatement(c.getLastPart());
        v.addColumns(rResult);
        session.commit();
        this.tTable.addElement(v);
        c.setPartMarker(logposition);
    }

    private void processRenameTable(Tokenizer c, Session session, String tablename) throws SQLException {
        String newname = c.getName();
        boolean isquoted = c.wasQuotedIdentifier();
        Table t = this.findUserTable(tablename);
        if (t == null || !t.equals(tablename, session)) {
            throw Trace.error(22, tablename);
        }
        Table ttemp = this.findUserTable(newname);
        if (ttemp != null && ttemp.equals(ttemp.getName().name, session)) {
            throw Trace.error(21, tablename);
        }
        session.commit();
        session.setScripting(!t.isTemp());
        t.setName(newname, isquoted);
    }

    private Result processAlter(Tokenizer c, Session session) throws SQLException {
        session.checkReadWrite();
        session.checkAdmin();
        session.setScripting(true);
        String sToken = c.getString();
        if (sToken.equals("TABLE")) {
            this.processAlterTable(c, session);
        } else if (sToken.equals("INDEX")) {
            this.processAlterIndex(c, session);
        } else {
            throw Trace.error(11, sToken);
        }
        return new Result();
    }

    private void processAlterTable(Tokenizer c, Session session) throws SQLException {
        String tablename = c.getString();
        Table t = this.getUserTable(tablename, session);
        TableWorks tw = new TableWorks(t);
        String sToken = c.getString();
        session.setScripting(!t.isTemp());
        if (sToken.equals("RENAME")) {
            c.getThis("TO");
            this.processRenameTable(c, session, tablename);
            return;
        }
        if (sToken.equals("ADD")) {
            sToken = c.getString();
            if (sToken.equals("CONSTRAINT")) {
                HsqlName cname = new HsqlName(c.getName(), c.wasQuotedIdentifier());
                sToken = c.getString();
                if (sToken.equals("FOREIGN")) {
                    c.getThis("KEY");
                    TempConstraint tc = this.processCreateFK(c, session, t, cname);
                    t.checkColumnsMatch(tc.localCol, tc.expTable, tc.expCol);
                    session.commit();
                    tw.createForeignKey(tc.localCol, tc.expCol, tc.name, tc.expTable, tc.cascade);
                    return;
                }
                if (sToken.equals("UNIQUE")) {
                    int[] col = this.processColumnList(c, t);
                    session.commit();
                    tw.createUniqueConstraint(col, cname);
                    return;
                }
                throw Trace.error(11, sToken);
            }
            if (sToken.equals("COLUMN")) {
                int colindex = t.getColumnCount();
                Column column = this.processCreateColumn(c, t);
                sToken = c.getString();
                if (sToken.equals("BEFORE")) {
                    sToken = c.getName();
                    colindex = t.getColumnNr(sToken);
                } else {
                    c.back();
                }
                if (column.isIdentity() || column.isPrimaryKey() || !t.isEmpty() && !column.isNullable() && column.getDefaultString() == null) {
                    throw Trace.error(58);
                }
                session.commit();
                tw.addOrDropColumn(column, colindex, 1);
                return;
            }
        } else {
            if (sToken.equals("DROP")) {
                sToken = c.getString();
                if (sToken.equals("CONSTRAINT")) {
                    String cname = c.getName();
                    session.commit();
                    tw.dropConstraint(cname);
                    return;
                }
                if (sToken.equals("COLUMN")) {
                    sToken = c.getName();
                    int colindex = t.getColumnNr(sToken);
                    session.commit();
                    tw.addOrDropColumn(null, colindex, -1);
                    return;
                }
                throw Trace.error(11, sToken);
            }
            throw Trace.error(11, sToken);
        }
    }

    private void processAlterIndex(Tokenizer c, Session session) throws SQLException {
        String indexname = c.getName();
        c.getThis("RENAME");
        c.getThis("TO");
        String newname = c.getName();
        boolean isQuoted = c.wasQuotedIdentifier();
        Table t = this.findTableForIndex(indexname);
        if (t == null || !t.equals(t.getName().name, session)) {
            throw Trace.error(26, indexname);
        }
        Table ttemp = this.findTableForIndex(newname);
        if (ttemp != null && ttemp.equals(ttemp.getName().name, session)) {
            throw Trace.error(23, indexname);
        }
        if (HsqlName.isReservedName(indexname)) {
            throw Trace.error(56, indexname);
        }
        if (HsqlName.isReservedName(newname)) {
            throw Trace.error(49, indexname);
        }
        session.setScripting(!t.isTemp());
        session.commit();
        t.getIndex(indexname).setName(newname, isQuoted);
    }

    private Result processDrop(Tokenizer c, Session session) throws SQLException {
        session.checkReadWrite();
        session.checkAdmin();
        session.setScripting(true);
        String sToken = c.getString();
        if (sToken.equals("TABLE") || sToken.equals("VIEW")) {
            boolean isview = sToken.equals("VIEW");
            String tablename = c.getString();
            boolean dropmode = false;
            sToken = c.getString();
            if (sToken.equals("IF")) {
                c.getThis("EXISTS");
                dropmode = true;
            } else {
                c.back();
                Table t = this.getTable(tablename, session);
                session.setScripting(!t.isTemp());
            }
            this.dropTable(tablename, dropmode, isview, session);
            session.commit();
        } else if (sToken.equals("USER")) {
            this.aAccess.dropUser(c.getStringToken());
        } else if (sToken.equals("TRIGGER")) {
            this.dropTrigger(c.getString(), session);
        } else if (sToken.equals("INDEX")) {
            String indexname = c.getName();
            Table t = this.findTableForIndex(indexname);
            if (t == null || !t.equals(t.getName().name, session)) {
                throw Trace.error(26, indexname);
            }
            t.checkDropIndex(indexname, null);
            session.commit();
            session.setScripting(!t.isTemp());
            TableWorks tw = new TableWorks(t);
            tw.dropIndex(indexname);
        } else {
            throw Trace.error(11, sToken);
        }
        return new Result();
    }

    private Result processGrantOrRevoke(Tokenizer c, Session session, boolean grant) throws SQLException {
        String sToken;
        session.checkReadWrite();
        session.checkAdmin();
        session.setScripting(true);
        int right = 0;
        do {
            String sRight = c.getString();
            right |= UserManager.getRight(sRight);
        } while ((sToken = c.getString()).equals(","));
        if (!sToken.equals("ON")) {
            throw Trace.error(11, sToken);
        }
        String table = c.getString();
        if (table.equals("CLASS")) {
            table = table + " \"" + c.getString() + "\"";
        } else {
            Table t = this.getTable(table, session);
            session.setScripting(!t.isTemp());
        }
        c.getThis("TO");
        String user = c.getStringToken();
        if (grant) {
            this.aAccess.grant(user, table, right);
            String command = "GRANT";
        } else {
            this.aAccess.revoke(user, table, right);
            String command = "REVOKE";
        }
        return new Result();
    }

    private Result processConnect(Tokenizer c, Session session) throws SQLException {
        c.getThis("USER");
        String username = c.getStringToken();
        c.getThis("PASSWORD");
        String password = c.getStringToken();
        User user = this.aAccess.getUser(username, password);
        session.commit();
        session.setUser(user);
        return new Result();
    }

    private Result processDisconnect(Session session) throws SQLException {
        if (!session.isClosed()) {
            session.disconnect();
            this.cSession.setElementAt(null, session.getId());
        }
        return new Result();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Result processSet(Tokenizer c, Session session) throws SQLException {
        session.setScripting(true);
        String sToken = c.getString();
        if (sToken.equals("PASSWORD")) {
            session.checkReadWrite();
            session.setPassword(c.getStringToken());
            return new Result();
        } else if (sToken.equals("READONLY")) {
            session.commit();
            session.setReadOnly(this.processTrueOrFalse(c));
            return new Result();
        } else if (sToken.equals("LOGSIZE")) {
            session.checkAdmin();
            int i = Integer.parseInt(c.getString());
            this.logger.setLogSize(i);
            return new Result();
        } else if (sToken.equals("IGNORECASE")) {
            session.checkAdmin();
            this.bIgnoreCase = this.processTrueOrFalse(c);
            return new Result();
        } else if (sToken.equals("MAXROWS")) {
            int i = Integer.parseInt(c.getString());
            session.setMaxRows(i);
            return new Result();
        } else if (sToken.equals("AUTOCOMMIT")) {
            session.setAutoCommit(this.processTrueOrFalse(c));
            return new Result();
        } else if (sToken.equals("TABLE")) {
            session.checkReadWrite();
            Table t = this.getTable(c.getString(), session);
            sToken = c.getString();
            session.setScripting(!t.isTemp());
            if (sToken.equals("SOURCE")) {
                if (!t.isTemp()) {
                    session.checkAdmin();
                }
                sToken = c.getString();
                if (!c.wasQuotedIdentifier()) {
                    throw Trace.error(7);
                }
                boolean isDesc = false;
                if (c.getString().equals("DESC")) {
                    isDesc = true;
                } else {
                    c.back();
                }
                t.setDataSource(sToken, isDesc, session);
                return new Result();
            } else if (sToken.equals("READONLY")) {
                session.checkAdmin();
                t.setDataReadOnly(this.processTrueOrFalse(c));
                return new Result();
            } else {
                if (!sToken.equals("INDEX")) throw Trace.error(11, sToken);
                session.checkAdmin();
                c.getString();
                t.setIndexRoots((String)c.getAsValue());
            }
            return new Result();
        } else if (sToken.equals("REFERENTIAL_INTEGRITY")) {
            session.checkAdmin();
            this.bReferentialIntegrity = this.processTrueOrFalse(c);
            return new Result();
        } else {
            if (!sToken.equals("WRITE_DELAY")) throw Trace.error(11, sToken);
            session.checkAdmin();
            boolean delay = this.processTrueOrFalse(c);
            this.logger.setWriteDelay(delay);
        }
        return new Result();
    }

    private boolean processTrueOrFalse(Tokenizer c) throws SQLException {
        String sToken = c.getString();
        if (sToken.equals("TRUE")) {
            return true;
        }
        if (sToken.equals("FALSE")) {
            return false;
        }
        throw Trace.error(11, sToken);
    }

    private Result processCommit(Tokenizer c, Session session) throws SQLException {
        String sToken = c.getString();
        if (!sToken.equals("WORK")) {
            c.back();
        }
        session.commit();
        return new Result();
    }

    private Result processRollback(Tokenizer c, Session session) throws SQLException {
        String sToken = c.getString();
        if (sToken.equals("TO")) {
            String sToken1 = c.getString();
            if (!sToken1.equals("SAVEPOINT")) {
                throw Trace.error(11, sToken1);
            }
            sToken1 = c.getString();
            if (sToken1.length() == 0) {
                throw Trace.error(11, sToken1);
            }
            session.rollbackToSavepoint(sToken1);
            return new Result();
        }
        if (!sToken.equals("WORK")) {
            c.back();
        }
        session.rollback();
        return new Result();
    }

    private Result processSavepoint(Tokenizer c, Session session) throws SQLException {
        String sToken = c.getString();
        if (sToken.length() == 0) {
            throw Trace.error(11, sToken);
        }
        session.savepoint(sToken);
        return new Result();
    }

    public void finalize() {
        try {
            this.close(-1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void close(int closemode) throws SQLException {
        this.logger.closeLog(closemode);
        if (closemode == 1) {
            this.open();
            this.logger.closeLog(0);
        }
        this.bShutdown = true;
        jdbcConnection.removeDatabase(this);
    }

    private Result processShutdown(Tokenizer c, Session session) throws SQLException {
        if (!session.isClosed()) {
            session.checkAdmin();
        }
        int closemode = 0;
        String token = c.getString();
        if (token.equals("IMMEDIATELY")) {
            closemode = -1;
        } else if (token.equals("COMPACT")) {
            closemode = 1;
        } else {
            c.back();
        }
        int tsize = this.cSession.size();
        for (int i = 1; i < tsize; ++i) {
            Session d = (Session)this.cSession.elementAt(i);
            if (d == null) continue;
            d.disconnect();
        }
        this.cSession.removeAllElements();
        this.close(closemode);
        this.processDisconnect(session);
        return new Result();
    }

    private Result processCheckpoint(Session session) throws SQLException {
        session.checkAdmin();
        session.checkReadWrite();
        this.logger.checkpoint();
        return new Result();
    }

    void dropTempTables(Session ownerSession) {
        for (int i = 0; i < this.tTable.size(); ++i) {
            Table toDrop = (Table)this.tTable.elementAt(i);
            if (!toDrop.isTemp() || toDrop.getOwnerSession() != ownerSession) continue;
            this.tTable.removeElementAt(i);
        }
    }

    void dropTable(String name, boolean ifExists, boolean isView, Session session) throws SQLException {
        Table toDrop = null;
        int dropIndex = -1;
        int refererIndex = -1;
        Enumeration constraints = null;
        Constraint currentConstraint = null;
        Table refTable = null;
        boolean isRef = false;
        boolean isSelfRef = false;
        for (int i = 0; i < this.tTable.size(); ++i) {
            toDrop = (Table)this.tTable.elementAt(i);
            if (toDrop.equals(name, session) && isView == toDrop.isView()) {
                dropIndex = i;
                break;
            }
            toDrop = null;
        }
        if (dropIndex == -1) {
            if (ifExists) {
                return;
            }
            throw Trace.error(isView ? 53 : 22, name);
        }
        constraints = toDrop.getConstraints().elements();
        while (constraints.hasMoreElements()) {
            currentConstraint = (Constraint)constraints.nextElement();
            if (currentConstraint.getType() != 1) continue;
            refTable = currentConstraint.getRef();
            isRef = refTable != null;
            boolean bl = isSelfRef = isRef && toDrop.equals(refTable);
            if (!isRef || isSelfRef) continue;
            for (int k = 0; k < this.tTable.size(); ++k) {
                if (!refTable.equals(this.tTable.elementAt(k))) continue;
                refererIndex = k;
                break;
            }
            if (refererIndex == -1) continue;
            throw Trace.error(8, currentConstraint.getName().name + " table: " + refTable.getName().name);
        }
        if (toDrop.isText()) {
            toDrop.setDataSource("", false, session);
        }
        this.tTable.removeElementAt(dropIndex);
        this.removeExportedKeys(toDrop);
    }

    void removeExportedKeys(Table toDrop) {
        for (int i = 0; i < this.tTable.size(); ++i) {
            Vector constraintvector = ((Table)this.tTable.elementAt(i)).getConstraints();
            for (int j = constraintvector.size() - 1; j >= 0; --j) {
                Constraint currentConstraint = (Constraint)constraintvector.elementAt(j);
                Table refTable = currentConstraint.getRef();
                if (toDrop != refTable) continue;
                constraintvector.removeElementAt(j);
            }
        }
    }

    private void dropTrigger(String name, Session session) throws SQLException {
        boolean found = false;
        int tsize = this.tTable.size();
        for (int i = 0; i < tsize; ++i) {
            Table t = (Table)this.tTable.elementAt(i);
            int numTrigs = TriggerDef.numTrigs();
            for (int tv = 0; tv < numTrigs; ++tv) {
                Vector v = t.vTrigs[tv];
                for (int tr = v.size() - 1; tr >= 0; --tr) {
                    TriggerDef td = (TriggerDef)v.elementAt(tr);
                    if (!td.name.equals(name)) continue;
                    session.setScripting(!td.table.isTemp());
                    v.removeElementAt(tr);
                    found = true;
                    if (!Trace.TRACE) continue;
                    Trace.trace("Trigger dropped " + name);
                }
            }
        }
        Trace.check(found, 43, name);
    }

    static {
        hCommands.put("ALTER", new Integer(20));
        hCommands.put("CALL", new Integer(1));
        hCommands.put("CHECKPOINT", new Integer(2));
        hCommands.put("COMMIT", new Integer(3));
        hCommands.put("CONNECT", new Integer(4));
        hCommands.put("CREATE", new Integer(5));
        hCommands.put("DELETE", new Integer(6));
        hCommands.put("DISCONNECT", new Integer(7));
        hCommands.put("DROP", new Integer(8));
        hCommands.put("GRANT", new Integer(9));
        hCommands.put("INSERT", new Integer(10));
        hCommands.put("REVOKE", new Integer(11));
        hCommands.put("ROLLBACK", new Integer(12));
        hCommands.put("SAVEPOINT", new Integer(13));
        hCommands.put("SCRIPT", new Integer(14));
        hCommands.put("SELECT", new Integer(15));
        hCommands.put("SET", new Integer(16));
        hCommands.put("SHUTDOWN", new Integer(17));
        hCommands.put("UPDATE", new Integer(18));
        hCommands.put(";", new Integer(19));
    }

    class Logger {
        private Log lLog;

        Logger() {
        }

        boolean openLog(Database db, Session sys, String name) throws SQLException {
            this.lLog = new Log(db, sys, name);
            boolean result = this.lLog.open();
            return result;
        }

        void closeLog(int closemode) throws SQLException {
            if (this.lLog == null) {
                return;
            }
            this.lLog.stop();
            switch (closemode) {
                case -1: {
                    this.lLog.shutdown();
                    break;
                }
                case 0: {
                    this.lLog.close(false);
                    break;
                }
                case 1: {
                    this.lLog.close(true);
                }
            }
            this.lLog = null;
        }

        boolean hasLog() {
            return this.lLog != null;
        }

        Cache getCache() throws SQLException {
            if (this.lLog != null) {
                return this.lLog.getCache();
            }
            return null;
        }

        void cleanUp() throws SQLException {
            if (this.lLog != null && this.lLog.getCache() != null) {
                this.lLog.getCache().cleanUp();
            }
        }

        void logConnectUser(Session session, String username, String password) throws SQLException {
            if (this.lLog != null) {
                this.lLog.write(session, "CONNECT USER " + username + " PASSWORD \"" + password + "\"");
            }
        }

        void writeToLog(Session session, String statement) throws SQLException {
            if (this.lLog != null) {
                this.lLog.write(session, statement);
            }
        }

        private void checkpoint() throws SQLException {
            if (this.lLog != null) {
                this.lLog.checkpoint();
            }
        }

        void setLogSize(int i) {
            if (this.lLog != null) {
                this.lLog.setLogSize(i);
            }
        }

        void setWriteDelay(boolean delay) {
            if (this.lLog != null) {
                this.lLog.setWriteDelay(delay);
            }
        }

        Cache openTextCache(String table, String source, boolean readOnlyData, boolean reversed) throws SQLException {
            return this.lLog.openTextCache(table, source, readOnlyData, reversed);
        }

        void closeTextCache(String name) throws SQLException {
            this.lLog.closeTextCache(name);
        }
    }

    private class TempConstraint {
        HsqlName name;
        int[] localCol;
        Table expTable;
        int[] expCol;
        int type;
        boolean cascade;

        TempConstraint(HsqlName name, int[] localCol, Table expTable, int[] expCol, int type, boolean cascade) {
            this.name = name;
            this.type = type;
            this.localCol = localCol;
            this.expTable = expTable;
            this.expCol = expCol;
            this.cascade = cascade;
        }
    }
}

