/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

class DatabaseFile
extends RandomAccessFile {
    protected byte[] in;
    protected long pos;
    protected int index;
    protected int count;

    DatabaseFile(String name, String mode, int inSize) throws FileNotFoundException, IOException {
        super(name, mode);
        this.in = new byte[inSize];
    }

    protected void realSeek(long newPos) throws IOException {
        super.seek(newPos);
    }

    @Override
    public void seek(long newPos) throws IOException {
        super.seek(newPos);
        this.pos = newPos;
        this.count = 0;
        this.index = 0;
    }

    public void readSeek(long newPos) throws IOException {
        if (this.in == null) {
            this.seek(newPos);
        } else if (newPos != this.pos) {
            this.index += (int)(newPos - this.pos);
            if (this.index < 0 || this.index > this.count) {
                this.seek(newPos);
            } else {
                this.pos = newPos;
            }
        }
    }

    @Override
    public int read() throws IOException {
        if (this.in == null) {
            return super.read();
        }
        if (this.index == this.count) {
            this.index = 0;
            this.count = super.read(this.in);
            if (this.count == -1) {
                this.count = 0;
            }
        }
        if (this.index == this.count) {
            return -1;
        }
        ++this.pos;
        return this.in[this.index++] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int i;
        for (i = 0; i < b.length; ++i) {
            int next = this.read();
            if (next == -1) {
                return -1;
            }
            b[i] = (byte)next;
        }
        return i;
    }

    public int readInteger() throws IOException {
        int ret = 0;
        for (int i = 0; i < 4; ++i) {
            int next = this.read();
            if (next == -1) {
                throw new EOFException();
            }
            ret <<= 8;
            ret += next & 0xFF;
        }
        return ret;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.count = 0;
        this.index = 0;
        this.pos += (long)b.length;
        super.write(b);
    }

    public void writeInteger(int i) throws IOException {
        this.count = 0;
        this.index = 0;
        this.pos += 4L;
        this.writeInt(i);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.in = null;
    }
}

