/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.DatabaseRowOutputInterface;
import com.kingdee.eas.cp.hsqldb.Table;
import com.kingdee.eas.cp.hsqldb.Trace;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

abstract class DatabaseRowOutput
extends DataOutputStream
implements DatabaseRowOutputInterface {
    protected boolean skipSystemId = false;

    public DatabaseRowOutput(OutputStream out) throws IOException {
        super(out);
    }

    @Override
    public abstract void writePos(int var1) throws IOException;

    @Override
    public abstract void writeSize(int var1) throws IOException;

    @Override
    public abstract void writeType(int var1) throws IOException;

    @Override
    public abstract void writeIntData(int var1) throws IOException;

    @Override
    public abstract void writeString(String var1) throws IOException;

    protected abstract void writeFieldType(int var1) throws IOException;

    protected abstract void writeNull(int var1) throws IOException;

    protected abstract void writeChar(String var1, int var2) throws IOException;

    protected abstract void writeSmallint(Number var1) throws IOException, SQLException;

    protected abstract void writeInteger(Number var1) throws IOException, SQLException;

    protected abstract void writeBigint(Number var1) throws IOException, SQLException;

    protected abstract void writeReal(Double var1, int var2) throws IOException, SQLException;

    protected abstract void writeDecimal(BigDecimal var1) throws IOException, SQLException;

    protected abstract void writeBit(Boolean var1) throws IOException, SQLException;

    protected abstract void writeDate(Date var1) throws IOException, SQLException;

    protected abstract void writeTime(Time var1) throws IOException, SQLException;

    protected abstract void writeTimestamp(Timestamp var1) throws IOException, SQLException;

    protected abstract void writeOther(Object var1) throws IOException, SQLException;

    protected abstract void writeBinary(byte[] var1, int var2) throws IOException, SQLException;

    @Override
    public void writeData(Object[] data, Table t) throws IOException, SQLException {
        int[] types = t.getColumnTypes();
        int l = types.length;
        if (this.skipSystemId) {
            --l;
        }
        this.writeData(l, types, data);
    }

    @Override
    public void writeData(int l, int[] types, Object[] data) throws IOException, SQLException {
        block14: for (int i = 0; i < l; ++i) {
            Object o = data[i];
            int t = types[i];
            if (o == null) {
                this.writeNull(t);
                continue;
            }
            this.writeFieldType(t);
            switch (t) {
                case -1: 
                case 1: 
                case 12: 
                case 100: {
                    this.writeChar((String)o, t);
                    continue block14;
                }
                case -6: 
                case 5: {
                    this.writeSmallint((Number)o);
                    continue block14;
                }
                case 4: {
                    this.writeInteger((Number)o);
                    continue block14;
                }
                case -5: {
                    this.writeBigint((Number)o);
                    continue block14;
                }
                case 6: 
                case 7: 
                case 8: {
                    this.writeReal((Double)o, t);
                    continue block14;
                }
                case 2: 
                case 3: {
                    this.writeDecimal((BigDecimal)o);
                    continue block14;
                }
                case -7: {
                    this.writeBit((Boolean)o);
                    continue block14;
                }
                case 91: {
                    this.writeDate((Date)o);
                    continue block14;
                }
                case 92: {
                    this.writeTime((Time)o);
                    continue block14;
                }
                case 93: {
                    this.writeTimestamp((Timestamp)o);
                    continue block14;
                }
                case 1111: {
                    this.writeOther(o);
                    continue block14;
                }
                case -4: 
                case -3: 
                case -2: {
                    this.writeBinary((byte[])o, t);
                    continue block14;
                }
                default: {
                    throw Trace.error(20, t);
                }
            }
        }
    }
}

