/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.CachedRow;
import com.kingdee.eas.cp.hsqldb.DatabaseRowInputInterface;
import com.kingdee.eas.cp.hsqldb.DatabaseRowOutputInterface;
import com.kingdee.eas.cp.hsqldb.Node;
import com.kingdee.eas.cp.hsqldb.Row;
import com.kingdee.eas.cp.hsqldb.Table;
import com.kingdee.eas.cp.hsqldb.Trace;
import java.io.IOException;
import java.sql.SQLException;

class DiskNode
extends Node {
    private int iLeft = -1;
    private int iRight = -1;
    private int iParent = -1;
    private int iId;
    private int iData = -1;
    private Table tTable;

    DiskNode(CachedRow r, DatabaseRowInputInterface in, int id) throws IOException, SQLException {
        this.iId = id;
        this.tTable = r.getTable();
        this.rData = r;
        this.iData = r.iPos;
        this.iBalance = in.readIntData();
        this.iLeft = in.readIntData();
        if (this.iLeft <= 0) {
            this.iLeft = -1;
        }
        this.iRight = in.readIntData();
        if (this.iRight <= 0) {
            this.iRight = -1;
        }
        this.iParent = in.readIntData();
        if (this.iParent <= 0) {
            this.iParent = -1;
        }
    }

    DiskNode(CachedRow r, int id) {
        this.iId = id;
        this.tTable = r.getTable();
        if (r.iPos == -1) {
            this.rData = r;
        } else {
            this.iData = r.iPos;
        }
    }

    @Override
    void delete() {
        this.iBalance = -2;
        this.iParent = 0;
        this.iRight = 0;
        this.iLeft = 0;
        this.tTable = null;
    }

    @Override
    int getKey() {
        if (this.rData != null) {
            return ((CachedRow)this.rData).iPos;
        }
        return this.iData;
    }

    @Override
    void setKey(int pos) {
        this.iData = pos;
        this.rData = null;
    }

    @Override
    Row getRow() throws SQLException {
        if (this.rData != null) {
            return this.rData;
        }
        if (this.iData == -1) {
            return null;
        }
        return this.tTable.getRow(this.iData);
    }

    private Node findNode(int pos, int id) throws SQLException {
        Node ret = null;
        Row r = this.tTable.getRow(pos);
        if (r != null) {
            ret = r.getNode(id);
        }
        return ret;
    }

    @Override
    Node getLeft() throws SQLException {
        if (this.iLeft == -1) {
            return null;
        }
        return this.findNode(this.iLeft, this.iId);
    }

    @Override
    void setLeft(Node n) throws SQLException {
        ((CachedRow)this.getRow()).changed();
        this.iLeft = -1;
        if (n != null) {
            this.iLeft = n.getKey();
        }
    }

    @Override
    Node getRight() throws SQLException {
        if (this.iRight == -1) {
            return null;
        }
        return this.findNode(this.iRight, this.iId);
    }

    @Override
    Node getRightPointer() throws SQLException {
        throw Trace.error(40, "wrong method access");
    }

    @Override
    void setRight(Node n) throws SQLException {
        ((CachedRow)this.getRow()).changed();
        this.iRight = -1;
        if (n != null) {
            this.iRight = n.getKey();
        }
    }

    @Override
    Node getParent() throws SQLException {
        if (this.iParent == -1) {
            return null;
        }
        return this.findNode(this.iParent, this.iId);
    }

    @Override
    boolean isRoot() {
        return this.iParent == -1;
    }

    @Override
    void setParent(Node n) throws SQLException {
        ((CachedRow)this.getRow()).changed();
        this.iParent = -1;
        if (n != null) {
            this.iParent = n.getKey();
        }
    }

    @Override
    void setBalance(int b) throws SQLException {
        if (this.iBalance != b) {
            ((CachedRow)this.getRow()).changed();
            this.iBalance = b;
        }
    }

    @Override
    boolean from() throws SQLException {
        if (this.isRoot()) {
            return true;
        }
        DiskNode parent = (DiskNode)this.getParent();
        if (parent.iLeft != -1) {
            return this.getKey() == parent.iLeft;
        }
        return this.equals(parent.getLeft());
    }

    @Override
    Object[] getData() throws SQLException {
        return this.getRow().getData();
    }

    @Override
    boolean equals(Node n) throws SQLException {
        return n == this;
    }

    @Override
    void write(DatabaseRowOutputInterface out) throws IOException, SQLException {
        out.writeIntData(this.iBalance);
        out.writeIntData(this.iLeft == -1 ? 0 : this.iLeft);
        out.writeIntData(this.iRight == -1 ? 0 : this.iRight);
        out.writeIntData(this.iParent == -1 ? 0 : this.iParent);
    }
}

