/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.StringConverter;

class HsqlName {
    String name;
    boolean isNameQuoted;
    String statementName;
    static int sysNumber = 0;

    public HsqlName(String name, boolean isquoted) {
        this.rename(name, isquoted);
    }

    public HsqlName(String prefix, String name, boolean isquoted) {
        this.rename(prefix, name, isquoted);
    }

    public static HsqlName makeAutoName(String type) {
        StringBuffer sbname = new StringBuffer();
        sbname.append("SYS_");
        sbname.append(type);
        sbname.append('_');
        sbname.append(++sysNumber);
        return new HsqlName(sbname.toString(), false);
    }

    public static HsqlName makeAutoName(String type, String namepart) {
        StringBuffer sbname = new StringBuffer();
        sbname.append("SYS_");
        sbname.append(type);
        sbname.append('_');
        sbname.append(namepart);
        sbname.append('_');
        sbname.append(++sysNumber);
        return new HsqlName(sbname.toString(), false);
    }

    public void rename(String name, boolean isquoted) {
        this.name = name;
        this.statementName = name;
        this.isNameQuoted = isquoted;
        if (name == null) {
            return;
        }
        if (this.isNameQuoted) {
            this.statementName = StringConverter.toQuotedString(name, '\"', true);
        }
        if (name.startsWith("SYS_")) {
            int index = name.lastIndexOf(95) + 1;
            try {
                int temp = Integer.parseInt(name.substring(index));
                if (temp > sysNumber) {
                    sysNumber = temp;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void rename(String prefix, String name, boolean isquoted) {
        StringBuffer sbname = new StringBuffer(prefix);
        sbname.append('_');
        sbname.append(name);
        this.rename(sbname.toString(), isquoted);
    }

    public boolean equals(HsqlName other) {
        return this.name.equals(other.name) && this.isNameQuoted == other.isNameQuoted;
    }

    public static boolean isReservedName(String name) {
        return name.startsWith("SYS_IDX_") || name.startsWith("SYS_PK_") || name.startsWith("SYS_REF_");
    }

    public boolean isReservedName() {
        return HsqlName.isReservedName(this.name);
    }
}

