/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Properties;

public class HsqlProperties {
    protected String fileName;
    protected Properties stringProps;

    public HsqlProperties() {
        this.stringProps = new Properties();
        this.fileName = null;
    }

    public HsqlProperties(String name) {
        this.stringProps = new Properties();
        this.fileName = name;
    }

    public HsqlProperties(Properties props) {
        this.stringProps = props;
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public String setProperty(String key, int value) {
        return (String)this.stringProps.put(key, Integer.toString(value));
    }

    public String setProperty(String key, boolean value) {
        return (String)this.stringProps.put(key, String.valueOf(value));
    }

    public String setProperty(String key, String value) {
        return (String)this.stringProps.put(key, value);
    }

    public String setPropertyIfNotExists(String key, String value) {
        value = this.stringProps.getProperty(key, value);
        return (String)this.stringProps.put(key, value);
    }

    public String getProperty(String key) {
        return this.stringProps.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.stringProps.getProperty(key, defaultValue);
    }

    public int getIntegerProperty(String key, int defaultValue) {
        String prop = this.getProperty(key);
        try {
            defaultValue = Integer.parseInt(prop);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    public boolean isPropertyTrue(String key) {
        return this.isPropertyTrue(key, false);
    }

    public boolean isPropertyTrue(String key, boolean defaultValue) {
        String value = this.stringProps.getProperty(key, defaultValue ? "true" : "false");
        return Boolean.valueOf(value);
    }

    public void removeProperty(String key) {
        this.stringProps.remove(key);
    }

    public static HsqlProperties argArrayToProps(String[] arg, String type) {
        HsqlProperties props = new HsqlProperties();
        for (int i = 0; i < arg.length - 1; ++i) {
            String p = arg[i];
            if (p.charAt(0) != '-' || p.startsWith("-?")) continue;
            props.setProperty(type + "." + p.substring(1), arg[i + 1]);
            ++i;
        }
        return props;
    }

    public void addProperties(HsqlProperties props) {
        Enumeration<?> keys = props.stringProps.propertyNames();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            this.stringProps.put(key, props.stringProps.get(key));
        }
    }

    public boolean checkFileExists() {
        if (this.fileName == null || this.fileName.length() == 0) {
            return false;
        }
        return new File(this.fileName + ".properties").exists();
    }

    public void load() throws Exception {
        if (this.fileName == null || this.fileName.length() == 0) {
            throw new FileNotFoundException("properties name is null or empty");
        }
        try (FileInputStream fis = null;){
            File f = new File(this.fileName + ".properties");
            fis = new FileInputStream(f);
            this.stringProps.load(fis);
            fis.close();
        }
    }

    public void save() throws Exception {
        if (this.fileName == null || this.fileName.length() == 0) {
            throw new FileNotFoundException("properties name is null or empty");
        }
        File f = new File(this.fileName + ".properties");
        File parent = f.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(f);
        this.stringProps.store(fos, "HSQL database");
        fos.close();
    }
}

