/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Random;

class Library {
    static final String[][] sNumeric = new String[][]{{"ABS", "com.kingdee.eas.cp.hsqldb.Library.abs"}, {"ACOS", "java.lang.Math.acos"}, {"ASIN", "java.lang.Math.asin"}, {"ATAN", "java.lang.Math.atan"}, {"ATAN2", "java.lang.Math.atan2"}, {"CEILING", "java.lang.Math.ceil"}, {"COS", "java.lang.Math.cos"}, {"COT", "com.kingdee.eas.cp.hsqldb.Library.cot"}, {"DEGREES", "java.lang.Math.toDegrees"}, {"EXP", "java.lang.Math.exp"}, {"FLOOR", "java.lang.Math.floor"}, {"LOG", "java.lang.Math.log"}, {"LOG10", "com.kingdee.eas.cp.hsqldb.Library.log10"}, {"MOD", "com.kingdee.eas.cp.hsqldb.Library.mod"}, {"PI", "com.kingdee.eas.cp.hsqldb.Library.pi"}, {"POWER", "java.lang.Math.pow"}, {"RADIANS", "java.lang.Math.toRadians"}, {"RAND", "java.lang.Math.random"}, {"ROUND", "com.kingdee.eas.cp.hsqldb.Library.round"}, {"SIGN", "com.kingdee.eas.cp.hsqldb.Library.sign"}, {"SIN", "java.lang.Math.sin"}, {"SQRT", "java.lang.Math.sqrt"}, {"TAN", "java.lang.Math.tan"}, {"TRUNCATE", "com.kingdee.eas.cp.hsqldb.Library.truncate"}, {"BITAND", "com.kingdee.eas.cp.hsqldb.Library.bitand"}, {"BITOR", "com.kingdee.eas.cp.hsqldb.Library.bitor"}, {"ROUNDMAGIC", "com.kingdee.eas.cp.hsqldb.Library.roundMagic"}};
    static final String[][] sString = new String[][]{{"ASCII", "com.kingdee.eas.cp.hsqldb.Library.ascii"}, {"CHAR", "com.kingdee.eas.cp.hsqldb.Library.character"}, {"CONCAT", "com.kingdee.eas.cp.hsqldb.Library.concat"}, {"DIFFERENCE", "com.kingdee.eas.cp.hsqldb.Library.difference"}, {"HEXTORAW", "com.kingdee.eas.cp.hsqldb.Library.hexToRaw"}, {"INSERT", "com.kingdee.eas.cp.hsqldb.Library.insert"}, {"LCASE", "com.kingdee.eas.cp.hsqldb.Library.lcase"}, {"LEFT", "com.kingdee.eas.cp.hsqldb.Library.left"}, {"LENGTH", "com.kingdee.eas.cp.hsqldb.Library.length"}, {"LOCATE", "com.kingdee.eas.cp.hsqldb.Library.locate"}, {"LTRIM", "com.kingdee.eas.cp.hsqldb.Library.ltrim"}, {"RAWTOHEX", "com.kingdee.eas.cp.hsqldb.Library.rawToHex"}, {"REPEAT", "com.kingdee.eas.cp.hsqldb.Library.repeat"}, {"REPLACE", "com.kingdee.eas.cp.hsqldb.Library.replace"}, {"RIGHT", "com.kingdee.eas.cp.hsqldb.Library.right"}, {"RTRIM", "com.kingdee.eas.cp.hsqldb.Library.rtrim"}, {"SOUNDEX", "com.kingdee.eas.cp.hsqldb.Library.soundex"}, {"SPACE", "com.kingdee.eas.cp.hsqldb.Library.space"}, {"SUBSTR", "com.kingdee.eas.cp.hsqldb.Library.substring"}, {"SUBSTRING", "com.kingdee.eas.cp.hsqldb.Library.substring"}, {"UCASE", "com.kingdee.eas.cp.hsqldb.Library.ucase"}, {"LOWER", "com.kingdee.eas.cp.hsqldb.Library.lcase"}, {"UPPER", "com.kingdee.eas.cp.hsqldb.Library.ucase"}};
    static final String[][] sTimeDate = new String[][]{{"CURDATE", "com.kingdee.eas.cp.hsqldb.Library.curdate"}, {"CURTIME", "com.kingdee.eas.cp.hsqldb.Library.curtime"}, {"DAYNAME", "com.kingdee.eas.cp.hsqldb.Library.dayname"}, {"DAYOFMONTH", "com.kingdee.eas.cp.hsqldb.Library.dayofmonth"}, {"DAYOFWEEK", "com.kingdee.eas.cp.hsqldb.Library.dayofweek"}, {"DAYOFYEAR", "com.kingdee.eas.cp.hsqldb.Library.dayofyear"}, {"HOUR", "com.kingdee.eas.cp.hsqldb.Library.hour"}, {"MINUTE", "com.kingdee.eas.cp.hsqldb.Library.minute"}, {"MONTH", "com.kingdee.eas.cp.hsqldb.Library.month"}, {"MONTHNAME", "com.kingdee.eas.cp.hsqldb.Library.monthname"}, {"NOW", "com.kingdee.eas.cp.hsqldb.Library.now"}, {"QUARTER", "com.kingdee.eas.cp.hsqldb.Library.quarter"}, {"SECOND", "com.kingdee.eas.cp.hsqldb.Library.second"}, {"WEEK", "com.kingdee.eas.cp.hsqldb.Library.week"}, {"YEAR", "com.kingdee.eas.cp.hsqldb.Library.year"}};
    static final String[][] sSystem = new String[][]{{"DATABASE", "com.kingdee.eas.cp.hsqldb.Library.database"}, {"USER", "com.kingdee.eas.cp.hsqldb.Library.user"}, {"IDENTITY", "com.kingdee.eas.cp.hsqldb.Library.identity"}};
    private static final Random rRandom = new Random();
    private static final double LOG10_FACTOR = 0.4342944819032518;
    private static int sql_month = 0;
    private static boolean sql_month_set = false;

    Library() {
    }

    static void register(Hashtable h) {
        Library.register(h, sNumeric);
        Library.register(h, sString);
        Library.register(h, sTimeDate);
        Library.register(h, sSystem);
    }

    private static void register(Hashtable h, String[][] s) {
        for (int i = 0; i < s.length; ++i) {
            h.put(s[i][0], s[i][1]);
        }
    }

    public static synchronized double rand(Integer i) {
        if (i != null) {
            rRandom.setSeed(i.intValue());
        }
        return rRandom.nextDouble();
    }

    public static double abs(double d) {
        return Math.abs(d);
    }

    public static double log10(double x) {
        return Library.roundMagic(Math.log(x) * 0.4342944819032518);
    }

    public static double roundMagic(double d) {
        if (d < 1.0E-13 && d > -1.0E-13) {
            return 0.0;
        }
        if (d > 1.0E12 || d < -1.0E12) {
            return d;
        }
        StringBuffer s = new StringBuffer();
        s.append(d);
        int len = s.length();
        if (len < 16) {
            return d;
        }
        char cx = s.charAt(len - 1);
        char c1 = s.charAt(len - 2);
        char c2 = s.charAt(len - 3);
        char c3 = s.charAt(len - 4);
        if (c1 == '0' && c2 == '0' && c3 == '0' && cx != '.') {
            s.setCharAt(len - 1, '0');
        } else if (c1 == '9' && c2 == '9' && c3 == '9' && cx != '.') {
            s.setCharAt(len - 1, '9');
            s.append('9');
            s.append('9');
        }
        return Double.valueOf(s.toString());
    }

    public static double cot(double d) {
        return 1.0 / Math.tan(d);
    }

    public static int mod(int i1, int i2) {
        return i1 % i2;
    }

    public static double pi() {
        return Math.PI;
    }

    public static double round(double d, int p) {
        double f = Math.pow(10.0, p);
        return (double)Math.round(d * f) / f;
    }

    public static int sign(double d) {
        return d < 0.0 ? -1 : (d > 0.0 ? 1 : 0);
    }

    public static double truncate(double d, int p) {
        double f = Math.pow(10.0, p);
        double g = d * f;
        return (d < 0.0 ? Math.ceil(g) : Math.floor(g)) / f;
    }

    public static int bitand(int i, int j) {
        return i & j;
    }

    public static int bitor(int i, int j) {
        return i | j;
    }

    public static Integer ascii(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        return new Integer(s.charAt(0));
    }

    public static String character(int code) {
        return String.valueOf((char)code);
    }

    public static String concat(String s1, String s2) {
        if (s1 == null) {
            if (s2 == null) {
                return null;
            }
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        return s1 + s2;
    }

    public static int difference(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return 0;
        }
        s1 = Library.soundex(s1);
        s2 = Library.soundex(s2);
        int e = 0;
        for (int i = 0; i < 4; ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            ++e;
        }
        return e;
    }

    public static String hexToRaw(String s) {
        StringBuffer to = new StringBuffer();
        int len = s.length();
        if (len % 4 != 0) {
            return null;
        }
        for (int i = 0; i < len; i += 4) {
            char raw = (char)Integer.parseInt(s.substring(i, i + 4), 16);
            to.append(raw);
        }
        return to.toString();
    }

    public static String insert(String s1, int start, int length, String s2) {
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        int len1 = s1.length();
        int len2 = s2.length();
        if (--start < 0 || length <= 0 || len2 == 0 || start > len1) {
            return s1;
        }
        if (start + length > len1) {
            length = len1 - start;
        }
        return s1.substring(0, start) + s2 + s1.substring(start + length);
    }

    public static String lcase(String s) {
        return s == null ? null : s.toLowerCase();
    }

    public static String left(String s, int i) {
        if (s == null) {
            return null;
        }
        return s.substring(0, i < 0 ? 0 : (i < s.length() ? i : s.length()));
    }

    public static Integer length(String s) {
        return s == null ? null : new Integer(s.length());
    }

    public static int locate(String search, String s, Integer start) {
        if (s == null || search == null) {
            return 0;
        }
        int i = start == null ? 0 : start - 1;
        return s.indexOf(search, i < 0 ? 0 : i) + 1;
    }

    public static String ltrim(String s) {
        int i;
        if (s == null) {
            return s;
        }
        int len = s.length();
        for (i = 0; i < len && s.charAt(i) <= ' '; ++i) {
        }
        return i == 0 ? s : s.substring(i);
    }

    public static String rawToHex(String s) {
        char[] from = s.toCharArray();
        StringBuffer to = new StringBuffer();
        for (int i = 0; i < from.length; ++i) {
            String hex = Integer.toHexString(from[i] & 0xFFFF);
            for (int j = hex.length(); j < 4; ++j) {
                to.append('0');
            }
            to.append(hex);
        }
        return to.toString();
    }

    public static String repeat(String s, Integer count) {
        if (s == null || count == null || count < 0) {
            return null;
        }
        int i = count;
        StringBuffer b = new StringBuffer(s.length() * i);
        while (i-- > 0) {
            b.append(s);
        }
        return b.toString();
    }

    public static String replace(String s, String replace, String with) {
        if (s == null || replace == null) {
            return s;
        }
        if (with == null) {
            with = "";
        }
        StringBuffer b = new StringBuffer();
        int start = 0;
        int lenreplace = replace.length();
        while (true) {
            int i;
            if ((i = s.indexOf(replace, start)) == -1) break;
            b.append(s.substring(start, i));
            b.append(with);
            start = i + lenreplace;
        }
        b.append(s.substring(start));
        return b.toString();
    }

    public static String right(String s, int i) {
        if (s == null) {
            return null;
        }
        i = s.length() - i;
        return s.substring(i < 0 ? 0 : (i < s.length() ? i : s.length()));
    }

    public static String rtrim(String s) {
        int endindex;
        int i;
        if (s == null) {
            return s;
        }
        for (i = endindex = s.length() - 1; i >= 0 && s.charAt(i) == ' '; --i) {
        }
        return i == endindex ? s : s.substring(0, i + 1);
    }

    public static String soundex(String s) {
        if (s == null) {
            return s;
        }
        s = s.toUpperCase();
        int len = s.length();
        char[] b = new char[]{'0', '0', '0', '0'};
        int lastdigit = 48;
        int j = 0;
        for (int i = 0; i < len && j < 4; ++i) {
            int newdigit;
            char c = s.charAt(i);
            if ("AEIOUY".indexOf(c) != -1) {
                newdigit = 55;
            } else if (c == 'H' || c == 'W') {
                newdigit = 56;
            } else if ("BFPV".indexOf(c) != -1) {
                newdigit = 49;
            } else if ("CGJKQSXZ".indexOf(c) != -1) {
                newdigit = 50;
            } else if (c == 'D' || c == 'T') {
                newdigit = 51;
            } else if (c == 'L') {
                newdigit = 52;
            } else if (c == 'M' || c == 'N') {
                newdigit = 53;
            } else {
                if (c != 'R') continue;
                newdigit = 54;
            }
            if (j == 0) {
                b[j++] = c;
                lastdigit = newdigit;
                continue;
            }
            if (newdigit <= 54) {
                if (newdigit == lastdigit) continue;
                b[j++] = newdigit;
                lastdigit = newdigit;
                continue;
            }
            if (newdigit != 55) continue;
            lastdigit = newdigit;
        }
        return new String(b, 0, 4);
    }

    public static String space(int i) {
        if (i < 0) {
            return null;
        }
        char[] c = new char[i];
        while (i > 0) {
            c[--i] = 32;
        }
        return new String(c);
    }

    public static String substring(String s, int start, Integer length) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        start = --start > len ? len : start;
        int l = len;
        if (length != null) {
            l = length;
        }
        if (start + l > len) {
            l = len - start;
        }
        return s.substring(start, start + l);
    }

    public static String ucase(String s) {
        return s == null ? null : s.toUpperCase();
    }

    public static java.sql.Date curdate() {
        return new java.sql.Date(System.currentTimeMillis());
    }

    public static Time curtime() {
        return new Time(System.currentTimeMillis());
    }

    public static String dayname(java.sql.Date d) {
        SimpleDateFormat f = new SimpleDateFormat("EEEE");
        return f.format(d).toString();
    }

    private static int getDateTimePart(Date d, int part) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(d);
        return c.get(part);
    }

    private static int getTimePart(Time t, int part) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(t);
        return c.get(part);
    }

    public static int dayofmonth(java.sql.Date d) {
        return Library.getDateTimePart(d, 5);
    }

    public static int dayofweek(java.sql.Date d) {
        return Library.getDateTimePart(d, 7);
    }

    public static int dayofyear(java.sql.Date d) {
        return Library.getDateTimePart(d, 6);
    }

    public static int hour(Time t) {
        return Library.getDateTimePart(t, 11);
    }

    public static int minute(Time t) {
        return Library.getDateTimePart(t, 12);
    }

    static void setSqlMonth(boolean value) {
        if (!sql_month_set) {
            sql_month = value ? 1 : 0;
            sql_month_set = true;
        }
    }

    public static int month(java.sql.Date d) {
        return Library.getDateTimePart(d, 2) + sql_month;
    }

    public static String monthname(java.sql.Date d) {
        SimpleDateFormat f = new SimpleDateFormat("MMMM");
        return f.format(d).toString();
    }

    public static Timestamp now() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static int quarter(java.sql.Date d) {
        return Library.getDateTimePart(d, 2) / 3 + 1;
    }

    public static int second(Time d) {
        return Library.getDateTimePart(d, 13);
    }

    public static int week(java.sql.Date d) {
        return Library.getDateTimePart(d, 3);
    }

    public static int year(java.sql.Date d) {
        return Library.getDateTimePart(d, 1);
    }

    public static String database(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        String s = "SELECT Value FROM SYSTEM_CONNECTIONINFO WHERE KEY='DATABASE'";
        ResultSet r = stat.executeQuery(s);
        r.next();
        return r.getString(1);
    }

    public static String user(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        String s = "SELECT Value FROM SYSTEM_CONNECTIONINFO WHERE KEY='USER'";
        ResultSet r = stat.executeQuery(s);
        r.next();
        return r.getString(1);
    }

    public static int identity() throws SQLException {
        return 0;
    }

    public static boolean getAutoCommit(Connection c) {
        try {
            return c.getAutoCommit();
        }
        catch (SQLException e) {
            return false;
        }
    }
}

