/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.CachedRow;
import com.kingdee.eas.cp.hsqldb.DatabaseRowInputInterface;
import com.kingdee.eas.cp.hsqldb.DatabaseRowOutputInterface;
import com.kingdee.eas.cp.hsqldb.DiskNode;
import com.kingdee.eas.cp.hsqldb.MemoryNode;
import com.kingdee.eas.cp.hsqldb.PointerNode;
import com.kingdee.eas.cp.hsqldb.Row;
import com.kingdee.eas.cp.hsqldb.Table;
import java.io.IOException;
import java.sql.SQLException;

abstract class Node {
    static final int TYPE_MEMORY = 0;
    static final int TYPE_DISK = 1;
    static final int TYPE_POINTER = 2;
    static final int NO_POS = -1;
    protected int iBalance;
    protected Row rData;
    Node nNext;

    Node() {
    }

    static final Node newNode(Row r, int id, Table t) {
        switch (t.getIndexType()) {
            case 0: {
                return new MemoryNode(r);
            }
            case 2: {
                return new PointerNode((CachedRow)r);
            }
        }
        return new DiskNode((CachedRow)r, id);
    }

    static final Node newNode(Row r, DatabaseRowInputInterface in, int id, Table t) throws IOException, SQLException {
        switch (t.getIndexType()) {
            case 0: {
                return new MemoryNode(r);
            }
            case 2: {
                return new PointerNode((CachedRow)r);
            }
        }
        return new DiskNode((CachedRow)r, in, id);
    }

    abstract void delete();

    abstract int getKey();

    abstract void setKey(int var1);

    abstract Row getRow() throws SQLException;

    abstract Node getLeft() throws SQLException;

    abstract void setLeft(Node var1) throws SQLException;

    abstract Node getRight() throws SQLException;

    abstract Node getRightPointer() throws SQLException;

    abstract void setRight(Node var1) throws SQLException;

    abstract Node getParent() throws SQLException;

    abstract boolean isRoot();

    abstract void setParent(Node var1) throws SQLException;

    final int getBalance() throws SQLException {
        return this.iBalance;
    }

    abstract void setBalance(int var1) throws SQLException;

    abstract boolean from() throws SQLException;

    abstract Object[] getData() throws SQLException;

    abstract boolean equals(Node var1) throws SQLException;

    abstract void write(DatabaseRowOutputInterface var1) throws IOException, SQLException;
}

