/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.Column;
import com.kingdee.eas.cp.hsqldb.Database;
import com.kingdee.eas.cp.hsqldb.DatabaseScript;
import com.kingdee.eas.cp.hsqldb.Expression;
import com.kingdee.eas.cp.hsqldb.Function;
import com.kingdee.eas.cp.hsqldb.HsqlName;
import com.kingdee.eas.cp.hsqldb.Record;
import com.kingdee.eas.cp.hsqldb.Result;
import com.kingdee.eas.cp.hsqldb.Select;
import com.kingdee.eas.cp.hsqldb.Session;
import com.kingdee.eas.cp.hsqldb.Table;
import com.kingdee.eas.cp.hsqldb.TableFilter;
import com.kingdee.eas.cp.hsqldb.TextTable;
import com.kingdee.eas.cp.hsqldb.Tokenizer;
import com.kingdee.eas.cp.hsqldb.Trace;
import com.kingdee.eas.cp.hsqldb.View;
import com.kingdee.eas.cp.hsqldb.lib.StringUtil;
import java.sql.SQLException;
import java.util.Vector;

class Parser {
    private Database dDatabase;
    private Tokenizer tTokenizer;
    private Session cSession;
    private String sTable;
    private String sToken;
    private Object oData;
    private int iType;
    private int iToken;
    private static boolean sql_enforce_size;

    Parser(Database db, Tokenizer t, Session session) {
        this.dDatabase = db;
        this.tTokenizer = t;
        this.cSession = session;
    }

    static void setEnforceSize(boolean value) {
        sql_enforce_size = value;
    }

    Result processSelect() throws SQLException {
        Select select = this.parseSelect();
        if (select.sIntoTable == null) {
            return select.getResult(this.cSession.getMaxRows());
        }
        for (int i = 0; i < select.eColumn.length; ++i) {
            if (select.eColumn[i].getAlias().length() != 0) continue;
            throw Trace.error(45);
        }
        if (this.dDatabase.findUserTable(select.sIntoTable.name, this.cSession) != null) {
            throw Trace.error(21, select.sIntoTable.name);
        }
        Result r = select.getResult(0);
        Table t = select.intoType == 5 ? new TextTable(this.dDatabase, select.sIntoTable, select.intoType, this.cSession) : new Table(this.dDatabase, select.sIntoTable, select.intoType, this.cSession);
        t.addColumns(r);
        t.createPrimaryKey();
        this.dDatabase.linkTable(t);
        if (select.intoType == 5) {
            try {
                String src = StringUtil.toLowerSubset(select.sIntoTable.name, '_') + ".csv";
                t.setDataSource(src, false, this.cSession);
                this.logTableDDL(t);
                t.insert(r, this.cSession);
            }
            catch (SQLException e) {
                this.dDatabase.dropTable(select.sIntoTable.name, false, false, this.cSession);
                throw e;
            }
        } else {
            this.logTableDDL(t);
            t.insert(r, this.cSession);
        }
        int i = r.getSize();
        r = new Result();
        r.iUpdateCount = i;
        return r;
    }

    void logTableDDL(Table t) throws SQLException {
        if (t.isTemp()) {
            return;
        }
        StringBuffer tableDDL = new StringBuffer();
        DatabaseScript.getTableDDL(this.dDatabase, t, 0, null, null, tableDDL);
        String sourceDDL = DatabaseScript.getDataSource(t);
        this.dDatabase.logger.writeToLog(this.cSession, tableDDL.toString());
        if (sourceDDL != null) {
            this.dDatabase.logger.writeToLog(this.cSession, sourceDDL);
        }
    }

    Result processCall() throws SQLException {
        Expression e = this.parseExpression();
        e.resolve(null);
        int type = e.getDataType();
        Object o = e.getValue();
        Result r = new Result(1);
        r.sTable[0] = "";
        r.colType[0] = type;
        r.sLabel[0] = "";
        r.sName[0] = "";
        Object[] row = new Object[]{o};
        r.add(row);
        return r;
    }

    Result processUpdate() throws SQLException {
        String token = this.tTokenizer.getString();
        this.cSession.checkReadWrite();
        this.cSession.check(token, 8);
        Table table = this.dDatabase.getTable(token, this.cSession);
        TableFilter filter = new TableFilter(table, null, false);
        if (table.isView()) {
            throw Trace.error(55, token);
        }
        this.tTokenizer.getThis("SET");
        Vector<Integer> vColumn = new Vector<Integer>();
        Vector<Expression> eColumn = new Vector<Expression>();
        int len = 0;
        token = null;
        do {
            ++len;
            int i = table.getColumnNr(this.tTokenizer.getString());
            vColumn.addElement(new Integer(i));
            this.tTokenizer.getThis("=");
            Expression e = this.parseExpression();
            e.resolve(filter);
            eColumn.addElement(e);
        } while ((token = this.tTokenizer.getString()).equals(","));
        Expression eCondition = null;
        if (token.equals("WHERE")) {
            eCondition = this.parseExpression();
            eCondition.resolve(filter);
            filter.setCondition(eCondition);
        } else {
            this.tTokenizer.back();
        }
        table.fireAll(5);
        Object[] exp = new Expression[len];
        eColumn.copyInto(exp);
        int[] col = new int[len];
        int[] type = new int[len];
        int[] csize = new int[len];
        for (int i = 0; i < len; ++i) {
            col[i] = (Integer)vColumn.elementAt(i);
            Column column = table.getColumn(col[i]);
            type[i] = column.getType();
            csize[i] = column.getSize();
        }
        int count = 0;
        if (filter.findFirst()) {
            Object ni;
            Object nd;
            Result del = new Result();
            Result ins = new Result();
            int size = table.getColumnCount();
            do {
                int i;
                if (eCondition != null && !eCondition.test()) continue;
                nd = filter.oCurrentData;
                del.add((Object[])nd);
                ni = table.getNewRow();
                System.arraycopy(nd, 0, ni, 0, size);
                if (sql_enforce_size) {
                    for (i = 0; i < len; ++i) {
                        ni[col[i]] = Parser.enforceSize(((Expression)exp[i]).getValue(type[i]), type[i], csize[i], true);
                    }
                } else {
                    for (i = 0; i < len; ++i) {
                        ni[col[i]] = ((Expression)exp[i]).getValue(type[i]);
                    }
                }
                ins.add((Object[])ni);
            } while (filter.next());
            this.cSession.beginNestedTransaction();
            try {
                nd = del.rRoot;
                while (nd != null) {
                    table.fireAll(11, nd.data);
                    table.deleteNoCheck(nd.data, this.cSession, true);
                    nd = nd.next;
                }
                ni = ins.rRoot;
                while (ni != null) {
                    table.insertNoCheck(ni.data, this.cSession, true);
                    ni = ni.next;
                    ++count;
                }
                table.checkUpdate(col, del, ins);
                ni = ins.rRoot;
                while (ni != null) {
                    table.fireAll(8, ni.data);
                    ni = ni.next;
                }
                this.cSession.endNestedTransaction(false);
            }
            catch (SQLException e) {
                this.cSession.endNestedTransaction(true);
                throw e;
            }
        }
        table.fireAll(2);
        Result r = new Result();
        r.iUpdateCount = count;
        return r;
    }

    Result processDelete() throws SQLException {
        this.tTokenizer.getThis("FROM");
        String token = this.tTokenizer.getString();
        this.cSession.checkReadWrite();
        this.cSession.check(token, 2);
        Table table = this.dDatabase.getTable(token, this.cSession);
        TableFilter filter = new TableFilter(table, null, false);
        if (table.isView()) {
            throw Trace.error(55, token);
        }
        token = this.tTokenizer.getString();
        Expression eCondition = null;
        if (token.equals("WHERE")) {
            eCondition = this.parseExpression();
            eCondition.resolve(filter);
            filter.setCondition(eCondition);
        } else {
            this.tTokenizer.back();
        }
        Trace.check(!table.isDataReadOnly(), 32);
        table.fireAll(4);
        int count = 0;
        if (filter.findFirst()) {
            Result del = new Result();
            do {
                if (eCondition != null && !eCondition.test()) continue;
                del.add(filter.oCurrentData);
            } while (filter.next());
            Record n = del.rRoot;
            while (n != null) {
                table.delete(n.data, this.cSession);
                ++count;
                n = n.next;
            }
        }
        table.fireAll(1);
        Result r = new Result();
        r.iUpdateCount = count;
        return r;
    }

    Result processInsert() throws SQLException {
        this.tTokenizer.getThis("INTO");
        String token = this.tTokenizer.getString();
        this.cSession.checkReadWrite();
        this.cSession.check(token, 4);
        Table t = this.dDatabase.getTable(token, this.cSession);
        if (t.isView()) {
            throw Trace.error(55, token);
        }
        token = this.tTokenizer.getString();
        Vector<String> vcolumns = null;
        if (token.equals("(")) {
            block19: {
                vcolumns = new Vector<String>();
                int i = 0;
                do {
                    vcolumns.addElement(this.tTokenizer.getString());
                    ++i;
                    token = this.tTokenizer.getString();
                    if (token.equals(")")) break block19;
                } while (token.equals(","));
                throw Trace.error(11, token);
            }
            token = this.tTokenizer.getString();
        }
        int count = 0;
        int len = vcolumns == null ? t.getColumnCount() : vcolumns.size();
        if (token.equals("VALUES")) {
            int i;
            boolean[] check;
            Object[] row;
            block20: {
                this.tTokenizer.getThis("(");
                row = t.getNewRow();
                check = vcolumns == null ? null : new boolean[row.length];
                i = 0;
                do {
                    int colindex;
                    if (vcolumns == null) {
                        colindex = i;
                        if (i == len) {
                            break block20;
                        }
                    } else {
                        colindex = t.getColumnNr((String)vcolumns.elementAt(i));
                        check[colindex] = true;
                    }
                    Column column = t.getColumn(colindex);
                    row[colindex] = sql_enforce_size ? Parser.enforceSize(this.getValue(column.getType()), column.getType(), column.getSize(), true) : this.getValue(column.getType());
                    ++i;
                    token = this.tTokenizer.getString();
                    if (token.equals(")")) break block20;
                } while (token.equals(","));
                throw Trace.error(11, token);
            }
            Trace.check(len == i, 5);
            if (vcolumns != null) {
                for (i = 0; i < check.length; ++i) {
                    String def;
                    if (check[i] || (def = t.getColumn(i).getDefaultString()) == null) continue;
                    row[i] = Column.convertObject(def, t.getColumn(i).getType());
                }
            }
            t.insert(row, this.cSession);
            count = 1;
        } else if (token.equals("SELECT")) {
            Result result = this.processSelect();
            Record r = result.rRoot;
            Trace.check(len == result.getColumnCount(), 5);
            int[] col = new int[len];
            int[] type = new int[len];
            for (int i = 0; i < len; ++i) {
                int j = vcolumns == null ? i : t.getColumnNr((String)vcolumns.elementAt(i));
                col[i] = j;
                type[i] = t.getColumn(j).getType();
            }
            this.cSession.beginNestedTransaction();
            try {
                while (r != null) {
                    int i;
                    Object[] row = t.getNewRow();
                    boolean[] check = new boolean[row.length];
                    for (i = 0; i < len; ++i) {
                        check[col[i]] = true;
                        row[col[i]] = type[i] != result.colType[i] ? Column.convertObject(r.data[i], type[i]) : r.data[i];
                    }
                    for (i = 0; i < check.length; ++i) {
                        String def;
                        if (check[i] || (def = t.getColumn(i).getDefaultString()) == null) continue;
                        row[i] = Column.convertObject(def, t.getColumn(i).getType());
                    }
                    t.insert(row, this.cSession);
                    ++count;
                    r = r.next;
                }
                this.cSession.endNestedTransaction(false);
            }
            catch (SQLException e) {
                this.cSession.endNestedTransaction(true);
                throw e;
            }
        } else {
            throw Trace.error(11, token);
        }
        Result r = new Result();
        r.iUpdateCount = count;
        return r;
    }

    static Object enforceSize(Object obj, int type, int size, boolean pad) {
        if (size == 0 || obj == null) {
            return obj;
        }
        switch (type) {
            case 1: {
                return Parser.padOrTrunc((String)obj, size, pad);
            }
            case 12: {
                if (((String)obj).length() <= size) break;
                return ((String)obj).substring(0, size);
            }
        }
        return obj;
    }

    static String padOrTrunc(String s, int len, boolean pad) {
        if (s.length() >= len) {
            return s.substring(0, len);
        }
        StringBuffer b = new StringBuffer(len);
        b.append(s);
        if (pad) {
            for (int i = s.length(); i < len; ++i) {
                b.append(' ');
            }
        }
        return b.toString();
    }

    Select parseSelect() throws SQLException {
        Select select = new Select();
        String token = this.tTokenizer.getString();
        if (token.equals("LIMIT")) {
            String limStart = this.tTokenizer.getString();
            String limEnd = this.tTokenizer.getString();
            try {
                select.limitStart = new Integer(limStart);
                select.limitCount = new Integer(limEnd);
            }
            catch (NumberFormatException ex) {
                throw Trace.error(16, "LIMIT n m");
            }
            token = this.tTokenizer.getString();
        } else if (token.equals("TOP")) {
            String limEnd = this.tTokenizer.getString();
            try {
                select.limitStart = 0;
                select.limitCount = new Integer(limEnd);
            }
            catch (NumberFormatException ex) {
                throw Trace.error(16, "TOP m");
            }
            token = this.tTokenizer.getString();
        }
        if (token.equals("DISTINCT")) {
            select.isDistinctSelect = true;
        } else {
            this.tTokenizer.back();
        }
        Vector<Expression> vcolumn = new Vector<Expression>();
        do {
            Expression e = this.parseExpression();
            token = this.tTokenizer.getString();
            if (token.equals("AS")) {
                e.setAlias(this.tTokenizer.getName(), this.tTokenizer.wasQuotedIdentifier());
                token = this.tTokenizer.getString();
            } else if (this.tTokenizer.wasName()) {
                e.setAlias(token, this.tTokenizer.wasQuotedIdentifier());
                token = this.tTokenizer.getString();
            }
            vcolumn.addElement(e);
        } while (token.equals(","));
        if (token.equals("INTO")) {
            token = this.tTokenizer.getString();
            if (token.equals("CACHED")) {
                select.intoType = 3;
                select.sIntoTable = new HsqlName(this.tTokenizer.getString(), this.tTokenizer.wasQuotedIdentifier());
            } else if (token.equals("TEMP")) {
                select.intoType = 1;
                select.sIntoTable = new HsqlName(this.tTokenizer.getString(), this.tTokenizer.wasQuotedIdentifier());
            } else if (token.equals("TEXT")) {
                select.intoType = 5;
                select.sIntoTable = new HsqlName(this.tTokenizer.getString(), this.tTokenizer.wasQuotedIdentifier());
            } else {
                select.sIntoTable = new HsqlName(token, this.tTokenizer.wasQuotedIdentifier());
            }
            token = this.tTokenizer.getString();
        }
        if (!token.equals("FROM")) {
            throw Trace.error(11, token);
        }
        Expression condition = null;
        Vector<TableFilter> vfilter = new Vector<TableFilter>();
        vfilter.addElement(this.parseTableFilter(false));
        while (true) {
            if ((token = this.tTokenizer.getString()).equals("LEFT")) {
                token = this.tTokenizer.getString();
                if (token.equals("OUTER")) {
                    token = this.tTokenizer.getString();
                }
                Trace.check(token.equals("JOIN"), 11, token);
                vfilter.addElement(this.parseTableFilter(true));
                this.tTokenizer.getThis("ON");
                condition = this.addCondition(condition, this.parseOuterJoinCondition());
                continue;
            }
            if (token.equals("INNER")) {
                this.tTokenizer.getThis("JOIN");
                vfilter.addElement(this.parseTableFilter(false));
                this.tTokenizer.getThis("ON");
                condition = this.addCondition(condition, this.parseExpression());
                continue;
            }
            if (!token.equals(",")) break;
            vfilter.addElement(this.parseTableFilter(false));
        }
        this.tTokenizer.back();
        int len = vfilter.size();
        Object[] filter = new TableFilter[len];
        vfilter.copyInto(filter);
        select.tFilter = filter;
        len = vcolumn.size();
        for (int i = 0; i < len; ++i) {
            Expression e = (Expression)vcolumn.elementAt(i);
            if (e.getType() == 6) {
                int current = i;
                Table table = null;
                String n = e.getTableName();
                for (int t = 0; t < filter.length; ++t) {
                    Object f = filter[t];
                    e.resolve((TableFilter)f);
                    if (n != null && !n.equals(((TableFilter)f).getName())) continue;
                    table = ((TableFilter)f).getTable();
                    int col = table.getColumnCount();
                    for (int c = 0; c < col; ++c) {
                        Expression ins = new Expression(((TableFilter)f).getName(), table.getColumn((int)c).columnName.name, table.getColumn((int)c).columnName.isNameQuoted);
                        vcolumn.insertElementAt(ins, current++);
                        ++len;
                    }
                }
                Trace.check(table != null, 22, n);
                --len;
                vcolumn.removeElementAt(current);
                continue;
            }
            if (e.getType() != 2 || e.getTableName() != null) continue;
            for (int filterIndex = 0; filterIndex < filter.length; ++filterIndex) {
                e.resolve((TableFilter)filter[filterIndex]);
            }
        }
        select.iResultLen = len;
        token = this.tTokenizer.getString();
        if (token.equals("WHERE")) {
            condition = this.addCondition(condition, this.parseExpression());
            token = this.tTokenizer.getString();
        }
        select.eCondition = condition;
        if (token.equals("GROUP")) {
            this.tTokenizer.getThis("BY");
            len = 0;
            do {
                Expression e = this.parseExpression();
                e = this.doOrderGroup(e, vcolumn);
                vcolumn.addElement(e);
                token = this.tTokenizer.getString();
                ++len;
            } while (token.equals(","));
            select.iGroupLen = len;
        }
        if (token.equals("HAVING")) {
            Expression hcondition = null;
            this.addCondition(hcondition, this.parseExpression());
            select.havingCondition = hcondition;
            token = this.tTokenizer.getString();
            throw Trace.error(20);
        }
        if (token.equals("ORDER")) {
            this.tTokenizer.getThis("BY");
            len = 0;
            do {
                Expression e = this.parseExpression();
                e = this.doOrderGroup(e, vcolumn);
                token = this.tTokenizer.getString();
                if (token.equals("DESC")) {
                    e.setDescending();
                    token = this.tTokenizer.getString();
                } else if (token.equals("ASC")) {
                    token = this.tTokenizer.getString();
                }
                vcolumn.addElement(e);
                ++len;
            } while (token.equals(","));
            select.iOrderLen = len;
        }
        len = vcolumn.size();
        select.eColumn = new Expression[len];
        vcolumn.copyInto(select.eColumn);
        if (token.equals("UNION")) {
            token = this.tTokenizer.getString();
            if (token.equals("ALL")) {
                select.iUnionType = 2;
            } else {
                select.iUnionType = 1;
                this.tTokenizer.back();
            }
            this.tTokenizer.getThis("SELECT");
            select.sUnion = this.parseSelect();
        } else if (token.equals("INTERSECT")) {
            this.tTokenizer.getThis("SELECT");
            select.iUnionType = 3;
            select.sUnion = this.parseSelect();
        } else if (token.equals("EXCEPT") || token.equals("MINUS")) {
            this.tTokenizer.getThis("SELECT");
            select.iUnionType = 4;
            select.sUnion = this.parseSelect();
        } else {
            this.tTokenizer.back();
        }
        return select;
    }

    private Expression doOrderGroup(Expression e, Vector vcolumn) throws SQLException {
        block3: {
            block2: {
                if (e.getType() != 1) break block2;
                if (e.getDataType() != 4) break block3;
                int i = (Integer)e.getValue();
                e = (Expression)vcolumn.elementAt(i - 1);
                break block3;
            }
            if (e.getType() == 2 && e.getTableName() == null) {
                String s = e.getColumnName();
                int vSize = vcolumn.size();
                for (int i = 0; i < vSize; ++i) {
                    Expression ec = (Expression)vcolumn.elementAt(i);
                    if (!s.equals(ec.getAlias())) continue;
                    e = ec;
                    break;
                }
            }
        }
        return e;
    }

    private TableFilter parseTableFilter(boolean outerjoin) throws SQLException {
        String token = this.tTokenizer.getString();
        Table t = null;
        if (token.equals("(")) {
            this.tTokenizer.getThis("SELECT");
            Select s = this.parseSelect();
            Result r = s.getResult(0);
            t = new Table(this.dDatabase, new HsqlName("SYSTEM_SUBQUERY", false), 0, null);
            this.tTokenizer.getThis(")");
            t.addColumns(r);
            t.createPrimaryKey();
            t.insert(r, this.cSession);
        } else {
            this.cSession.check(token, 1);
            t = this.dDatabase.getTable(token, this.cSession);
            if (t.isView()) {
                String Viewname = token;
                int CurrentPos = this.tTokenizer.getPosition();
                int sLength = this.tTokenizer.getLength();
                int TokenLength = token.length();
                int NewCurPos = CurrentPos;
                token = this.tTokenizer.getString();
                if (token.equals("AS")) {
                    Viewname = this.tTokenizer.getName();
                    NewCurPos = this.tTokenizer.getPosition();
                } else if (this.tTokenizer.wasName()) {
                    Viewname = token;
                    NewCurPos = this.tTokenizer.getPosition();
                } else {
                    this.tTokenizer.back();
                }
                String sLeft = this.tTokenizer.getPart(0, CurrentPos - TokenLength);
                String sRight = this.tTokenizer.getPart(NewCurPos, sLength);
                View v = (View)t;
                String sView = v.getStatement();
                StringBuffer sFromView = new StringBuffer(128);
                sFromView.append(sLeft);
                sFromView.append('(');
                sFromView.append(sView);
                sFromView.append(") ");
                sFromView.append(Viewname);
                sFromView.append(sRight);
                this.tTokenizer.setString(sFromView.toString(), CurrentPos - TokenLength + 1);
                this.tTokenizer.getThis("SELECT");
                Select s = this.parseSelect();
                Result r = s.getResult(0);
                t = new Table(this.dDatabase, new HsqlName("SYSTEM_SUBQUERY", false), 0, null);
                this.tTokenizer.getThis(")");
                t.addColumns(r);
                t.createPrimaryKey();
                t.insert(r, this.cSession);
            }
        }
        String sAlias = null;
        token = this.tTokenizer.getString();
        if (token.equals("AS")) {
            sAlias = this.tTokenizer.getName();
        } else if (this.tTokenizer.wasName()) {
            sAlias = token;
        } else {
            this.tTokenizer.back();
        }
        return new TableFilter(t, sAlias, outerjoin);
    }

    private Expression addCondition(Expression e1, Expression e2) {
        if (e1 == null) {
            return e2;
        }
        if (e2 == null) {
            return e1;
        }
        return new Expression(28, e1, e2);
    }

    private Object getValue(int type) throws SQLException {
        Expression r = this.parseExpression();
        r.resolve(null);
        return r.getValue(type);
    }

    private Expression parseOuterJoinCondition() throws SQLException {
        boolean parens = false;
        this.read();
        if (this.iToken == 101) {
            parens = true;
            this.read();
        }
        Trace.check(this.iToken == 2, 64);
        Expression left = new Expression(this.sTable, this.sToken);
        this.read();
        Trace.check(this.iToken == 21, 64);
        this.read();
        Trace.check(this.iToken == 2, 64);
        Expression right = new Expression(this.sTable, this.sToken);
        if (parens) {
            this.read();
            Trace.check(this.iToken == 102, 64);
        }
        return new Expression(21, left, right);
    }

    private Expression parseExpression() throws SQLException {
        this.read();
        if (Expression.isAggregate(this.iToken)) {
            boolean distinct = false;
            int type = this.iToken;
            this.read();
            if (this.tTokenizer.getString().equals("DISTINCT")) {
                distinct = true;
            } else {
                this.tTokenizer.back();
            }
            Expression r = new Expression(type, this.readOr(), null);
            r.setDistinctAggregate(distinct);
            this.tTokenizer.back();
            return r;
        }
        Expression r = this.readOr();
        this.tTokenizer.back();
        return r;
    }

    private Expression readOr() throws SQLException {
        Expression r = this.readAnd();
        while (this.iToken == 29) {
            int type = this.iToken;
            Expression a = r;
            this.read();
            r = new Expression(type, a, this.readAnd());
        }
        return r;
    }

    private Expression readAnd() throws SQLException {
        Expression r = this.readCondition();
        while (this.iToken == 28) {
            int type = this.iToken;
            Expression a = r;
            this.read();
            r = new Expression(type, a, this.readCondition());
        }
        return r;
    }

    private Expression readCondition() throws SQLException {
        if (this.iToken == 20) {
            int type = this.iToken;
            this.read();
            return new Expression(type, this.readCondition(), null);
        }
        if (this.iToken == 31) {
            int type = this.iToken;
            this.read();
            this.readThis(101);
            Trace.check(this.iToken == 103, 11);
            Expression s = new Expression(this.parseSelect());
            this.read();
            this.readThis(102);
            return new Expression(type, s, null);
        }
        Expression a = this.readConcat();
        boolean not = false;
        if (this.iToken == 20) {
            not = true;
            this.read();
        }
        if (this.iToken == 27) {
            this.read();
            Expression b = this.readConcat();
            char escape = '\u0000';
            if (this.sToken.equals("ESCAPE")) {
                this.read();
                Expression c = this.readTerm();
                Trace.check(c.getType() == 1, 7);
                String s = (String)c.getValue(12);
                if (s == null || s.length() < 1) {
                    throw Trace.error(7, s);
                }
                escape = s.charAt(0);
            }
            a = new Expression(27, a, b);
            a.setLikeEscape(escape);
        } else if (this.iToken == 106) {
            this.read();
            Expression l = new Expression(22, a, this.readConcat());
            this.readThis(28);
            Expression h = new Expression(25, a, this.readConcat());
            a = new Expression(28, l, h);
        } else if (this.iToken == 30) {
            int type = this.iToken;
            this.read();
            this.readThis(101);
            Expression b = null;
            if (this.iToken == 103) {
                b = new Expression(this.parseSelect());
                this.read();
            } else {
                this.tTokenizer.back();
                Vector<Object> v = new Vector<Object>();
                do {
                    v.addElement(this.getValue(12));
                    this.read();
                } while (this.iToken == 104);
                b = new Expression(v);
            }
            this.readThis(102);
            a = new Expression(type, a, b);
        } else {
            Trace.check(!not, 11);
            if (Expression.isCompare(this.iToken)) {
                int type = this.iToken;
                this.read();
                return new Expression(type, a, this.readConcat());
            }
            return a;
        }
        if (not) {
            a = new Expression(20, a, null);
        }
        return a;
    }

    private void readThis(int type) throws SQLException {
        Trace.check(this.iToken == type, 11);
        this.read();
    }

    private Expression readConcat() throws SQLException {
        Expression r = this.readSum();
        while (this.iToken == 105) {
            int type = 15;
            Expression a = r;
            this.read();
            r = new Expression(type, a, this.readSum());
        }
        return r;
    }

    private Expression readSum() throws SQLException {
        Expression r = this.readFactor();
        while (true) {
            int type;
            if (this.iToken == 100) {
                type = 10;
            } else {
                if (this.iToken != 9) break;
                type = 11;
            }
            Expression a = r;
            this.read();
            r = new Expression(type, a, this.readFactor());
        }
        return r;
    }

    private Expression readFactor() throws SQLException {
        Expression r = this.readTerm();
        while (this.iToken == 12 || this.iToken == 14) {
            int type = this.iToken;
            Expression a = r;
            this.read();
            r = new Expression(type, a, this.readTerm());
        }
        return r;
    }

    private Expression readTerm() throws SQLException {
        Expression r = null;
        if (this.iToken == 2) {
            String name = this.sToken;
            r = new Expression(this.sTable, this.sToken);
            this.read();
            if (this.iToken == 101) {
                Function f = new Function(this.dDatabase.getAlias(name), this.cSession);
                int len = f.getArgCount();
                int i = 0;
                this.read();
                if (this.iToken != 102) {
                    while (true) {
                        f.setArgument(i++, this.readOr());
                        if (this.iToken != 104) break;
                        this.read();
                    }
                }
                this.readThis(102);
                r = new Expression(f);
            }
        } else if (this.iToken == 9) {
            int type = this.iToken;
            this.read();
            r = new Expression(type, this.readTerm(), null);
        } else if (this.iToken == 100) {
            this.read();
            r = this.readTerm();
        } else if (this.iToken == 101) {
            this.read();
            r = this.readOr();
            if (this.iToken != 102) {
                throw Trace.error(11, this.sToken);
            }
            this.read();
        } else if (this.iToken == 1) {
            r = new Expression(this.iType, this.oData);
            this.read();
        } else if (this.iToken == 103) {
            r = new Expression(this.parseSelect());
            this.read();
        } else if (this.iToken == 12) {
            r = new Expression(this.sTable, null);
            this.read();
        } else if (this.iToken == 60 || this.iToken == 15) {
            int type = this.iToken;
            this.read();
            this.readThis(101);
            r = this.readOr();
            this.readThis(104);
            r = new Expression(type, r, this.readOr());
            this.readThis(102);
        } else if (this.iToken == 62) {
            int type = this.iToken;
            this.read();
            this.readThis(101);
            r = this.readOr();
            this.readThis(104);
            Expression thenelse = this.readOr();
            this.readThis(104);
            thenelse = new Expression(type, thenelse, this.readOr());
            r = new Expression(type, r, thenelse);
            this.readThis(102);
        } else if (this.iToken == 61) {
            int type = this.iToken;
            this.read();
            this.readThis(101);
            r = this.readOr();
            this.readThis(104);
            int t = Column.getTypeNr(this.sToken);
            r = new Expression(type, r, null);
            r.setDataType(t);
            this.read();
            this.readThis(102);
        } else if (this.iToken == 107) {
            this.read();
            this.readThis(101);
            r = this.readOr();
            Trace.check(this.sToken.equals("AS"), 11, this.sToken);
            this.read();
            int t = Column.getTypeNr(this.sToken);
            r = new Expression(61, r, null);
            r.setDataType(t);
            this.read();
            this.readThis(102);
        } else {
            throw Trace.error(11, this.sToken);
        }
        return r;
    }

    private void read() throws SQLException {
        this.sToken = this.tTokenizer.getString();
        if (this.tTokenizer.wasValue()) {
            this.iToken = 1;
            this.oData = this.tTokenizer.getAsValue();
            this.iType = this.tTokenizer.getType();
        } else if (this.tTokenizer.wasName()) {
            this.iToken = 2;
            this.sTable = null;
        } else if (this.tTokenizer.wasLongName()) {
            this.sTable = this.tTokenizer.getLongNameFirst();
            this.sToken = this.tTokenizer.getLongNameLast();
            this.iToken = this.sToken.equals("*") ? 12 : 2;
        } else if (this.sToken.length() == 0) {
            this.iToken = 108;
        } else if (this.sToken.equals(",")) {
            this.iToken = 104;
        } else if (this.sToken.equals("=")) {
            this.iToken = 21;
        } else if (this.sToken.equals("<>") || this.sToken.equals("!=")) {
            this.iToken = 26;
        } else if (this.sToken.equals("<")) {
            this.iToken = 24;
        } else if (this.sToken.equals(">")) {
            this.iToken = 23;
        } else if (this.sToken.equals("<=")) {
            this.iToken = 25;
        } else if (this.sToken.equals(">=")) {
            this.iToken = 22;
        } else if (this.sToken.equals("AND")) {
            this.iToken = 28;
        } else if (this.sToken.equals("OR")) {
            this.iToken = 29;
        } else if (this.sToken.equals("NOT")) {
            this.iToken = 20;
        } else if (this.sToken.equals("IN")) {
            this.iToken = 30;
        } else if (this.sToken.equals("EXISTS")) {
            this.iToken = 31;
        } else if (this.sToken.equals("BETWEEN")) {
            this.iToken = 106;
        } else if (this.sToken.equals("+")) {
            this.iToken = 100;
        } else if (this.sToken.equals("-")) {
            this.iToken = 9;
        } else if (this.sToken.equals("*")) {
            this.iToken = 12;
            this.sTable = null;
        } else if (this.sToken.equals("/")) {
            this.iToken = 14;
        } else if (this.sToken.equals("||")) {
            this.iToken = 105;
        } else if (this.sToken.equals("(")) {
            this.iToken = 101;
        } else if (this.sToken.equals(")")) {
            this.iToken = 102;
        } else if (this.sToken.equals("SELECT")) {
            this.iToken = 103;
        } else if (this.sToken.equals("IS")) {
            this.sToken = this.tTokenizer.getString();
            if (this.sToken.equals("NOT")) {
                this.iToken = 26;
            } else {
                this.iToken = 21;
                this.tTokenizer.back();
            }
        } else {
            this.iToken = this.sToken.equals("LIKE") ? 27 : (this.sToken.equals("COUNT") ? 40 : (this.sToken.equals("SUM") ? 41 : (this.sToken.equals("MIN") ? 42 : (this.sToken.equals("MAX") ? 43 : (this.sToken.equals("AVG") ? 44 : (this.sToken.equals("IFNULL") ? 60 : (this.sToken.equals("CONVERT") ? 61 : (this.sToken.equals("CAST") ? 107 : (this.sToken.equals("CASEWHEN") ? 62 : (this.sToken.equals("CONCAT") ? 15 : 108))))))))));
        }
    }
}

