/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.CachedRow;
import com.kingdee.eas.cp.hsqldb.MemoryNode;
import com.kingdee.eas.cp.hsqldb.Node;
import com.kingdee.eas.cp.hsqldb.Row;
import com.kingdee.eas.cp.hsqldb.Table;
import java.sql.SQLException;

class PointerNode
extends MemoryNode {
    private int iId;
    private int iData = -1;
    private Table tTable;
    private int iRight = -1;

    PointerNode(CachedRow r) {
        this.tTable = r.getTable();
        if (r.iPos == -1) {
            this.rData = r;
        } else {
            this.iData = r.iPos;
        }
    }

    @Override
    void delete() {
        this.iBalance = -2;
        this.nParent = null;
        this.nRight = null;
        this.nLeft = null;
        this.iRight = 0;
        this.tTable = null;
    }

    @Override
    int getKey() {
        if (this.rData != null) {
            return ((CachedRow)this.rData).iPos;
        }
        return this.iData;
    }

    @Override
    void setKey(int pos) {
        this.iData = pos;
        this.rData = null;
    }

    @Override
    Row getRow() throws SQLException {
        if (this.rData != null) {
            return this.rData;
        }
        if (this.iData == -1) {
            return null;
        }
        return this.tTable.getRow(this.iData);
    }

    private Node findNode(int pos, int id) throws SQLException {
        Node ret = null;
        Row r = this.tTable.getRow(pos);
        if (r != null) {
            ret = r.getNode(id);
        }
        return ret;
    }

    @Override
    Node getRight() throws SQLException {
        if (this.nRight != null) {
            return this.nRight;
        }
        if (this.iRight == -1) {
            return null;
        }
        return this.findNode(this.iRight, this.iId);
    }

    @Override
    Node getRightPointer() throws SQLException {
        return this.nRight;
    }

    @Override
    void setRight(Node n) throws SQLException {
        this.iRight = -1;
        this.nRight = n;
    }

    void setNextKey(int i) throws SQLException {
        this.iRight = i;
        this.nRight = null;
    }

    @Override
    Object[] getData() throws SQLException {
        return this.getRow().getData();
    }

    @Override
    boolean equals(Node n) throws SQLException {
        return n == this;
    }
}

