/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.TextDatabaseRowOutput;
import java.io.IOException;

class QuotedTextDatabaseRowOutput
extends TextDatabaseRowOutput {
    public QuotedTextDatabaseRowOutput(String fieldSep, String varSep, String longvarSep) throws IOException {
        super(fieldSep, varSep, longvarSep);
    }

    private String addQuotes(String s, String sep) {
        if (s.indexOf(34) != -1 || sep.length() > 0 && s.indexOf(sep) != -1) {
            int len = s.length();
            StringBuffer quoted = new StringBuffer(len + 3);
            quoted.append('\"');
            for (int i = 0; i < len; ++i) {
                char ch = s.charAt(i);
                if (ch == '\"') {
                    quoted.append('\"');
                }
                quoted.append(ch);
            }
            quoted.append('\"');
            s = quoted.toString();
        }
        return s;
    }

    @Override
    public void writeString(String s) throws IOException {
        super.writeString(this.addQuotes(s, this.fieldSep));
    }

    @Override
    protected void writeVarString(String s) throws IOException {
        super.writeVarString(this.addQuotes(s, this.varSep));
    }

    @Override
    protected void writeLongVarString(String s) throws IOException {
        super.writeLongVarString(this.addQuotes(s, this.longvarSep));
    }

    private String addQuotes(byte[] b, String sep) {
        StringBuffer quoted = new StringBuffer(b.length + 2);
        quoted.append('\"');
        for (int i = 0; i < b.length; ++i) {
            char ch = (char)(b[i] & 0xFF);
            if (ch == '\"') {
                quoted.append('\"');
            }
            quoted.append(ch);
        }
        quoted.append('\"');
        return quoted.toString();
    }

    @Override
    protected void writeByteArray(byte[] b) throws IOException {
        super.writeString(this.addQuotes(b, this.fieldSep));
    }

    @Override
    protected void writeVarByteArray(byte[] b) throws IOException {
        super.writeVarString(this.addQuotes(b, this.varSep));
    }

    @Override
    protected void writeLongVarByteArray(byte[] b) throws IOException {
        super.writeLongVarString(this.addQuotes(b, this.longvarSep));
    }
}

