/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.BinaryServerRowInput;
import com.kingdee.eas.cp.hsqldb.BinaryServerRowOutput;
import com.kingdee.eas.cp.hsqldb.Column;
import com.kingdee.eas.cp.hsqldb.Record;
import com.kingdee.eas.cp.hsqldb.Trace;
import java.io.IOException;
import java.sql.SQLException;

class Result {
    private Record rTail;
    private int iSize;
    private int iColumnCount;
    static final int UPDATECOUNT = 0;
    static final int ERROR = 1;
    static final int DATA = 2;
    int iMode;
    String sError;
    int errorCode;
    int iUpdateCount;
    Record rRoot;
    String[] sLabel;
    String[] sTable;
    String[] sName;
    boolean[] isLabelQuoted;
    int[] colType;
    int[] colSize;
    int[] colScale;

    Result() {
        this.iMode = 0;
        this.iUpdateCount = 0;
    }

    Result(String error, int code) {
        this.iMode = 1;
        this.sError = error;
        this.errorCode = code;
    }

    Result(int columns) {
        this.prepareData(columns);
        this.iColumnCount = columns;
    }

    Result(byte[] b) throws SQLException {
        try {
            BinaryServerRowInput in = new BinaryServerRowInput(b);
            this.iMode = in.readIntData();
            if (this.iMode == 1) {
                int code = in.readIntData();
                throw Trace.getError(in.readString(), code);
            }
            if (this.iMode == 0) {
                this.iUpdateCount = in.readIntData();
            } else if (this.iMode == 2) {
                int l = in.readIntData();
                this.prepareData(l);
                this.iColumnCount = l;
                for (int i = 0; i < l; ++i) {
                    this.colType[i] = in.readType();
                    this.sLabel[i] = in.readString();
                    this.sTable[i] = in.readString();
                    this.sName[i] = in.readString();
                }
                while (in.available() != 0) {
                    this.add(in.readData(this.colType));
                }
            }
        }
        catch (IOException e) {
            throw Trace.error(19);
        }
    }

    int getSize() {
        return this.iSize;
    }

    void setColumnCount(int columns) {
        this.iColumnCount = columns;
    }

    int getColumnCount() {
        return this.iColumnCount;
    }

    void append(Result a) {
        if (this.rRoot == null) {
            this.rRoot = a.rRoot;
        } else {
            this.rTail.next = a.rRoot;
        }
        this.rTail = a.rTail;
        this.iSize += a.iSize;
    }

    void setRows(Result a) {
        this.rRoot = a.rRoot;
        this.rTail = a.rTail;
        this.iSize = a.iSize;
    }

    void add(Object[] d) {
        Record r = new Record();
        r.data = d;
        if (this.rRoot == null) {
            this.rRoot = r;
        } else {
            this.rTail.next = r;
        }
        this.rTail = r;
        ++this.iSize;
    }

    void trimResult(int limitstart, int limitcount) {
        int i;
        Record n = this.rRoot;
        if (n == null) {
            return;
        }
        if (limitstart >= this.iSize) {
            this.iSize = 0;
            this.rTail = null;
            this.rRoot = null;
            return;
        }
        this.iSize -= limitstart;
        for (i = 0; i < limitstart; ++i) {
            n = n.next;
            if (n != null) continue;
            this.iSize = 0;
            this.rRoot = this.rTail = n;
            return;
        }
        this.rRoot = n;
        if (limitcount == 0 || limitcount >= this.iSize) {
            return;
        }
        for (i = 1; i < limitcount; ++i) {
            n = n.next;
            if (n != null) continue;
            return;
        }
        n.next = null;
        this.rTail = n;
    }

    void removeDuplicates() throws SQLException {
        Record next;
        if (this.rRoot == null) {
            return;
        }
        int len = this.getColumnCount();
        int[] order = new int[len];
        int[] way = new int[len];
        for (int i = 0; i < len; ++i) {
            order[i] = i;
            way[i] = 1;
        }
        this.sortResult(order, way);
        Record n = this.rRoot;
        while ((next = n.next) != null) {
            if (this.compareRecord(n.data, next.data, len) == 0) {
                n.next = next.next;
                --this.iSize;
                continue;
            }
            n = next;
        }
        this.rTail = n;
        Trace.doAssert(this.rTail.next == null, "rTail not correct in Result.removeDuplicates iSise =" + this.iSize);
    }

    void removeSecond(Result minus) throws SQLException {
        this.removeDuplicates();
        minus.removeDuplicates();
        int len = this.getColumnCount();
        Record n = this.rRoot;
        Record last = this.rRoot;
        boolean rootr = true;
        Record n2 = minus.rRoot;
        int i = 0;
        while (n != null && n2 != null) {
            i = this.compareRecord(n.data, n2.data, len);
            if (i == 0) {
                if (rootr) {
                    this.rRoot = last = n.next;
                } else {
                    last.next = n.next;
                }
                n = n.next;
                --this.iSize;
                continue;
            }
            if (i > 0) {
                n2 = n2.next;
                continue;
            }
            last = n;
            rootr = false;
            n = n.next;
        }
        while (n != null) {
            last = n;
            n = n.next;
        }
        this.rTail = last;
        Trace.doAssert(this.rRoot == null && this.rTail == null || this.rTail.next == null, "rTail not correct in Result.removeSecond iSise =" + this.iSize);
    }

    void removeDifferent(Result r2) throws SQLException {
        this.removeDuplicates();
        r2.removeDuplicates();
        int len = this.getColumnCount();
        Record n = this.rRoot;
        Record last = this.rRoot;
        boolean rootr = true;
        Record n2 = r2.rRoot;
        int i = 0;
        this.iSize = 0;
        while (n != null && n2 != null) {
            i = this.compareRecord(n.data, n2.data, len);
            if (i == 0) {
                if (rootr) {
                    this.rRoot = n;
                } else {
                    last.next = n;
                }
                rootr = false;
                last = n;
                n = n.next;
                n2 = n2.next;
                ++this.iSize;
                continue;
            }
            if (i > 0) {
                n2 = n2.next;
                continue;
            }
            n = n.next;
        }
        if (rootr) {
            this.rRoot = null;
            last = null;
        } else {
            last.next = null;
        }
        this.rTail = last;
        Trace.doAssert(this.rRoot == null && this.rTail == null || this.rTail.next == null, "rTail not correct in Result.removeDifference iSise =" + this.iSize);
    }

    void sortResult(int[] order, int[] way) throws SQLException {
        if (this.rRoot == null || this.rRoot.next == null) {
            return;
        }
        Record[] target = new Record[2];
        Record[] targetlast = new Record[2];
        int dest = 0;
        Record n = this.rRoot;
        while (n != null) {
            Record next = n.next;
            n.next = target[dest];
            target[dest] = n;
            n = next;
            dest ^= 1;
        }
        int blocksize = 1;
        while (target[1] != null) {
            Record source0 = target[0];
            Record source1 = target[1];
            targetlast[1] = null;
            targetlast[0] = null;
            target[1] = null;
            target[0] = null;
            dest = 0;
            while (source0 != null) {
                int n0 = blocksize;
                int n1 = blocksize;
                while (true) {
                    if (n0 == 0 || source0 == null) {
                        if (n1 == 0 || source1 == null) break;
                        n = source1;
                        source1 = source1.next;
                        --n1;
                    } else if (n1 == 0 || source1 == null) {
                        n = source0;
                        source0 = source0.next;
                        --n0;
                    } else if (this.compareRecord(source0.data, source1.data, order, way) > 0) {
                        n = source1;
                        source1 = source1.next;
                        --n1;
                    } else {
                        n = source0;
                        source0 = source0.next;
                        --n0;
                    }
                    if (target[dest] == null) {
                        target[dest] = n;
                    } else {
                        targetlast[dest].next = n;
                    }
                    targetlast[dest] = n;
                    n.next = null;
                }
                dest ^= 1;
            }
            blocksize <<= 1;
        }
        this.rRoot = target[0];
        this.rTail = targetlast[0];
        Trace.doAssert(this.rTail.next == null, "rTail not correct in Result.sortResult iSise =" + this.iSize);
    }

    private int compareRecord(Object[] a, Object[] b, int[] order, int[] way) throws SQLException {
        int i = Column.compare(a[order[0]], b[order[0]], this.colType[order[0]]);
        if (i == 0) {
            for (int j = 1; j < order.length; ++j) {
                i = Column.compare(a[order[j]], b[order[j]], this.colType[order[j]]);
                if (i == 0) continue;
                return i * way[j];
            }
        }
        return i * way[0];
    }

    private int compareRecord(Object[] a, Object[] b, int len) throws SQLException {
        for (int j = 0; j < len; ++j) {
            int i = Column.compare(a[j], b[j], this.colType[j]);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    byte[] getBytes() throws SQLException {
        try {
            BinaryServerRowOutput out = new BinaryServerRowOutput();
            out.writeIntData(this.iMode);
            if (this.iMode == 0) {
                out.writeIntData(this.iUpdateCount);
            } else if (this.iMode == 1) {
                out.writeIntData(this.errorCode);
                out.writeString(this.sError);
            } else {
                int l = this.iColumnCount;
                out.writeIntData(l);
                Record n = this.rRoot;
                for (int i = 0; i < l; ++i) {
                    out.writeType(this.colType[i]);
                    out.writeString(this.sLabel[i]);
                    out.writeString(this.sTable[i]);
                    out.writeString(this.sName[i]);
                }
                while (n != null) {
                    out.writeData(l, this.colType, n.data);
                    n = n.next;
                }
            }
            return out.toByteArray();
        }
        catch (IOException e) {
            throw Trace.error(19);
        }
    }

    private void prepareData(int columns) {
        this.iMode = 2;
        this.sLabel = new String[columns];
        this.sTable = new String[columns];
        this.sName = new String[columns];
        this.isLabelQuoted = new boolean[columns];
        this.colType = new int[columns];
        this.colSize = new int[columns];
        this.colScale = new int[columns];
    }
}

