/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.CachedRow;
import com.kingdee.eas.cp.hsqldb.HsqlDatabaseProperties;
import com.kingdee.eas.cp.hsqldb.ReverseDatabaseFile;
import com.kingdee.eas.cp.hsqldb.Table;
import com.kingdee.eas.cp.hsqldb.TextCache;
import com.kingdee.eas.cp.hsqldb.Trace;
import java.io.IOException;
import java.sql.SQLException;

class ReverseTextCache
extends TextCache {
    ReverseTextCache(String name, String propPrefix, HsqlDatabaseProperties props) throws SQLException {
        super(name, propPrefix, props);
    }

    @Override
    void open(boolean readonly) throws SQLException {
        try {
            if (!readonly) {
                throw Trace.error(29, "File '" + this.sName + "' must be read-only");
            }
            this.rFile = new ReverseDatabaseFile(this.sName, "r", 4096);
            this.iFreePos = (int)this.rFile.length();
        }
        catch (Exception e) {
            throw Trace.error(29, "error " + e + " opening " + this.sName);
        }
        this.readOnly = readonly;
    }

    @Override
    void flush() throws SQLException {
        this.closeFile();
    }

    @Override
    void purge() throws SQLException {
        this.closeFile();
    }

    @Override
    protected CachedRow makeRow(int pos, Table t) throws SQLException {
        CachedRow r = null;
        try {
            StringBuffer buffer = new StringBuffer(80);
            boolean blank = true;
            boolean complete = false;
            int nextPos = 0;
            try {
                char rowSep = '\u0000';
                int next = 0;
                this.rFile.readSeek(pos);
                do {
                    if ((next = this.rFile.read()) != -1) continue;
                    throw new Exception("break");
                } while ((rowSep = (char)(next & 0xFF)) != '\n' && rowSep != '\r');
                buffer.append('\n');
                boolean first = true;
                nextPos = (int)this.rFile.getFilePointer();
                while (true) {
                    if ((next = this.rFile.read()) == -1) {
                        complete = !blank && !this.ignoreFirst;
                        break;
                    }
                    ++nextPos;
                    char c = (char)(next & 0xFF);
                    if (first && rowSep == '\n' && c == '\r') {
                        c = '\n';
                    } else if (c == rowSep || c == '\n') {
                        if (!blank) {
                            --nextPos;
                            complete = true;
                            break;
                        }
                        pos += buffer.length();
                        buffer.setLength(0);
                        buffer.append(c);
                        blank = true;
                        first = true;
                        this.in.skippedLine();
                        continue;
                    }
                    first = false;
                    if (c != ' ' && c != '\n') {
                        blank = false;
                    }
                    buffer.append(c);
                }
            }
            catch (Exception e) {
                complete = false;
            }
            if (complete) {
                buffer.reverse();
                this.in.setSource(buffer.toString(), pos);
                this.in.setNextPos(nextPos);
                r = new CachedRow(t, this.in);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw Trace.error(29, "reading: " + e);
        }
        return r;
    }
}

