/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.CachedRow;
import com.kingdee.eas.cp.hsqldb.Node;
import com.kingdee.eas.cp.hsqldb.Record;
import com.kingdee.eas.cp.hsqldb.Table;
import java.sql.SQLException;

class Row {
    protected Object[] oData;
    protected Node nPrimaryNode;

    static Row newRow(Table t, Object[] o) throws SQLException {
        if (t.isCached()) {
            return new CachedRow(t, o);
        }
        return new Row(t, o);
    }

    Row() {
    }

    Row(Table t, Object[] o) throws SQLException {
        int index = t.getIndexCount();
        Node n = this.nPrimaryNode = Node.newNode(this, 0, t);
        for (int i = 1; i < index; ++i) {
            n = n.nNext = Node.newNode(this, i, t);
        }
        this.oData = o;
    }

    void setPrimaryNode(Node primary) {
        this.nPrimaryNode = primary;
    }

    Node getNode(int index) {
        Node n = this.nPrimaryNode;
        while (index-- > 0) {
            n = n.nNext;
        }
        return n;
    }

    Node getNextNode(Node n) {
        n = n == null ? this.nPrimaryNode : n.nNext;
        return n;
    }

    Object[] getData() {
        return this.oData;
    }

    void delete() throws SQLException {
        ++Record.memoryRecords;
        this.oData = null;
        this.nPrimaryNode = null;
    }
}

