/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.Cache;
import com.kingdee.eas.cp.hsqldb.CachedRow;
import com.kingdee.eas.cp.hsqldb.Column;
import com.kingdee.eas.cp.hsqldb.Constraint;
import com.kingdee.eas.cp.hsqldb.Database;
import com.kingdee.eas.cp.hsqldb.HsqlName;
import com.kingdee.eas.cp.hsqldb.Index;
import com.kingdee.eas.cp.hsqldb.Node;
import com.kingdee.eas.cp.hsqldb.Record;
import com.kingdee.eas.cp.hsqldb.Result;
import com.kingdee.eas.cp.hsqldb.Row;
import com.kingdee.eas.cp.hsqldb.Session;
import com.kingdee.eas.cp.hsqldb.Trace;
import com.kingdee.eas.cp.hsqldb.TriggerDef;
import com.kingdee.eas.cp.hsqldb.lib.ArrayUtil;
import com.kingdee.eas.cp.hsqldb.lib.StringUtil;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;

class Table {
    static final int SYSTEM_TABLE = 0;
    static final int TEMP_TABLE = 1;
    static final int MEMORY_TABLE = 2;
    static final int CACHED_TABLE = 3;
    static final int TEMP_TEXT_TABLE = 4;
    static final int TEXT_TABLE = 5;
    static final int VIEW = 6;
    static final String DEFAULT_PK = "";
    private Vector vColumn;
    private Vector vIndex;
    private int[] iPrimaryKey;
    private int iIndexCount;
    private int iIdentityColumn;
    private int iIdentityId;
    Vector vConstraint;
    Vector[] vTrigs;
    private int[] colTypes;
    private boolean isSystem;
    private boolean isText;
    private boolean isView;
    protected int iColumnCount;
    protected int iVisibleColumns;
    protected Database dDatabase;
    protected Cache cCache;
    protected HsqlName tableName;
    protected int tableType;
    protected Session ownerSession;
    protected boolean isReadOnly;
    protected boolean isTemp;
    protected boolean isCached;
    protected int indexType;

    Table(Database db, HsqlName name, int type, Session session) throws SQLException {
        this.dDatabase = db;
        if (type == 0) {
            this.isTemp = true;
        } else if (type == 1) {
            Trace.doAssert(session != null);
            this.isTemp = true;
            this.ownerSession = session;
        } else if (type == 3) {
            this.cCache = db.logger.getCache();
            if (this.cCache != null) {
                this.isCached = true;
            } else {
                type = 2;
            }
        } else if (type == 4) {
            Trace.doAssert(session != null);
            if (!db.logger.hasLog()) {
                throw Trace.error(63);
            }
            this.isTemp = true;
            this.isText = true;
            this.isReadOnly = true;
            this.isCached = true;
            this.ownerSession = session;
        } else if (type == 5) {
            if (!db.logger.hasLog()) {
                throw Trace.error(63);
            }
            this.isText = true;
            this.isCached = true;
        } else if (type == 6) {
            this.isView = true;
        }
        if (this.isText) {
            this.indexType = 2;
        } else if (this.isCached) {
            this.indexType = 1;
        }
        this.tableType = type;
        this.tableName = name;
        this.iPrimaryKey = null;
        this.iIdentityColumn = -1;
        this.vColumn = new Vector();
        this.vIndex = new Vector();
        this.vConstraint = new Vector();
        this.vTrigs = new Vector[TriggerDef.numTrigs()];
        for (int vi = 0; vi < TriggerDef.numTrigs(); ++vi) {
            this.vTrigs[vi] = new Vector();
        }
    }

    boolean equals(String other, Session c) {
        if (this.isTemp && c.getId() != this.ownerSession.getId()) {
            return false;
        }
        return this.tableName.name.equals(other);
    }

    boolean equals(String other) {
        return this.tableName.name.equals(other);
    }

    final boolean isText() {
        return this.isText;
    }

    final boolean isTemp() {
        return this.isTemp;
    }

    final boolean isView() {
        return this.isView;
    }

    final int getIndexType() {
        return this.indexType;
    }

    final boolean isDataReadOnly() {
        return this.isReadOnly;
    }

    void setDataReadOnly(boolean value) throws SQLException {
        this.isReadOnly = value;
    }

    Session getOwnerSession() {
        return this.ownerSession;
    }

    protected void setDataSource(String source, boolean isDesc, Session s) throws SQLException {
        throw Trace.error(22);
    }

    protected String getDataSource() throws SQLException {
        return null;
    }

    protected boolean isDescDataSource() throws SQLException {
        return false;
    }

    void addConstraint(Constraint c) {
        this.vConstraint.addElement(c);
    }

    Vector getConstraints() {
        return this.vConstraint;
    }

    Index getConstraintIndexForColumns(int[] col, boolean unique) {
        Index currentIndex = this.getPrimaryIndex();
        if (ArrayUtil.haveEquality(currentIndex.getColumns(), col, col.length, unique)) {
            return currentIndex;
        }
        for (int i = 0; i < this.vConstraint.size(); ++i) {
            Constraint c = (Constraint)this.vConstraint.elementAt(i);
            currentIndex = c.getMainIndex();
            if (!ArrayUtil.haveEquality(currentIndex.getColumns(), col, col.length, unique)) continue;
            return currentIndex;
        }
        return null;
    }

    int getNextConstraintIndex(int from, int type) {
        for (int i = from; i < this.vConstraint.size(); ++i) {
            Constraint c = (Constraint)this.vConstraint.elementAt(i);
            if (c.getType() != type) continue;
            return i;
        }
        return -1;
    }

    void addColumn(String name, int type) throws SQLException {
        Column column = new Column(new HsqlName(name, false), true, type, 0, 0, false, false, null);
        this.addColumn(column);
    }

    void addColumn(Column column) throws SQLException {
        if (this.searchColumn(column.columnName.name) >= 0) {
            throw Trace.error(27);
        }
        if (column.isIdentity()) {
            Trace.check(column.getType() == 4, 16, column.columnName.name);
            Trace.check(this.iIdentityColumn == -1, 24, column.columnName.name);
            this.iIdentityColumn = this.iColumnCount;
        }
        Trace.doAssert(this.iPrimaryKey == null, "Table.addColumn");
        this.vColumn.addElement(column);
        ++this.iColumnCount;
    }

    void addColumns(Result result) throws SQLException {
        for (int i = 0; i < result.getColumnCount(); ++i) {
            Column column = new Column(new HsqlName(result.sLabel[i], result.isLabelQuoted[i]), true, result.colType[i], result.colSize[i], result.colScale[i], false, false, null);
            this.addColumn(column);
        }
    }

    HsqlName getName() {
        return this.tableName;
    }

    void setName(String name, boolean isquoted) {
        this.tableName.rename(name, isquoted);
        if (HsqlName.isReservedName(this.getPrimaryIndex().getName().name)) {
            this.getPrimaryIndex().getName().rename("SYS_PK", name, isquoted);
        }
    }

    int getInternalColumnCount() {
        return this.iColumnCount;
    }

    protected Table duplicate() throws SQLException {
        Table t = new Table(this.dDatabase, this.tableName, this.tableType, this.ownerSession);
        return t;
    }

    void checkColumnsMatch(int[] col, Table other, int[] othercol) throws SQLException {
        if (col.length != othercol.length) {
            throw Trace.error(5);
        }
        for (int i = 0; i < col.length; ++i) {
            if (col[i] >= this.iColumnCount || othercol[i] >= other.iColumnCount) {
                throw Trace.error(5);
            }
            if (this.getColumn(col[i]).getType() == other.getColumn(othercol[i]).getType()) continue;
            throw Trace.error(57);
        }
    }

    Table moveDefinition(String withoutindex, Column newcolumn, int colindex, int adjust) throws SQLException {
        int[] primarykey;
        Table tn = this.duplicate();
        for (int i = 0; i < this.iVisibleColumns + 1; ++i) {
            if (i == colindex) {
                if (adjust > 0) {
                    tn.addColumn(newcolumn);
                } else if (adjust < 0) continue;
            }
            if (i == this.iVisibleColumns) break;
            tn.addColumn(this.getColumn(i));
        }
        int[] nArray = primarykey = this.iPrimaryKey[0] == this.iVisibleColumns ? null : this.iPrimaryKey;
        if (primarykey != null) {
            int[] newpk = ArrayUtil.toAdjustedColumnArray(primarykey, colindex, adjust);
            if (primarykey.length != newpk.length) {
                throw Trace.error(25);
            }
            primarykey = newpk;
        }
        tn.createPrimaryKey(this.getIndex(0).getName(), primarykey);
        tn.vConstraint = this.vConstraint;
        for (int i = 1; i < this.getIndexCount(); ++i) {
            Index newidx;
            Index idx = this.getIndex(i);
            if (withoutindex != null && idx.getName().name.equals(withoutindex) || (newidx = tn.createAdjustedIndex(idx, colindex, adjust)) != null) continue;
            throw Trace.error(23);
        }
        return tn;
    }

    void updateConstraints(Table to, int colindex, int adjust) throws SQLException {
        for (int j = 0; j < this.vConstraint.size(); ++j) {
            Constraint c = (Constraint)this.vConstraint.elementAt(j);
            c.replaceTable(to, this, colindex, adjust);
        }
    }

    int getColumnCount() {
        return this.iVisibleColumns;
    }

    int getIndexCount() {
        return this.iIndexCount;
    }

    int getIdentityColumn() {
        return this.iIdentityColumn;
    }

    int getColumnNr(String c) throws SQLException {
        int i = this.searchColumn(c);
        if (i == -1) {
            throw Trace.error(28, c);
        }
        return i;
    }

    int searchColumn(String c) {
        for (int i = 0; i < this.iColumnCount; ++i) {
            if (!c.equals(((Column)this.vColumn.elementAt((int)i)).columnName.name)) continue;
            return i;
        }
        return -1;
    }

    Index getPrimaryIndex() {
        if (this.iPrimaryKey == null) {
            return null;
        }
        return this.getIndex(0);
    }

    Index getIndexForColumn(int column) throws SQLException {
        for (int i = 0; i < this.iIndexCount; ++i) {
            Index h = this.getIndex(i);
            if (h.getColumns()[0] != column) continue;
            return h;
        }
        return null;
    }

    Index getIndexForColumns(int[] col, boolean unique) throws SQLException {
        for (int i = 0; i < this.iIndexCount; ++i) {
            Index currentindex = this.getIndex(i);
            int[] indexcol = currentindex.getColumns();
            if (!ArrayUtil.haveEquality(indexcol, col, col.length, unique) || unique && !currentindex.isUnique()) continue;
            return currentindex;
        }
        return null;
    }

    int[] getIndexRootsArray() throws SQLException {
        int[] roots = new int[this.iIndexCount];
        for (int i = 0; i < this.iIndexCount; ++i) {
            Node f = this.getIndex(i).getRoot();
            roots[i] = f != null ? f.getKey() : -1;
        }
        return roots;
    }

    String getIndexRoots() throws SQLException {
        Trace.doAssert(this.isCached, "Table.getIndexRootData");
        String roots = StringUtil.getList(this.getIndexRootsArray(), " ", DEFAULT_PK);
        StringBuffer s = new StringBuffer(roots);
        s.append(' ');
        s.append(this.iIdentityId);
        return s.toString();
    }

    void setIndexRoots(int[] roots) throws SQLException {
        Trace.check(this.isCached, 22);
        for (int i = 0; i < this.iIndexCount; ++i) {
            int p = roots[i];
            CachedRow r = null;
            if (p != -1) {
                r = this.cCache.getRow(p, this);
            }
            Node f = null;
            if (r != null) {
                f = ((Row)r).getNode(i);
            }
            this.getIndex(i).setRoot(f);
        }
    }

    void setIndexRoots(String s) throws SQLException {
        Trace.check(this.isCached, 22);
        int[] roots = new int[this.iIndexCount];
        int j = 0;
        for (int i = 0; i < this.iIndexCount; ++i) {
            int p;
            int n = s.indexOf(32, j);
            roots[i] = p = Integer.parseInt(s.substring(j, n));
            j = n + 1;
        }
        this.setIndexRoots(roots);
        this.iIdentityId = Integer.parseInt(s.substring(j));
    }

    Index getNextIndex(Index index) {
        int i;
        if (index != null) {
            for (i = 0; i < this.iIndexCount && this.getIndex(i) != index; ++i) {
            }
            ++i;
        }
        if (i < this.iIndexCount) {
            return this.getIndex(i);
        }
        return null;
    }

    void createPrimaryKey() throws SQLException {
        this.createPrimaryKey(null, null);
    }

    void createPrimaryKey(HsqlName pkName, int[] columns) throws SQLException {
        Trace.doAssert(this.iPrimaryKey == null, "Table.createPrimaryKey(column)");
        this.iVisibleColumns = this.iColumnCount;
        if (columns == null) {
            columns = new int[]{this.iColumnCount};
            Column column = new Column(new HsqlName(DEFAULT_PK, false), false, 4, 0, 0, true, true, null);
            this.addColumn(column);
        } else {
            for (int i = 0; i < columns.length; ++i) {
                this.getColumn(columns[i]).setNullable(false);
                this.getColumn(columns[i]).setPrimaryKey(true);
            }
        }
        this.iPrimaryKey = columns;
        HsqlName name = pkName != null ? pkName : new HsqlName("SYS_PK", this.tableName.name, this.tableName.isNameQuoted);
        this.createIndexPrivate(columns, name, true);
        this.colTypes = new int[this.iColumnCount];
        for (int i = 0; i < this.iColumnCount; ++i) {
            this.colTypes[i] = this.getColumn(i).getType();
        }
    }

    private Index createAdjustedIndex(Index index, int colindex, int adjust) throws SQLException {
        int[] colarr = ArrayUtil.getAdjustedColumnArray(index.getColumns(), index.getVisibleColumns(), colindex, adjust);
        if (colarr.length != index.getVisibleColumns()) {
            return null;
        }
        return this.createIndexPrivate(colarr, index.getName(), index.isUnique());
    }

    Index createIndexPrivate(int[] column, HsqlName name, boolean unique) throws SQLException {
        int j;
        Trace.doAssert(this.iPrimaryKey != null, "createIndex");
        int s = column.length;
        int t = this.iPrimaryKey.length;
        int[] col = new int[unique ? s : s + t];
        int[] type = new int[unique ? s : s + t];
        for (j = 0; j < s; ++j) {
            col[j] = column[j];
            type[j] = this.getColumn(col[j]).getType();
        }
        if (!unique) {
            for (j = 0; j < t; ++j) {
                col[s + j] = this.iPrimaryKey[j];
                type[s + j] = this.getColumn(this.iPrimaryKey[j]).getType();
            }
        }
        if (col[0] == this.iVisibleColumns) {
            s = 0;
        }
        Index newindex = new Index(name, this, col, type, unique, s);
        Trace.doAssert(this.isEmpty(), "createIndex");
        this.vIndex.addElement(newindex);
        ++this.iIndexCount;
        return newindex;
    }

    void checkDropIndex(String indexname, Hashtable ignore) throws SQLException {
        Index index = this.getIndex(indexname);
        if (index == null) {
            throw Trace.error(26, indexname);
        }
        if (index.equals(this.getIndex(0))) {
            throw Trace.error(25, indexname);
        }
        for (int i = 0; i < this.vConstraint.size(); ++i) {
            Constraint c = (Constraint)this.vConstraint.elementAt(i);
            if (ignore.get(c) != null) continue;
            if (c.isIndexFK(index)) {
                throw Trace.error(50, indexname);
            }
            if (!c.isIndexUnique(index)) continue;
            throw Trace.error(56, indexname);
        }
    }

    boolean isEmpty() {
        if (this.iIndexCount == 0) {
            return true;
        }
        return this.getIndex(0).getRoot() == null;
    }

    Object[] getNewRow() {
        return new Object[this.iColumnCount];
    }

    void moveData(Table from, int colindex, int adjust) throws SQLException {
        Object colvalue = null;
        if (adjust > 0) {
            Column column = this.getColumn(colindex);
            colvalue = Column.convertObject(column.getDefaultString(), column.getType());
        }
        Index index = from.getPrimaryIndex();
        Node n = index.first();
        while (n != null) {
            Object[] o = n.getData();
            Object[] newrow = this.getNewRow();
            ArrayUtil.copyAdjustArray(o, newrow, colvalue, colindex, adjust);
            this.insertNoCheck(newrow, null, false);
            n = index.next(n);
        }
        index = from.getPrimaryIndex();
        n = index.first();
        while (n != null) {
            Node nextnode = index.next(n);
            Object[] o = n.getData();
            from.deleteNoCheck(o, null, false);
            n = nextnode;
        }
    }

    void checkUpdate(int[] col, Result deleted, Result inserted) throws SQLException {
        Trace.check(!this.isReadOnly, 32);
        if (this.dDatabase.isReferentialIntegrity()) {
            for (int i = 0; i < this.vConstraint.size(); ++i) {
                Constraint v = (Constraint)this.vConstraint.elementAt(i);
                v.checkUpdate(col, deleted, inserted);
            }
        }
    }

    void insert(Result result, Session c) throws SQLException {
        Record r = result.rRoot;
        int len = result.getColumnCount();
        while (r != null) {
            Object[] row = this.getNewRow();
            for (int i = 0; i < len; ++i) {
                row[i] = r.data[i];
            }
            this.insert(row, c);
            r = r.next;
        }
    }

    void insert(Object[] row, Session c) throws SQLException {
        Trace.check(!this.isReadOnly, 32);
        this.fireAll(3, row);
        if (this.dDatabase.isReferentialIntegrity()) {
            for (int i = 0; i < this.vConstraint.size(); ++i) {
                ((Constraint)this.vConstraint.elementAt(i)).checkInsert(row);
            }
        }
        this.insertNoCheck(row, c, true);
        this.fireAll(0, row);
    }

    void insertNoCheck(Object[] row, Session c, boolean log) throws SQLException {
        for (int i = 0; i < this.iColumnCount; ++i) {
            boolean nullOK;
            if (row[i] != null) continue;
            Column col = this.getColumn(i);
            boolean bl = nullOK = col.isNullable() || col.isIdentity();
            if (nullOK) continue;
            throw Trace.error(10);
        }
        int nextId = this.iIdentityId;
        if (this.iIdentityColumn != -1) {
            Number id = (Number)row[this.iIdentityColumn];
            if (id == null) {
                row[this.iIdentityColumn] = new Integer(this.iIdentityId);
            } else {
                int columnId = id.intValue();
                if (this.iIdentityId < columnId) {
                    this.iIdentityId = nextId = columnId;
                }
            }
        }
        Row r = Row.newRow(this, row);
        nextId = this.isText ? ((CachedRow)r).iPos + ((CachedRow)r).storageSize : ++nextId;
        this.indexRow(r, true);
        if (c != null) {
            c.setLastIdentity(this.iIdentityId);
            c.addTransactionInsert(this, row);
        }
        this.iIdentityId = nextId;
        if (log && !this.isTemp && !this.isReadOnly && this.dDatabase.logger.hasLog()) {
            this.dDatabase.logger.writeToLog(c, this.getInsertStatement(row));
        }
    }

    void fireAll(int trigVecIndx, Object[] row) {
        if (!this.dDatabase.isReferentialIntegrity()) {
            return;
        }
        Vector trigVec = this.vTrigs[trigVecIndx];
        int trCount = trigVec.size();
        for (int i = 0; i < trCount; ++i) {
            TriggerDef td = (TriggerDef)trigVec.elementAt(i);
            td.push(row);
        }
    }

    void fireAll(int trigVecIndx) {
        Object[] row = new Object[]{new String("Statement-level")};
        this.fireAll(trigVecIndx, row);
    }

    void addTrigger(TriggerDef trigDef) {
        if (Trace.TRACE) {
            Trace.trace("Trigger added " + String.valueOf(trigDef.vectorIndx));
        }
        this.vTrigs[trigDef.vectorIndx].addElement(trigDef);
    }

    void checkCascadeDelete(Object[] row, Session session, boolean delete) throws SQLException {
        block0: for (int i = 0; i < this.vConstraint.size(); ++i) {
            boolean hasref;
            Node refnode;
            Constraint c = (Constraint)this.vConstraint.elementAt(i);
            if (c.getType() != 1 || c.getRef() == null || (refnode = c.findFkRef(row)) == null) continue;
            Table reftable = c.getRef();
            boolean bl = hasref = reftable.getNextConstraintIndex(0, 1) != -1;
            if (!delete && !hasref) {
                return;
            }
            Index refindex = c.getRefIndex();
            int[] maincolumns = c.getMainColumns();
            Object[] mainobjects = new Object[maincolumns.length];
            ArrayUtil.copyColumnValues(row, maincolumns, mainobjects);
            Node n = refnode;
            while (refindex.comparePartialRowNonUnique(mainobjects, n.getData()) == 0) {
                Node nextn = refindex.next(n);
                if (hasref) {
                    reftable.checkCascadeDelete(n.getData(), session, delete);
                }
                if (delete) {
                    reftable.deleteNoRefCheck(n.getData(), session);
                    if (reftable == this) {
                        nextn = c.findFkRef(row);
                    }
                }
                if (nextn == null) continue block0;
                n = nextn;
            }
        }
    }

    void delete(Object[] row, Session session) throws SQLException {
        this.fireAll(10, row);
        if (this.dDatabase.isReferentialIntegrity()) {
            this.checkCascadeDelete(row, session, false);
            this.checkCascadeDelete(row, session, true);
        }
        this.deleteNoCheck(row, session, true);
        this.fireAll(7, row);
    }

    private void deleteNoRefCheck(Object[] row, Session session) throws SQLException {
        this.fireAll(10, row);
        this.deleteNoCheck(row, session, true);
        this.fireAll(7, row);
    }

    void deleteNoCheck(Object[] row, Session c, boolean log) throws SQLException {
        for (int i = 1; i < this.iIndexCount; ++i) {
            this.getIndex(i).delete(row, false);
        }
        this.getIndex(0).delete(row, true);
        if (c != null) {
            c.addTransactionDelete(this, row);
        }
        if (log && !this.isTemp && !this.isReadOnly && this.dDatabase.logger.hasLog()) {
            this.dDatabase.logger.writeToLog(c, this.getDeleteStatement(row));
        }
    }

    String getInsertStatement(Object[] row) throws SQLException {
        StringBuffer a = new StringBuffer(128);
        a.append("INSERT INTO ");
        a.append(this.tableName.statementName);
        a.append(" VALUES(");
        for (int i = 0; i < this.iVisibleColumns; ++i) {
            a.append(Column.createSQLString(row[i], this.getColumn(i).getType()));
            a.append(',');
        }
        a.setCharAt(a.length() - 1, ')');
        return a.toString();
    }

    boolean isCached() {
        return this.isCached;
    }

    boolean isIndexCached() {
        return this.isCached;
    }

    Index getIndex(String s) {
        for (int i = 0; i < this.iIndexCount; ++i) {
            Index h = this.getIndex(i);
            if (!s.equals(h.getName().name)) continue;
            return h;
        }
        return null;
    }

    int getConstraintIndex(String s) {
        for (int j = 0; j < this.vConstraint.size(); ++j) {
            Constraint tempc = (Constraint)this.vConstraint.elementAt(j);
            if (!tempc.getName().name.equals(s)) continue;
            return j;
        }
        return -1;
    }

    Constraint getConstraint(String s) {
        int j = this.getConstraintIndex(s);
        if (j >= 0) {
            return (Constraint)this.vConstraint.elementAt(j);
        }
        return null;
    }

    Column getColumn(int i) {
        return (Column)this.vColumn.elementAt(i);
    }

    int[] getColumnTypes() {
        return this.colTypes;
    }

    protected Index getIndex(int i) {
        return (Index)this.vIndex.elementAt(i);
    }

    private String getDeleteStatement(Object[] row) throws SQLException {
        StringBuffer a = new StringBuffer(128);
        a.append("DELETE FROM ");
        a.append(this.tableName.statementName);
        a.append(" WHERE ");
        if (this.iVisibleColumns < this.iColumnCount) {
            for (int i = 0; i < this.iVisibleColumns; ++i) {
                Column c = this.getColumn(i);
                a.append(c.columnName.statementName);
                a.append('=');
                a.append(Column.createSQLString(row[i], c.getType()));
                if (i >= this.iVisibleColumns - 1) continue;
                a.append(" AND ");
            }
        } else {
            for (int i = 0; i < this.iPrimaryKey.length; ++i) {
                Column c = this.getColumn(this.iPrimaryKey[i]);
                a.append(c.columnName.statementName);
                a.append('=');
                a.append(Column.createSQLString(row[this.iPrimaryKey[i]], c.getType()));
                if (i >= this.iPrimaryKey.length - 1) continue;
                a.append(" AND ");
            }
        }
        return a.toString();
    }

    Row getRow(int pos) throws SQLException {
        if (this.isCached) {
            return this.cCache.getRow(pos, this);
        }
        return null;
    }

    void putRow(CachedRow r) throws SQLException {
        boolean size = false;
        if (this.cCache != null) {
            this.cCache.add(r);
        }
    }

    void removeRow(CachedRow r) throws SQLException {
        if (this.cCache != null) {
            this.cCache.free(r);
        }
    }

    void cleanUp() throws SQLException {
        if (this.cCache != null) {
            this.cCache.cleanUp();
        }
    }

    void indexRow(Row r, boolean inserted) throws SQLException {
        if (inserted) {
            int i;
            try {
                Node n = null;
                for (i = 0; i < this.iIndexCount; ++i) {
                    n = r.getNextNode(n);
                    this.getIndex(i).insert(n);
                }
            }
            catch (SQLException e) {
                --i;
                while (i >= 0) {
                    this.getIndex(i).delete(r.getData(), i == 0);
                    --i;
                }
                throw e;
            }
        }
    }
}

