/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.ByteArray;
import com.kingdee.eas.cp.hsqldb.DatabaseRowInput;
import com.kingdee.eas.cp.hsqldb.DatabaseRowInputInterface;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

class TextDatabaseRowInput
extends DatabaseRowInput
implements DatabaseRowInputInterface {
    private String fieldSep;
    private String varSep;
    private String longvarSep;
    private int fieldSepLen;
    private int varSepLen;
    private int longvarSepLen;
    private boolean fieldSepEnd;
    private boolean varSepEnd;
    private boolean longvarSepEnd;
    private int textLen;
    protected String text;
    protected int line;
    protected int field;
    protected int next = 0;
    protected boolean emptyIsNull;

    public TextDatabaseRowInput(String fieldSep, String varSep, String longvarSep, boolean emptyIsNull) throws IOException {
        super(new ByteArrayInputStream(new byte[0]));
        this.makeSystemId = true;
        if (fieldSep.endsWith("\n")) {
            this.fieldSepEnd = true;
            fieldSep = fieldSep.substring(0, fieldSep.length() - 1);
        }
        if (varSep.endsWith("\n")) {
            this.varSepEnd = true;
            varSep = varSep.substring(0, varSep.length() - 1);
        }
        if (longvarSep.endsWith("\n")) {
            this.longvarSepEnd = true;
            longvarSep = longvarSep.substring(0, longvarSep.length() - 1);
        }
        this.emptyIsNull = emptyIsNull;
        this.fieldSep = fieldSep;
        this.varSep = varSep;
        this.longvarSep = longvarSep;
        this.fieldSepLen = fieldSep.length();
        this.varSepLen = varSep.length();
        this.longvarSepLen = longvarSep.length();
    }

    public void setSource(String text, int pos) {
        this.text = text.substring(0, text.indexOf(10));
        this.textLen = this.text.length();
        this.pos = pos;
        this.size = text.length();
        this.nextPos = pos + this.size;
        this.next = 0;
        ++this.line;
        this.field = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getField(String sep, int sepLen, boolean isEnd) throws IOException {
        String s = this.emptyIsNull ? null : "";
        try {
            int start = this.next;
            ++this.field;
            if (isEnd) {
                if (this.next >= this.textLen && sepLen > 0) {
                    throw new Exception("No end sep.");
                }
                if (!this.text.endsWith(sep)) throw new Exception("No end sep.");
                this.next = this.textLen - sepLen;
            } else {
                this.next = this.text.indexOf(sep, start);
                if (this.next == -1) {
                    this.next = this.textLen;
                }
            }
            s = this.text.substring(start, this.next);
            this.next += sepLen;
            if (!this.emptyIsNull) return s;
            if (!s.equals("")) return s;
            return null;
        }
        catch (Exception e) {
            throw new IOException("line " + this.line + ", field " + this.field + " (" + e.getMessage() + ")");
        }
    }

    @Override
    public String readString() throws IOException {
        return this.getField(this.fieldSep, this.fieldSepLen, this.fieldSepEnd);
    }

    private String readVarString() throws IOException {
        return this.getField(this.varSep, this.varSepLen, this.varSepEnd);
    }

    private String readLongVarString() throws IOException {
        return this.getField(this.longvarSep, this.longvarSepLen, this.longvarSepEnd);
    }

    private byte[] readByteArray(String field) throws IOException, SQLException {
        char[] from = field.toCharArray();
        StringBuffer to = new StringBuffer();
        for (int i = 0; i < from.length; ++i) {
            String hex = Integer.toHexString(from[i]);
            if (hex.length() == 1) {
                to.append("0");
            }
            to.append(hex);
        }
        return ByteArray.hexToByteArray(to.toString());
    }

    @Override
    public int readIntData() throws IOException {
        String s = this.readString();
        if (s == null) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    @Override
    public int readType() throws IOException {
        return 0;
    }

    @Override
    protected boolean checkNull() {
        return false;
    }

    @Override
    protected String readChar(int type) throws IOException {
        switch (type) {
            case 1: {
                return this.readString();
            }
            case 12: 
            case 100: {
                return this.readVarString();
            }
        }
        return this.readLongVarString();
    }

    @Override
    protected Integer readSmallint() throws IOException, SQLException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        return Integer.valueOf(s);
    }

    @Override
    protected Integer readInteger() throws IOException, SQLException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        return Integer.valueOf(s);
    }

    @Override
    protected Long readBigint() throws IOException, SQLException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        return Long.valueOf(s);
    }

    @Override
    protected Double readReal(int type) throws IOException, SQLException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        return Double.valueOf(s);
    }

    @Override
    protected BigDecimal readDecimal() throws IOException, SQLException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        return new BigDecimal(s);
    }

    @Override
    protected Time readTime() throws IOException, SQLException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        return Time.valueOf(s);
    }

    @Override
    protected Date readDate() throws IOException, SQLException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        return Date.valueOf(s);
    }

    @Override
    protected Timestamp readTimestamp() throws IOException, SQLException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        return Timestamp.valueOf(s);
    }

    @Override
    protected Boolean readBit() throws IOException, SQLException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        return Boolean.valueOf(s);
    }

    @Override
    protected Object readOther() throws IOException, SQLException {
        String s = this.readLongVarString();
        if (s == null) {
            return null;
        }
        byte[] o = this.readByteArray(s);
        return ByteArray.deserialize(o);
    }

    @Override
    protected byte[] readBinary(int type) throws IOException, SQLException {
        switch (type) {
            case -2: {
                String s = this.readString();
                if (s == null) {
                    return null;
                }
                return this.readByteArray(s);
            }
            case -3: {
                String s = this.readVarString();
                if (s == null) {
                    return null;
                }
                return this.readByteArray(s);
            }
        }
        String s = this.readLongVarString();
        if (s == null) {
            return null;
        }
        return this.readByteArray(s);
    }

    public void setNextPos(int pos) {
        this.nextPos = pos;
    }

    public void skippedLine() {
        ++this.line;
    }

    @Override
    public void reset() {
        this.text = "";
        this.textLen = 0;
        this.pos = 0;
        this.size = 0;
        this.nextPos = 0;
        this.next = 0;
        this.field = 0;
        this.line = 0;
    }
}

