/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.Database;
import com.kingdee.eas.cp.hsqldb.HsqlName;
import com.kingdee.eas.cp.hsqldb.Index;
import com.kingdee.eas.cp.hsqldb.Node;
import com.kingdee.eas.cp.hsqldb.Result;
import com.kingdee.eas.cp.hsqldb.Row;
import com.kingdee.eas.cp.hsqldb.Session;
import com.kingdee.eas.cp.hsqldb.Table;
import com.kingdee.eas.cp.hsqldb.TextCache;
import com.kingdee.eas.cp.hsqldb.Trace;
import java.sql.SQLException;

class TextTable
extends Table {
    private String readRoots = "";
    private String emptyRoots = "";
    private String dataSource = "";
    private String firstLine = "";
    private boolean isReversed = false;

    TextTable(Database db, HsqlName name, int type, Session session) throws SQLException {
        super(db, name, type, session);
    }

    private void openCache(String source, boolean isDesc, boolean isRdOnly) throws SQLException {
        if (!this.dataSource.equals("")) {
            this.dDatabase.logger.closeTextCache(this.tableName.name);
        }
        this.cCache = null;
        int count = this.getIndexCount();
        for (int i = 0; i < count; ++i) {
            this.getIndex(i).setRoot(null);
        }
        if (source != null && !source.equals("")) {
            try {
                this.cCache = this.dDatabase.logger.openTextCache(this.tableName.name, source, isRdOnly, isDesc);
                int freePos = this.cCache.getFreePos();
                String roots = this.readRoots;
                if (freePos <= TextCache.NL.length()) {
                    roots = this.emptyRoots;
                }
                roots = roots + freePos;
                super.setIndexRoots(roots);
            }
            catch (SQLException e) {
                if (!this.dataSource.equals(source) || isDesc != this.isReversed || isRdOnly != this.isReadOnly) {
                    this.openCache(this.dataSource, this.isReversed, this.isReadOnly);
                } else {
                    if (this.cCache != null) {
                        this.cCache.closeFile();
                    }
                    this.dataSource = "";
                    this.isReversed = false;
                }
                throw e;
            }
        }
        if (source == null) {
            source = "";
        }
        this.dataSource = source;
        this.isReversed = isDesc && !source.equals("");
    }

    @Override
    boolean equals(String other, Session c) {
        boolean isEqual = super.equals(other, c);
        if (isEqual && this.isReversed) {
            try {
                this.openCache(this.dataSource, this.isReversed, this.isReadOnly);
            }
            catch (SQLException e) {
                return false;
            }
        }
        return isEqual;
    }

    @Override
    boolean equals(String other) {
        boolean isEqual = super.equals(other);
        if (isEqual && this.isReversed) {
            try {
                this.openCache(this.dataSource, this.isReversed, this.isReadOnly);
            }
            catch (SQLException e) {
                return false;
            }
        }
        return isEqual;
    }

    @Override
    protected void setDataSource(String source, boolean isDesc, Session s) throws SQLException {
        if (this.isTemp) {
            Trace.check(s.getId() == this.ownerSession.getId(), 33);
        } else {
            s.checkAdmin();
        }
        if (isDesc || isDesc != this.isReversed || !this.dataSource.equals(source)) {
            this.openCache(source, isDesc, this.isReadOnly);
        }
        if (this.isReversed) {
            this.isReadOnly = true;
        }
    }

    @Override
    protected String getDataSource() throws SQLException {
        return this.dataSource;
    }

    @Override
    protected boolean isDescDataSource() throws SQLException {
        return this.isReversed;
    }

    @Override
    void setDataReadOnly(boolean value) throws SQLException {
        if (this.isReversed && value) {
            throw Trace.error(32);
        }
        this.openCache(this.dataSource, this.isReversed, value);
        this.isReadOnly = value;
    }

    @Override
    String getIndexRoots() throws SQLException {
        Trace.doAssert(this.isCached, "Table.getIndexRootData");
        return this.readRoots + "0";
    }

    @Override
    void setIndexRoots(String s) throws SQLException {
        Trace.check(this.isCached, 22);
    }

    @Override
    boolean isIndexCached() {
        return false;
    }

    @Override
    protected Table duplicate() throws SQLException {
        return new TextTable(this.dDatabase, this.tableName, this.tableType, this.ownerSession);
    }

    @Override
    void indexRow(Row r, boolean inserted) throws SQLException {
        if (inserted) {
            super.indexRow(r, true);
        } else {
            Node n = r.getNextNode(null);
            Node primary = this.getPrimaryIndex().insertUncached(n);
            if (primary == n) {
                n = r.getNextNode(n);
                int i = 1;
                while (n != null) {
                    this.getIndex(i).insertUncached(n);
                    n = r.getNextNode(n);
                    ++i;
                }
            } else {
                r.setPrimaryNode(primary);
            }
        }
    }

    @Override
    void checkUpdate(int[] col, Result deleted, Result inserted) throws SQLException {
        Trace.check(!this.dataSource.equals(""), 48);
        super.checkUpdate(col, deleted, inserted);
    }

    @Override
    void insert(Object[] row, Session c) throws SQLException {
        Trace.check(!this.dataSource.equals(""), 48);
        super.insert(row, c);
    }

    @Override
    void delete(Object[] row, Session c) throws SQLException {
        Trace.check(!this.dataSource.equals(""), 48);
        super.delete(row, c);
    }

    @Override
    Index createIndexPrivate(int[] column, HsqlName name, boolean unique) throws SQLException {
        this.readRoots = this.readRoots + "0 ";
        this.emptyRoots = this.emptyRoots + "-1 ";
        return super.createIndexPrivate(column, name, unique);
    }

    void createPrimaryKey(String pkName, int[] columns) throws SQLException {
        if (!(columns == null || columns.length == 1 && this.getColumn((int)columns[0]).columnName.name.equals(""))) {
            throw Trace.error(24);
        }
        super.createPrimaryKey(null, columns);
    }
}

