/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import java.io.File;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.sql.SQLException;

public class Trace
extends PrintWriter {
    public static boolean TRACE = false;
    public static boolean TRACESYSTEMOUT = false;
    public static final boolean STOP = false;
    public static final boolean DOASSERT = false;
    private static Trace tTracer = new Trace();
    private static String sTrace;
    private static int iStop;
    public static final int DATABASE_ALREADY_IN_USE = 1;
    public static final int CONNECTION_IS_CLOSED = 2;
    public static final int CONNECTION_IS_BROKEN = 3;
    public static final int DATABASE_IS_SHUTDOWN = 4;
    public static final int COLUMN_COUNT_DOES_NOT_MATCH = 5;
    public static final int DIVISION_BY_ZERO = 6;
    public static final int INVALID_ESCAPE = 7;
    public static final int INTEGRITY_CONSTRAINT_VIOLATION = 8;
    public static final int VIOLATION_OF_UNIQUE_INDEX = 9;
    public static final int TRY_TO_INSERT_NULL = 10;
    public static final int UNEXPECTED_TOKEN = 11;
    public static final int UNEXPECTED_END_OF_COMMAND = 12;
    public static final int UNKNOWN_FUNCTION = 13;
    public static final int NEED_AGGREGATE = 14;
    public static final int SUM_OF_NON_NUMERIC = 15;
    public static final int WRONG_DATA_TYPE = 16;
    public static final int SINGLE_VALUE_EXPECTED = 17;
    public static final int SERIALIZATION_FAILURE = 18;
    public static final int TRANSFER_CORRUPTED = 19;
    public static final int FUNCTION_NOT_SUPPORTED = 20;
    public static final int TABLE_ALREADY_EXISTS = 21;
    public static final int TABLE_NOT_FOUND = 22;
    public static final int INDEX_ALREADY_EXISTS = 23;
    public static final int SECOND_PRIMARY_KEY = 24;
    public static final int DROP_PRIMARY_KEY = 25;
    public static final int INDEX_NOT_FOUND = 26;
    public static final int COLUMN_ALREADY_EXISTS = 27;
    public static final int COLUMN_NOT_FOUND = 28;
    public static final int FILE_IO_ERROR = 29;
    public static final int WRONG_DATABASE_FILE_VERSION = 30;
    public static final int DATABASE_IS_READONLY = 31;
    public static final int DATA_IS_READONLY = 32;
    public static final int ACCESS_IS_DENIED = 33;
    public static final int INPUTSTREAM_ERROR = 34;
    public static final int NO_DATA_IS_AVAILABLE = 35;
    public static final int USER_ALREADY_EXISTS = 36;
    public static final int USER_NOT_FOUND = 37;
    public static final int ASSERT_FAILED = 38;
    public static final int EXTERNAL_STOP = 39;
    public static final int GENERAL_ERROR = 40;
    public static final int WRONG_OUT_PARAMETER = 41;
    public static final int ERROR_IN_FUNCTION = 42;
    public static final int TRIGGER_NOT_FOUND = 43;
    public static final int SAVEPOINT_NOT_FOUND = 44;
    public static final int LABEL_REQUIRED = 45;
    public static final int WRONG_DEFAULT_CLAUSE = 46;
    public static final int FOREIGN_KEY_NOT_ALLOWED = 47;
    public static final int UNKNOWN_DATA_SOURCE = 48;
    public static final int BAD_INDEX_CONSTRAINT_NAME = 49;
    public static final int DROP_FK_INDEX = 50;
    public static final int RESULTSET_FORWARD_ONLY = 51;
    public static final int VIEW_ALREADY_EXISTS = 52;
    public static final int VIEW_NOT_FOUND = 53;
    public static final int NOT_A_VIEW = 54;
    public static final int NOT_A_TABLE = 55;
    public static final int SYSTEM_INDEX = 56;
    public static final int COLUMN_TYPE_MISMATCH = 57;
    public static final int BAD_ADD_COLUMN_DEFINITION = 58;
    public static final int DROP_SYSTEM_CONSTRAINT = 59;
    public static final int CONSTRAINT_ALREADY_EXISTS = 60;
    public static final int CONSTRAINT_NOT_FOUND = 61;
    public static final int INVALID_JDBC_ARGUMENT = 62;
    public static final int DATABASE_IS_MEMORY_ONLY = 63;
    public static final int OUTER_JOIN_CONDITION = 64;
    public static final int NUMERIC_VALUE_OUT_OF_RANGE = 65;
    private static String[] sDescription;

    static SQLException getError(int code, Object add) {
        code = Math.abs(code);
        String s = Trace.getMessage(code);
        if (add != null) {
            s = s + ": " + add.toString();
        }
        return new SQLException(s.substring(6), s.substring(0, 5), -code);
    }

    static SQLException getError(String msg, int code) {
        code = Math.abs(code);
        String s = Trace.getMessage(code);
        return new SQLException(msg, s.substring(0, 5), -code);
    }

    static String getMessage(int code) {
        return sDescription[code];
    }

    static String getMessage(SQLException e) {
        return e.getSQLState() + " " + e.getMessage();
    }

    static SQLException getError(String msg) {
        return new SQLException(msg.substring(6), msg.substring(0, 5), -40);
    }

    public static SQLException error(int code) {
        return Trace.getError(code, null);
    }

    public static SQLException error(int code, String s) {
        return Trace.getError(code, s);
    }

    public static SQLException error(int code, int i) {
        return Trace.getError(code, String.valueOf(i));
    }

    static void doAssert(boolean condition) throws SQLException {
        Trace.doAssert(condition, null);
    }

    static void doAssert(boolean condition, String error) throws SQLException {
        if (!condition) {
            Trace.printStack();
            throw Trace.getError(38, error);
        }
    }

    static void check(boolean condition, int code) throws SQLException {
        Trace.check(condition, code, null);
    }

    static void check(boolean condition, int code, Object add) throws SQLException {
        if (!condition) {
            throw Trace.getError(code, add);
        }
    }

    @Override
    public void println(char[] c) {
        String s = new String(c);
        if (sTrace.equals("") && s.indexOf("hsqldb.Trace") == -1 && s.indexOf("hsqldb") != -1) {
            int i = s.indexOf(46);
            if (i != -1) {
                s = s.substring(i + 1);
            }
            if ((i = s.indexOf(40)) != -1) {
                s = s.substring(0, i);
            }
            sTrace = s;
        }
    }

    @Override
    public void println(String s) {
        if (sTrace.equals("") && s.indexOf("hsqldb.Trace") == -1 && s.indexOf("hsqldb") != -1) {
            int i = s.indexOf(46);
            if (i != -1) {
                s = s.substring(i + 1);
            }
            if ((i = s.indexOf(40)) != -1) {
                s = s.substring(0, i);
            }
            sTrace = s;
        }
    }

    @Override
    public void write(String s) {
    }

    Trace() {
        super(System.out);
    }

    static void printSystemOut(String message) {
        System.out.println(message);
    }

    static void trace(long l) {
        Trace.traceCaller(String.valueOf(l));
    }

    static void trace(int i) {
        Trace.traceCaller(String.valueOf(i));
    }

    static void trace() {
        Trace.traceCaller("");
    }

    static void trace(String s) {
        Trace.traceCaller(s);
    }

    static void stop() throws SQLException {
        Trace.stop(null);
    }

    static void stop(String s) throws SQLException {
        if (iStop++ % 10000 != 0) {
            return;
        }
        if (new File("trace.stop").exists()) {
            Trace.printStack();
            throw Trace.getError(39, s);
        }
    }

    private static void printStack() {
        class TraceException
        extends Exception {
            TraceException() {
                super("Trace");
            }
        }
        TraceException e = new TraceException();
        e.printStackTrace();
    }

    private static void traceCaller(String s) {
        class TraceCallerException
        extends Exception {
            TraceCallerException() {
                super("TraceCaller");
            }
        }
        TraceCallerException e = new TraceCallerException();
        sTrace = "";
        e.printStackTrace(tTracer);
        s = sTrace + "\t" + s;
        if (TRACESYSTEMOUT) {
            System.out.println(s);
        } else {
            DriverManager.println(s);
        }
    }

    static {
        iStop = 0;
        sDescription = new String[]{"NOT USED", "08001 The database is already in use by another process", "08003 Connection is closed", "08003 Connection is broken", "08003 The database is shutdown", "21000 Column count does not match", "22012 Division by zero", "22019 Invalid escape character", "23000 Integrity constraint violation", "23000 Violation of unique index", "23000 Try to insert null into a non-nullable column", "37000 Unexpected token", "37000 Unexpected end of command", "37000 Unknown function", "37000 Need aggregate function or group by", "37000 Sum on non-numeric data not allowed", "37000 Wrong data type", "37000 Single value expected", "40001 Serialization failure", "40001 Transfer corrupted", "IM001 This function is not supported", "S0001 Table already exists", "S0002 Table not found", "S0011 Index already exists", "S0011 Attempt to define a second primary key", "S0011 Attempt to drop the primary key", "S0012 Index not found", "S0021 Column already exists", "S0022 Column not found", "S1000 File input/output error", "S1000 Wrong database file version", "S1000 The database is in read only mode", "S1000 The table data is read only", "S1000 Access is denied", "S1000 InputStream error", "S1000 No data is available", "S1000 User already exists", "S1000 User not found", "S1000 Assert failed", "S1000 External stop request", "S1000 General error", "S1009 Wrong OUT parameter", "S1010 Error in function", "S0002 Trigger not found", "S1011 Savepoint not found", "37000 Label required for value list", "37000 Wrong data type or data too long in DEFAULT clause", "S0011 Foreign key not allowed", "S1000 The table's data source for this connection is not known", "S0000 User-defined index or constraint name cannot begin with SYS_", "S0011 Attempt to drop a foreign key index", "S1000 ResultSet was set to forward only", "S0003 View already exists", "S0004 View not found", "S0005 Not A View", "S0005 Not A Table", "S0011 Attempt to drop or rename a system index", "S0021 Column types do not match", "s0021 Column constraints are not acceptable", "S0011 Attempt to drop a system constraint", "S0011 Constraint already exists", "S0011 Constraint not found", "SOO10 Invalid argument in JDBC call", "S1000 Database is memory only", "37000 only one join condition on table columns allowed", "22003 Numeric value out of range"};
        try {
            TRACE = Boolean.getBoolean("hsqldb.trace");
            TRACESYSTEMOUT = Boolean.getBoolean("hsqldb.tracesystemout");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

