/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.Table;
import com.kingdee.eas.cp.hsqldb.Trigger;
import com.kingdee.eas.cp.hsqldb.lib.HsqlDeque;

class TriggerDef
extends Thread {
    static final int NUM_TRIGGER_OPS = 3;
    static final int NUM_TRIGS = 12;
    static final int INSERT_AFTER = 0;
    static final int DELETE_AFTER = 1;
    static final int UPDATE_AFTER = 2;
    static final int INSERT_BEFORE = 3;
    static final int DELETE_BEFORE = 4;
    static final int UPDATE_BEFORE = 5;
    static final int INSERT_AFTER_ROW = 6;
    static final int DELETE_AFTER_ROW = 7;
    static final int UPDATE_AFTER_ROW = 8;
    static final int INSERT_BEFORE_ROW = 9;
    static final int DELETE_BEFORE_ROW = 10;
    static final int UPDATE_BEFORE_ROW = 11;
    String name;
    String when;
    String operation;
    boolean forEachRow;
    boolean nowait;
    int maxRowsQueued;
    protected static int defaultQueueSize = 1024;
    Table table;
    Trigger trig;
    String fire;
    int vectorIndx;
    protected HsqlDeque pendingQueue;
    protected int rowsQueued;
    protected boolean valid;

    public static int getDefaultQueueSize() {
        return defaultQueueSize;
    }

    public TriggerDef(String sName, String sWhen, String sOper, boolean bForEach, Table pTab, Trigger pTrig, String sFire, boolean bNowait, int nQueueSize) {
        this.name = sName.toUpperCase();
        this.when = sWhen.toUpperCase();
        this.operation = sOper.toUpperCase();
        this.forEachRow = bForEach;
        this.nowait = bNowait;
        this.maxRowsQueued = nQueueSize;
        this.table = pTab;
        this.trig = pTrig;
        this.fire = sFire;
        this.vectorIndx = this.SqlToIndex();
        this.rowsQueued = 0;
        this.pendingQueue = new HsqlDeque();
        this.valid = this.vectorIndx >= 0;
    }

    public StringBuffer toBuf() {
        StringBuffer a = new StringBuffer(256);
        a.append("CREATE TRIGGER ");
        a.append(this.name);
        a.append(" ");
        a.append(this.when);
        a.append(" ");
        a.append(this.operation);
        a.append(" ON ");
        a.append(this.table.getName().statementName);
        if (this.forEachRow) {
            a.append(" FOR EACH ROW ");
        }
        if (this.nowait) {
            a.append(" NOWAIT ");
        }
        if (this.maxRowsQueued != TriggerDef.getDefaultQueueSize()) {
            a.append(" QUEUE ");
            a.append(this.maxRowsQueued);
        }
        a.append(" CALL ");
        a.append(this.fire);
        return a;
    }

    public int SqlToIndex() {
        int indx = this.operation.equals("INSERT") ? 0 : (this.operation.equals("DELETE") ? 1 : (this.operation.equals("UPDATE") ? 2 : -1));
        if (this.when.equals("BEFORE")) {
            indx += 3;
        } else if (!this.when.equals("AFTER")) {
            indx = -1;
        }
        if (this.forEachRow) {
            indx += 6;
        }
        return indx;
    }

    @Override
    public void run() {
        boolean keepGoing = true;
        while (keepGoing) {
            Object[] trigRow = this.pop();
            this.trig.fire(this.name, this.table.getName().name, trigRow);
        }
    }

    synchronized Object[] pop() {
        if (this.rowsQueued == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        --this.rowsQueued;
        this.notify();
        return (Object[])this.pendingQueue.removeFirst();
    }

    synchronized void push(Object[] row) {
        if (this.rowsQueued >= this.maxRowsQueued) {
            if (this.nowait) {
                this.pendingQueue.removeLast();
            } else {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++this.rowsQueued;
            }
        } else {
            ++this.rowsQueued;
        }
        this.pendingQueue.add(row);
        this.notify();
    }

    public static int numTrigs() {
        return 12;
    }

    public boolean isBusy() {
        return this.rowsQueued != 0;
    }

    public boolean isValid() {
        return this.valid;
    }
}

