/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.Database;
import com.kingdee.eas.cp.hsqldb.HsqlProperties;
import com.kingdee.eas.cp.hsqldb.Result;
import com.kingdee.eas.cp.hsqldb.Session;
import com.kingdee.eas.cp.hsqldb.StringConverter;
import com.kingdee.eas.cp.hsqldb.Trace;
import com.kingdee.eas.cp.hsqldb.jdbcDatabaseMetaData;
import com.kingdee.eas.cp.hsqldb.jdbcPreparedStatement;
import com.kingdee.eas.cp.hsqldb.jdbcResultSet;
import com.kingdee.eas.cp.hsqldb.jdbcStatement;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.Executor;

public class jdbcConnection
implements Connection {
    private boolean bClosed;
    private String sDatabaseName;
    private HsqlProperties connProperties;
    static final int HTTP = 0;
    static final int STANDALONE = 1;
    static final int INTERNAL = 2;
    static final int HSQLDB = 3;
    private int iType;
    Database dDatabase;
    Session cSession;
    private static Hashtable tDatabase = new Hashtable();
    private static Hashtable iUsageCount = new Hashtable();
    Socket sSocket;
    DataOutputStream dOutput;
    DataInputStream dInput;
    public static final int DEFAULT_HSQLDB_PORT = 9001;
    private String sConnect;
    private String sUser;
    private String sPassword;
    static final String ENCODING = "8859_1";

    @Override
    public Statement createStatement() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        return new jdbcStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace(sql);
        }
        this.checkClosed();
        return new jdbcPreparedStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace(sql);
        }
        this.checkClosed();
        return new jdbcPreparedStatement(this, sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkClosed();
        if (sql.indexOf(123) == -1) {
            return sql;
        }
        char[] s = sql.toCharArray();
        boolean changed = false;
        int state = 0;
        int len = s.length;
        block7: for (int i = 0; i < len; ++i) {
            char c = s[i];
            switch (state) {
                case 0: {
                    if (c == '\'') {
                        state = 1;
                        continue block7;
                    }
                    if (c == '\"') {
                        state = 2;
                        continue block7;
                    }
                    if (c != '{') continue block7;
                    s[i] = 32;
                    changed = true;
                    String sub = sql.substring(i + 1).toUpperCase();
                    if (sub.startsWith("?=")) {
                        i += 2;
                    } else if (sub.startsWith("CALL")) {
                        i += 4;
                    } else if (sub.startsWith("ESCAPE")) {
                        i += 6;
                    }
                    state = 3;
                    continue block7;
                }
                case 1: 
                case 5: {
                    if (c != '\'') continue block7;
                    --state;
                    continue block7;
                }
                case 2: 
                case 6: {
                    if (c != '\"') continue block7;
                    state -= 2;
                    continue block7;
                }
                case 3: {
                    if (c == ' ') {
                        state = 4;
                        continue block7;
                    }
                    s[i] = 32;
                    changed = true;
                    continue block7;
                }
                case 4: {
                    if (c == '\'') {
                        state = 5;
                        continue block7;
                    }
                    if (c == '\"') {
                        state = 6;
                        continue block7;
                    }
                    if (c != '}') continue block7;
                    s[i] = 32;
                    changed = true;
                    state = 0;
                }
            }
        }
        if (changed) {
            sql = new String(s);
            if (Trace.TRACE) {
                Trace.trace(s + " > " + sql);
            }
        }
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.execute("SET AUTOCOMMIT " + (autoCommit ? "TRUE" : "FALSE"));
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.iType == 2 || this.iType == 1) {
            return this.cSession.getAutoCommit();
        }
        try {
            jdbcResultSet rs = this.execute("call \"org.hsqldb.Library.getAutoCommit\"()");
            rs.next();
            return rs.getBoolean(1);
        }
        catch (SQLException e) {
            this.close();
            throw Trace.error(3);
        }
    }

    @Override
    public void commit() throws SQLException {
        this.execute("COMMIT");
    }

    @Override
    public void rollback() throws SQLException {
        this.execute("ROLLBACK");
    }

    @Override
    public void close() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.iType == 2) {
            return;
        }
        if (this.bClosed) {
            return;
        }
        if (this.iType == 1) {
            this.closeStandalone();
        } else {
            this.execute("DISCONNECT");
        }
        this.bClosed = true;
    }

    @Override
    public boolean isClosed() {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return this.bClosed;
    }

    @Override
    public DatabaseMetaData getMetaData() {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return new jdbcDatabaseMetaData(this);
    }

    @Override
    public void setReadOnly(boolean readonly) throws SQLException {
        this.execute("SET READONLY " + (readonly ? "TRUE" : "FALSE"));
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        String s = "SELECT * FROM SYSTEM_CONNECTIONINFO WHERE KEY='READONLY'";
        jdbcResultSet r = this.execute(s);
        r.next();
        return r.getString(2).equals("TRUE");
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace(catalog);
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace(level);
        }
        if (level != 1) {
            throw Trace.error(20);
        }
        this.checkClosed();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        return 1;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        return null;
    }

    static void checkTypeConcurrency(int type, int concurrency) throws SQLException {
        if (type != 1003 && type != 1004 || concurrency != 1007) {
            throw Trace.error(20);
        }
    }

    void checkClosed() throws SQLException {
        if (this.bClosed) {
            throw Trace.error(2);
        }
    }

    static void removeDatabase(Database database) {
        if (database == null) {
            return;
        }
        tDatabase.remove(database.getName());
        iUsageCount.remove(database);
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
    }

    @Override
    public Statement createStatement(int type, int concurrency) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        jdbcConnection.checkTypeConcurrency(type, concurrency);
        return new jdbcStatement(this, type);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int type, int concurrency) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace(sql);
        }
        jdbcConnection.checkTypeConcurrency(type, concurrency);
        this.checkClosed();
        return new jdbcPreparedStatement(this, sql, type);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        jdbcConnection.checkTypeConcurrency(resultSetType, resultSetConcurrency);
        this.checkClosed();
        return this.prepareCall(sql);
    }

    public Map getTypeMap() throws SQLException {
        throw Trace.error(20);
    }

    public void setTypeMap(Map map) throws SQLException {
        throw Trace.error(20);
    }

    jdbcConnection(String s, Properties props) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace(s);
        }
        String user = (String)props.get("user");
        String password = (String)props.get("password");
        if (user == null) {
            user = "";
        }
        if (password == null) {
            password = "";
        }
        this.sDatabaseName = s;
        if ((s = s.toUpperCase()).startsWith("HTTP://")) {
            this.iType = 0;
            this.openHTTP(user, password);
        } else if (s.startsWith("HSQL://")) {
            this.iType = 3;
            this.openHSQL(user, password);
        } else {
            this.iType = 1;
            this.openStandalone(user, password);
        }
        this.connProperties = new HsqlProperties(props);
    }

    jdbcConnection(Session c) throws SQLException {
        Trace.doAssert(c != null, "The specified Session is null");
        this.iType = 2;
        this.cSession = c;
        this.dDatabase = c.getDatabase();
        this.sDatabaseName = this.dDatabase.getName();
    }

    jdbcResultSet execute(String s) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace(s);
        }
        this.checkClosed();
        if (this.iType == 0) {
            return this.executeHTTP(s);
        }
        if (this.iType == 3) {
            return this.executeHSQL(s);
        }
        return this.executeStandalone(s);
    }

    boolean usesLocalFiles() {
        return this.iType != 0;
    }

    String getName() {
        return this.sDatabaseName;
    }

    private void openHTTP(String user, String password) throws SQLException {
        this.sConnect = this.sDatabaseName;
        this.sUser = user;
        this.sPassword = password;
        this.executeHTTP(" ");
    }

    private synchronized jdbcResultSet executeHTTP(String s) throws SQLException {
        byte[] result;
        try {
            URL url = new URL(this.sConnect);
            String p = StringConverter.unicodeToHexString(this.sUser);
            p = p + "+" + StringConverter.unicodeToHexString(this.sPassword);
            p = p + "+" + StringConverter.unicodeToHexString(s);
            URLConnection c = url.openConnection();
            c.setDoOutput(true);
            OutputStream os = c.getOutputStream();
            os.write(p.getBytes(ENCODING));
            os.close();
            c.connect();
            InputStream is = (InputStream)c.getContent();
            BufferedInputStream in = new BufferedInputStream(is);
            int len = c.getContentLength();
            result = new byte[len];
            for (int i = 0; i < len; ++i) {
                int r = in.read();
                result[i] = (byte)r;
            }
        }
        catch (Exception e) {
            throw Trace.error(3, e.getMessage());
        }
        return new jdbcResultSet(new Result(result), this.connProperties);
    }

    private void openHSQL(String user, String password) throws SQLException {
        this.sConnect = this.sDatabaseName.substring(7);
        this.sUser = user;
        this.sPassword = password;
        this.reconnectHSQL();
    }

    private void reconnectHSQL() throws SQLException {
        try {
            StringTokenizer st = new StringTokenizer(this.sConnect, ":");
            String host = st.hasMoreTokens() ? st.nextToken() : "";
            int port = st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : 9001;
            this.sSocket = new Socket(host, port);
            this.sSocket.setTcpNoDelay(true);
            this.dOutput = new DataOutputStream(new BufferedOutputStream(this.sSocket.getOutputStream()));
            this.dInput = new DataInputStream(new BufferedInputStream(this.sSocket.getInputStream()));
            this.dOutput.writeUTF(this.sUser);
            this.dOutput.writeUTF(this.sPassword);
            this.dOutput.flush();
        }
        catch (Exception e) {
            throw Trace.error(3, e.getMessage());
        }
    }

    private synchronized jdbcResultSet executeHSQL(String s) throws SQLException {
        byte[] result;
        try {
            int l;
            byte[] bytes = s.getBytes("utf-8");
            this.dOutput.writeInt(bytes.length);
            this.dOutput.write(bytes);
            this.dOutput.flush();
            int len = this.dInput.readInt();
            result = new byte[len];
            int p = 0;
            while ((l = this.dInput.read(result, p, len)) != len) {
                len -= l;
                p += l;
            }
        }
        catch (Exception e) {
            throw Trace.error(3, e.getMessage());
        }
        return new jdbcResultSet(new Result(result), this.connProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openStandalone(String user, String password) throws SQLException {
        Class<jdbcConnection> clazz = jdbcConnection.class;
        synchronized (jdbcConnection.class) {
            int usage;
            this.dDatabase = (Database)tDatabase.get(this.sDatabaseName);
            if (this.dDatabase == null) {
                this.dDatabase = new Database(this.sDatabaseName);
                tDatabase.put(this.sDatabaseName, this.dDatabase);
                usage = 1;
            } else {
                usage = 1 + (Integer)iUsageCount.get(this.sDatabaseName);
            }
            iUsageCount.put(this.sDatabaseName, new Integer(usage));
            this.cSession = this.dDatabase.connect(user, password);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStandalone() throws SQLException {
        Class<jdbcConnection> clazz = jdbcConnection.class;
        synchronized (jdbcConnection.class) {
            Integer i = (Integer)iUsageCount.get(this.sDatabaseName);
            if (i == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            int usage = i - 1;
            if (usage == 0) {
                iUsageCount.remove(this.sDatabaseName);
                tDatabase.remove(this.sDatabaseName);
                if (!this.dDatabase.isShutdown()) {
                    this.execute("SHUTDOWN");
                }
                this.dDatabase = null;
                this.cSession = null;
            } else {
                iUsageCount.put(this.sDatabaseName, new Integer(usage));
                this.execute("DISCONNECT");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private jdbcResultSet executeStandalone(String s) throws SQLException {
        return new jdbcResultSet(this.dDatabase.execute(s, this.cSession), this.connProperties);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return null;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return null;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        return null;
    }

    @Override
    public Clob createClob() throws SQLException {
        return null;
    }

    @Override
    public NClob createNClob() throws SQLException {
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return null;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return null;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return null;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return false;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }
}

