/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.ByteArray;
import com.kingdee.eas.cp.hsqldb.Column;
import com.kingdee.eas.cp.hsqldb.StringConverter;
import com.kingdee.eas.cp.hsqldb.Trace;
import com.kingdee.eas.cp.hsqldb.jdbcConnection;
import com.kingdee.eas.cp.hsqldb.jdbcStatement;
import com.kingdee.eas.cp.hsqldb.lib.HsqlDateTime;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;

public class jdbcPreparedStatement
extends jdbcStatement
implements PreparedStatement,
CallableStatement {
    private String sSql;
    private Vector vParameter;

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return super.executeQuery(this.build());
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return super.executeUpdate(this.build());
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setNull(parameterIndex);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(parameterIndex, x ? "TRUE" : "FALSE");
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(parameterIndex, String.valueOf(x));
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(parameterIndex, String.valueOf(x));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(parameterIndex, String.valueOf(x));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(parameterIndex, String.valueOf(x));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(parameterIndex, Column.createSQLString(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(parameterIndex, Column.createSQLString(x));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(parameterIndex, Column.createSQLString(x, 3));
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(parameterIndex, Column.createSQLString(x));
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (x == null) {
            this.setNull(parameterIndex);
        } else {
            this.setParameter(parameterIndex, Column.createSQLString(StringConverter.byteToHex(x)));
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(parameterIndex, Column.createSQLString(x, 91));
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(parameterIndex, Column.createSQLString(x, 92));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(parameterIndex, Column.createSQLString(x, 93));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (x == null) {
            this.setNull(parameterIndex);
        } else {
            this.setString(parameterIndex, StringConverter.inputStreamToString(x));
        }
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        StringBuffer sb = new StringBuffer(length / 2);
        try {
            int c1;
            int c;
            for (int i = 0; i < sb.length() && (c = x.read()) != -1 && (c1 = x.read()) != -1; ++i) {
                int character = c << 8 | c1;
                sb.append(character);
            }
        }
        catch (IOException e) {
            throw Trace.error(19);
        }
        this.setParameter(parameterIndex, sb.toString());
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        byte[] b = new byte[length];
        try {
            x.read(b, 0, length);
            x.close();
        }
        catch (IOException e) {
            throw Trace.error(34, e.getMessage());
        }
        this.setBytes(parameterIndex, b);
    }

    @Override
    public void clearParameters() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.vParameter.removeAllElements();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (x == null) {
            this.setNull(parameterIndex);
            return;
        }
        if (targetSqlType != 1111) {
            x = Column.convertObject(x, targetSqlType);
        }
        this.setObjectInType(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (x == null) {
            this.setNull(parameterIndex);
            return;
        }
        int type = 1111;
        if (x instanceof String) {
            type = 12;
        } else if (x instanceof BigDecimal) {
            type = 2;
        } else if (x instanceof Integer) {
            type = 4;
        } else if (x instanceof Long) {
            type = -5;
        } else if (x instanceof Float) {
            type = 7;
        } else if (x instanceof Double) {
            type = 8;
        } else if (x instanceof byte[]) {
            type = -2;
        } else if (x instanceof Date) {
            type = 91;
        } else if (x instanceof Time) {
            type = 92;
        } else if (x instanceof Timestamp) {
            type = 93;
        } else if (x instanceof Boolean) {
            type = -7;
        } else if (x instanceof Byte) {
            type = -6;
        } else if (x instanceof Short) {
            type = 5;
        }
        this.setObjectInType(parameterIndex, x, type);
    }

    @Override
    public boolean execute() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return super.execute(this.build());
    }

    @Override
    public void addBatch() throws SQLException {
        throw this.getNotSupported();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        char[] buffer = new char[length];
        try {
            int result = reader.read(buffer);
            if (result == -1) {
                throw new IOException();
            }
        }
        catch (IOException e) {
            throw Trace.error(19);
        }
        this.setString(parameterIndex, new String(buffer));
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        throw this.getNotSupported();
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        throw this.getNotSupported();
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        throw this.getNotSupported();
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        throw this.getNotSupported();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw this.getNotSupported();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (x == null) {
            this.setNull(parameterIndex);
        } else {
            String dateString = HsqlDateTime.getDateString(x, cal);
            this.setParameter(parameterIndex, Column.createSQLString(dateString));
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (x == null) {
            this.setNull(parameterIndex);
        } else {
            String dateString = HsqlDateTime.getTimeString(x, cal);
            this.setParameter(parameterIndex, Column.createSQLString(dateString));
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (x == null) {
            this.setNull(parameterIndex);
        } else {
            String dateString = HsqlDateTime.getTimestampString(x, cal);
            this.setParameter(parameterIndex, Column.createSQLString(dateString));
        }
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(paramIndex, sqlType);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        throw this.getNotSupported();
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        throw this.getNotSupported();
    }

    @Override
    public boolean wasNull() throws SQLException {
        throw this.getNotSupported();
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        throw this.getNotSupported();
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        throw this.getNotSupported();
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        throw this.getNotSupported();
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        throw this.getNotSupported();
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        throw this.getNotSupported();
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        throw this.getNotSupported();
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        throw this.getNotSupported();
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        throw this.getNotSupported();
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        throw this.getNotSupported();
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        throw this.getNotSupported();
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        throw this.getNotSupported();
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        throw this.getNotSupported();
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        throw this.getNotSupported();
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        throw this.getNotSupported();
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        throw this.getNotSupported();
    }

    public Object getObject(int i, Map map) throws SQLException {
        throw this.getNotSupported();
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw this.getNotSupported();
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        throw this.getNotSupported();
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        throw this.getNotSupported();
    }

    @Override
    public Array getArray(int i) throws SQLException {
        throw this.getNotSupported();
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        String dateString = this.getParameter(parameterIndex);
        dateString = dateString.substring(1, dateString.length() - 1);
        return HsqlDateTime.getDate(dateString, cal);
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        String timeString = this.getParameter(parameterIndex);
        timeString = timeString.substring(1, timeString.length() - 1);
        return HsqlDateTime.getTime(timeString, cal);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        String dateString = this.getParameter(parameterIndex);
        dateString = dateString.substring(1, dateString.length() - 1);
        return HsqlDateTime.getTimestamp(dateString, cal);
    }

    @Override
    public void registerOutParameter(int paramIndex, int sqlType, String typeName) throws SQLException {
        throw this.getNotSupported();
    }

    jdbcPreparedStatement(jdbcConnection c, String s) {
        super(c);
        this.sSql = s;
        this.vParameter = new Vector();
    }

    jdbcPreparedStatement(jdbcConnection c, String s, int type) {
        super(c, type);
        this.sSql = s;
        this.vParameter = new Vector();
    }

    private String build() {
        if (this.vParameter.isEmpty()) {
            return this.sSql;
        }
        StringBuffer s = new StringBuffer();
        int i = 0;
        int l = this.sSql.length();
        boolean bSkip = false;
        boolean bSkip2 = false;
        for (int j = 0; j < l; ++j) {
            char c = this.sSql.charAt(j);
            if (c == '?' && !bSkip && !bSkip2) {
                s.append(this.getParameter(i++));
                continue;
            }
            if (c == '\'' && !bSkip2) {
                bSkip = !bSkip;
            } else if (c == '\"' && !bSkip) {
                bSkip2 = !bSkip2;
            }
            s.append(c);
        }
        return s.toString();
    }

    private SQLException getNotSupported() {
        return Trace.error(20);
    }

    private String getParameter(int i) {
        if (i >= this.vParameter.size()) {
            return null;
        }
        return (String)this.vParameter.elementAt(i);
    }

    private SQLException invalidValue() {
        return Trace.error(11);
    }

    private void setNull(int parameterIndex) {
        this.setParameter(parameterIndex, "NULL");
    }

    private void setObjectInType(int parameterIndex, Object x, int type) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (x == null) {
            this.setNull(parameterIndex);
            return;
        }
        switch (type) {
            case -7: {
                this.setBoolean(parameterIndex, (boolean)((Boolean)x));
                break;
            }
            case -6: {
                this.setByte(parameterIndex, ((Number)x).byteValue());
                break;
            }
            case 5: {
                this.setShort(parameterIndex, ((Number)x).shortValue());
                break;
            }
            case 4: {
                this.setInt(parameterIndex, ((Number)x).intValue());
                break;
            }
            case -5: {
                this.setLong(parameterIndex, ((Number)x).longValue());
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this.setDouble(parameterIndex, ((Number)x).doubleValue());
                break;
            }
            case 2: {
                this.setBigDecimal(parameterIndex, (BigDecimal)x);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this.setString(parameterIndex, (String)x);
                break;
            }
            case 91: {
                this.setDate(parameterIndex, (Date)x);
                break;
            }
            case 92: {
                this.setTime(parameterIndex, (Time)x);
                break;
            }
            case 93: {
                this.setTimestamp(parameterIndex, (Timestamp)x);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setBytes(parameterIndex, (byte[])x);
                break;
            }
            case 1111: {
                this.setParameter(parameterIndex, Column.createSQLString(ByteArray.serializeToString(x)));
                break;
            }
            default: {
                this.setParameter(parameterIndex, x.toString());
            }
        }
    }

    private void setParameter(int i, String s) {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.vParameter.size() < i) {
            this.vParameter.setSize(i);
        }
        this.vParameter.setElementAt(s, --i);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return false;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return 0;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        return null;
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        return null;
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        return false;
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        return 0;
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        return null;
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        return null;
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        return null;
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        return 0.0;
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        return 0.0f;
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        return 0;
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        return 0L;
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        return null;
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        return null;
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        return null;
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        return 0;
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        return null;
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        return null;
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        return null;
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        return null;
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        return null;
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        return null;
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        return null;
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        return null;
    }
}

