/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb;

import com.kingdee.eas.cp.hsqldb.Trace;
import com.kingdee.eas.cp.hsqldb.jdbcConnection;
import com.kingdee.eas.cp.hsqldb.jdbcResultSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class jdbcStatement
implements Statement {
    private boolean bEscapeProcessing = true;
    private jdbcConnection cConnection;
    private int iMaxRows;
    private jdbcResultSet rSet;
    private int rsType = 1003;

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkClosed();
        this.fetchResult(sql);
        return this.rSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkClosed();
        this.fetchResult(sql);
        if (this.rSet == null) {
            return -1;
        }
        return this.rSet.getUpdateCount();
    }

    @Override
    public void close() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.closeOldResult();
        this.rSet = null;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
    }

    @Override
    public int getMaxRows() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        return this.iMaxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        this.iMaxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        this.bEscapeProcessing = enable;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
    }

    @Override
    public void cancel() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        this.fetchResult(sql);
        if (this.rSet == null) {
            return false;
        }
        return this.rSet.isResult();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        if (this.rSet != null && this.rSet.isResult()) {
            return this.rSet;
        }
        return null;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        if (this.rSet == null) {
            return -1;
        }
        return this.rSet.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        if (this.rSet != null) {
            this.rSet.close();
            this.rSet = null;
        }
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        if (direction != 1000) {
            throw Trace.error(20);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        return 0;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        return this.rsType;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw Trace.error(20);
    }

    @Override
    public void clearBatch() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw Trace.error(20);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        throw Trace.error(20);
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkClosed();
        if (Trace.TRACE) {
            Trace.trace();
        }
        return this.cConnection;
    }

    jdbcStatement(jdbcConnection c) {
        this.cConnection = c;
        this.rsType = 1003;
    }

    jdbcStatement(jdbcConnection c, int type) {
        this(c);
        this.rsType = type;
    }

    void checkClosed() throws SQLException {
        this.cConnection.checkClosed();
    }

    private void closeOldResult() throws SQLException {
        if (this.rSet != null) {
            this.rSet.close();
            this.rSet = null;
        }
    }

    private void fetchResult(String sql) throws SQLException {
        if (this.bEscapeProcessing) {
            sql = this.cConnection.nativeSQL(sql);
        }
        this.closeOldResult();
        if (this.iMaxRows == 0) {
            this.rSet = this.cConnection.execute(sql);
        } else {
            try {
                sql = "SET MAXROWS " + this.iMaxRows + ";" + sql;
                this.rSet = this.cConnection.execute(sql);
                this.cConnection.execute("SET MAXROWS 0");
            }
            catch (SQLException e) {
                this.cConnection.execute("SET MAXROWS 0");
                throw e;
            }
        }
        if (this.rSet != null) {
            this.rSet.sqlStatement = this;
            this.rSet.rsType = this.rsType;
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return false;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return 0;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }
}

