/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb.lib;

public class ArrayUtil {
    public static void sortArray(int[] intarr) {
        boolean swapped;
        do {
            swapped = false;
            for (int i = 0; i < intarr.length - 1; ++i) {
                if (intarr[i] <= intarr[i + 1]) continue;
                int temp = intarr[i + 1];
                intarr[i + 1] = intarr[i];
                intarr[i] = temp;
                swapped = true;
            }
        } while (swapped);
    }

    public static boolean haveEquality(int[] a, int[] b, int count, boolean sets) {
        return sets ? a.length == b.length && count == a.length && ArrayUtil.haveEqualSets(a, b, count) : ArrayUtil.haveEqualArrays(a, b, count);
    }

    public static boolean haveEqualSets(int[] a, int[] b, int count) {
        if (count > a.length || count > b.length) {
            return false;
        }
        if (count == 1) {
            return a[0] == b[0];
        }
        int[] tempa = new int[count];
        int[] tempb = new int[count];
        ArrayUtil.copyArray(a, tempa, count);
        ArrayUtil.copyArray(b, tempb, count);
        ArrayUtil.sortArray(tempa);
        ArrayUtil.sortArray(tempb);
        for (int j = 0; j < count; ++j) {
            if (tempa[j] == tempb[j]) continue;
            return false;
        }
        return true;
    }

    public static boolean haveEqualArrays(int[] a, int[] b, int count) {
        if (count > a.length || count > b.length) {
            return false;
        }
        if (count == 1) {
            return a[0] == b[0];
        }
        for (int j = 0; j < count; ++j) {
            if (a[j] == b[j]) continue;
            return false;
        }
        return true;
    }

    public static boolean haveCommonElement(int[] a, int[] b, int lenb) {
        for (int i = 0; i < a.length; ++i) {
            int c = a[i];
            for (int j = 0; j < lenb; ++j) {
                if (c != b[j]) continue;
                return true;
            }
        }
        return false;
    }

    public static void copyArray(int[] source, int[] dest, int count) {
        System.arraycopy(source, 0, dest, 0, count);
    }

    public static void copyAdjustArray(Object[] source, Object[] dest, Object addition, int colindex, int adjust) {
        int i;
        for (i = 0; i < colindex; ++i) {
            dest[i] = source[i];
        }
        if (i == dest.length) {
            return;
        }
        if (adjust < 0) {
            ++i;
        } else {
            dest[i] = addition;
        }
        while (i < source.length) {
            dest[i + adjust] = source[i];
            ++i;
        }
    }

    public static int[] toAdjustedColumnArray(int[] colarr, int colindex, int adjust) {
        if (colarr == null) {
            return null;
        }
        int[] intarr = new int[colarr.length];
        int j = 0;
        for (int i = 0; i < colarr.length; ++i) {
            if (colarr[i] > colindex) {
                intarr[j] = colarr[i] + adjust;
                ++j;
                continue;
            }
            if (colarr[i] == colindex) {
                if (adjust < 0) continue;
                intarr[j] = colarr[i] + adjust;
                ++j;
                continue;
            }
            intarr[j] = colarr[i];
            ++j;
        }
        if (colarr.length != j) {
            int[] newarr = new int[j];
            ArrayUtil.copyArray(intarr, newarr, j);
            return newarr;
        }
        return intarr;
    }

    public static int[] getAdjustedColumnArray(int[] colarr, int size, int colindex, int adjust) {
        int[] newarr = new int[size];
        ArrayUtil.copyArray(colarr, newarr, size);
        return ArrayUtil.toAdjustedColumnArray(newarr, colindex, adjust);
    }

    public static void copyColumnValues(Object[] row, int[] colindex, Object[] colobject) {
        for (int i = 0; i < colindex.length; ++i) {
            colobject[i] = row[colindex[i]];
        }
    }
}

