/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb.lib;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class HsqlDeque {
    private Object[] list = new Object[10];
    private int firstindex = 0;
    private int endindex = 0;
    private int usedsize = 0;
    private final int DEFAULT_INITIAL_CAPACITY = 10;

    public int size() {
        return this.usedsize;
    }

    public Object getFirst() throws NoSuchElementException {
        if (this.usedsize == 0) {
            throw new NoSuchElementException();
        }
        return this.list[this.firstindex];
    }

    public Object getLast() throws NoSuchElementException {
        if (this.usedsize == 0) {
            throw new NoSuchElementException();
        }
        return this.list[this.endindex - 1];
    }

    public Object get(int i) throws IndexOutOfBoundsException {
        int index = this.getInternalIndex(i);
        return this.list[index];
    }

    public Object set(int i, Object o) throws IndexOutOfBoundsException {
        int index = this.getInternalIndex(i);
        Object result = this.list[index];
        this.list[index] = o;
        return result;
    }

    public Object removeFirst() throws NoSuchElementException {
        if (this.usedsize == 0) {
            throw new NoSuchElementException();
        }
        Object o = this.list[this.firstindex];
        this.list[this.firstindex] = null;
        ++this.firstindex;
        --this.usedsize;
        if (this.usedsize == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        } else if (this.firstindex == this.list.length) {
            this.firstindex = 0;
        }
        return o;
    }

    public Object removeLast() throws NoSuchElementException {
        if (this.usedsize == 0) {
            throw new NoSuchElementException();
        }
        --this.endindex;
        Object o = this.list[this.endindex];
        this.list[this.endindex] = null;
        --this.usedsize;
        if (this.usedsize == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        } else if (this.endindex == 0) {
            this.endindex = this.list.length;
        }
        return o;
    }

    public boolean add(Object o) {
        this.resetCapacity();
        if (this.endindex == this.list.length) {
            this.endindex = 0;
        }
        this.list[this.endindex] = o;
        ++this.usedsize;
        ++this.endindex;
        return true;
    }

    public boolean addLast(Object o) {
        return this.add(o);
    }

    public boolean addFirst(Object o) {
        this.resetCapacity();
        --this.firstindex;
        if (this.firstindex < 0) {
            this.firstindex = this.list.length - 1;
            if (this.endindex == 0) {
                this.endindex = this.list.length;
            }
        }
        this.list[this.firstindex] = o;
        ++this.usedsize;
        return true;
    }

    public void clear() {
        this.usedsize = 0;
        this.endindex = 0;
        this.firstindex = 0;
        for (int i = 0; i < this.list.length; ++i) {
            this.list[i] = null;
        }
    }

    public boolean isEmpty() {
        return this.usedsize == 0;
    }

    private int getInternalIndex(int i) throws IndexOutOfBoundsException {
        if (i < 0 || i >= this.usedsize) {
            throw new IndexOutOfBoundsException();
        }
        int index = this.firstindex + i;
        if (index >= this.list.length) {
            index -= this.list.length;
        }
        return index;
    }

    public Enumeration elements() {
        Enumeration _enum = new Enumeration(){
            private int currentIndex = 0;

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException("Enumeration complete");
                }
                return HsqlDeque.this.get(this.currentIndex++);
            }

            @Override
            public boolean hasMoreElements() {
                return HsqlDeque.this.usedsize > this.currentIndex;
            }
        };
        return _enum;
    }

    private void resetCapacity() {
        if (this.usedsize < this.list.length) {
            return;
        }
        Object[] newList = new Object[this.list.length * 2];
        for (int i = 0; i < this.list.length; ++i) {
            newList[i] = this.list[i];
        }
        this.list = newList;
        newList = null;
        if (this.endindex <= this.firstindex) {
            int tail = this.firstindex + this.usedsize - this.endindex;
            for (int i = 0; i < this.endindex; ++i) {
                this.list[tail + i] = this.list[i];
                this.list[i] = null;
            }
            this.endindex = this.firstindex + this.usedsize;
        }
    }
}

