/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb.test;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

class JDBCBench {
    public static int tps = 1;
    public static int nbranches = 1;
    public static int ntellers = 10;
    public static int naccounts = 100000;
    public static int nhistory = 864000;
    public static final int TELLER = 0;
    public static final int BRANCH = 1;
    public static final int ACCOUNT = 2;
    int failed_transactions = 0;
    int transaction_count = 0;
    static int n_clients = 10;
    static int n_txn_per_client = 10;
    long start_time = 0L;
    static boolean transactions = true;
    static boolean prepared_stmt = false;
    static String tableExtension = "";
    static String createExtension = "";
    static String ShutdownCommand = "";
    static PrintStream TabFile = null;
    static boolean verbose = false;
    MemoryWatcherThread MemoryWatcher;

    public static void main(String[] Args) {
        String DriverName = "";
        String DBUrl = "";
        String DBUser = "";
        String DBPassword = "";
        boolean initialize_dataset = false;
        for (int i = 0; i < Args.length; ++i) {
            if (Args[i].equals("-clients")) {
                if (i + 1 >= Args.length) continue;
                n_clients = Integer.parseInt(Args[++i]);
                continue;
            }
            if (Args[i].equals("-driver")) {
                if (i + 1 >= Args.length) continue;
                if ((DriverName = Args[++i]).equals("org.enhydra.instantdb.jdbc.idbDriver")) {
                    ShutdownCommand = "SHUTDOWN";
                }
                if (DriverName.equals("com.borland.datastore.jdbc.DataStoreDriver")) {
                    // empty if block
                }
                if (DriverName.equals("com.mckoi.JDBCDriver")) {
                    ShutdownCommand = "SHUTDOWN";
                }
                if (!DriverName.equals("org.hsqldb.jdbcDriver")) continue;
                tableExtension = "CREATE CACHED TABLE ";
                ShutdownCommand = "SHUTDOWN COMPACT";
                continue;
            }
            if (Args[i].equals("-url")) {
                if (i + 1 >= Args.length) continue;
                DBUrl = Args[++i];
                continue;
            }
            if (Args[i].equals("-user")) {
                if (i + 1 >= Args.length) continue;
                DBUser = Args[++i];
                continue;
            }
            if (Args[i].equals("-tabfile")) {
                if (i + 1 >= Args.length) continue;
                ++i;
                try {
                    FileOutputStream File2 = new FileOutputStream(Args[i]);
                    TabFile = new PrintStream(File2);
                }
                catch (Exception e) {
                    TabFile = null;
                }
                continue;
            }
            if (Args[i].equals("-password")) {
                if (i + 1 >= Args.length) continue;
                DBPassword = Args[++i];
                continue;
            }
            if (Args[i].equals("-tpc")) {
                if (i + 1 >= Args.length) continue;
                n_txn_per_client = Integer.parseInt(Args[++i]);
                continue;
            }
            if (Args[i].equals("-init")) {
                initialize_dataset = true;
                continue;
            }
            if (Args[i].equals("-tps")) {
                if (i + 1 >= Args.length) continue;
                tps = Integer.parseInt(Args[++i]);
                continue;
            }
            if (!Args[i].equals("-v")) continue;
            verbose = true;
        }
        if (DriverName.length() == 0 || DBUrl.length() == 0) {
            System.out.println("usage: java JDBCBench -driver [driver_class_name] -url [url_to_db] -user [username] -password [password] [-v] [-init] [-tpc n] [-clients]");
            System.out.println();
            System.out.println("-v          verbose error messages");
            System.out.println("-init       initialize the tables");
            System.out.println("-tpc        transactions per client");
            System.out.println("-clients    number of simultaneous clients");
            System.exit(-1);
        }
        System.out.println("*********************************************************");
        System.out.println("* JDBCBench v1.1                                        *");
        System.out.println("*********************************************************");
        System.out.println();
        System.out.println("Driver: " + DriverName);
        System.out.println("URL:" + DBUrl);
        System.out.println();
        System.out.println("Scale factor value: " + tps);
        System.out.println("Number of clients: " + n_clients);
        System.out.println("Number of transactions per client: " + n_txn_per_client);
        System.out.println();
        try {
            Class.forName(DriverName);
            JDBCBench i = new JDBCBench(DBUrl, DBUser, DBPassword, initialize_dataset);
        }
        catch (Exception E) {
            System.out.println(E.getMessage());
            E.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDBCBench(String url, String user, String password, boolean init) {
        Vector<Thread> vClient = new Vector<Thread>();
        Thread Client = null;
        Enumeration e = null;
        try {
            int i;
            if (init) {
                System.out.println("Start: " + new Date().toString());
                System.out.print("Initializing dataset...");
                this.createDatabase(url, user, password);
                System.out.println("done.\n");
                System.out.println("Complete: " + new Date().toString());
            }
            System.out.println("* Starting Benchmark Run *");
            this.MemoryWatcher = new MemoryWatcherThread();
            this.MemoryWatcher.start();
            transactions = false;
            prepared_stmt = false;
            this.start_time = System.currentTimeMillis();
            for (i = 0; i < n_clients; ++i) {
                Client = new ClientThread(n_txn_per_client, url, user, password);
                Client.start();
                vClient.addElement(Client);
            }
            e = vClient.elements();
            while (e.hasMoreElements()) {
                Client = (Thread)e.nextElement();
                Client.join();
            }
            vClient.removeAllElements();
            this.reportDone();
            transactions = true;
            prepared_stmt = false;
            this.start_time = System.currentTimeMillis();
            for (i = 0; i < n_clients; ++i) {
                Client = new ClientThread(n_txn_per_client, url, user, password);
                Client.start();
                vClient.addElement(Client);
            }
            e = vClient.elements();
            while (e.hasMoreElements()) {
                Client = (Thread)e.nextElement();
                Client.join();
            }
            vClient.removeAllElements();
            this.reportDone();
            transactions = false;
            prepared_stmt = true;
            this.start_time = System.currentTimeMillis();
            for (i = 0; i < n_clients; ++i) {
                Client = new ClientThread(n_txn_per_client, url, user, password);
                Client.start();
                vClient.addElement(Client);
            }
            e = vClient.elements();
            while (e.hasMoreElements()) {
                Client = (Thread)e.nextElement();
                Client.join();
            }
            vClient.removeAllElements();
            this.reportDone();
            transactions = true;
            prepared_stmt = true;
            this.start_time = System.currentTimeMillis();
            for (i = 0; i < n_clients; ++i) {
                Client = new ClientThread(n_txn_per_client, url, user, password);
                Client.start();
                vClient.addElement(Client);
            }
            e = vClient.elements();
            while (e.hasMoreElements()) {
                Client = (Thread)e.nextElement();
                Client.join();
            }
            vClient.removeAllElements();
            this.reportDone();
        }
        catch (Exception E) {
            System.out.println(E.getMessage());
            E.printStackTrace();
        }
        finally {
            this.MemoryWatcher.end();
            try {
                this.MemoryWatcher.join();
                if (ShutdownCommand.length() > 0) {
                    Connection C = JDBCBench.connect(url, user, password);
                    Statement Stmt = C.createStatement();
                    Stmt.execute(ShutdownCommand);
                    Stmt.close();
                    JDBCBench.connectClose(C);
                }
                if (TabFile != null) {
                    TabFile.close();
                }
            }
            catch (Exception exception) {}
            System.exit(0);
        }
    }

    public void reportDone() {
        long end_time = System.currentTimeMillis();
        double completion_time = ((double)end_time - (double)this.start_time) / 1000.0;
        if (TabFile != null) {
            TabFile.print(tps + ";" + n_clients + ";" + n_txn_per_client + ";");
        }
        System.out.println("\n* Benchmark Report *");
        System.out.print("* Featuring ");
        if (prepared_stmt) {
            System.out.print("<prepared statements> ");
            if (TabFile != null) {
                TabFile.print("<prepared statements>;");
            }
        } else {
            System.out.print("<direct queries> ");
            if (TabFile != null) {
                TabFile.print("<direct queries>;");
            }
        }
        if (transactions) {
            System.out.print("<transactions> ");
            if (TabFile != null) {
                TabFile.print("<transactions>;");
            }
        } else {
            System.out.print("<auto-commit> ");
            if (TabFile != null) {
                TabFile.print("<auto-commit>;");
            }
        }
        System.out.println("\n--------------------");
        System.out.println("Time to execute " + this.transaction_count + " transactions: " + completion_time + " seconds.");
        System.out.println("Max/Min memory usage: " + this.MemoryWatcher.max + " / " + this.MemoryWatcher.min + " kb");
        System.out.println(this.failed_transactions + " / " + this.transaction_count + " failed to complete.");
        double rate = (double)(this.transaction_count - this.failed_transactions) / completion_time;
        System.out.println("Transaction rate: " + rate + " txn/sec.");
        if (TabFile != null) {
            TabFile.print(this.MemoryWatcher.max + ";" + this.MemoryWatcher.min + ";" + this.failed_transactions + ";" + rate + "\n");
        }
        this.transaction_count = 0;
        this.failed_transactions = 0;
        this.MemoryWatcher.reset();
    }

    public synchronized void incrementTransactionCount() {
        ++this.transaction_count;
    }

    public synchronized void incrementFailedTransactionCount() {
        ++this.failed_transactions;
    }

    void createDatabase(String url, String user, String password) throws Exception {
        String Query;
        Statement Stmt3;
        Connection Conn = JDBCBench.connect(url, user, password);
        String s = Conn.getMetaData().getDatabaseProductName();
        System.out.println("DBMS: " + s);
        transactions = true;
        if (transactions) {
            try {
                Conn.setAutoCommit(false);
                System.out.println("In transaction mode");
            }
            catch (SQLException Etrxn) {
                transactions = false;
            }
        }
        try {
            int accountsnb = 0;
            Statement Stmt2 = Conn.createStatement();
            String Query2 = "SELECT count(*) ";
            Query2 = Query2 + "FROM   accounts";
            ResultSet RS = Stmt2.executeQuery(Query2);
            Stmt2.clearWarnings();
            while (RS.next()) {
                accountsnb = RS.getInt(1);
            }
            if (transactions) {
                Conn.commit();
            }
            Stmt2.close();
            if (accountsnb == naccounts * tps) {
                System.out.println("Already initialized");
                JDBCBench.connectClose(Conn);
                return;
            }
        }
        catch (Exception accountsnb) {
            // empty catch block
        }
        System.out.println("Drop old tables if they exist");
        try {
            Stmt3 = Conn.createStatement();
            Query = "DROP TABLE history";
            Stmt3.execute(Query);
            Stmt3.clearWarnings();
            Query = "DROP TABLE accounts";
            Stmt3.execute(Query);
            Stmt3.clearWarnings();
            Query = "DROP TABLE tellers";
            Stmt3.execute(Query);
            Stmt3.clearWarnings();
            Query = "DROP TABLE branches";
            Stmt3.execute(Query);
            Stmt3.clearWarnings();
            if (transactions) {
                Conn.commit();
            }
            Stmt3.close();
        }
        catch (Exception Stmt3) {
            // empty catch block
        }
        System.out.println("Creates tables");
        try {
            Stmt3 = Conn.createStatement();
            Query = tableExtension.length() > 0 ? tableExtension + " branches (" : "CREATE TABLE branches (";
            Query = Query + "Bid         INTEGER NOT NULL PRIMARY KEY, ";
            Query = Query + "Bbalance    INTEGER,";
            Query = Query + "filler      CHAR(88))";
            if (createExtension.length() > 0) {
                Query = Query + createExtension;
            }
            Stmt3.execute(Query);
            Stmt3.clearWarnings();
            Query = tableExtension.length() > 0 ? tableExtension + " tellers (" : "CREATE TABLE tellers (";
            Query = Query + "Tid         INTEGER NOT NULL PRIMARY KEY,";
            Query = Query + "Bid         INTEGER,";
            Query = Query + "Tbalance    INTEGER,";
            Query = Query + "filler      CHAR(84))";
            if (createExtension.length() > 0) {
                Query = Query + createExtension;
            }
            Stmt3.execute(Query);
            Stmt3.clearWarnings();
            Query = tableExtension.length() > 0 ? tableExtension + " accounts (" : "CREATE TABLE accounts (";
            Query = Query + "Aid         INTEGER NOT NULL PRIMARY KEY, ";
            Query = Query + "Bid         INTEGER, ";
            Query = Query + "Abalance    INTEGER, ";
            Query = Query + "filler      CHAR(84))";
            if (createExtension.length() > 0) {
                Query = Query + createExtension;
            }
            Stmt3.execute(Query);
            Stmt3.clearWarnings();
            Query = tableExtension.length() > 0 ? tableExtension + " history (" : "CREATE TABLE history (";
            Query = Query + "Tid         INTEGER, ";
            Query = Query + "Bid         INTEGER, ";
            Query = Query + "Aid         INTEGER, ";
            Query = Query + "delta       INTEGER, ";
            Query = Query + "tstime        TIMESTAMP, ";
            Query = Query + "filler      CHAR(22))";
            if (createExtension.length() > 0) {
                Query = Query + createExtension;
            }
            Stmt3.execute(Query);
            Stmt3.clearWarnings();
            if (transactions) {
                Conn.commit();
            }
            Stmt3.close();
        }
        catch (Exception Stmt4) {
            // empty catch block
        }
        System.out.println("Delete elements in table in case Drop didn't work");
        try {
            int i;
            Stmt3 = Conn.createStatement();
            Query = "DELETE FROM history";
            Stmt3.execute(Query);
            Stmt3.clearWarnings();
            Query = "DELETE FROM accounts";
            Stmt3.execute(Query);
            Stmt3.clearWarnings();
            Query = "DELETE FROM tellers";
            Stmt3.execute(Query);
            Stmt3.clearWarnings();
            Query = "DELETE FROM branches";
            Stmt3.execute(Query);
            Stmt3.clearWarnings();
            if (transactions) {
                Conn.commit();
            }
            PreparedStatement pstmt = null;
            prepared_stmt = true;
            if (prepared_stmt) {
                try {
                    Query = "INSERT INTO branches(Bid,Bbalance) VALUES (?,0)";
                    pstmt = Conn.prepareStatement(Query);
                    System.out.println("Using prepared statements");
                }
                catch (SQLException Epstmt) {
                    pstmt = null;
                    prepared_stmt = false;
                }
            }
            System.out.println("Insert data in branches table");
            for (i = 0; i < nbranches * tps; ++i) {
                if (prepared_stmt) {
                    pstmt.setInt(1, i);
                    pstmt.executeUpdate();
                    pstmt.clearWarnings();
                } else {
                    Query = "INSERT INTO branches(Bid,Bbalance) VALUES (" + i + ",0)";
                    Stmt3.executeUpdate(Query);
                }
                if (i % 100 != 0 || !transactions) continue;
                Conn.commit();
            }
            if (prepared_stmt) {
                pstmt.close();
            }
            if (transactions) {
                Conn.commit();
            }
            if (prepared_stmt) {
                Query = "INSERT INTO tellers(Tid,Bid,Tbalance) VALUES (?,?,0)";
                pstmt = Conn.prepareStatement(Query);
            }
            System.out.println("Insert data in tellers table");
            for (i = 0; i < ntellers * tps; ++i) {
                if (prepared_stmt) {
                    pstmt.setInt(1, i);
                    pstmt.setInt(2, i / ntellers);
                    pstmt.executeUpdate();
                    pstmt.clearWarnings();
                } else {
                    Query = "INSERT INTO tellers(Tid,Bid,Tbalance) VALUES (" + i + "," + i / ntellers + ",0)";
                    Stmt3.executeUpdate(Query);
                }
                if (i % 100 != 0 || !transactions) continue;
                Conn.commit();
            }
            if (prepared_stmt) {
                pstmt.close();
            }
            if (transactions) {
                Conn.commit();
            }
            if (prepared_stmt) {
                Query = "INSERT INTO accounts(Aid,Bid,Abalance) VALUES (?,?,0)";
                pstmt = Conn.prepareStatement(Query);
            }
            System.out.println("Insert data in accounts table");
            for (i = 0; i < naccounts * tps; ++i) {
                if (prepared_stmt) {
                    pstmt.setInt(1, i);
                    pstmt.setInt(2, i / naccounts);
                    pstmt.executeUpdate();
                    pstmt.clearWarnings();
                } else {
                    Query = "INSERT INTO accounts(Aid,Bid,Abalance) VALUES (" + i + "," + i / naccounts + ",0)";
                    Stmt3.executeUpdate(Query);
                }
                if (i % 10000 == 0 && transactions) {
                    Conn.commit();
                }
                if (i <= 0 || i % 10000 != 0) continue;
                System.out.println("\t" + i + "\t records inserted");
            }
            if (prepared_stmt) {
                pstmt.close();
            }
            if (transactions) {
                Conn.commit();
            }
            System.out.println("\t" + naccounts * tps + "\t records inserted");
            Stmt3.close();
        }
        catch (Exception E) {
            System.out.println(E.getMessage());
            E.printStackTrace();
        }
        JDBCBench.connectClose(Conn);
    }

    public static int getRandomInt(int lo, int hi) {
        int ret = 0;
        ret = (int)(Math.random() * (double)(hi - lo + 1));
        return ret += lo;
    }

    public static int getRandomID(int type) {
        int min = 0;
        int max = 0;
        int num = naccounts;
        switch (type) {
            case 0: {
                min += nbranches;
                num = ntellers;
            }
            case 1: {
                if (type == 1) {
                    num = nbranches;
                }
                min += naccounts;
            }
            case 2: {
                max = min + num - 1;
            }
        }
        return JDBCBench.getRandomInt(min, max);
    }

    public static Connection connect(String DBUrl, String DBUser, String DBPassword) {
        try {
            Connection conn = DriverManager.getConnection(DBUrl, DBUser, DBPassword);
            return conn;
        }
        catch (Exception E) {
            System.out.println(E.getMessage());
            E.printStackTrace();
            return null;
        }
    }

    public static void connectClose(Connection c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (Exception E) {
            System.out.println(E.getMessage());
            E.printStackTrace();
        }
    }

    class MemoryWatcherThread
    extends Thread {
        long min = 0L;
        long max = 0L;
        boolean keep_running = true;

        public MemoryWatcherThread() {
            this.reset();
            this.keep_running = true;
        }

        public void reset() {
            System.gc();
            long currentFree = Runtime.getRuntime().freeMemory();
            long currentAlloc = Runtime.getRuntime().totalMemory();
            this.min = this.max = currentAlloc - currentFree;
        }

        public void end() {
            this.keep_running = false;
        }

        @Override
        public void run() {
            while (this.keep_running) {
                long currentFree = Runtime.getRuntime().freeMemory();
                long currentAlloc = Runtime.getRuntime().totalMemory();
                long used = currentAlloc - currentFree;
                if (used < this.min) {
                    this.min = used;
                }
                if (used > this.max) {
                    this.max = used;
                }
                try {
                    MemoryWatcherThread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    class ClientThread
    extends Thread {
        int ntrans = 0;
        Connection Conn;
        PreparedStatement pstmt1 = null;
        PreparedStatement pstmt2 = null;
        PreparedStatement pstmt3 = null;
        PreparedStatement pstmt4 = null;
        PreparedStatement pstmt5 = null;

        public ClientThread(int number_of_txns, String url, String user, String password) {
            this.ntrans = number_of_txns;
            this.Conn = JDBCBench.connect(url, user, password);
            if (this.Conn == null) {
                return;
            }
            try {
                if (transactions) {
                    this.Conn.setAutoCommit(false);
                }
                if (prepared_stmt) {
                    String Query = "UPDATE accounts ";
                    Query = Query + "SET     Abalance = Abalance + ? ";
                    Query = Query + "WHERE   Aid = ?";
                    this.pstmt1 = this.Conn.prepareStatement(Query);
                    Query = "SELECT Abalance ";
                    Query = Query + "FROM   accounts ";
                    Query = Query + "WHERE  Aid = ?";
                    this.pstmt2 = this.Conn.prepareStatement(Query);
                    Query = "UPDATE tellers ";
                    Query = Query + "SET    Tbalance = Tbalance + ? ";
                    Query = Query + "WHERE  Tid = ?";
                    this.pstmt3 = this.Conn.prepareStatement(Query);
                    Query = "UPDATE branches ";
                    Query = Query + "SET    Bbalance = Bbalance + ? ";
                    Query = Query + "WHERE  Bid = ?";
                    this.pstmt4 = this.Conn.prepareStatement(Query);
                    Query = "INSERT INTO history(Tid, Bid, Aid, delta) ";
                    Query = Query + "VALUES (?,?,?,?)";
                    this.pstmt5 = this.Conn.prepareStatement(Query);
                }
            }
            catch (Exception E) {
                System.out.println(E.getMessage());
                E.printStackTrace();
            }
        }

        @Override
        public void run() {
            while (this.ntrans-- > 0) {
                int account = JDBCBench.getRandomID(2);
                int branch = JDBCBench.getRandomID(1);
                int teller = JDBCBench.getRandomID(0);
                int delta = JDBCBench.getRandomInt(0, 1000);
                this.doOne(branch, teller, account, delta);
                JDBCBench.this.incrementTransactionCount();
            }
            if (prepared_stmt) {
                try {
                    if (this.pstmt1 != null) {
                        this.pstmt1.close();
                    }
                    if (this.pstmt2 != null) {
                        this.pstmt2.close();
                    }
                    if (this.pstmt3 != null) {
                        this.pstmt3.close();
                    }
                    if (this.pstmt4 != null) {
                        this.pstmt4.close();
                    }
                    if (this.pstmt5 != null) {
                        this.pstmt5.close();
                    }
                }
                catch (Exception E) {
                    System.out.println(E.getMessage());
                    E.printStackTrace();
                }
            }
            JDBCBench.connectClose(this.Conn);
            this.Conn = null;
        }

        int doOne(int bid, int tid, int aid, int delta) {
            int aBalance = 0;
            if (this.Conn == null) {
                JDBCBench.this.incrementFailedTransactionCount();
                return 0;
            }
            try {
                if (prepared_stmt) {
                    this.pstmt1.setInt(1, delta);
                    this.pstmt1.setInt(2, aid);
                    this.pstmt1.executeUpdate();
                    this.pstmt1.clearWarnings();
                    this.pstmt2.setInt(1, aid);
                    ResultSet RS = this.pstmt2.executeQuery();
                    this.pstmt2.clearWarnings();
                    while (RS.next()) {
                        aBalance = RS.getInt(1);
                    }
                    this.pstmt3.setInt(1, delta);
                    this.pstmt3.setInt(2, tid);
                    this.pstmt3.executeUpdate();
                    this.pstmt3.clearWarnings();
                    this.pstmt4.setInt(1, delta);
                    this.pstmt4.setInt(2, bid);
                    this.pstmt4.executeUpdate();
                    this.pstmt4.clearWarnings();
                    this.pstmt5.setInt(1, tid);
                    this.pstmt5.setInt(2, bid);
                    this.pstmt5.setInt(3, aid);
                    this.pstmt5.setInt(4, delta);
                    this.pstmt5.executeUpdate();
                    this.pstmt5.clearWarnings();
                } else {
                    Statement Stmt = this.Conn.createStatement();
                    String Query = "UPDATE accounts ";
                    Query = Query + "SET     Abalance = Abalance + " + delta + " ";
                    Query = Query + "WHERE   Aid = " + aid;
                    int res = Stmt.executeUpdate(Query);
                    Stmt.clearWarnings();
                    Query = "SELECT Abalance ";
                    Query = Query + "FROM   accounts ";
                    Query = Query + "WHERE  Aid = " + aid;
                    ResultSet RS = Stmt.executeQuery(Query);
                    Stmt.clearWarnings();
                    while (RS.next()) {
                        aBalance = RS.getInt(1);
                    }
                    Query = "UPDATE tellers ";
                    Query = Query + "SET    Tbalance = Tbalance + " + delta + " ";
                    Query = Query + "WHERE  Tid = " + tid;
                    Stmt.executeUpdate(Query);
                    Stmt.clearWarnings();
                    Query = "UPDATE branches ";
                    Query = Query + "SET    Bbalance = Bbalance + " + delta + " ";
                    Query = Query + "WHERE  Bid = " + bid;
                    Stmt.executeUpdate(Query);
                    Stmt.clearWarnings();
                    Query = "INSERT INTO history(Tid, Bid, Aid, delta) ";
                    Query = Query + "VALUES (";
                    Query = Query + tid + ",";
                    Query = Query + bid + ",";
                    Query = Query + aid + ",";
                    Query = Query + delta + ")";
                    Stmt.executeUpdate(Query);
                    Stmt.clearWarnings();
                    Stmt.close();
                }
                if (transactions) {
                    this.Conn.commit();
                }
                return aBalance;
            }
            catch (Exception E) {
                if (verbose) {
                    System.out.println("Transaction failed: " + E.getMessage());
                    E.printStackTrace();
                }
                JDBCBench.this.incrementFailedTransactionCount();
                if (transactions) {
                    try {
                        this.Conn.rollback();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                return 0;
            }
        }
    }
}

